/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.extensions.client;

import com.ibm.team.build.extensions.client.IBuildCacheItem;
import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.LogString;
import com.ibm.team.build.extensions.common.debug.MethodName;
import com.ibm.team.build.extensions.common.util.Verification;
import com.ibm.team.enterprise.build.buildmap.common.model.IBuildMap;
import com.ibm.team.enterprise.build.buildmap.common.model.IBuildMapHandle;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class BuildCacheItemAddBuildMap {
    private static final String className = BuildCacheItemAddBuildMap.class.getSimpleName();

    public static IBuildMap add(ITeamRepository repository, IBuildCacheItem<IBuildMap> buildCacheItem, IBuildMap item, IBuildMapHandle itemHandle, String itemString, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        IItemManager client = repository.itemManager();
        IBuildMap itemDefinition = null;
        if (item != null) {
            if (buildCacheItem.containsUuid(item.getItemId().getUuidValue())) {
                return (IBuildMap)buildCacheItem.getUuid(item.getItemId().getUuidValue());
            }
            itemDefinition = item;
        } else if (itemHandle != null) {
            if (buildCacheItem.containsUuid(itemHandle.getItemId().getUuidValue())) {
                return (IBuildMap)buildCacheItem.getUuid(itemHandle.getItemId().getUuidValue());
            }
            itemDefinition = (IBuildMap)client.fetchCompleteItem((IItemHandle)itemHandle, 0, monitor);
        } else if (itemString != null) {
            if (buildCacheItem.contains(itemString)) {
                return (IBuildMap)buildCacheItem.get(itemString);
            }
            if (Verification.isUUID((String)itemString)) {
                itemDefinition = (IBuildMap)client.fetchCompleteItem(IBuildMap.ITEM_TYPE.createItemHandle(UUID.valueOf((String)itemString), null), 0, monitor);
            }
        }
        if (itemDefinition == null) {
            return itemDefinition;
        }
        String itemDefinitionName = itemDefinition.getItemId().getUuidValue();
        String itemDefinitionUuid = itemDefinition.getItemId().getUuidValue();
        if (buildCacheItem.hasItemList()) {
            buildCacheItem.addItemList((Object)itemDefinition);
        }
        if (buildCacheItem.hasItemMapByName()) {
            buildCacheItem.addItemMapByName(itemDefinitionName, (Object)itemDefinition);
        }
        if (buildCacheItem.hasItemMapByUuid()) {
            buildCacheItem.addItemMapByUuid(itemDefinitionUuid, (Object)itemDefinition);
        }
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((IItem)itemDefinition)});
        }
        return itemDefinition;
    }

    public static List<IBuildMap> add(ITeamRepository repository, IBuildCacheItem<IBuildMap> buildCacheItem, List<IBuildMap> items, List<IBuildMapHandle> itemHandles, List<String> itemStrings, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        IItemManager client = repository.itemManager();
        ArrayList<IBuildMap> itemList = new ArrayList<IBuildMap>();
        if (items != null) {
            itemList.addAll(items);
        } else if (itemHandles != null) {
            itemList.addAll(client.fetchCompleteItems(itemHandles, 0, monitor));
        } else if (itemStrings != null) {
            ArrayList<IBuildMap> handles = new ArrayList<IBuildMap>();
            for (String itemId : itemStrings) {
                if (!Verification.isUUID((String)itemId)) continue;
                handles.add((IBuildMap)client.fetchCompleteItem(IBuildMap.ITEM_TYPE.createItemHandle(UUID.valueOf((String)itemId), null), 0, monitor));
            }
            itemList.addAll(client.fetchCompleteItems(handles, 0, monitor));
        }
        itemList.removeAll(Collections.singleton(null));
        HashMap<String, IBuildMap> itemMapByName = new HashMap<String, IBuildMap>();
        HashMap<String, IBuildMap> itemMapByUuid = new HashMap<String, IBuildMap>();
        for (IBuildMap item : itemList) {
            if (buildCacheItem.hasItemMapByName()) {
                String itemName = item.getItemId().getUuidValue();
                itemMapByName.put(itemName, item);
            }
            if (!buildCacheItem.hasItemMapByUuid()) continue;
            String itemUuid = item.getItemId().getUuidValue();
            itemMapByUuid.put(itemUuid, item);
        }
        if (buildCacheItem.hasItemList()) {
            buildCacheItem.addAllItemList(itemList);
        }
        if (buildCacheItem.hasItemMapByName()) {
            buildCacheItem.addAllItemMapByName(itemMapByName);
        }
        if (buildCacheItem.hasItemMapByUuid()) {
            buildCacheItem.addAllItemMapByUuid(itemMapByUuid);
        }
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf(itemList)});
        }
        return itemList;
    }
}

