<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet 
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
    xmlns:bf="http://www.ibm.com/team/enterprise/build/buildablefiles/1.0/" 
    xmlns:buildmap="http://www.ibm.com/team/enterprise/build/buildmap/1.0/" 
    xmlns:ds="http://www.ibm.com/team/enterprise/build/dependencyset/1.0/" 
    xmlns:inputs="http://www.ibm.com/team/enterprise/build/buildmap/inputs/1.0/" 
    xmlns:outputs="http://www.ibm.com/team/enterprise/build/buildmap/outputs/1.0/" 
    xmlns:parserOutputs="http://www.ibm.com/team/enterprise/build/buildmap/parserOutputs/1.0/"
	version="1.0">

	<xsl:template match="/">
		<html>
			<head>
					<meta http-equiv="content-type" content="text/html; charset=UTF-8" />
					<title>${PROMOTION_REPORT_TITLE}</title>
					<style type="text/css">
body {padding:3px;font:13px Arial, Helvetica, sans-serif;}
.buildmaps {margin-left:15px;margin-top:3px;}
		    	</style>
			</head>
			<body>
				<xsl:apply-templates/>
			</body>
		</html>
	</xsl:template>
	<xsl:template match="bf:buildable">
		<div>${PROMOTION_REPORT_DESCRIPTION}</div>
		<p>
			<xsl:choose>
				<xsl:when test="count(bf:component/bf:project/bf:file) = 0">
					${PROMOTION_NOTHING_PROMOTED}
				</xsl:when>
				<xsl:otherwise>
					${PROMOTION_INFO_FINAL_BUILDMAPS_DESCRIPTION}<br/>
					<div class="buildmaps">
						<xsl:apply-templates/>
					</div>
				</xsl:otherwise>
			</xsl:choose>
		</p>
	</xsl:template>

	<xsl:template name="handleComponent" match="bf:component">
		<xsl:for-each select="bf:project">
			<xsl:for-each select="bf:file">
				<xsl:sort select="concat(@bf:buildPath, @bf:buildFile)"/> <!-- sort the build maps by label -->
				<xsl:variable name="buildMap"><xsl:value-of select="@bf:buildMap" /></xsl:variable>
				<a href="open://./enterprise_buildmap/{$buildMap}"><xsl:value-of select="@bf:buildPath" />(<xsl:value-of select="@bf:buildFile" />)</a><br/>
			</xsl:for-each>
		</xsl:for-each>
	</xsl:template>  

</xsl:stylesheet>
