<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet 
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
    xmlns:pi="http://www.ibm.com/enterprise/promotion/promotioninfo"
	version="1.0">

	<xsl:template match="/">
		<html>
			<head>
				<meta http-equiv="content-type" content="text/html; charset=UTF-8" />
				<title>${PROMOTION_INFO_TITLE}</title>
				<style type="text/css">
.titlebox {color:#FFFFFF;padding:3px;font:13px Arial,Helvetica,sans-serif; background-color:#888888;margin:0px;}
.row {padding:3px;font:11px Arial, Helvetica, sans-serif;background-color:#eeeeee;margin:0px;}
.buildmaps {margin-left:15px;margin-top:3px;}
body {padding:3px;font:13px Arial, Helvetica, sans-serif;}
table { empty-cells: show; border-collapse: collapse; }
.normalrow {padding:3px;font:13px Arial, Helvetica, sans-serif;margin:0px;}
		    	</style>
		    	<script type="text/javascript">
		    		function formatTimestamp(ts, id) {
		    			var d = new Date(ts);
		    			var formatted = d.getFullYear() + "-" + pad(d.getMonth() + 1) + "-" + pad(d.getDate()) + " " + pad(d.getHours()) + ":" + pad(d.getMinutes()) + ":" + pad(d.getSeconds());
		    			document.getElementById(id).innerHTML = formatted;
		    		}
		    		function pad(val) {
		    			if (val &lt; 10) {
		    				return "0" + val;
		    			}
		    			return val;
		    		}
		    	</script>
			</head>
			<body>
				<xsl:apply-templates/>
			</body>
		</html>
	</xsl:template>
	
	<xsl:template match="pi:resources">
		<div>${PROMOTION_INFO_DESCRIPTION}</div>
	    <p>
		    <xsl:choose>
			    <xsl:when test="count(pi:resource) = 0">
					${PROMOTION_NOTHING_PROMOTED}
			    </xsl:when>
			    <xsl:otherwise>
			    	<table border="1" cellspacing="0" width="100%">
						<xsl:apply-templates>
							<xsl:sort select="pi:sourceResource/@pi:name"/> <!-- sort the resource prefix sections -->
						</xsl:apply-templates>
					</table>
					<br/>
					<xsl:if test="/pi:promotioninfo/@pi:promotionType = 'workitem'">
					    <table class="normalrow" border="0" cellpadding="2" cellspacing="2">
                          <tbody>
	  			            <tr><td width="40px" ></td><th align="left">${PROMOTION_INFO_Reason_Label}</th><th align="left">${PROMOTION_INFO_Reason_Desc}</th></tr>
                            <tr><td></td><td align="center">0</td><td>${PROMOTION_INFO_Reason_Desc_0}</td></tr>
                            <tr><td></td><td align="center">1</td><td>${PROMOTION_INFO_Reason_Desc_1}</td></tr>
                            <tr><td></td><td align="center">2</td><td>${PROMOTION_INFO_Reason_Desc_2}</td></tr>
                         </tbody>
                      </table>
                   </xsl:if>   
			    </xsl:otherwise>
		    </xsl:choose>
	    </p>
	</xsl:template>
	
	<xsl:template match="pi:resource">
		<xsl:variable name="percent">
			<xsl:choose>
				<xsl:when test="/pi:promotioninfo/@pi:buildType = 'ibmi'">
				   <xsl:choose>
				       <xsl:when test="/pi:promotioninfo/@pi:promotionType = 'workitem'">
				            <xsl:value-of select="'16%'"/>
				       </xsl:when>
				       <xsl:otherwise>
					<xsl:value-of select="'20%'"/>
				       </xsl:otherwise>
				   </xsl:choose>               					
				</xsl:when>
				<xsl:otherwise>
				   <xsl:choose>
				       <xsl:when test="/pi:promotioninfo/@pi:promotionType = 'workitem'">
				            <xsl:value-of select="'20%'"/>
				       </xsl:when>
				       <xsl:otherwise>
					<xsl:value-of select="'25%'"/>
				</xsl:otherwise>
			</xsl:choose>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<tr class="titlebox">
			<th width="{$percent}">${PROMOTION_INFO_SourceName}</th>
			<th width="{$percent}">${PROMOTION_INFO_TargetName}</th>
			<xsl:if test="/pi:promotioninfo/@pi:buildType = 'ibmi'">
				<th width="{$percent}">${PROMOTION_INFO_Type}</th>
			</xsl:if>
			<th width="{$percent}">${PROMOTION_INFO_Timestamp}</th>
			<xsl:if test="/pi:promotioninfo/@pi:promotionType = 'workitem'">
			    <th width="{$percent}">${PROMOTION_INFO_Reason}</th>
			</xsl:if>
			<th width="{$percent}">${PROMOTION_INFO_DEPLOY_TYPE}</th>
		</tr>
		
		<xsl:for-each select="pi:members/pi:sourceMember">
			<xsl:sort select="@pi:name"/> <!-- sort the members in each section by name -->
			<tr class="row">
				<xsl:choose>
					<xsl:when test="@pi:type = 'sequential'">
						<td align="left"><xsl:value-of select="../../pi:sourceResource/@pi:name"/>.<xsl:value-of select="@pi:name" /></td>
						<td align="left"><xsl:value-of select="../../pi:targetResource/@pi:name"/>.<xsl:value-of select="@pi:name" /></td>
					</xsl:when>
					<xsl:when test="@pi:type = 'file'">
						<td align="left"><xsl:value-of select="../../../../pi:sourceHFS/@pi:path"/><xsl:value-of select="../../pi:sourceResource/@pi:name"/><xsl:value-of select="@pi:name" /></td>
						<td align="left"><xsl:value-of select="../../../../pi:targetHFS/@pi:path"/><xsl:value-of select="../../pi:targetResource/@pi:name"/><xsl:value-of select="@pi:name" /></td>
					</xsl:when>
					<xsl:otherwise>
						<td align="left"><xsl:value-of select="../../pi:sourceResource/@pi:name"/>(<xsl:value-of select="@pi:name" />)</td>
						<td align="left"><xsl:value-of select="../../pi:targetResource/@pi:name"/>(<xsl:value-of select="@pi:name" />)</td>
					</xsl:otherwise>
				</xsl:choose>
				<xsl:if test="/pi:promotioninfo/@pi:buildType = 'ibmi'">
					<td align="center"><xsl:value-of select="@pi:type" /></td>
				</xsl:if>
				
				<!-- create a unique id to be used by javascript. 'position()' is relative to the current 'pi:members' so include the resource prefix in the id -->
				<xsl:variable name="uniqueID"><xsl:value-of select="../../pi:sourceResource/@pi:name"/><xsl:value-of select="position()"/></xsl:variable>
				<xsl:variable name="timestamp"><xsl:value-of select="@pi:timestamp"/></xsl:variable>
				<td align="center" id="{$uniqueID}"><script type="text/javascript">formatTimestamp(<xsl:value-of select="@pi:timestamp"/>, "<xsl:value-of select="$uniqueID"/>");</script></td>
                <xsl:if test="/pi:promotioninfo/@pi:promotionType = 'workitem'"> 
                   <td align="center">                   
        	         <xsl:choose>
        	          <xsl:when test="@pi:reason = 'LINKED'">1</xsl:when>
        	          <xsl:when test="@pi:reason = 'IMPACTED'">2</xsl:when>
        	          <xsl:otherwise>0</xsl:otherwise>
				     </xsl:choose>                      	        	
                   </td>
                </xsl:if>
                <td align="center"><xsl:value-of select="@pi:deployType"/></td>				
			</tr>
		</xsl:for-each>
		 		
	</xsl:template>
	
	<xsl:template match="pi:finalbuildmaps">
		<xsl:if test="count(pi:finalbuildmap) > 0">
			<p>
			    ${PROMOTION_INFO_FINAL_BUILDMAPS_DESCRIPTION}<br/>
			    <div class="buildmaps">
					<xsl:for-each select="pi:finalbuildmap">
						<xsl:sort select="@pi:label"/> <!-- sort the build maps by label -->
						<xsl:variable name="slug"><xsl:value-of select="@pi:slug" /></xsl:variable>
						<a href="open://./enterprise_buildmap/{$slug}"><xsl:value-of select="@pi:label" /></a><br/>
					</xsl:for-each>
				</div>
			</p>
		</xsl:if>
	</xsl:template>

</xsl:stylesheet>
