/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.build.common.dependency;

import com.ibm.team.enterprise.systemdefinition.common.model.ILanguageDefinition;
import com.ibm.team.enterprise.zos.build.common.dependency.IBuildOrderProperty;

public class BuildOrderProperty
implements IBuildOrderProperty {
    private final String propertySeparator = ":";
    private ILanguageDefinition langDef;
    private boolean isEnabled;
    private String parsedUUID;
    private String tokenizedString;

    @Override
    public String getTokenizedString() {
        return this.tokenizedString;
    }

    public BuildOrderProperty(String unparsedString) {
        this.tokenizedString = unparsedString;
        this.parseToken(unparsedString);
    }

    public BuildOrderProperty(ILanguageDefinition langDef, boolean isEnabled) {
        this.langDef = langDef;
        this.isEnabled = isEnabled;
        this.encodeToken();
    }

    private void parseToken(String unparsedString) {
        String[] parsedElements = unparsedString.split(":");
        if (parsedElements.length >= 2) {
            this.parsedUUID = parsedElements[0];
            this.isEnabled = parsedElements[1].equalsIgnoreCase("Y");
        }
    }

    private void encodeToken() {
        this.parsedUUID = this.langDef.getItemId().getUuidValue();
        this.tokenizedString = String.valueOf(this.parsedUUID) + ":" + (this.isEnabled ? "Y" : "N");
    }

    @Override
    public String getPropertyUUID() {
        return this.parsedUUID;
    }

    @Override
    public boolean isPropertyEnabled() {
        return this.isEnabled;
    }

    public ILanguageDefinition getLangDef() {
        return this.langDef;
    }
}

