/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.common.simulationregistry.util;

import com.ibm.team.enterprise.build.buildmap.common.model.IBuildFile;
import com.ibm.team.enterprise.build.common.simulationregistry.ISimulationRegistry;
import com.ibm.team.enterprise.build.common.simulationregistry.ISimulationRegistryFile;
import com.ibm.team.enterprise.build.common.simulationregistry.impl.SimulationRegistry;
import com.ibm.team.enterprise.build.common.simulationregistry.impl.SimulationRegistryFile;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SimulationRegistryUtil {
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private static final String UTF_8 = "UTF-8";
    private static final String COLON = ":";
    private static final String YES = "yes";
    private static final String INDENT_AMOUNT = "{http://xml.apache.org/xalan}indent-amount";
    private static final String THREE = "3";
    private static final String XMLNS_NAMESPACE = "http://www.w3.org/2000/xmlns/";
    private static final String XMLNS_NAMESPACE_PREFIX = "xmlns";
    private static final String BUILD_FILE_NAME_SPACE = "http://www.ibm.com/team/enterprise/build/buildablefiles/1.0/";
    private static final String BUILD_FILE_PREFIX = "bf";
    private static final String REGISTRY_NAMESPACE = "http://www.ibm.com/team/enterprise/build/buildmap/outputs/1.0/";
    private static final String REGISTRY_NAMESPACE_PREFIX = "outputs";
    private static final String REGISTRY_TAG = "outputs";
    private static final String FILE_TAG = "file";
    private static final String BUILDFILE_TAG = "buildFile";
    private static final String BUILDPATH_TAG = "buildPath";
    private static final String NATIVEPATH_TAG = "nativePath";
    private static final String TIMESTAMP_TAG = "timestamp";
    private static final String BINARYEXISTS_TAG = "binaryExists";
    private static final String HFS_TAG = "hfs";

    private SimulationRegistryUtil() {
    }

    public static ISimulationRegistry createRegistryFromFile(File file) throws SAXException, IOException, ParserConfigurationException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        SimulationRegistryParser parser = new SimulationRegistryParser();
        factory.newSAXParser().parse(file, (DefaultHandler)parser);
        return parser.registry;
    }

    public static ISimulationRegistry createRegistryFromXml(String xml) throws UnsupportedEncodingException, SAXException, IOException, ParserConfigurationException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        SimulationRegistryParser parser = new SimulationRegistryParser();
        factory.newSAXParser().parse((InputStream)new ByteArrayInputStream(xml.getBytes(UTF_8)), (DefaultHandler)parser);
        return parser.registry;
    }

    public static ISimulationRegistry createNewRegistry() {
        return new SimulationRegistry();
    }

    public static ISimulationRegistryFile createNewFile() {
        return new SimulationRegistryFile();
    }

    public static ISimulationRegistryFile createFile(IBuildFile buildFile, long timestamp, String nativePath) {
        SimulationRegistryFile file = new SimulationRegistryFile();
        file.setBuildFile(buildFile.getBuildFile());
        file.setBuildPath(buildFile.getBuildPath());
        file.setNativePath(nativePath);
        file.setTimestamp(timestamp);
        file.setHFS(buildFile.isHFS());
        return file;
    }

    public static ISimulationRegistryFile createFile(String buildFile, String buildPath, long timestamp, String nativePath, boolean isHFS) {
        SimulationRegistryFile file = new SimulationRegistryFile();
        file.setBuildFile(buildFile);
        file.setBuildPath(buildPath);
        file.setNativePath(nativePath);
        file.setTimestamp(timestamp);
        file.setHFS(isHFS);
        return file;
    }

    public static void serializeRegistry(ISimulationRegistry registry, File file) throws IOException {
        try (BufferedWriter bw = null;){
            bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), UTF_8));
            SimulationRegistryUtil.serializeRegistry(registry, bw);
        }
    }

    public static void serializeRegistry(ISimulationRegistry registry, Writer writer) throws IOException {
        int tabs = 0;
        writer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        writer.append('<');
        writer.append(BUILD_FILE_PREFIX);
        writer.append(':');
        writer.append("outputs");
        writer.append(' ');
        writer.append(XMLNS_NAMESPACE_PREFIX);
        writer.append(':');
        writer.append(BUILD_FILE_PREFIX);
        writer.append('=');
        writer.append('\"');
        writer.append(BUILD_FILE_NAME_SPACE);
        writer.append('\"');
        writer.append(' ');
        writer.append(XMLNS_NAMESPACE_PREFIX);
        writer.append(':');
        writer.append("outputs");
        writer.append('=');
        writer.append('\"');
        writer.append(REGISTRY_NAMESPACE);
        writer.append('\"');
        writer.append('>');
        writer.append('\n');
        ++tabs;
        Iterator<ISimulationRegistryFile> it = registry.iterator();
        while (it.hasNext()) {
            ISimulationRegistryFile file = it.next();
            SimulationRegistryUtil.writeTabs(tabs, writer);
            writer.append('<');
            writer.append("outputs");
            writer.append(':');
            writer.append(FILE_TAG);
            writer.append('>');
            writer.append('\n');
            SimulationRegistryUtil.writeElement("outputs", BUILDFILE_TAG, file.getBuildFile(), ++tabs, writer);
            SimulationRegistryUtil.writeElement("outputs", BUILDPATH_TAG, file.getBuildPath(), tabs, writer);
            SimulationRegistryUtil.writeElement("outputs", NATIVEPATH_TAG, file.getNativePath(), tabs, writer);
            if (file.binaryExists() != null) {
                SimulationRegistryUtil.writeElement("outputs", BINARYEXISTS_TAG, Boolean.toString(file.binaryExists()), tabs, writer);
            }
            if (file.isHFS()) {
                SimulationRegistryUtil.writeElement("outputs", HFS_TAG, Boolean.toString(file.isHFS()), tabs, writer);
            }
            SimulationRegistryUtil.writeElement("outputs", TIMESTAMP_TAG, Long.toString(file.getTimestamp()), tabs, writer);
            SimulationRegistryUtil.writeTabs(--tabs, writer);
            writer.append('<');
            writer.append('/');
            writer.append("outputs");
            writer.append(':');
            writer.append(FILE_TAG);
            writer.append('>');
            writer.append('\n');
        }
        --tabs;
        writer.append('<');
        writer.append('/');
        writer.append(BUILD_FILE_PREFIX);
        writer.append(':');
        writer.append("outputs");
        writer.append('>');
        writer.append('\n');
        writer.flush();
    }

    private static void writeElement(String namespacePrefix, String name, String value, int tabs, Writer writer) throws IOException {
        if (value != null && value.length() > 0) {
            SimulationRegistryUtil.writeTabs(tabs, writer);
            writer.append('<');
            writer.append(namespacePrefix);
            writer.append(':');
            writer.append(name);
            writer.append('>');
            writer.append(value);
            writer.append('<');
            writer.append('/');
            writer.append(namespacePrefix);
            writer.append(':');
            writer.append(name);
            writer.append('>');
            writer.append('\n');
        }
    }

    private static void writeTabs(int count, Writer writer) throws IOException {
        int i = count;
        while (i > 0) {
            writer.append('\t');
            --i;
        }
    }

    public static String getSimulationRegistryXmlString(ISimulationRegistry registry) throws ParserConfigurationException, TransformerConfigurationException, TransformerFactoryConfigurationError, TransformerException, UnsupportedEncodingException {
        Document document = SimulationRegistryUtil.createRegistryDoc(registry);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(4096);
        StreamResult result = new StreamResult(outputStream);
        SimulationRegistryUtil.transform(result, document);
        return outputStream.toString(UTF_8);
    }

    private static void transform(Result result, Document document) throws TransformerConfigurationException, TransformerFactoryConfigurationError, TransformerException {
        DOMSource source = new DOMSource(document);
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("indent", YES);
        transformer.setOutputProperty(INDENT_AMOUNT, THREE);
        transformer.transform(source, result);
    }

    private static Document createRegistryDoc(ISimulationRegistry registry) throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        Document document = documentBuilderFactory.newDocumentBuilder().newDocument();
        Element root = document.createElementNS(BUILD_FILE_NAME_SPACE, "outputs");
        root.setPrefix(BUILD_FILE_PREFIX);
        document.appendChild(root);
        Attr attrRegistry = document.createAttributeNS(XMLNS_NAMESPACE, XMLNS_NAMESPACE_PREFIX + COLON + "outputs");
        attrRegistry.setValue(REGISTRY_NAMESPACE);
        root.setAttributeNode(attrRegistry);
        if (registry.size() > 0) {
            ArrayList<ISimulationRegistryFile> sortedFiles = new ArrayList<ISimulationRegistryFile>(registry.size());
            Iterator<ISimulationRegistryFile> it = registry.iterator();
            while (it.hasNext()) {
                sortedFiles.add(it.next());
            }
            Collections.sort(sortedFiles, new RegistryFileComparator());
            for (ISimulationRegistryFile file : sortedFiles) {
                Element buildPathElement;
                Element fileElement = document.createElementNS(REGISTRY_NAMESPACE, FILE_TAG);
                fileElement.setPrefix("outputs");
                Node node = fileElement;
                if (node != null && file.getBuildFile() != null && file.getBuildFile().length() > 0) {
                    Element buildFileElement = document.createElementNS(REGISTRY_NAMESPACE, BUILDFILE_TAG);
                    buildFileElement.setPrefix("outputs");
                    buildFileElement.setTextContent(file.getBuildFile());
                    node = fileElement.appendChild(buildFileElement);
                }
                if (node != null && file.getBuildPath() != null && file.getBuildPath().length() > 0) {
                    buildPathElement = document.createElementNS(REGISTRY_NAMESPACE, BUILDPATH_TAG);
                    buildPathElement.setPrefix("outputs");
                    buildPathElement.setTextContent(file.getBuildPath());
                    node = fileElement.appendChild(buildPathElement);
                }
                if (node != null && file.getNativePath() != null && file.getNativePath().length() > 0) {
                    buildPathElement = document.createElementNS(REGISTRY_NAMESPACE, NATIVEPATH_TAG);
                    buildPathElement.setPrefix("outputs");
                    buildPathElement.setTextContent(file.getNativePath());
                    node = fileElement.appendChild(buildPathElement);
                }
                if (node != null && file.getTimestamp() != 0L) {
                    Element timestampElement = document.createElementNS(REGISTRY_NAMESPACE, TIMESTAMP_TAG);
                    timestampElement.setPrefix("outputs");
                    timestampElement.setTextContent(Long.toString(file.getTimestamp()));
                    node = fileElement.appendChild(timestampElement);
                }
                if (node != null && file.binaryExists() != null) {
                    Element binaryExistsElement = document.createElementNS(REGISTRY_NAMESPACE, BINARYEXISTS_TAG);
                    binaryExistsElement.setPrefix("outputs");
                    binaryExistsElement.setTextContent(Boolean.toString(file.binaryExists()));
                    node = fileElement.appendChild(binaryExistsElement);
                }
                if (node != null && file.isHFS()) {
                    Element hfsElement = document.createElementNS(REGISTRY_NAMESPACE, HFS_TAG);
                    hfsElement.setPrefix("outputs");
                    hfsElement.setTextContent(Boolean.toString(file.isHFS()));
                    node = fileElement.appendChild(hfsElement);
                }
                if (node == null) {
                    new Throwable().printStackTrace();
                }
                root.appendChild(fileElement);
            }
        }
        return document;
    }

    public static boolean equals(ISimulationRegistry registry1, ISimulationRegistry registry2, boolean compareTimestamps, boolean compareBinaryExists) {
        if (registry1 == null) {
            return registry2 == null;
        }
        if (registry2 == null) {
            return false;
        }
        if (registry1 == registry2) {
            return true;
        }
        if (compareTimestamps) {
            int size = registry1.size();
            if (size != registry2.size()) {
                return false;
            }
            if (size > 0) {
                RegistryFileComparator comparator = new RegistryFileComparator();
                ArrayList<ISimulationRegistryFile> list1 = new ArrayList<ISimulationRegistryFile>(size);
                Iterator<ISimulationRegistryFile> it = registry1.iterator();
                while (it.hasNext()) {
                    list1.add(it.next());
                }
                Collections.sort(list1, comparator);
                ArrayList<ISimulationRegistryFile> list2 = new ArrayList<ISimulationRegistryFile>(size);
                Iterator<ISimulationRegistryFile> it2 = registry2.iterator();
                while (it2.hasNext()) {
                    list2.add(it2.next());
                }
                Collections.sort(list2, comparator);
                int i = 0;
                while (i < size) {
                    if (!((ISimulationRegistryFile)list1.get(i)).equals((ISimulationRegistryFile)list2.get(i), compareTimestamps, compareBinaryExists)) {
                        return false;
                    }
                    ++i;
                }
            }
            return true;
        }
        return registry1.equals(registry2);
    }

    private static class RegistryFileComparator
    implements Comparator<ISimulationRegistryFile> {
        private RegistryFileComparator() {
        }

        @Override
        public int compare(ISimulationRegistryFile reg1, ISimulationRegistryFile reg2) {
            int result = reg1.getBuildPath().compareTo(reg2.getBuildPath());
            if (result == 0) {
                result = reg1.getBuildFile().compareTo(reg2.getBuildFile());
            }
            if (result == 0) {
                result = reg1.getNativePath().compareTo(reg2.getNativePath());
            }
            return result;
        }
    }

    private static class SimulationRegistryParser
    extends DefaultHandler {
        final ISimulationRegistry registry = new SimulationRegistry();
        ISimulationRegistryFile currentFile;
        private StringBuilder characters;

        @Override
        public void characters(char[] c, int start, int length) throws SAXException {
            if (this.characters == null) {
                this.characters = new StringBuilder(length + 100);
            }
            this.characters.append(c, start, length);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.characters = null;
            if (SimulationRegistryUtil.REGISTRY_NAMESPACE.equals(uri) && SimulationRegistryUtil.FILE_TAG.equals(localName)) {
                this.currentFile = new SimulationRegistryFile();
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.currentFile == null) {
                return;
            }
            if (SimulationRegistryUtil.REGISTRY_NAMESPACE.equals(uri)) {
                if (SimulationRegistryUtil.FILE_TAG.equals(localName)) {
                    this.registry.add(this.currentFile);
                } else if (SimulationRegistryUtil.BUILDFILE_TAG.equals(localName)) {
                    this.currentFile.setBuildFile(this.characters.toString());
                } else if (SimulationRegistryUtil.BUILDPATH_TAG.equals(localName)) {
                    this.currentFile.setBuildPath(this.characters.toString());
                } else if (SimulationRegistryUtil.NATIVEPATH_TAG.equals(localName)) {
                    this.currentFile.setNativePath(this.characters.toString());
                } else if (SimulationRegistryUtil.TIMESTAMP_TAG.equals(localName)) {
                    this.currentFile.setTimestamp(Long.valueOf(this.characters.toString()));
                } else if (SimulationRegistryUtil.BINARYEXISTS_TAG.equals(localName)) {
                    this.currentFile.setBinaryExists(Boolean.valueOf(this.characters.toString()));
                } else if (SimulationRegistryUtil.HFS_TAG.equals(localName)) {
                    this.currentFile.setHFS(Boolean.valueOf(this.characters.toString()));
                }
            }
        }
    }
}

