/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.common.promotion.util;

import com.ibm.team.enterprise.build.common.promotion.IPromotableFile;
import com.ibm.team.enterprise.build.common.promotion.IPromotableResource;
import com.ibm.team.enterprise.build.common.promotion.impl.PromotableFile;
import com.ibm.team.enterprise.build.common.promotion.impl.PromotableResource;
import com.ibm.team.enterprise.build.common.promotion.util.PromotionInfo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class PromotionInfoUtil {
    private static final String PROMOTION_INFO_NS = "http://www.ibm.com/enterprise/promotion/promotioninfo";
    public static final String PROMOTION_INFO_FILE_NAME = "promotionInfo.xml";
    private static final String PROMOTION_INFO_PREFIX = "pi:";
    private static final String BUILDMAP_CONSTANT = "buildmap";
    private static final String BUILDMAPS_ELEMENT = "buildmaps";
    private static final String RESOURCES_ELEMENT = "resources";
    private static final String SRC_HFS_ELEMENT = "sourceHFS";
    private static final String TARGET_HFS_ELEMENT = "targetHFS";
    private static final String PROMOTION_INFO_ELEMENT = "promotioninfo";
    private static final String RESOURCE_ELEMENT = "resource";
    private static final String SOURCE_RESOURCE_ELEMENT = "sourceResource";
    private static final String TARGET_RESOURCE_ELEMENT = "targetResource";
    private static final String SOURCE_PDS_ELEMENT = "sourcePDS";
    private static final String TARGET_PDS_ELEMENT = "targetPDS";
    private static final String MEMBERS_ELEMENT = "members";
    private static final String SOURCE_MEMBER_ELEMENT = "sourceMember";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String IS_DEPLOYABLE_ATTRIBUTE = "isDeployable";
    private static final String TIMESTAMP_ATTRIBUTE = "timestamp";
    private static final String TYPE_ATTRIBUTE = "type";
    private static final String SLUG_ATTRIBUTE = "slug";
    private static final String LABEL_ATTRIBUTE = "label";
    private static final String SCM_LOCATION_ATTRIBUTE = "scmLocation";
    private static final String FINAL_BUILDMAPS_ELEMENT = "finalbuildmaps";
    private static final String FINAL_BUILDMAP_CONSTANT = "finalbuildmap";
    private static final String BUILD_TYPE = "buildType";
    private static final String XML_STYLESHEET = "xml-stylesheet";
    private static final String XSL_INSTRUCTION = "type=\"text/xsl\" href=\"promotionInfo.xsl\"";
    private static final String VERSION_ID_ATTRIBUTE = "versionId";
    private static final String REASON_ATTRIBUTE = "reason";
    private static final String PROMOTION_TYPE_ATTRIBUTE = "promotionType";
    private static final String DEPLOY_TYPE_ATTRIBUTE = "deployType";
    private static final String PATH_ATTRIBUTE = "path";
    private static final String YES = "yes";
    private static final String INDENT_AMOUNT = "{http://xml.apache.org/xalan}indent-amount";
    private static final String THREE = "3";
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private static final String UTF_8 = "UTF-8";
    public static final String EMTPY = "";
    public static final String DOUBLE_NEW_LINE = "\n\n";

    public static Element getPromotionInfoElement(PromotionInfo promotionInfo, Document promotionInfoDoc) {
        Element hfsElement;
        Element rootElement = promotionInfoDoc.createElementNS(PROMOTION_INFO_NS, "pi:promotioninfo");
        rootElement.setAttributeNS(PROMOTION_INFO_NS, "pi:buildType", promotionInfo.getPromotionBuildType().name());
        if (promotionInfo.getPromotionType() != PromotionInfo.PromotionType.unspecified) {
            rootElement.setAttributeNS(PROMOTION_INFO_NS, "pi:promotionType", promotionInfo.getPromotionType().name());
        }
        if (promotionInfo.getSourceHFSDir() != null && !promotionInfo.getSourceHFSDir().isEmpty()) {
            hfsElement = promotionInfoDoc.createElementNS(PROMOTION_INFO_NS, "pi:sourceHFS");
            hfsElement.setAttributeNS(PROMOTION_INFO_NS, "pi:path", promotionInfo.getSourceHFSDir());
            rootElement.appendChild(hfsElement);
        }
        if (promotionInfo.getTargetHFSDir() != null && !promotionInfo.getTargetHFSDir().isEmpty()) {
            hfsElement = promotionInfoDoc.createElementNS(PROMOTION_INFO_NS, "pi:targetHFS");
            hfsElement.setAttributeNS(PROMOTION_INFO_NS, "pi:path", promotionInfo.getTargetHFSDir());
            rootElement.appendChild(hfsElement);
        }
        Element promotableResourcesElement = promotionInfoDoc.createElementNS(PROMOTION_INFO_NS, "pi:resources");
        rootElement.appendChild(promotableResourcesElement);
        if (promotionInfo.getPromotableResources() != null) {
            for (String sourcePDS : promotionInfo.getPromotableResources().keySet()) {
                IPromotableResource resource = promotionInfo.getPromotableResources().get(sourcePDS);
                Element promotableResourceElement = promotionInfoDoc.createElementNS(PROMOTION_INFO_NS, "pi:resource");
                Element sourcePDSElement = promotionInfo.getPromotionBuildType() == PromotionInfo.PromotionBuildType.oldzos ? promotionInfoDoc.createElementNS(PROMOTION_INFO_NS, "pi:sourcePDS") : promotionInfoDoc.createElementNS(PROMOTION_INFO_NS, "pi:sourceResource");
                sourcePDSElement.setAttributeNS(PROMOTION_INFO_NS, "pi:name", sourcePDS);
                String type = resource.getType();
                if (type != null && !type.isEmpty()) {
                    sourcePDSElement.setAttributeNS(PROMOTION_INFO_NS, "pi:type", type);
                }
                promotableResourceElement.appendChild(sourcePDSElement);
                Element membersElement = promotionInfoDoc.createElementNS(PROMOTION_INFO_NS, "pi:members");
                promotableResourceElement.appendChild(membersElement);
                if (resource.getFiles() != null) {
                    for (IPromotableFile file : resource.getFiles()) {
                        Element memberElement = promotionInfoDoc.createElementNS(PROMOTION_INFO_NS, "pi:sourceMember");
                        memberElement.setAttributeNS(PROMOTION_INFO_NS, "pi:name", file.getName());
                        memberElement.setAttributeNS(PROMOTION_INFO_NS, "pi:isDeployable", Boolean.toString(file.isDeployable()));
                        memberElement.setAttributeNS(PROMOTION_INFO_NS, "pi:timestamp", Long.toString(file.getTimestamp()));
                        if (file.getType() != null) {
                            memberElement.setAttributeNS(PROMOTION_INFO_NS, "pi:type", file.getType());
                        }
                        if (file.getScmLocation() != null) {
                            memberElement.setAttributeNS(PROMOTION_INFO_NS, "pi:scmLocation", file.getScmLocation());
                        }
                        if (file.getVersionId() != null && !file.getVersionId().isEmpty()) {
                            memberElement.setAttributeNS(PROMOTION_INFO_NS, "pi:versionId", file.getVersionId());
                        }
                        if (file.getReason() != null && file.getReason() != IPromotableFile.Reason.CHANGESET) {
                            memberElement.setAttributeNS(PROMOTION_INFO_NS, "pi:reason", file.getReason().name());
                        }
                        if (file.getDeployType() != null) {
                            memberElement.setAttributeNS(PROMOTION_INFO_NS, "pi:deployType", file.getDeployType());
                        }
                        membersElement.appendChild(memberElement);
                    }
                }
                Element targetPDSElement = promotionInfo.getPromotionBuildType() == PromotionInfo.PromotionBuildType.oldzos ? promotionInfoDoc.createElementNS(PROMOTION_INFO_NS, "pi:targetPDS") : promotionInfoDoc.createElementNS(PROMOTION_INFO_NS, "pi:targetResource");
                targetPDSElement.setAttributeNS(PROMOTION_INFO_NS, "pi:name", resource.getTargetResource());
                promotableResourceElement.appendChild(targetPDSElement);
                promotableResourcesElement.appendChild(promotableResourceElement);
            }
        }
        Element buildMapsElement = promotionInfoDoc.createElementNS(PROMOTION_INFO_NS, "pi:buildmaps");
        rootElement.appendChild(buildMapsElement);
        if (promotionInfo.getTemporaryBuildMaps() != null) {
            for (PromotionInfo.BuildMapEntry entry : promotionInfo.getTemporaryBuildMaps()) {
                Element buildMapElement = promotionInfoDoc.createElementNS(PROMOTION_INFO_NS, "pi:buildmap");
                buildMapElement.setAttributeNS(PROMOTION_INFO_NS, "pi:slug", entry.uri.toString());
                if (entry.versionId != null && !entry.versionId.isEmpty()) {
                    buildMapElement.setAttributeNS(PROMOTION_INFO_NS, "pi:versionId", entry.versionId);
                }
                buildMapsElement.appendChild(buildMapElement);
            }
        }
        if (promotionInfo.getFinalBuildMaps() != null && promotionInfo.getFinalBuildMaps().size() > 0) {
            Element finalBuildMapsElement = promotionInfoDoc.createElementNS(PROMOTION_INFO_NS, "pi:finalbuildmaps");
            rootElement.appendChild(finalBuildMapsElement);
            for (PromotionInfo.BuildMapEntry entry : promotionInfo.getFinalBuildMaps()) {
                Element buildMapElement = promotionInfoDoc.createElementNS(PROMOTION_INFO_NS, "pi:finalbuildmap");
                buildMapElement.setAttributeNS(PROMOTION_INFO_NS, "pi:label", entry.label);
                buildMapElement.setAttributeNS(PROMOTION_INFO_NS, "pi:slug", entry.uri.toString());
                if (entry.versionId != null && !entry.versionId.isEmpty()) {
                    buildMapElement.setAttributeNS(PROMOTION_INFO_NS, "pi:versionId", entry.versionId);
                }
                finalBuildMapsElement.appendChild(buildMapElement);
            }
        }
        return rootElement;
    }

    public static PromotionInfo parsePromotionInfo(String xmlContent) throws Exception {
        NodeList hfsTargetList;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        Document document = null;
        DocumentBuilder builder = factory.newDocumentBuilder();
        document = builder.parse(new ByteArrayInputStream(xmlContent.getBytes(UTF_8)));
        if (document == null) {
            return null;
        }
        NodeList promotionInfoElements = document.getElementsByTagNameNS(PROMOTION_INFO_NS, PROMOTION_INFO_ELEMENT);
        if (promotionInfoElements == null || promotionInfoElements.getLength() == 0) {
            return null;
        }
        String promotionBuildTypeValue = ((Element)promotionInfoElements.item(0)).getAttributeNS(PROMOTION_INFO_NS, BUILD_TYPE);
        PromotionInfo.PromotionBuildType promotionBuildType = PromotionInfo.PromotionBuildType.valueOf(promotionBuildTypeValue);
        String promotionTypeValue = ((Element)promotionInfoElements.item(0)).getAttributeNS(PROMOTION_INFO_NS, PROMOTION_TYPE_ATTRIBUTE);
        PromotionInfo.PromotionType promotionType = PromotionInfoUtil.convertToPromotionType(promotionTypeValue);
        NodeList slugElements = document.getElementsByTagNameNS(PROMOTION_INFO_NS, BUILDMAP_CONSTANT);
        ArrayList<PromotionInfo.BuildMapEntry> buildMaps = new ArrayList<PromotionInfo.BuildMapEntry>();
        if (slugElements != null) {
            int i = 0;
            while (i < slugElements.getLength()) {
                PromotionInfo.BuildMapEntry temp = new PromotionInfo.BuildMapEntry();
                Element slugElement = (Element)slugElements.item(i);
                temp.uri = URI.create(slugElement.getAttributeNS(PROMOTION_INFO_NS, SLUG_ATTRIBUTE));
                temp.label = slugElement.getAttributeNS(PROMOTION_INFO_NS, LABEL_ATTRIBUTE);
                temp.versionId = slugElement.getAttributeNS(PROMOTION_INFO_NS, VERSION_ID_ATTRIBUTE);
                buildMaps.add(temp);
                ++i;
            }
        }
        NodeList finalSlugElements = document.getElementsByTagNameNS(PROMOTION_INFO_NS, FINAL_BUILDMAP_CONSTANT);
        ArrayList<PromotionInfo.BuildMapEntry> finalBuildMaps = new ArrayList<PromotionInfo.BuildMapEntry>();
        if (finalSlugElements != null) {
            int i = 0;
            while (i < finalSlugElements.getLength()) {
                PromotionInfo.BuildMapEntry temp = new PromotionInfo.BuildMapEntry();
                Element slugElement = (Element)finalSlugElements.item(i);
                temp.uri = URI.create(slugElement.getAttributeNS(PROMOTION_INFO_NS, SLUG_ATTRIBUTE));
                temp.label = slugElement.getAttributeNS(PROMOTION_INFO_NS, LABEL_ATTRIBUTE);
                temp.versionId = slugElement.getAttributeNS(PROMOTION_INFO_NS, VERSION_ID_ATTRIBUTE);
                finalBuildMaps.add(temp);
                ++i;
            }
        }
        NodeList datasetElements = document.getElementsByTagNameNS(PROMOTION_INFO_NS, RESOURCE_ELEMENT);
        HashMap<String, IPromotableResource> promotableResources = new HashMap<String, IPromotableResource>();
        if (datasetElements != null) {
            int i = 0;
            while (i < datasetElements.getLength()) {
                Element targetPDSElement;
                Element sourcePDSElement;
                Element datasetElement = (Element)datasetElements.item(i);
                if (promotionBuildType == PromotionInfo.PromotionBuildType.oldzos) {
                    sourcePDSElement = (Element)datasetElement.getElementsByTagNameNS(PROMOTION_INFO_NS, SOURCE_PDS_ELEMENT).item(0);
                    targetPDSElement = (Element)datasetElement.getElementsByTagNameNS(PROMOTION_INFO_NS, TARGET_PDS_ELEMENT).item(0);
                } else {
                    sourcePDSElement = (Element)datasetElement.getElementsByTagNameNS(PROMOTION_INFO_NS, SOURCE_RESOURCE_ELEMENT).item(0);
                    targetPDSElement = (Element)datasetElement.getElementsByTagNameNS(PROMOTION_INFO_NS, TARGET_RESOURCE_ELEMENT).item(0);
                }
                String resourceType = sourcePDSElement.getAttributeNS(PROMOTION_INFO_NS, TYPE_ATTRIBUTE);
                String sourcePDS = sourcePDSElement.getAttributeNS(PROMOTION_INFO_NS, NAME_ATTRIBUTE);
                String targetPDS = targetPDSElement.getAttributeNS(PROMOTION_INFO_NS, NAME_ATTRIBUTE);
                Element membersElement = (Element)datasetElement.getElementsByTagNameNS(PROMOTION_INFO_NS, MEMBERS_ELEMENT).item(0);
                NodeList memberElements = membersElement.getElementsByTagNameNS(PROMOTION_INFO_NS, SOURCE_MEMBER_ELEMENT);
                ArrayList<IPromotableFile> files = new ArrayList<IPromotableFile>();
                if (memberElements != null) {
                    int j = 0;
                    while (j < memberElements.getLength()) {
                        Element memberElement = (Element)memberElements.item(j);
                        String name = memberElement.getAttributeNS(PROMOTION_INFO_NS, NAME_ATTRIBUTE);
                        String deployable = memberElement.getAttributeNS(PROMOTION_INFO_NS, IS_DEPLOYABLE_ATTRIBUTE);
                        String timestamp = memberElement.getAttributeNS(PROMOTION_INFO_NS, TIMESTAMP_ATTRIBUTE);
                        String type = memberElement.getAttributeNS(PROMOTION_INFO_NS, TYPE_ATTRIBUTE);
                        String scmLocation = memberElement.getAttributeNS(PROMOTION_INFO_NS, SCM_LOCATION_ATTRIBUTE);
                        String versionId = memberElement.getAttributeNS(PROMOTION_INFO_NS, VERSION_ID_ATTRIBUTE);
                        IPromotableFile.Reason reason = PromotionInfoUtil.convertToReason(memberElement.getAttributeNS(PROMOTION_INFO_NS, REASON_ATTRIBUTE));
                        PromotableFile file = new PromotableFile(name, Boolean.parseBoolean(deployable), Long.parseLong(timestamp), type, scmLocation, versionId, reason);
                        String deployType = memberElement.getAttributeNS(PROMOTION_INFO_NS, DEPLOY_TYPE_ATTRIBUTE);
                        if (deployType != null && !deployType.isEmpty()) {
                            file.setDeployType(deployType);
                        }
                        files.add(file);
                        ++j;
                    }
                }
                PromotableResource promotableResource = new PromotableResource(files, sourcePDS, targetPDS, resourceType);
                promotableResources.put(sourcePDS, promotableResource);
                ++i;
            }
        }
        String srcHfsPath = null;
        String targetHfsPath = null;
        NodeList hfsSrcList = document.getElementsByTagNameNS(PROMOTION_INFO_NS, SRC_HFS_ELEMENT);
        if (hfsSrcList != null && hfsSrcList.getLength() > 0) {
            srcHfsPath = ((Element)hfsSrcList.item(0)).getAttributeNS(PROMOTION_INFO_NS, PATH_ATTRIBUTE);
        }
        if ((hfsTargetList = document.getElementsByTagNameNS(PROMOTION_INFO_NS, TARGET_HFS_ELEMENT)) != null && hfsTargetList.getLength() > 0) {
            targetHfsPath = ((Element)hfsTargetList.item(0)).getAttributeNS(PROMOTION_INFO_NS, PATH_ATTRIBUTE);
        }
        PromotionInfo promotionInfo = new PromotionInfo(promotableResources, buildMaps, promotionBuildType, promotionType);
        promotionInfo.setSourceHFSDir(srcHfsPath);
        promotionInfo.setTargetHFSDir(targetHfsPath);
        promotionInfo.setFinalBuildMaps(finalBuildMaps);
        return promotionInfo;
    }

    public static String getXmlString(PromotionInfo promotionInfo) throws TransformerConfigurationException, TransformerFactoryConfigurationError, TransformerException, UnsupportedEncodingException, ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        Document promotionInfoDoc = factory.newDocumentBuilder().newDocument();
        promotionInfoDoc.appendChild(promotionInfoDoc.createProcessingInstruction(XML_STYLESHEET, XSL_INSTRUCTION));
        promotionInfoDoc.appendChild(PromotionInfoUtil.getPromotionInfoElement(promotionInfo, promotionInfoDoc));
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(4096);
        StreamResult result = new StreamResult(outputStream);
        PromotionInfoUtil.transform(result, promotionInfoDoc);
        String xml = outputStream.toString(UTF_8);
        return xml;
    }

    private static void transform(Result result, Document document) throws TransformerConfigurationException, TransformerFactoryConfigurationError, TransformerException {
        DOMSource source = new DOMSource(document);
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("indent", YES);
        transformer.setOutputProperty(INDENT_AMOUNT, THREE);
        transformer.transform(source, result);
    }

    public static String getPromotionInfoURIRoot(String repositoryLocation) {
        StringBuffer buildMapURI = new StringBuffer();
        if (repositoryLocation != null) {
            buildMapURI.append(repositoryLocation);
            if (buildMapURI.charAt(buildMapURI.length() - 1) != '/') {
                buildMapURI.append('/');
            }
            buildMapURI.append("teamz_promote");
            buildMapURI.append('/');
        }
        return buildMapURI.toString();
    }

    public static IPromotableFile.Reason convertToReason(String reasonValue) {
        IPromotableFile.Reason reason = IPromotableFile.Reason.CHANGESET;
        if (IPromotableFile.Reason.LINKED.name().equals(reasonValue)) {
            reason = IPromotableFile.Reason.LINKED;
        } else if (IPromotableFile.Reason.IMPACTED.name().equals(reasonValue)) {
            reason = IPromotableFile.Reason.IMPACTED;
        }
        return reason;
    }

    public static PromotionInfo.PromotionType convertToPromotionType(String value) {
        try {
            return PromotionInfo.PromotionType.valueOf(value);
        }
        catch (Exception e) {
            return PromotionInfo.PromotionType.unspecified;
        }
    }

    public static String normalizeVariantChars(String resourceName) {
        String correctedResourceName = resourceName;
        correctedResourceName = correctedResourceName.replace('\u00d8', '@');
        correctedResourceName = correctedResourceName.replace('\u00c6', '#');
        correctedResourceName = correctedResourceName.replace('\u00c5', '$');
        correctedResourceName = correctedResourceName.replace('\u00d1', '#');
        correctedResourceName = correctedResourceName.replace('\u00a7', '@');
        correctedResourceName = correctedResourceName.replace('\u00d6', '@');
        correctedResourceName = correctedResourceName.replace('\u00c4', '$');
        correctedResourceName = correctedResourceName.replace('\u00c5', '$');
        correctedResourceName = correctedResourceName.replace('\u00a5', '$');
        return correctedResourceName;
    }
}

