/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.common.promotion.util;

import com.ibm.team.enterprise.build.common.promotion.IPromotableResource;
import com.ibm.team.scm.common.IVersionableHandle;
import java.net.URI;
import java.util.List;
import java.util.Map;

public class PromotionInfo {
    private Map<String, IPromotableResource> fPromotableResources;
    private List<BuildMapEntry> fTemporaryBuildMaps;
    private List<BuildMapEntry> fFinalBuildMaps;
    private final PromotionBuildType type;
    private final PromotionType promotionType;
    private String sourceHFSDir;
    private String targetHFSDir;

    public PromotionInfo(Map<String, IPromotableResource> promotableResources, List<BuildMapEntry> temporaryBuildMaps, PromotionBuildType type, PromotionType promotionType) {
        this.fPromotableResources = promotableResources;
        this.fTemporaryBuildMaps = temporaryBuildMaps;
        this.type = type;
        this.promotionType = promotionType;
    }

    public PromotionInfo(List<BuildMapEntry> finalBuildMaps, PromotionBuildType type, PromotionType promotionType) {
        this.fFinalBuildMaps = finalBuildMaps;
        this.type = type;
        this.promotionType = promotionType;
    }

    public void setPromotableResources(Map<String, IPromotableResource> promotableResources) {
        this.fPromotableResources = promotableResources;
    }

    public Map<String, IPromotableResource> getPromotableResources() {
        return this.fPromotableResources;
    }

    public void setTemporaryBuildMaps(List<BuildMapEntry> temporaryBuildMaps) {
        this.fTemporaryBuildMaps = temporaryBuildMaps;
    }

    public List<BuildMapEntry> getTemporaryBuildMaps() {
        return this.fTemporaryBuildMaps;
    }

    public void setFinalBuildMaps(List<BuildMapEntry> finalBuildMaps) {
        this.fFinalBuildMaps = finalBuildMaps;
    }

    public List<BuildMapEntry> getFinalBuildMaps() {
        return this.fFinalBuildMaps;
    }

    public PromotionBuildType getPromotionBuildType() {
        return this.type;
    }

    public PromotionType getPromotionType() {
        return this.promotionType;
    }

    public String getSourceHFSDir() {
        return this.sourceHFSDir;
    }

    public void setSourceHFSDir(String sourceHFSDir) {
        this.sourceHFSDir = sourceHFSDir;
        if (sourceHFSDir != null && !sourceHFSDir.isEmpty() && !sourceHFSDir.endsWith("/")) {
            this.sourceHFSDir = String.valueOf(this.sourceHFSDir) + "/";
        }
    }

    public String getTargetHFSDir() {
        return this.targetHFSDir;
    }

    public void setTargetHFSDir(String targetHFSDir) {
        this.targetHFSDir = targetHFSDir;
        if (targetHFSDir != null && !targetHFSDir.isEmpty() && !targetHFSDir.endsWith("/")) {
            this.targetHFSDir = String.valueOf(this.targetHFSDir) + "/";
        }
    }

    public static class BuildMapEntry {
        public URI uri;
        public String label;
        public String versionId;
        public IVersionableHandle versionable;
    }

    public static enum PromotionBuildType {
        oldzos,
        zos,
        ibmi;

    }

    public static enum PromotionType {
        unspecified,
        component,
        workitem;

    }
}

