/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.common.promotion.util;

import com.ibm.team.build.common.model.IBuildConfigurationElement;
import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionInstance;

public class PromotionBuildUtil {
    public static boolean isIBMiPromotionBuild(IBuildDefinition buildDefinition) {
        return buildDefinition.getConfigurationElement("com.ibm.team.enterprise.ibmi.promotion.build") != null;
    }

    public static boolean isZosPromotionBuild(IBuildDefinition buildDefinition) {
        return buildDefinition.getConfigurationElement("com.ibm.team.enterprise.promotion.build") != null;
    }

    public static boolean isPromotionBuild(IBuildDefinition buildDefinition) {
        return PromotionBuildUtil.isZosPromotionBuild(buildDefinition) || PromotionBuildUtil.isIBMiPromotionBuild(buildDefinition);
    }

    public static boolean isIBMiPromotionBuild(IBuildDefinitionInstance buildDefinitionInstance) {
        return buildDefinitionInstance.getConfigurationElement("com.ibm.team.enterprise.ibmi.promotion.build") != null;
    }

    public static boolean isZosPromotionBuild(IBuildDefinitionInstance buildDefinitionInstance) {
        return buildDefinitionInstance.getConfigurationElement("com.ibm.team.enterprise.promotion.build") != null;
    }

    public static boolean isPromotionBuild(IBuildDefinitionInstance buildDefinitionInstance) {
        return PromotionBuildUtil.isZosPromotionBuild(buildDefinitionInstance) || PromotionBuildUtil.isIBMiPromotionBuild(buildDefinitionInstance);
    }

    public static IBuildConfigurationElement getPromotionBuildConfigurationElement(IBuildDefinition buildDefinition) {
        if (PromotionBuildUtil.isZosPromotionBuild(buildDefinition)) {
            return buildDefinition.getConfigurationElement("com.ibm.team.enterprise.promotion.build");
        }
        if (PromotionBuildUtil.isIBMiPromotionBuild(buildDefinition)) {
            return buildDefinition.getConfigurationElement("com.ibm.team.enterprise.ibmi.promotion.build");
        }
        return null;
    }

    public static String getConcurrentFilePath(String parentPath, String buildLabel, String fileName, String suffix, String separator) {
        String result = null;
        if (fileName == null || fileName.isEmpty()) {
            return result;
        }
        StringBuilder builder = new StringBuilder();
        if (parentPath != null && parentPath.length() > 0) {
            builder.append(parentPath);
            if (!parentPath.endsWith("/") && !parentPath.endsWith("\\")) {
                builder.append(separator);
            }
        }
        builder.append(fileName);
        if (buildLabel != null) {
            builder.append('_');
            builder.append(buildLabel);
        }
        if (suffix != null) {
            builder.append(suffix);
        }
        result = builder.toString();
        return result;
    }
}

