/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.common.promotion.util;

import com.ibm.team.enterprise.build.common.promotion.IPromotedComponentMetadata;
import com.ibm.team.enterprise.build.common.promotion.util.PromotedMetadata;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PromotedMetadataUtil {
    private static final String PROMOTED_METADATA_NS = "http://www.ibm.com/enterprise/promotion/promotedMetadata";
    public static final String PROMOTED_METADATA_FILE_NAME = "promotedMetadata.xml";
    private static final String PROMOTED_METADATA_PREFIX = "pm:";
    private static final String PROMOTED_METADATA_ELEMENT = "promotedMetadata";
    private static final String COMPONENTS_ELEMENT = "components";
    private static final String SOURCE_STREAM_ATTRIBUTE = "sourceStream";
    private static final String TARGET_STREAM_ATTRIBUTE = "targetStream";
    private static final String COMPONENT_ELEMENT = "component";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String VOLUME_ELEMENT = "volume";
    private static final String REVISION_ATTRIBUTE = "revision";
    private static final String YES = "yes";
    private static final String INDENT_AMOUNT = "{http://xml.apache.org/xalan}indent-amount";
    private static final String THREE = "3";
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private static final String UTF_8 = "UTF-8";

    public static Element getPromotedMetadataElement(PromotedMetadata promotedMetadata, Document promotedMetadataDoc) {
        Element rootElement = promotedMetadataDoc.createElementNS(PROMOTED_METADATA_NS, "pm:promotedMetadata");
        Element promotableResourcesElement = promotedMetadataDoc.createElementNS(PROMOTED_METADATA_NS, "pm:components");
        promotableResourcesElement.setAttributeNS(PROMOTED_METADATA_NS, "pm:sourceStream", promotedMetadata.getSourceStream());
        promotableResourcesElement.setAttributeNS(PROMOTED_METADATA_NS, "pm:targetStream", promotedMetadata.getTargetStream());
        rootElement.appendChild(promotableResourcesElement);
        if (promotedMetadata.getPromotedComponentMetadata() != null) {
            for (IPromotedComponentMetadata componentMetadata : promotedMetadata.getPromotedComponentMetadata()) {
                Element componentElement = promotedMetadataDoc.createElementNS(PROMOTED_METADATA_NS, "pm:component");
                componentElement.setAttributeNS(PROMOTED_METADATA_NS, "pm:name", componentMetadata.getId());
                for (Map.Entry<Integer, String> volumeRevision : componentMetadata.getVolumeRevisions().entrySet()) {
                    Element volumeElement = promotedMetadataDoc.createElementNS(PROMOTED_METADATA_NS, "pm:volume");
                    volumeElement.setAttributeNS(PROMOTED_METADATA_NS, "pm:name", volumeRevision.getKey().toString());
                    volumeElement.setAttributeNS(PROMOTED_METADATA_NS, "pm:revision", volumeRevision.getValue());
                    componentElement.appendChild(volumeElement);
                }
                promotableResourcesElement.appendChild(componentElement);
            }
        }
        return rootElement;
    }

    public static String getXmlString(PromotedMetadata promotedMetadata) throws TransformerConfigurationException, TransformerFactoryConfigurationError, TransformerException, UnsupportedEncodingException, ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        Document promotedMetadataDoc = factory.newDocumentBuilder().newDocument();
        promotedMetadataDoc.appendChild(PromotedMetadataUtil.getPromotedMetadataElement(promotedMetadata, promotedMetadataDoc));
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(4096);
        StreamResult result = new StreamResult(outputStream);
        PromotedMetadataUtil.transform(result, promotedMetadataDoc);
        return outputStream.toString(UTF_8);
    }

    private static void transform(Result result, Document document) throws TransformerConfigurationException, TransformerFactoryConfigurationError, TransformerException {
        DOMSource source = new DOMSource(document);
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("indent", YES);
        transformer.setOutputProperty(INDENT_AMOUNT, THREE);
        transformer.transform(source, result);
    }
}

