/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.common.promotion.impl;

import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.enterprise.build.common.IBuildUtility;
import com.ibm.team.enterprise.build.common.promotion.IPromotionParameters;
import com.ibm.team.enterprise.build.common.promotion.util.PromotionInfo;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public class PromotionParameters
implements IPromotionParameters {
    private final IBaselineHandle[] fBaselineHandles;
    private final IBuildResultHandle fSourceBuildResultHandle;
    private final IWorkspaceHandle fSourceWorkspaceHandle;
    private final IWorkspaceHandle fSourceStreamHandle;
    private final IBuildDefinitionHandle fTargetBuildDefinitionHandle;
    private final IWorkspaceHandle fTargetWorkspaceHandle;
    private final IWorkspaceHandle fTargetStreamHandle;
    private final Map<String, String> fSourceBuildResultProperties;
    private final Map<String, String> fSourceBuildResultDSDefProperties;
    private final Map<String, String> fTargetBuildDefinitionProperties;
    private PromotionInfo.PromotionBuildType type;
    private final List<UUID> linkedTypePromotedFiles;
    private final List<UUID> impactedTypePromotedFiles;

    public PromotionParameters(IWorkspaceHandle sourceWorkspaceHandle, IBuildResultHandle sourceBuildResultHandle, IWorkspaceHandle targetWorkspaceHandle, IBuildDefinitionHandle targetBuildDefinitionHandle, IBaselineHandle[] baselineHandles, IWorkspaceHandle sourceStreamHandle, IWorkspaceHandle targetStreamHandle, Map<String, String> sourceBuildResultProperties, Map<String, String> sourceDSDefBuildResultProperties, Hashtable<String, String> targetBuildDefinitionProperties, List<UUID> linkedTypePromotedFiles, List<UUID> impactedTypePromotedFiles) {
        this.fBaselineHandles = baselineHandles;
        this.fSourceBuildResultHandle = sourceBuildResultHandle;
        this.fSourceStreamHandle = sourceStreamHandle;
        this.fTargetBuildDefinitionHandle = targetBuildDefinitionHandle;
        this.fTargetStreamHandle = targetStreamHandle;
        this.fSourceBuildResultProperties = sourceBuildResultProperties == null ? Collections.EMPTY_MAP : sourceBuildResultProperties;
        this.fSourceBuildResultDSDefProperties = sourceDSDefBuildResultProperties == null ? Collections.EMPTY_MAP : sourceDSDefBuildResultProperties;
        Map<String, String> map = this.fTargetBuildDefinitionProperties = targetBuildDefinitionProperties == null ? Collections.EMPTY_MAP : targetBuildDefinitionProperties;
        this.type = IBuildUtility.isIBMiDependencyBuild(sourceBuildResultProperties) ? PromotionInfo.PromotionBuildType.ibmi : (IBuildUtility.isZOSDependencyBuild(sourceBuildResultProperties) ? PromotionInfo.PromotionBuildType.zos : PromotionInfo.PromotionBuildType.oldzos);
        this.linkedTypePromotedFiles = linkedTypePromotedFiles;
        this.impactedTypePromotedFiles = impactedTypePromotedFiles;
        this.fSourceWorkspaceHandle = sourceWorkspaceHandle;
        this.fTargetWorkspaceHandle = targetWorkspaceHandle;
    }

    @Override
    public IBaselineHandle[] getBaselineHandles() {
        return this.fBaselineHandles;
    }

    @Override
    public IBuildResultHandle getSourceBuildResultHandle() {
        return this.fSourceBuildResultHandle;
    }

    @Override
    public IWorkspaceHandle getSourceStreamHandle() {
        return this.fSourceStreamHandle;
    }

    @Override
    public IBuildDefinitionHandle getTargetBuildDefinitionHandle() {
        return this.fTargetBuildDefinitionHandle;
    }

    @Override
    public IWorkspaceHandle getTargetStreamHandle() {
        return this.fTargetStreamHandle;
    }

    @Override
    public Map<String, String> getSourceBuildResultProperties() {
        return this.fSourceBuildResultProperties;
    }

    @Override
    public Map<String, String> getSourceBuildResultDSDefProperties() {
        return this.fSourceBuildResultDSDefProperties;
    }

    @Override
    public Map<String, String> getTargetBuildDefinitionProperties() {
        return this.fTargetBuildDefinitionProperties;
    }

    @Override
    public PromotionInfo.PromotionBuildType getPromotionBuildType() {
        return this.type;
    }

    @Override
    public boolean isLinkedTypePromotedFile(IVersionableHandle versionableHandle) {
        return versionableHandle != null && this.linkedTypePromotedFiles != null && this.linkedTypePromotedFiles.contains(versionableHandle.getItemId());
    }

    @Override
    public boolean isImpactedTypePromotedFile(IVersionableHandle versionableHandle) {
        return versionableHandle != null && this.impactedTypePromotedFiles != null && this.impactedTypePromotedFiles.contains(versionableHandle.getItemId());
    }

    @Override
    public IWorkspaceHandle getSourceWorkspaceHandle() {
        return this.fSourceWorkspaceHandle;
    }

    @Override
    public IWorkspaceHandle getTargetWorkspaceHandle() {
        return this.fTargetWorkspaceHandle;
    }
}

