/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.common.promotion.build;

import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import java.util.ArrayList;
import java.util.List;

public class PropertyParser {
    private static String tokenSeparator = ";";

    public static IVersionableHandle[] toVerionableHandles(String propertyValue) {
        String[] UUIDValues;
        if (propertyValue == null) {
            return new IVersionableHandle[0];
        }
        ArrayList<IVersionableHandle> handles = new ArrayList<IVersionableHandle>();
        String[] stringArray = UUIDValues = propertyValue.split(tokenSeparator);
        int n = UUIDValues.length;
        int n2 = 0;
        while (n2 < n) {
            String UUIDValue = stringArray[n2];
            UUID uuid = PropertyParser.getUUID(UUIDValue);
            if (uuid != null) {
                handles.add((IVersionableHandle)IFileItem.ITEM_TYPE.createItemHandle(uuid, null));
            }
            ++n2;
        }
        return handles.toArray(new IVersionableHandle[handles.size()]);
    }

    public static List<IVersionableHandle> toList(String propertyValue) {
        String[] UUIDValues;
        if (propertyValue == null || "".equals(propertyValue)) {
            return new ArrayList<IVersionableHandle>();
        }
        ArrayList<IVersionableHandle> handles = new ArrayList<IVersionableHandle>();
        String[] stringArray = UUIDValues = propertyValue.split(tokenSeparator);
        int n = UUIDValues.length;
        int n2 = 0;
        while (n2 < n) {
            String UUIDValue = stringArray[n2];
            UUID uuid = PropertyParser.getUUID(UUIDValue);
            if (uuid != null) {
                handles.add((IVersionableHandle)IFileItem.ITEM_TYPE.createItemHandle(uuid, null));
            }
            ++n2;
        }
        return handles;
    }

    public static String toString(IItemHandle[] handles) {
        StringBuffer aString = new StringBuffer();
        IItemHandle[] iItemHandleArray = handles;
        int n = handles.length;
        int n2 = 0;
        while (n2 < n) {
            IItemHandle handle = iItemHandleArray[n2];
            if (aString.length() > 0) {
                aString.append(tokenSeparator);
            }
            aString.append(handle.getItemId().getUuidValue());
            ++n2;
        }
        return aString.toString();
    }

    public static IWorkItemHandle[] toWorkItemHandles(String propertyValue) {
        String[] UUIDValues;
        if (propertyValue == null) {
            return new IWorkItemHandle[0];
        }
        ArrayList<IWorkItemHandle> handles = new ArrayList<IWorkItemHandle>();
        String[] stringArray = UUIDValues = propertyValue.split(tokenSeparator);
        int n = UUIDValues.length;
        int n2 = 0;
        while (n2 < n) {
            String UUIDValue = stringArray[n2];
            UUID uuid = PropertyParser.getUUID(UUIDValue);
            if (uuid != null) {
                handles.add((IWorkItemHandle)IWorkItem.ITEM_TYPE.createItemHandle(uuid, null));
            }
            ++n2;
        }
        return handles.toArray(new IWorkItemHandle[handles.size()]);
    }

    public static String toString(List<IWorkItem> workItems) {
        StringBuffer buffer = new StringBuffer();
        for (IWorkItem workItem : workItems) {
            if (buffer.length() > 0) {
                buffer.append(tokenSeparator);
            }
            buffer.append(workItem.getId());
        }
        return buffer.toString();
    }

    public static String toString(int[] workItemIds) {
        StringBuffer buffer = new StringBuffer();
        int stop = workItemIds.length;
        if (stop > 20) {
            stop = 20;
        }
        int i = 0;
        while (i < stop) {
            if (buffer.length() > 0) {
                buffer.append(tokenSeparator);
            }
            buffer.append(workItemIds[i]);
            ++i;
        }
        if (workItemIds.length > stop) {
            buffer.append(". . .");
        }
        return buffer.toString();
    }

    public static int[] toWorkItemIds(String propertyValue) {
        if (propertyValue == null) {
            return new int[0];
        }
        String[] idValues = propertyValue.split(tokenSeparator);
        int[] workItemIds = new int[idValues.length];
        int i = 0;
        while (i < idValues.length) {
            workItemIds[i] = Integer.valueOf(idValues[i]);
            ++i;
        }
        return workItemIds;
    }

    private static UUID getUUID(String value) {
        if (value == null || value.trim().length() == 0) {
            return null;
        }
        try {
            return UUID.valueOf((String)value);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }
}

