/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.common.promotion.build;

import com.ibm.team.build.common.model.IBuildConfigurationElement;
import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionInstance;
import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.build.common.model.IConfigurationProperty;
import com.ibm.team.enterprise.build.common.promotion.util.PromotionBuildUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class PromotionBuildPropertyFactory {
    public static PromotionBuildPropertyFactory instance;
    private Map<String, String> ibmiConfigurationPropertyMap;
    private Map<String, String> ibmiBuildDefinitionPropertyMap;

    private PromotionBuildPropertyFactory() {
        this.initIBMiConfigurationPropertyMap();
        this.initBuildDefinitionPropertyMap();
    }

    private void initIBMiConfigurationPropertyMap() {
        this.ibmiConfigurationPropertyMap = new HashMap<String, String>();
        this.ibmiConfigurationPropertyMap.put("teamz.build.ant.buildFile", "team.enterprise.promotion.ant.buildFile");
        this.ibmiConfigurationPropertyMap.put("teamz.build.ant.buildTarget", "team.enterprise.promotion.ant.buildTarget");
        this.ibmiConfigurationPropertyMap.put("teamz.build.ant.antHome", "team.enterprise.promotion.ant.antHome");
        this.ibmiConfigurationPropertyMap.put("teamz.build.ant.antArgs", "team.enterprise.promotion.ant.antArgs");
        this.ibmiConfigurationPropertyMap.put("teamz.build.ant.workingDir", "team.enterprise.promotion.ant.workingDir");
        this.ibmiConfigurationPropertyMap.put("teamz.build.ant.propertiesFile", "team.enterprise.promotion.ant.propertiesFile");
        this.ibmiConfigurationPropertyMap.put("teamz.build.ant.javaVMArgs", "team.enterprise.promotion.ant.javaVMArgs");
        this.ibmiConfigurationPropertyMap.put("teamz.build.ant.javaHome", "team.enterprise.promotion.ant.javaHome");
    }

    private void initBuildDefinitionPropertyMap() {
        this.ibmiBuildDefinitionPropertyMap = new HashMap<String, String>();
        this.ibmiBuildDefinitionPropertyMap.put("com.ibm.team.enterprise.promotion.build", "com.ibm.team.enterprise.ibmi.promotion.build");
        this.ibmiBuildDefinitionPropertyMap.put("teamz.build.dependency.previewBuild", "team.enterprise.build.dependency.previewBuild");
    }

    public static PromotionBuildPropertyFactory getInstance() {
        if (instance == null) {
            instance = new PromotionBuildPropertyFactory();
        }
        return instance;
    }

    public String getConfigurationPropertyValue(String propertyId, String elementId, IBuildDefinition buildDefinition) {
        return buildDefinition.getConfigurationPropertyValue(elementId, this.resolvePropertyId(propertyId, elementId), null);
    }

    public String getConfigurationPropertyValue(String propertyId, String elementId, IBuildDefinitionInstance buildDefinitionInstance) {
        IConfigurationProperty property;
        IBuildConfigurationElement element = buildDefinitionInstance.getConfigurationElement(elementId);
        if (element != null && (property = element.getConfigurationProperty(this.resolvePropertyId(propertyId, elementId))) != null) {
            return property.getValue();
        }
        return null;
    }

    public void setConfigurationPropertyValue(String propertyId, String propertyValue, String elementId, IBuildDefinition buildDefinition) {
        buildDefinition.setConfigurationProperty(elementId, this.resolvePropertyId(propertyId, elementId), propertyValue);
    }

    public String getBuildPropertyValue(String propertyId, IBuildDefinition buildDefinition) {
        return this.getBuildPropertyValue(propertyId, buildDefinition, null);
    }

    public String getBuildPropertyValue(String propertyId, IBuildDefinition buildDefinition, String defaultValue) {
        return buildDefinition.getPropertyValue(this.resolvePropertyId(propertyId, buildDefinition), defaultValue);
    }

    public IBuildProperty getBuildProperty(String propertyId, IBuildDefinition buildDefinition) {
        return buildDefinition.getProperty(this.resolvePropertyId(propertyId, buildDefinition));
    }

    public void setBuildProperty(String propertyId, String propertyValue, IBuildDefinition buildDefinition) {
        buildDefinition.setProperty(this.resolvePropertyId(propertyId, buildDefinition), propertyValue);
    }

    public String getBuildPropertyValue(String propertyId, Properties buildProperties) {
        return (String)buildProperties.get(this.resolvePropertyId(propertyId, buildProperties));
    }

    public String getBuildPropertyValue(String propertyId, Map<String, String> buildProperties) {
        return buildProperties.get(this.resolvePropertyId(propertyId, buildProperties));
    }

    public String resolvePropertyId(String propertyId, IBuildDefinition buildDefinition) {
        boolean isIBMiPromotion = PromotionBuildUtil.isIBMiPromotionBuild(buildDefinition);
        return this.resolvePropertyId(propertyId, isIBMiPromotion, this.ibmiBuildDefinitionPropertyMap);
    }

    public String resolvePropertyId(String propertyId, IBuildDefinitionInstance buildDefinitionInstance) {
        boolean isIBMiPromotion = PromotionBuildUtil.isIBMiPromotionBuild(buildDefinitionInstance);
        return this.resolvePropertyId(propertyId, isIBMiPromotion, this.ibmiBuildDefinitionPropertyMap);
    }

    private String resolvePropertyId(String propertyId, String elementId) {
        boolean isIBMiPromotion = "com.ibm.team.enterprise.ibmi.promotion.build".equals(elementId);
        return this.resolvePropertyId(propertyId, isIBMiPromotion, this.ibmiConfigurationPropertyMap);
    }

    private String resolvePropertyId(String propertyId, Properties buildProperties) {
        boolean isIBMiPromotion = "com.ibm.team.enterprise.promotion.ibmi".equals(buildProperties.get("com.ibm.team.build.internal.template.id"));
        return this.resolvePropertyId(propertyId, isIBMiPromotion, this.ibmiBuildDefinitionPropertyMap);
    }

    private String resolvePropertyId(String propertyId, Map<String, String> buildProperties) {
        boolean isIBMiPromotion = "com.ibm.team.enterprise.promotion.ibmi".equals(buildProperties.get("com.ibm.team.build.internal.template.id"));
        return this.resolvePropertyId(propertyId, isIBMiPromotion, this.ibmiBuildDefinitionPropertyMap);
    }

    private String resolvePropertyId(String propertyId, boolean isIBMiPromotion, Map<String, String> propertyMap) {
        String newPropertyId;
        if (isIBMiPromotion) {
            newPropertyId = propertyMap.get(propertyId);
            if (newPropertyId == null) {
                newPropertyId = propertyId;
            }
        } else {
            newPropertyId = propertyId;
        }
        return newPropertyId;
    }
}

