/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.common.promotion;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.enterprise.build.common.promotion.IPromotionChangeEventConstants;
import com.ibm.team.enterprise.build.common.promotion.build.PropertyParser;
import com.ibm.team.enterprise.build.common.promotion.nls.Messages;
import com.ibm.team.enterprise.common.common.feed.ChangeEventHelper;
import com.ibm.team.repository.common.IChangeEvent;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.service.IChangeEventService;
import java.util.Properties;
import org.eclipse.osgi.util.NLS;

public class PromotionChangeEventHelper
implements IPromotionChangeEventConstants {
    public static IChangeEvent createPromotionChangeEvent(IBuildDefinition promotionBuildDefinition, int[] workItemIds, boolean isPreview, boolean isSuccess, boolean isWorkItemPromotion, IBuildResult buildResult, IChangeEventService changeEventService) throws TeamRepositoryException {
        Properties properties = new Properties();
        if (workItemIds != null && workItemIds.length > 0) {
            properties.setProperty("team.enterprise.promotion.event.property.workItems", PropertyParser.toString(workItemIds));
        }
        properties.setProperty("team.enterprise.promotion.event.property.buildDefinitionHandle", promotionBuildDefinition.getItemHandle().getItemId().getUuidValue());
        properties.setProperty("team.enterprise.promotion.event.property.isPreview", Boolean.toString(isPreview));
        properties.setProperty("team.enterprise.promotion.event.property.isSuccess", Boolean.toString(isSuccess));
        properties.setProperty("team.enterprise.promotion.event.property.isWorkItemPromotion", Boolean.toString(isWorkItemPromotion));
        String notificationMessage = promotionBuildDefinition.getId();
        IItemHandle itemHandle = promotionBuildDefinition.getItemHandle();
        if (buildResult != null) {
            properties.setProperty("team.enterprise.promotion.event.property.buildResultHandle", buildResult.getItemHandle().getItemId().getUuidValue());
            notificationMessage = String.valueOf(promotionBuildDefinition.getId()) + " " + buildResult.getLabel();
            itemHandle = buildResult.getItemHandle();
        }
        properties.setProperty("com.ibm.team.enterprise.event.message", notificationMessage);
        String title = isSuccess ? Messages.getCommonString("ChangeEvent.Label.PromotionSuccess") : Messages.getCommonString("Promotion failed");
        String description = PromotionChangeEventHelper.createHtmlDescription(promotionBuildDefinition, isPreview, isSuccess, isWorkItemPromotion, workItemIds, buildResult);
        return ChangeEventHelper.createChangeEvent((String)"com.ibm.team.enterprise.eventtype.promotionComplete", (String)title, (String)description, (IItemHandle)itemHandle, (Properties)properties, (IChangeEventService)changeEventService);
    }

    private static String createHtmlDescription(IBuildDefinition promotionBuildDefinition, boolean isPreview, boolean isSuccess, boolean isWorkItemPromotion, int[] workItemIds, IBuildResult buildResult) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(NLS.bind((String)Messages.getCommonString("ChangeEvent.Label.PromotionDefinition"), (Object)promotionBuildDefinition.getId())).append("<p/>");
        String typeLabel = isWorkItemPromotion ? (isPreview ? Messages.getCommonString("ChangeEvent.Label.Type.WorkItemPreview") : Messages.getCommonString("ChangeEvent.Label.Type.WorkItem")) : (isPreview ? Messages.getCommonString("ChangeEvent.Label.Type.ComponentPreview") : Messages.getCommonString("ChangeEvent.Label.Type.Component"));
        buffer.append(typeLabel).append("<p/>");
        if (isSuccess) {
            buffer.append(Messages.getCommonString("ChangeEvent.Label.StatusSuccess")).append("<p/>");
        } else {
            buffer.append(Messages.getCommonString("ChangeEvent.Label.StatusFailed")).append("<p/>");
        }
        if (isWorkItemPromotion) {
            buffer.append(NLS.bind((String)Messages.getCommonString("ChangeEvent.Label.WorkItems"), (Object)PropertyParser.toString(workItemIds))).append("<p/>");
        }
        if (buildResult != null) {
            buffer.append(NLS.bind((String)Messages.getCommonString("ChangeEvent.Label.BuildResult"), (Object)buildResult.getLabel())).append("<p/>");
        }
        return buffer.toString();
    }
}

