/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.common.dependencyset;

import com.ibm.team.enterprise.build.buildmap.common.model.IInputBuildFile;
import com.ibm.team.enterprise.build.common.dependencyset.IDependencySet;
import com.ibm.team.enterprise.build.common.dependencyset.nls.Messages;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.List;

public class DependencySet
implements IDependencySet {
    private static final String TYPE_SELF = "SELF";
    List<IInputBuildFile> fPhysicalDependencies;
    IInputBuildFile fSelf;

    public DependencySet(List<IInputBuildFile> dependencies) throws TeamRepositoryException {
        this.fPhysicalDependencies = dependencies;
        for (IInputBuildFile inputFile : dependencies) {
            if (!inputFile.getType().equals(TYPE_SELF)) continue;
            this.fSelf = inputFile;
            break;
        }
        if (this.fSelf == null) {
            throw new TeamRepositoryException(Messages.DependencySet_MissingSelfDependency);
        }
    }

    @Override
    public List<IInputBuildFile> getPhysicalDependencies() {
        return this.fPhysicalDependencies;
    }

    @Override
    public IInputBuildFile getSelfDependency() {
        return this.fSelf;
    }
}

