/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.common.buildreport;

import com.ibm.team.enterprise.build.common.BuildableFileBuildResult;
import com.ibm.team.enterprise.build.common.buildreport.BuildReportConstants;
import com.ibm.team.enterprise.build.common.buildreport.CommonBuildReportUtil;
import com.ibm.team.enterprise.build.common.buildreport.IReportBuildFile;
import com.ibm.team.enterprise.internal.buildmap.common.IBuildFile;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ReportBuildFile
implements IReportBuildFile,
Cloneable {
    private int fMaxRC = -1;
    private long fOutputTimestamp = -1L;
    private int fReasonCode = -2;
    private String fComponent = null;
    private String fComponentUUID;
    private String fProject = null;
    private String fUuid = null;
    private String fStateID = null;
    private String fBuildFileFullPath = null;
    private String fVersionID = null;
    private String fLangDefName = null;
    private String fLangDefUUID = null;
    private String fLangDefStateID = null;
    private URI fBuildMapURL = null;
    private String fOutputType = null;
    private String fOutputFullPath = null;
    private BuildableFileBuildResult fBuildResult = null;
    private List<String> fChangedDependencyUUIDs = null;
    private List<IBuildFile> fInputs = null;
    private boolean fHFS;

    public ReportBuildFile(String component, String componentUUID, String project, int maxRC, String buildFile, String buildPath, String uuid, String langDefName, String langDefUUID, String langDefStateID, URI buildMapURL, String outputType, String sequential, String changedDependencyUUIDs, String fResourcePrefix, boolean isOmitPrefix, boolean isHFS) {
        String[] changedDependenciesRaw;
        this.fComponent = component;
        this.fComponentUUID = componentUUID;
        this.fProject = project;
        this.fMaxRC = maxRC;
        this.fLangDefName = langDefName;
        this.fLangDefUUID = langDefUUID;
        this.fLangDefStateID = langDefStateID;
        this.fBuildMapURL = buildMapURL;
        this.fOutputType = outputType;
        this.fUuid = uuid;
        this.fHFS = isHFS;
        String string = this.fBuildFileFullPath = isOmitPrefix ? CommonBuildReportUtil.generateFullPathWithoutPrefix(buildPath, buildFile, outputType, sequential, fResourcePrefix, isHFS) : CommonBuildReportUtil.generateBuildFileFullPath(buildPath, buildFile, outputType, sequential, isHFS);
        if (changedDependencyUUIDs != null && !"".equals(changedDependencyUUIDs) && (changedDependenciesRaw = changedDependencyUUIDs.split(",")).length != 0) {
            this.fChangedDependencyUUIDs = Arrays.asList(changedDependenciesRaw);
        }
    }

    @Override
    public boolean isChangedDependency(String dependencyUUID) {
        if (this.fChangedDependencyUUIDs == null) {
            return false;
        }
        return this.fChangedDependencyUUIDs.contains(dependencyUUID);
    }

    @Override
    public int getMaxRC() {
        return this.fMaxRC;
    }

    @Override
    public void setMaxRC(int fMaxRC) {
        this.fMaxRC = fMaxRC;
    }

    @Override
    public long getOutputTimestamp() {
        return this.fOutputTimestamp;
    }

    @Override
    public int getReasonCode() {
        return this.fReasonCode;
    }

    @Override
    public void setReasonCode(int fReturnCode) {
        this.fReasonCode = fReturnCode;
    }

    @Override
    public void setOutputTimestamp(long fOutputTimestamp) {
        this.fOutputTimestamp = fOutputTimestamp;
    }

    @Override
    public String getComponent() {
        return this.fComponent;
    }

    @Override
    public void setComponent(String fComponent) {
        this.fComponent = fComponent;
    }

    @Override
    public String getComponentUUID() {
        return this.fComponentUUID;
    }

    @Override
    public void setComponentUUID(String uuid) {
        this.fComponentUUID = uuid;
    }

    @Override
    public String getProject() {
        return this.fProject;
    }

    @Override
    public void setProject(String fProject) {
        this.fProject = fProject;
    }

    @Override
    public String getUUID() {
        return this.fUuid;
    }

    @Override
    public void setStateID(String fStateID) {
        this.fStateID = fStateID;
    }

    @Override
    public String getStateID() {
        return this.fStateID;
    }

    @Override
    public String getBuildFileFullPath() {
        return this.fBuildFileFullPath;
    }

    @Override
    public void setBuildFileFullPath(String fBuildFileFullPath) {
        this.fBuildFileFullPath = fBuildFileFullPath;
    }

    @Override
    public String getVersionID() {
        return this.fVersionID;
    }

    @Override
    public void setVersionID(String fVersionID) {
        this.fVersionID = fVersionID;
    }

    @Override
    public String getLangDefName() {
        return this.fLangDefName;
    }

    @Override
    public void setLangDefName(String fLangDefName) {
        this.fLangDefName = fLangDefName;
    }

    @Override
    public String getLangDefUUID() {
        return this.fLangDefUUID;
    }

    @Override
    public void setLangDefUUID(String fLangDefUUID) {
        this.fLangDefUUID = fLangDefUUID;
    }

    @Override
    public String getLangDefStateID() {
        return this.fLangDefStateID;
    }

    @Override
    public void setLangDefStateID(String fLangDefStateID) {
        this.fLangDefStateID = fLangDefStateID;
    }

    @Override
    public URI getBuildMapURL() {
        return this.fBuildMapURL;
    }

    @Override
    public void setBuildMapURL(URI fBuildMapURL) {
        this.fBuildMapURL = fBuildMapURL;
    }

    @Override
    public String getOutputType() {
        return this.fOutputType;
    }

    @Override
    public void setOutputType(String fOutputType) {
        this.fOutputType = fOutputType;
    }

    @Override
    public String getOutputFullPath() {
        return this.fOutputFullPath;
    }

    @Override
    public void setOutputFullPath(String fOutputFullPath) {
        this.fOutputFullPath = fOutputFullPath;
    }

    @Override
    public BuildableFileBuildResult getBuildResult() {
        return this.fBuildResult;
    }

    @Override
    public void setBuildResult(BuildableFileBuildResult fBuildResult) {
        this.fBuildResult = fBuildResult;
    }

    @Override
    public void setInputs(List<IBuildFile> fInputs) {
        this.fInputs = fInputs;
    }

    @Override
    public List<IBuildFile> getInputs() {
        if (this.fInputs == null) {
            this.fInputs = new ArrayList<IBuildFile>();
        }
        return this.fInputs;
    }

    @Override
    public boolean isHFS() {
        return this.fHFS;
    }

    public void setHFS(boolean fHFS) {
        this.fHFS = fHFS;
    }

    @Override
    public ReportBuildFile clone() throws CloneNotSupportedException {
        ReportBuildFile tempBF = (ReportBuildFile)super.clone();
        tempBF.setOutputFullPath(null);
        tempBF.setOutputTimestamp(-1L);
        tempBF.setOutputType(null);
        tempBF.setInputs(this.fInputs);
        tempBF.setHFS(this.fHFS);
        return tempBF;
    }

    public int hashCode() {
        int result = BuildReportConstants.HASHCODE_INITIAL;
        result = CommonBuildReportUtil.hashCode(result, this.fMaxRC);
        result = CommonBuildReportUtil.hashCode(result, this.fUuid);
        result = CommonBuildReportUtil.hashCode(result, this.fStateID);
        result = CommonBuildReportUtil.hashCode(result, this.fComponent);
        result = CommonBuildReportUtil.hashCode(result, this.fBuildFileFullPath);
        result = CommonBuildReportUtil.hashCode(result, this.fVersionID);
        result = CommonBuildReportUtil.hashCode(result, this.fLangDefName);
        result = CommonBuildReportUtil.hashCode(result, this.fLangDefUUID);
        result = CommonBuildReportUtil.hashCode(result, this.fLangDefStateID);
        result = CommonBuildReportUtil.hashCode(result, this.fBuildMapURL);
        result = CommonBuildReportUtil.hashCode(result, this.fOutputType);
        result = CommonBuildReportUtil.hashCode(result, this.fOutputFullPath);
        result = CommonBuildReportUtil.hashCode(result, this.fOutputTimestamp);
        result = CommonBuildReportUtil.hashCode(result, (Object)this.fBuildResult);
        result = CommonBuildReportUtil.hashCode(result, this.fHFS);
        return result;
    }

    public boolean equals(Object obj) {
        IReportBuildFile tempObj;
        if (this == obj) {
            return true;
        }
        boolean result = false;
        if (obj instanceof IReportBuildFile && this.fMaxRC == (tempObj = (IReportBuildFile)obj).getMaxRC() && this.fHFS == tempObj.isHFS() && CommonBuildReportUtil.compareObject(this.fUuid, tempObj.getUUID()) && CommonBuildReportUtil.compareObject(this.fStateID, tempObj.getStateID()) && CommonBuildReportUtil.compareObject(this.fComponent, tempObj.getComponent()) && CommonBuildReportUtil.compareObject(this.fProject, tempObj.getProject()) && CommonBuildReportUtil.compareObject(this.fBuildFileFullPath, tempObj.getBuildFileFullPath()) && CommonBuildReportUtil.compareObject(this.fVersionID, tempObj.getVersionID()) && CommonBuildReportUtil.compareObject(this.fLangDefName, tempObj.getLangDefName()) && CommonBuildReportUtil.compareObject(this.fLangDefUUID, tempObj.getLangDefUUID()) && CommonBuildReportUtil.compareObject(this.fLangDefStateID, tempObj.getLangDefStateID()) && CommonBuildReportUtil.compareObject(this.fBuildMapURL, tempObj.getBuildMapURL()) && CommonBuildReportUtil.compareObject(this.fOutputType, tempObj.getOutputType()) && CommonBuildReportUtil.compareObject(this.fOutputFullPath, tempObj.getOutputFullPath()) && CommonBuildReportUtil.compareObject(this.fOutputTimestamp, tempObj.getOutputTimestamp()) && CommonBuildReportUtil.compareObject((Object)this.fBuildResult, (Object)tempObj.getBuildResult())) {
            result = true;
        }
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.fUuid != null && this.fUuid.length() > 0) {
            builder.append("UUID: ").append(this.fUuid);
        }
        if (this.fStateID != null && this.fStateID.length() > 0) {
            builder.append("State ID: ").append(this.fStateID);
        }
        if (this.fComponent != null && this.fComponent.length() > 0) {
            builder.append("Component: ").append(this.fComponent);
        }
        if (this.fProject != null && this.fProject.length() > 0) {
            builder.append(" | Output Type: ").append(this.fProject);
        }
        if (this.fBuildFileFullPath != null && this.fBuildFileFullPath.length() > 0) {
            builder.append(" | Source: ").append(this.fBuildFileFullPath);
        }
        if (this.fVersionID != null && this.fVersionID.length() > 0) {
            builder.append(" | Version ID: ").append(this.fVersionID);
        }
        if (this.fLangDefName != null && this.fLangDefName.length() > 0) {
            builder.append(" | Language Definition: ").append(this.fLangDefName);
        }
        if (this.fLangDefName != null && this.fLangDefName.length() > 0) {
            builder.append(" | Language Definition UUID : ").append(this.fLangDefUUID);
        }
        if (this.fLangDefStateID != null && this.fLangDefStateID.length() > 0) {
            builder.append(" | Language Definition State ID: ").append(this.fLangDefStateID);
        }
        if (this.fBuildMapURL != null && this.fBuildMapURL.getPath() != null && this.fBuildMapURL.getPath().length() > 0) {
            builder.append(" | Build Map URL: ").append(this.fBuildMapURL.getPath());
        }
        if (this.fOutputFullPath != null && this.fOutputFullPath.length() > 0) {
            builder.append(" |  Output Full Path: ").append(this.fLangDefStateID);
        }
        if (this.fOutputType != null && this.fOutputType.length() > 0) {
            builder.append(" | Output type: ").append(this.fOutputType);
        }
        if (this.fOutputTimestamp > -1L) {
            builder.append(" | Output Timestamp: ").append(this.fOutputTimestamp);
        }
        if (this.fMaxRC > -1) {
            builder.append(" | Max Return Code: ").append(this.fMaxRC);
        }
        builder.append(" | HFS: ").append(this.fHFS);
        if (this.fBuildResult != null) {
            builder.append(" | Build Result: ").append((Object)this.fBuildResult);
        }
        if (this.fChangedDependencyUUIDs != null && this.fChangedDependencyUUIDs.size() > 0) {
            builder.append(" | Changed Dependency Set UUIDs: [");
            for (String uuid : this.fChangedDependencyUUIDs) {
                builder.append(uuid).append(";");
            }
            builder.deleteCharAt(builder.length() - 1);
            builder.append("]");
        }
        if (this.fInputs != null && this.fInputs.size() > 0) {
            builder.append(" | Inputs: [\n");
            for (IBuildFile input : this.fInputs) {
                builder.append(input).append("\n");
            }
            builder.deleteCharAt(builder.length() - 1);
            builder.append("]");
        }
        return builder.toString();
    }
}

