/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.common.buildreport;

import com.ibm.team.enterprise.build.common.buildreport.BuildReportConstants;
import com.ibm.team.enterprise.internal.buildmap.common.IBuildFile;
import java.lang.reflect.Array;

public class CommonBuildReportUtil {
    public static String generateBuildFileFullPath(IBuildFile buildFile) {
        if (buildFile == null) {
            return null;
        }
        return CommonBuildReportUtil.generateBuildFileFullPath(buildFile.getBuildPath(), buildFile.getBuildFile(), buildFile.getOutputType(), buildFile.getSequential(), buildFile.isHFS());
    }

    public static String generateBuildFileFullPath(String fbuildPath, String fBuildFile, String fOutputType, String fSequential, boolean isHFS) {
        if (fbuildPath == null) {
            fbuildPath = "";
        }
        if (fBuildFile == null) {
            fBuildFile = "";
        }
        StringBuilder buf = new StringBuilder(100);
        buf.append(fbuildPath);
        if (isHFS) {
            if (buf.length() > 0 && buf.charAt(buf.length() - 1) != '/') {
                buf.append('/');
            }
            buf.append(fBuildFile);
        } else if (fOutputType != null && !fOutputType.isEmpty()) {
            buf.append('/');
            buf.append(fBuildFile);
            buf.append(" OBJTYPE(");
            buf.append(fOutputType);
            buf.append(')');
        } else if (!fbuildPath.contains("OBJTYPE")) {
            if (fSequential != null && !fSequential.isEmpty() && !fSequential.equalsIgnoreCase("false")) {
                buf.append('.');
                buf.append(fBuildFile);
            } else {
                buf.append('(');
                buf.append(fBuildFile);
                buf.append(')');
            }
        }
        return buf.toString();
    }

    public static String generateFullPathWithoutPrefix(String fbuildPath, String fBuildFile, String fOutputType, String fSequential, String fResourcePrefix, boolean isHFS) {
        if (fbuildPath == null) {
            fbuildPath = "";
        }
        if (fBuildFile == null) {
            fBuildFile = "";
        }
        StringBuilder buf = new StringBuilder(100);
        if (fbuildPath != null && fResourcePrefix != null && fResourcePrefix.length() > 0 && fbuildPath.startsWith(fResourcePrefix) && fbuildPath.length() > fResourcePrefix.length() + 1) {
            fbuildPath = fbuildPath.substring(fResourcePrefix.length() + 1);
        }
        buf.append(fbuildPath);
        if (fOutputType != null && !fOutputType.isEmpty()) {
            buf.append('/');
            buf.append(fBuildFile);
            buf.append(" OBJTYPE(");
            buf.append(fOutputType);
            buf.append(')');
        } else if (!fbuildPath.contains("OBJTYPE")) {
            if (fSequential != null && !fSequential.isEmpty() && !fSequential.equalsIgnoreCase("false")) {
                buf.append('.');
                buf.append(fBuildFile);
            } else if (!isHFS) {
                buf.append('(');
                buf.append(fBuildFile);
                buf.append(')');
            }
        }
        return buf.toString();
    }

    public static int hashCode(int seed, Object obj) {
        int result = seed;
        if (obj == null) {
            result = BuildReportConstants.HASHCODE_PRIME * result + 0;
        } else if (obj.getClass().isArray()) {
            int length = Array.getLength(obj);
            int idx = 0;
            while (idx < length) {
                Object item = Array.get(obj, idx);
                if (item != obj) {
                    result = CommonBuildReportUtil.hashCode(result, item);
                }
                ++idx;
            }
        }
        return result;
    }

    public static int hashCode(int seed, int intValue) {
        int result = BuildReportConstants.HASHCODE_PRIME * seed + intValue;
        return result;
    }

    public static boolean compareObject(Object obj1, Object obj2) {
        boolean result = false;
        if (obj1 == obj2) {
            result = true;
            return result;
        }
        if (obj1 == null && obj2 != null || obj1 != null && obj2 == null) {
            result = false;
            return result;
        }
        result = obj1.equals(obj2);
        return result;
    }
}

