/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.common.buildreport;

import com.ibm.team.enterprise.build.buildmap.common.model.IOutputBuildFile;
import com.ibm.team.enterprise.build.common.BuildableFileBuildResult;
import com.ibm.team.enterprise.build.common.buildreport.BuildReport;
import com.ibm.team.enterprise.build.common.buildreport.CommonBuildReportUtil;
import com.ibm.team.enterprise.build.common.buildreport.IBuildReport;
import com.ibm.team.enterprise.build.common.buildreport.IReportBuildFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

public class BuildReportCache {
    private AtomicBoolean fIsCompleted = new AtomicBoolean(false);
    private List<IReportBuildFile> fSuccessBuildFilesCache = new ArrayList<IReportBuildFile>();
    private List<IReportBuildFile> fFailedBuildFilesCache = new ArrayList<IReportBuildFile>();
    private List<IReportBuildFile> fUnbuiltBuildFilesCache = new ArrayList<IReportBuildFile>();
    private Map<String, Set<IOutputBuildFile>> fFailedOuputsMap = null;

    public boolean isEnded() {
        return this.fIsCompleted.get();
    }

    public void markEnd() {
        this.fIsCompleted.compareAndSet(false, true);
    }

    public void reset() {
        this.fIsCompleted.compareAndSet(true, false);
        this.fSuccessBuildFilesCache.clear();
        this.fFailedBuildFilesCache.clear();
        this.fUnbuiltBuildFilesCache.clear();
    }

    public void putReportBuildFile(IReportBuildFile reportBuildFile, boolean isParsFailed) {
        if (reportBuildFile != null) {
            BuildableFileBuildResult buildResult = reportBuildFile.getBuildResult();
            if (!this.fSuccessBuildFilesCache.contains(reportBuildFile) && (!isParsFailed || isParsFailed && buildResult != null && BuildableFileBuildResult.SUCCESS.equals((Object)buildResult))) {
                this.fSuccessBuildFilesCache.add(reportBuildFile);
            } else if (isParsFailed && buildResult != null && BuildableFileBuildResult.UNBUILD.equals((Object)buildResult) && !this.fUnbuiltBuildFilesCache.contains(reportBuildFile)) {
                this.fUnbuiltBuildFilesCache.add(reportBuildFile);
            }
        }
    }

    public void putFailedReportBuildFile(IReportBuildFile reportBuildFile) {
        BuildableFileBuildResult buildResult;
        if (reportBuildFile != null && (buildResult = reportBuildFile.getBuildResult()) != null && BuildableFileBuildResult.FAILED.equals((Object)buildResult)) {
            if (this.fFailedOuputsMap != null) {
                Set<IOutputBuildFile> outputs = this.fFailedOuputsMap.get(reportBuildFile.getUUID());
                if (outputs != null && outputs.size() > 0) {
                    boolean isFirst = true;
                    for (IOutputBuildFile output : outputs) {
                        IReportBuildFile addedReportBF = null;
                        String outputStr = CommonBuildReportUtil.generateBuildFileFullPath(output.getBuildPath(), output.getBuildFile(), output.getOutputType(), Boolean.toString(output.isSequential()), output.isHFS());
                        if (isFirst) {
                            addedReportBF = reportBuildFile;
                            isFirst = false;
                        } else {
                            try {
                                addedReportBF = reportBuildFile.clone();
                            }
                            catch (CloneNotSupportedException e) {
                                e.printStackTrace();
                            }
                        }
                        addedReportBF.setOutputFullPath(outputStr);
                        if (this.fFailedBuildFilesCache.contains(addedReportBF)) continue;
                        this.fFailedBuildFilesCache.add(addedReportBF);
                    }
                } else if (!this.fFailedBuildFilesCache.contains(reportBuildFile)) {
                    this.fFailedBuildFilesCache.add(reportBuildFile);
                }
            } else if (!this.fFailedBuildFilesCache.contains(reportBuildFile)) {
                this.fFailedBuildFilesCache.add(reportBuildFile);
            }
        }
    }

    public void putFailedOutput(String uuid, Set<IOutputBuildFile> outputs) {
        if (this.fFailedOuputsMap == null) {
            this.fFailedOuputsMap = new HashMap<String, Set<IOutputBuildFile>>();
        }
        this.fFailedOuputsMap.put(uuid, outputs);
    }

    public IReportBuildFile getSuccessReportBuildFile(int index) {
        IReportBuildFile result = null;
        if (index < this.fSuccessBuildFilesCache.size()) {
            result = this.fSuccessBuildFilesCache.get(index);
        }
        return result;
    }

    public IReportBuildFile getFailedReportBuildFile(int index) {
        IReportBuildFile result = null;
        if (index < this.fFailedBuildFilesCache.size()) {
            result = this.fFailedBuildFilesCache.get(index);
        }
        return result;
    }

    public IReportBuildFile getUnbuiltReportBuildFile(int index) {
        IReportBuildFile result = null;
        if (index < this.fUnbuiltBuildFilesCache.size()) {
            result = this.fUnbuiltBuildFilesCache.get(index);
        }
        return result;
    }

    public IReportBuildFile getReportBuildFile(int index, BuildableFileBuildResult buildResult) {
        IReportBuildFile result = null;
        if (buildResult == null) {
            buildResult = BuildableFileBuildResult.SUCCESS;
        }
        if (BuildableFileBuildResult.SUCCESS.equals((Object)buildResult)) {
            result = this.getSuccessReportBuildFile(index);
        } else if (BuildableFileBuildResult.FAILED.equals((Object)buildResult)) {
            result = this.getFailedReportBuildFile(index);
        } else if (BuildableFileBuildResult.UNBUILD.equals((Object)buildResult)) {
            result = this.getUnbuiltReportBuildFile(index);
        }
        return result;
    }

    public int getBuildFileSize(BuildableFileBuildResult buildResult) {
        int result = -1;
        if (buildResult == null) {
            buildResult = BuildableFileBuildResult.SUCCESS;
        }
        if (BuildableFileBuildResult.SUCCESS.equals((Object)buildResult)) {
            result = this.getSuccessBuildFileSize();
        } else if (BuildableFileBuildResult.FAILED.equals((Object)buildResult)) {
            result = this.getFailedBuildFileSize();
        } else if (BuildableFileBuildResult.UNBUILD.equals((Object)buildResult)) {
            result = this.getUnBuiltBuildFileSize();
        }
        return result;
    }

    public int getSuccessBuildFileSize() {
        return this.fSuccessBuildFilesCache.size();
    }

    public int getFailedBuildFileSize() {
        return this.fFailedBuildFilesCache.size();
    }

    public int getUnBuiltBuildFileSize() {
        return this.fUnbuiltBuildFilesCache.size();
    }

    public boolean isEmpty(BuildableFileBuildResult buildResult) {
        boolean isEmpty = false;
        if (buildResult == null) {
            buildResult = BuildableFileBuildResult.SUCCESS;
        }
        if (BuildableFileBuildResult.SUCCESS.equals((Object)buildResult)) {
            isEmpty = this.fSuccessBuildFilesCache.isEmpty();
        } else if (BuildableFileBuildResult.FAILED.equals((Object)buildResult)) {
            isEmpty = this.fFailedBuildFilesCache.isEmpty();
        } else if (BuildableFileBuildResult.UNBUILD.equals((Object)buildResult)) {
            isEmpty = this.fUnbuiltBuildFilesCache.isEmpty();
        }
        return isEmpty;
    }

    public void clearFull() {
        this.fSuccessBuildFilesCache.clear();
        this.fSuccessBuildFilesCache = null;
        this.fFailedBuildFilesCache.clear();
        this.fFailedBuildFilesCache = null;
        this.fUnbuiltBuildFilesCache.clear();
        this.fUnbuiltBuildFilesCache = null;
        this.fFailedOuputsMap.clear();
        this.fFailedOuputsMap = null;
    }

    public IBuildReport createBuildReport() {
        return new BuildReport(new ArrayList<IReportBuildFile>(this.fSuccessBuildFilesCache), new ArrayList<IReportBuildFile>(this.fFailedBuildFilesCache), new ArrayList<IReportBuildFile>(this.fUnbuiltBuildFilesCache));
    }
}

