/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.common.buildreport;

import com.ibm.team.enterprise.build.buildmap.common.model.IOutputBuildFile;
import com.ibm.team.enterprise.build.common.BuildableFileBuildResult;
import com.ibm.team.enterprise.build.common.Messages;
import com.ibm.team.enterprise.build.common.buildreport.BuildReportCache;
import com.ibm.team.enterprise.build.common.buildreport.CommonBuildReportUtil;
import com.ibm.team.enterprise.build.common.buildreport.IReportBuildFile;
import com.ibm.team.enterprise.build.common.buildreport.ReportBuildFile;
import com.ibm.team.enterprise.internal.buildmap.common.IBuildFile;
import com.ibm.team.enterprise.internal.buildmap.common.impl.BuildFile;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IVersionableHandle;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public abstract class AbstractBuildReportParser {
    private static XMLInputFactory inputFactory = XMLInputFactory.newInstance();
    private BuildReportCache fBuildReportCache = null;
    private List<IVersionableHandle> fVersionableList = new ArrayList<IVersionableHandle>();
    private boolean fNeedInputs = false;
    private String fResourcePrefix = null;
    private HashMap<String, String> langDefMappingCache;
    private boolean fIsZos = true;
    private boolean fIsPersonal = false;
    private boolean fNeedPrefix = false;
    private boolean isParseFailed = false;
    private boolean isFailedOrNotBuilt = false;

    public AbstractBuildReportParser(boolean fNeedInputs, String fResourcePrefix, boolean isPersonal, boolean isZos) {
        this.fNeedInputs = fNeedInputs;
        this.fResourcePrefix = fResourcePrefix;
        this.fIsPersonal = isPersonal;
        this.fIsZos = isZos;
    }

    public void parseXMLFromInputStream(InputStream inputStream, BuildReportCache buildReportCache, boolean isParseFailed, InputStream failedInputStream) throws XMLStreamException, CloneNotSupportedException, TeamRepositoryException {
        if (inputStream == null) {
            throw new IllegalArgumentException("Input stream can not be empty.");
        }
        if (buildReportCache == null) {
            throw new IllegalArgumentException("Input stream can not be empty.");
        }
        this.fBuildReportCache = buildReportCache;
        this.isParseFailed = isParseFailed;
        if (isParseFailed && failedInputStream != null) {
            this.parseFailedBuildReport(failedInputStream);
        }
        XMLEventReader reader = inputFactory.createXMLEventReader(inputStream);
        String componentName = null;
        String projectName = null;
        ReportBuildFile buildFile = null;
        boolean isInDependency = false;
        boolean isInInput = false;
        String inputBuildFile = null;
        String inputBuildPath = null;
        String inputType = null;
        String inputComponentName = null;
        String inputComponentUuid = null;
        String inputProjectName = null;
        String inputUuid = null;
        String inputStateUuid = null;
        String inputScmLocation = null;
        String inputResourceDefUuid = null;
        String inputResourceDefStateUuid = null;
        String inputTimestamp = null;
        boolean isInOutput = false;
        boolean isFirstOutput = true;
        String outputBuildFile = null;
        String outputBuildPath = null;
        String outputSequential = null;
        String outputOutputType = null;
        String outputTimestamp = null;
        boolean outputHFS = false;
        boolean inputHFS = false;
        while (reader.hasNext()) {
            String elementName;
            XMLEvent element;
            XMLEvent event = reader.nextEvent();
            if (event.isStartElement()) {
                element = event.asStartElement();
                if (element == null) continue;
                elementName = null;
                if (element != null) {
                    elementName = this.getQualifiedName(element.getName());
                }
                if (elementName == null || elementName.isEmpty()) continue;
                if ("bf:component".equals(elementName)) {
                    componentName = this.getNameAttributeFromElement((StartElement)element, reader);
                    continue;
                }
                if ("bf:project".equals(elementName)) {
                    projectName = this.getNameAttributeFromElement((StartElement)element, reader);
                    continue;
                }
                if ("bf:file".equals(elementName)) {
                    buildFile = this.generateBuildFile(componentName, projectName, (StartElement)element, reader);
                    continue;
                }
                if ((this.fNeedInputs || this.isParseFailed && this.isFailedOrNotBuilt) && "ds:dependency-set".equals(elementName)) {
                    isInDependency = true;
                    continue;
                }
                if (isInDependency && "inputs:file".equals(elementName)) {
                    isInInput = true;
                    continue;
                }
                if (isInInput) {
                    if ("inputs:buildFile".equals(elementName)) {
                        inputBuildFile = reader.getElementText().trim();
                        continue;
                    }
                    if ("inputs:buildPath".equals(elementName)) {
                        inputBuildPath = reader.getElementText().trim();
                        continue;
                    }
                    if ("inputs:componentName".equals(elementName)) {
                        inputComponentName = reader.getElementText().trim();
                        continue;
                    }
                    if ("inputs:componentUUID".equals(elementName)) {
                        inputComponentUuid = reader.getElementText().trim();
                        continue;
                    }
                    if ("inputs:projectName".equals(elementName)) {
                        inputProjectName = reader.getElementText().trim();
                        continue;
                    }
                    if ("inputs:uuid".equals(elementName)) {
                        inputUuid = reader.getElementText().trim();
                        continue;
                    }
                    if ("inputs:stateUuid".equals(elementName)) {
                        inputStateUuid = reader.getElementText().trim();
                        continue;
                    }
                    if ("inputs:resourceDefinitionID".equals(elementName)) {
                        inputResourceDefUuid = reader.getElementText().trim();
                        continue;
                    }
                    if ("inputs:resourceDefinitionStateID".equals(elementName)) {
                        inputResourceDefStateUuid = reader.getElementText().trim();
                        continue;
                    }
                    if ("inputs:type".equals(elementName)) {
                        inputType = reader.getElementText().trim();
                        continue;
                    }
                    if ("inputs:scmLocation".equals(elementName)) {
                        inputScmLocation = reader.getElementText().trim();
                        continue;
                    }
                    if ("inputs:timestamp".equals(elementName)) {
                        inputTimestamp = reader.getElementText().trim();
                        continue;
                    }
                    if (!"inputs:hfs".equals(elementName)) continue;
                    inputHFS = Boolean.parseBoolean(reader.getElementText().trim());
                    continue;
                }
                if ("outputs:file".equals(elementName)) {
                    isInOutput = true;
                    continue;
                }
                if (!isInOutput) continue;
                if ("outputs:buildFile".equals(elementName)) {
                    outputBuildFile = reader.getElementText().trim();
                    continue;
                }
                if ("outputs:buildPath".equals(elementName)) {
                    outputBuildPath = reader.getElementText().trim();
                    continue;
                }
                if ("outputs:sequential".equals(elementName)) {
                    outputSequential = reader.getElementText().trim();
                    continue;
                }
                if ("outputs:hfs".equals(elementName)) {
                    outputHFS = Boolean.parseBoolean(reader.getElementText().trim());
                    continue;
                }
                if ("outputs:timestamp".equals(elementName)) {
                    outputTimestamp = reader.getElementText().trim();
                    continue;
                }
                if (!"outputs:outputType".equals(elementName)) continue;
                outputOutputType = reader.getElementText().trim();
                continue;
            }
            if (!event.isEndElement() || (element = event.asEndElement()) == null) continue;
            elementName = null;
            if (element != null) {
                elementName = this.getQualifiedName(element.getName());
            }
            if (elementName == null || elementName.isEmpty()) continue;
            if ("bf:component".equals(elementName)) {
                componentName = null;
                continue;
            }
            if ("bf:project".equals(elementName)) {
                projectName = null;
                continue;
            }
            if ("bf:file".equals(elementName) && buildFile != null) {
                if (BuildableFileBuildResult.FAILED.equals((Object)buildFile.getBuildResult())) {
                    this.isFailedOrNotBuilt = false;
                    this.fBuildReportCache.putFailedReportBuildFile(buildFile);
                } else {
                    this.fBuildReportCache.putReportBuildFile(buildFile, this.isParseFailed);
                }
                buildFile = null;
                isFirstOutput = true;
                continue;
            }
            if ("inputs:file".equals(elementName) && buildFile != null) {
                isInInput = false;
                BuildFile inputFile = new BuildFile();
                inputFile.setBuildFile(inputBuildFile);
                inputFile.setBuildPath(inputBuildPath);
                inputFile.setType(inputType);
                inputFile.setTimestamp(inputTimestamp != null ? Long.valueOf(inputTimestamp) : -1L);
                inputFile.setComponentName(inputComponentName);
                inputFile.setProjectName(inputProjectName);
                inputFile.setResourceDefinitionID(inputResourceDefUuid);
                inputFile.setResourceDefinitionStateID(inputResourceDefStateUuid);
                inputFile.setComponentUUID(inputComponentUuid);
                inputFile.setFileUUID(inputUuid);
                inputFile.setFileStateUUID(inputStateUuid);
                inputFile.setSCMLocation(inputScmLocation);
                inputFile.setHFS(inputHFS);
                List<IBuildFile> inputsList = buildFile.getInputs();
                String changed = null;
                changed = buildFile.isChangedDependency(inputFile.getFileUUID()) ? Messages.BuildReportParser_YES : Messages.BuildReportParser_NO;
                inputFile.getUserProperties().put("changed", changed);
                if (!inputsList.contains(inputFile)) {
                    IVersionableHandle versionableHandle;
                    if (inputUuid != null && !this.fVersionableList.contains(versionableHandle = (IVersionableHandle)IFileItem.ITEM_TYPE.createItemHandle(UUID.valueOf((String)inputUuid), inputStateUuid == null ? null : UUID.valueOf((String)inputStateUuid)))) {
                        this.fVersionableList.add(versionableHandle);
                    }
                    inputsList.add((IBuildFile)inputFile);
                }
                inputBuildFile = null;
                inputBuildPath = null;
                inputType = null;
                inputTimestamp = null;
                inputComponentName = null;
                inputProjectName = null;
                inputResourceDefUuid = null;
                inputResourceDefStateUuid = null;
                inputComponentUuid = null;
                inputUuid = null;
                inputStateUuid = null;
                inputScmLocation = null;
                inputHFS = false;
                continue;
            }
            if (buildFile != null && "ds:dependency-set".equals(elementName)) {
                isInDependency = false;
                continue;
            }
            if (buildFile == null || !isInOutput || !"outputs:file".equals(elementName)) continue;
            isInOutput = false;
            String output = CommonBuildReportUtil.generateBuildFileFullPath(outputBuildPath, outputBuildFile, outputOutputType, outputSequential, outputHFS);
            IReportBuildFile tempBuildFile = null;
            if (isFirstOutput) {
                tempBuildFile = buildFile;
                isFirstOutput = false;
            } else {
                tempBuildFile = buildFile.clone();
                this.fBuildReportCache.putReportBuildFile(tempBuildFile, this.isParseFailed);
            }
            tempBuildFile.setOutputFullPath(output);
            tempBuildFile.setOutputTimestamp(outputTimestamp == null ? -1L : Long.parseLong(outputTimestamp));
            outputTimestamp = null;
            outputBuildPath = null;
            outputBuildFile = null;
            outputOutputType = null;
            outputSequential = null;
            outputHFS = false;
        }
        this.fBuildReportCache.markEnd();
    }

    private void parseFailedBuildReport(InputStream failedInputStream) throws XMLStreamException {
        XMLEventReader reader = inputFactory.createXMLEventReader(failedInputStream);
        boolean isInFile = false;
        String uuid = null;
        HashSet<IOutputBuildFile> outputs = null;
        boolean isInOutput = false;
        IOutputBuildFile outputFile = null;
        while (reader.hasNext()) {
            String elementName;
            XMLEvent element;
            XMLEvent event = reader.nextEvent();
            if (event.isStartElement()) {
                String resourceStateIDStr;
                element = event.asStartElement();
                if (element == null) continue;
                elementName = null;
                if (element != null) {
                    elementName = this.getQualifiedName(element.getName());
                }
                if (elementName == null || elementName.isEmpty()) continue;
                if ("bf:file".equals(elementName)) {
                    uuid = this.getUUIDAttributeFromElement((StartElement)element, reader);
                    outputs = new HashSet<IOutputBuildFile>();
                    isInFile = true;
                    continue;
                }
                if (isInFile && "outputs:file".equals(elementName)) {
                    isInOutput = true;
                    outputFile = (IOutputBuildFile)IOutputBuildFile.ITEM_TYPE.createItem();
                    continue;
                }
                if (!isInOutput || outputFile == null) continue;
                if ("outputs:buildFile".equals(elementName)) {
                    outputFile.setBuildFile(reader.getElementText().trim());
                    continue;
                }
                if ("outputs:buildPath".equals(elementName)) {
                    outputFile.setBuildPath(reader.getElementText().trim());
                    continue;
                }
                if ("outputs:sequential".equals(elementName)) {
                    outputFile.setSequential(Boolean.valueOf(reader.getElementText().trim()).booleanValue());
                    continue;
                }
                if ("outputs:hfs".equals(elementName)) {
                    outputFile.setHFS(Boolean.valueOf(reader.getElementText().trim()).booleanValue());
                    continue;
                }
                if ("outputs:outputType".equals(elementName)) {
                    outputFile.setOutputType(reader.getElementText().trim());
                    continue;
                }
                if ("outputs:deployType".equals(elementName)) {
                    outputFile.setDeployType(reader.getElementText().trim());
                    continue;
                }
                if ("outputs:resourceDefinitionID".equals(elementName)) {
                    String resourceUUIDStr = reader.getElementText().trim();
                    if (resourceUUIDStr == null || resourceUUIDStr.length() <= 0) continue;
                    outputFile.setResourceDefinitionUUID(UUID.valueOf((String)resourceUUIDStr));
                    continue;
                }
                if (!"outputs:resourceDefinitionStateID".equals(elementName) || (resourceStateIDStr = reader.getElementText().trim()) == null || resourceStateIDStr.length() <= 0) continue;
                outputFile.setResourceDefinitionStateUUID(UUID.valueOf((String)resourceStateIDStr));
                continue;
            }
            if (!event.isEndElement() || (element = event.asEndElement()) == null) continue;
            elementName = null;
            if (element != null) {
                elementName = this.getQualifiedName(element.getName());
            }
            if (elementName == null || elementName.isEmpty()) continue;
            if (isInFile && "bf:file".equals(elementName)) {
                this.fBuildReportCache.putFailedOutput(uuid, outputs);
                outputs = null;
                isInFile = false;
                uuid = null;
                continue;
            }
            if (!isInFile || !"outputs:file".equals(elementName) || outputs == null || outputFile == null) continue;
            isInOutput = false;
            outputs.add(outputFile);
            outputFile = null;
        }
    }

    private ReportBuildFile generateBuildFile(String componentName, String projectName, StartElement element, XMLEventReader reader) throws TeamRepositoryException {
        ReportBuildFile result = null;
        if (componentName == null || componentName.isEmpty() || projectName == null || projectName.isEmpty()) {
            return result;
        }
        Iterator<Attribute> it = element.getAttributes();
        String buildFile = null;
        String buildPath = null;
        String uuid = null;
        String stateID = null;
        String langDefName = null;
        String langDefUUID = null;
        String langDefStateID = null;
        int maxReturnCode = -1;
        int reasonCode = -2;
        URI buildMapURL = null;
        String outputType = null;
        String sequential = null;
        boolean hfs = false;
        String changedDependencyUUIDs = null;
        String componentUUID = null;
        String buildResult = null;
        while (it.hasNext()) {
            Attribute temp = it.next();
            if (!(temp instanceof Attribute)) continue;
            Attribute attr = temp;
            String attrName = this.getQualifiedName(attr.getName());
            String attrValue = attr.getValue();
            if (attrValue == null) continue;
            attrValue = attrValue.trim();
            if ("bf:buildFile".equals(attrName)) {
                buildFile = attrValue;
                continue;
            }
            if ("bf:buildPath".equals(attrName)) {
                buildPath = attrValue;
                continue;
            }
            if ("bf:uuid".equals(attrName)) {
                uuid = attrValue;
                continue;
            }
            if ("bf:stateID".equals(attrName)) {
                stateID = attrValue;
                continue;
            }
            if ("bf:langDefName".equals(attrName)) {
                langDefName = attrValue;
                continue;
            }
            if ("bf:buildMacro".equals(attrName)) {
                langDefUUID = attrValue;
                continue;
            }
            if ("bf:langDefStateId".equals(attrName)) {
                langDefStateID = attrValue;
                continue;
            }
            if ("bf:maxRc".equals(attrName)) {
                maxReturnCode = Integer.parseInt(attrValue);
                continue;
            }
            if ("bf:reason".equals(attrName)) {
                reasonCode = Integer.parseInt(attrValue);
                continue;
            }
            if ("bf:buildMap".equals(attrName)) {
                buildMapURL = URI.create(attrValue);
                continue;
            }
            if ("bf:sequential".equals(attrName)) {
                sequential = attrValue;
                continue;
            }
            if ("bf:hfs".equals(attrName)) {
                hfs = Boolean.parseBoolean(attrValue);
                continue;
            }
            if (this.isParseFailed && "bf:buildResult".equals(attrName)) {
                buildResult = attrValue;
                continue;
            }
            if ("bf:outputType".equals(attrName)) {
                outputType = attrValue;
                continue;
            }
            if ("bf:changedDependencyUUIDs".equals(attrName)) {
                changedDependencyUUIDs = attrValue;
                continue;
            }
            if (!"bf:componentUUID".equals(attrName)) continue;
            componentUUID = attrValue;
        }
        if (langDefUUID == null && langDefName != null && reasonCode != 0) {
            if (this.langDefMappingCache == null) {
                this.langDefMappingCache = new HashMap();
            }
            if ((langDefUUID = this.langDefMappingCache.get(langDefName)) == null) {
                langDefUUID = this.getLangDefUUID(langDefName);
                this.langDefMappingCache.put(langDefName, langDefUUID);
            }
        }
        if (buildFile != null && buildPath != null && reasonCode != 0) {
            if (!this.fNeedPrefix && this.fIsZos && this.fIsPersonal && this.fResourcePrefix != null && buildPath != null && !buildPath.startsWith(this.fResourcePrefix)) {
                this.fNeedPrefix = true;
            }
            result = new ReportBuildFile(componentName, componentUUID, projectName, maxReturnCode, buildFile, buildPath, uuid, langDefName, langDefUUID, langDefStateID, buildMapURL, outputType, sequential, changedDependencyUUIDs, this.fResourcePrefix, hfs || this.fIsZos && !this.fIsPersonal, hfs);
            if (buildResult != null) {
                result.setBuildResult(BuildableFileBuildResult.valueOf(buildResult));
                if (!result.getBuildResult().equals((Object)BuildableFileBuildResult.SUCCESS)) {
                    this.isFailedOrNotBuilt = true;
                }
            } else {
                result.setBuildResult(BuildableFileBuildResult.SUCCESS);
            }
            result.setStateID(stateID);
            result.setReasonCode(reasonCode);
        }
        return result;
    }

    protected abstract String getLangDefUUID(String var1) throws TeamRepositoryException;

    private String getNameAttributeFromElement(StartElement element, XMLEventReader reader) {
        String result = null;
        Iterator<Attribute> it = element.getAttributes();
        while (it.hasNext()) {
            Attribute attr;
            String attrName;
            Attribute temp = it.next();
            if (!(temp instanceof Attribute) || (attrName = this.getQualifiedName((attr = temp).getName())) == null || attrName.isEmpty() || !"bf:name".equals(attrName)) continue;
            result = attr.getValue();
            break;
        }
        return result;
    }

    private String getUUIDAttributeFromElement(StartElement element, XMLEventReader reader) {
        String result = null;
        Iterator<Attribute> it = element.getAttributes();
        while (it.hasNext()) {
            Attribute attr;
            String attrName;
            Attribute temp = it.next();
            if (!(temp instanceof Attribute) || (attrName = this.getQualifiedName((attr = temp).getName())) == null || attrName.isEmpty() || !"bf:uuid".equals(attrName)) continue;
            result = attr.getValue();
            break;
        }
        return result;
    }

    private String getQualifiedName(QName qName) {
        String result = null;
        if (qName == null) {
            return result;
        }
        StringBuilder builder = new StringBuilder();
        String prefix = qName.getPrefix();
        if (prefix != null && prefix.length() > 0) {
            builder.append(qName.getPrefix()).append(":");
        }
        builder.append(qName.getLocalPart());
        result = builder.toString();
        builder = null;
        return result;
    }

    public boolean isNeedPrefix() {
        return this.fNeedPrefix;
    }
}

