/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.common;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class IBuildUtility {
    private static final String HTTPS = "https://";
    private static final String COLON = ":";
    private static final String HTTPS_LOCALHOST = "https://localhost:";
    private static final String DOT = ".";
    private static final String REPOSITORY_ADDRESS = "repositoryAddress";

    public static Hashtable<String, String> parseNameValuePairFormat(String concatedNameValuePairs) {
        String[] projects;
        Hashtable<String, String> projectNameMap = new Hashtable<String, String>();
        if (concatedNameValuePairs.trim().length() == 0) {
            return projectNameMap;
        }
        String[] stringArray = projects = concatedNameValuePairs.split(";;");
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            String projectName = stringArray[n2];
            String[] nameValue = projectName.split("=");
            if (nameValue.length == 2 && nameValue[0].trim().length() > 0) {
                projectNameMap.put(nameValue[0], nameValue[1]);
            }
            ++n2;
        }
        return projectNameMap;
    }

    public static boolean isIBMiDependencyBuild(IBuildDefinition buildDefinition) {
        return buildDefinition.getConfigurationElement("com.ibm.team.enterprise.ibmi.build.common.IIBMiDependencyBuildConfigurationElement") != null;
    }

    public static boolean isZOSDependencyBuild(IBuildDefinition buildDefinition) {
        return buildDefinition.getConfigurationElement("com.ibm.team.enterprise.zos.build.common.IZosDependencyBuildConfigurationElement") != null;
    }

    public static boolean isDependencyBuild(IBuildDefinition buildDefinition) {
        return IBuildUtility.isIBMiDependencyBuild(buildDefinition) || IBuildUtility.isZOSDependencyBuild(buildDefinition);
    }

    public static boolean isOldDependencyBuild(IBuildDefinition buildDefinition) {
        return buildDefinition.getConfigurationElement("com.ibm.teamz.build.dependency") != null;
    }

    public static boolean isIBMiDependencyBuild(Map<String, String> buildProperties) {
        return "com.ibm.team.enterprise.ibmi.build.dependency.template".equals(buildProperties.get("com.ibm.team.build.internal.template.id"));
    }

    public static boolean isZOSDependencyBuild(Map<String, String> buildProperties) {
        return "com.ibm.team.enterprise.zos.build.dependency.template".equals(buildProperties.get("com.ibm.team.build.internal.template.id"));
    }

    public static boolean isDependencyBuild(Map<String, String> buildProperties) {
        return IBuildUtility.isIBMiDependencyBuild(buildProperties) || IBuildUtility.isZOSDependencyBuild(buildProperties);
    }

    public static boolean isOldDependencyBuild(Map<String, String> buildProperties) {
        return "com.ibm.teamz.build.dependency.template".equals(buildProperties.get("com.ibm.team.build.internal.template.id"));
    }

    public static boolean isIBMiDependencyBuild(Properties buildProperties) {
        return "com.ibm.team.enterprise.ibmi.build.dependency.template".equals(buildProperties.get("com.ibm.team.build.internal.template.id"));
    }

    public static boolean isZOSDependencyBuild(Properties buildProperties) {
        return "com.ibm.team.enterprise.zos.build.dependency.template".equals(buildProperties.get("com.ibm.team.build.internal.template.id"));
    }

    public static boolean isDependencyBuild(Properties buildProperties) {
        return IBuildUtility.isIBMiDependencyBuild(buildProperties) || IBuildUtility.isZOSDependencyBuild(buildProperties);
    }

    public static boolean isOldDependencyBuild(Properties buildProperties) {
        return "com.ibm.teamz.build.dependency.template".equals(buildProperties.get("com.ibm.team.build.internal.template.id"));
    }

    public static String getPropertyValue(String name, List<IBuildProperty> buildProperties) {
        for (IBuildProperty buildProperty : buildProperties) {
            if (!buildProperty.getName().equals(name)) continue;
            return buildProperty.getValue();
        }
        return "";
    }

    public static void resolveLocalhostIfNecessary(Map<String, String> properties) throws TeamRepositoryException {
        try {
            String repositoryAddress;
            String resolveLocalhost = properties.get("team.enterprise.build.resolve.localhost");
            if (Boolean.parseBoolean(resolveLocalhost) && (repositoryAddress = properties.get(REPOSITORY_ADDRESS)).startsWith(HTTPS_LOCALHOST)) {
                byte[] a = IBuildUtility.findBestInetAddress().getAddress();
                repositoryAddress = HTTPS + (a[0] & 0xFF) + DOT + (a[1] & 0xFF) + DOT + (a[2] & 0xFF) + DOT + (a[3] & 0xFF) + COLON + repositoryAddress.substring(HTTPS_LOCALHOST.length());
                properties.put(REPOSITORY_ADDRESS, repositoryAddress);
            }
        }
        catch (IOException e) {
            throw new TeamRepositoryException((Throwable)e);
        }
    }

    public static InetAddress findBestInetAddress() throws IOException {
        InetAddress possibleRouter = null;
        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
        while (interfaces.hasMoreElements()) {
            NetworkInterface nextInterface = interfaces.nextElement();
            Enumeration<InetAddress> addrs = nextInterface.getInetAddresses();
            while (addrs.hasMoreElements()) {
                InetAddress addr = addrs.nextElement();
                if (!(addr instanceof Inet4Address) || addr.isLoopbackAddress()) continue;
                byte[] address = addr.getAddress();
                if ((address[0] & 0xFF) == 192 && (address[1] & 0xFF) == 168) {
                    possibleRouter = addr;
                    continue;
                }
                return addr;
            }
        }
        if (possibleRouter != null) {
            return possibleRouter;
        }
        return InetAddress.getLocalHost();
    }

    public static boolean isValidUuidValue(String uuidValue) {
        if (uuidValue != null) {
            try {
                UUID.valueOf((String)uuidValue);
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return false;
    }
}

