/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.common;

import com.ibm.team.enterprise.build.common.Messages;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class EnterpriseRequestDialogOption {
    public static final String PROPERTY_CHANGED_ITEMS_ONLY = "changedItemsOnly";
    public static final String PROPERTY_MANDATORY_SUBSET = "mandatorySubset";
    public static final String PROPERTY_PREVIEW_BUILD = "previewBuild";
    public static final String PROPERTY_SIMULATION_BUILD = "simulationBuild";
    public static final String PROPERTY_VERIFY_BUILD_OUTPUTS = "verifyBuildOutputs";
    public static final String PROPERTY_FULL_MIN_LOAD = "fullMinLoad";
    public static final String PROPERTY_TRUST_OUTPUTS = "trustOutputs";
    public static final String PROPERTY_CONDITIONAL_BUILD = "conditionalBuild";
    public static final String PROPERTY_IMPACTS_REPOSITORY = "impactsInRepo";
    public static final String PROPERTY_IMPACTS_NOT_REPOSITORY = "impactsNotRepo";
    public static final String PROPERTY_IMPACTS_ALWAYS_BUILD = "impactsAlwaysBuild";
    public static final String PROPERTY_APPEND_LIBRARIES = "appendLibraries";
    public static final String PROPERTY_DELETE_DIRECTORY = "deleteDirectory";
    public static final String PROPERTY_ANT_ARGUMENTS = "antArgs";
    public static final String PROPERTY_PREBUILD_SCRIPT = "prebuildScript";
    public static final String PROPERTY_POSTBUILD_SCRIPT = "postbuildScript";
    public static final String PROPERTY_ALWAYS_RUN_POSTBUILD = "alwaysRunPostbuild";
    public static final String PROPERTY_CUSTOM_BUILD_FILE = "customBuildFile";
    public static final String PROPERTY_CUSTOM_BUILD_TARGETS = "customBuildTargets";
    public static final String PROPERTY_SUBPROCESS_COUNT_BUILD = "processCount";
    private static final List<String> PLATFORM_INDEPENDENT_OPTION_IDS = Arrays.asList("verifyBuildOutputs", "antArgs", "trustOutputs", "prebuildScript", "postbuildScript", "alwaysRunPostbuild", "customBuildFile", "customBuildTargets", "changedItemsOnly", "impactsInRepo", "impactsNotRepo", "impactsAlwaysBuild", "mandatorySubset", "deleteDirectory", "fullMinLoad", "previewBuild", "simulationBuild");
    private static final List<String> ZOS_OPTION_IDS = Arrays.asList("conditionalBuild", "processCount");
    private static final List<String> IBMI_OPTION_IDS = Arrays.asList("appendLibraries");
    public static final VisibilityPermissions SIMULATION_PERMISSIONS = new VisibilityPermissions("com.ibm.team.enterprise.build.ui.requestSimulationBuildOperation", "requestSimulationBuildAction", null);
    public static final VisibilityPermissions ADVANCED_PROPERTY_PERMISSIONS = new VisibilityPermissions("com.ibm.team.enterprise.build.ui.overrideAdvancedPropertiesOperation", "overrideAdvancedPropertiesTeamAction", "overrideAdvancedPropertiesPersonalAction");
    private static final RequestDialogEntry[] REQUEST_OPTIONS = new RequestDialogEntry[]{new RequestDialogEntry("verifyBuildOutputs", Messages.EnterpriseRequestDialogOption_SIMULATION_BUILD_BINARY_CHECK, Messages.EnterpriseRequestDialogOption_CATEGORY_ADVANCED, "team.enterprise.build.ant.simulationModeBinaryCheck", SIMULATION_PERMISSIONS, false, true, false, true, false), new RequestDialogEntry("conditionalBuild", Messages.EnterpriseRequestDialogOption_CONDITIONAL_BUILD, Messages.EnterpriseRequestDialogOption_CATEGORY_ADVANCED, "team.enterprise.build.ant.conditionalBuild", ADVANCED_PROPERTY_PERMISSIONS, true, false, false, true, true), new RequestDialogEntry("processCount", Messages.EnterpriseRequestDialogOption_NBSUBPROCESS_BUILD, Messages.EnterpriseRequestDialogOption_CATEGORY_ADVANCED, "team.enterprise.build.dependency.ProcessCount", ADVANCED_PROPERTY_PERMISSIONS, true, false, false, true, true), new RequestDialogEntry("antArgs", Messages.EnterpriseRequestDialogOption_ANT_ARGUMENTS, Messages.EnterpriseRequestDialogOption_CATEGORY_ANT_WITH_EE_CONFIGURATION, "team.enterprise.build.ant.antArgs", ADVANCED_PROPERTY_PERMISSIONS, true, false, false, true, true), new RequestDialogEntry("customBuildFile", Messages.EnterpriseRequestDialogOption_CUSTOM_BUILD_FILE, Messages.EnterpriseRequestDialogOption_CATEGORY_BUILD_FILE_TARGETS, "team.enterprise.build.ant.buildFile", ADVANCED_PROPERTY_PERMISSIONS, true, false, false, true, true), new RequestDialogEntry("customBuildTargets", Messages.EnterpriseRequestDialogOption_CUSTOM_BUILD_TARGETS, Messages.EnterpriseRequestDialogOption_CATEGORY_BUILD_FILE_TARGETS, "team.enterprise.build.ant.targets", ADVANCED_PROPERTY_PERMISSIONS, true, false, false, true, true), new RequestDialogEntry("trustOutputs", Messages.EnterpriseRequestDialogOption_TRUST_OUTPUTS, Messages.EnterpriseRequestDialogOption_CATEGORY_BUILD_FILE_TARGETS, "team.enterprise.build.dependency.trustOutputs", ADVANCED_PROPERTY_PERMISSIONS, false, false, false, true, true), new RequestDialogEntry("prebuildScript", Messages.EnterpriseRequestDialogOption_RUN_PREBUILD_SCRIPT, Messages.EnterpriseRequestDialogOption_CATEGORY_BUILD_FILE_TARGETS, "team.enterprise.build.ant.preBuildFile", ADVANCED_PROPERTY_PERMISSIONS, false, false, false, true, true), new RequestDialogEntry("postbuildScript", Messages.EnterpriseRequestDialogOption_RUN_POSTBUILD_SCRIPT, Messages.EnterpriseRequestDialogOption_CATEGORY_BUILD_FILE_TARGETS, "team.enterprise.build.ant.postBuildFile", ADVANCED_PROPERTY_PERMISSIONS, false, false, false, true, true), new RequestDialogEntry("alwaysRunPostbuild", Messages.EnterpriseRequestDialogOption_ALWAYS_RUN_POSTBUILD_SCRIPT, Messages.EnterpriseRequestDialogOption_CATEGORY_BUILD_FILE_TARGETS, "team.enterprise.build.ant.alwaysRunPostBuildFile", ADVANCED_PROPERTY_PERMISSIONS, false, false, false, true, true), new RequestDialogEntry("changedItemsOnly", Messages.EnterpriseRequestDialogOption_BUILD_CHANGED_ITEMS_ONLY, Messages.EnterpriseRequestDialogOption_CATEOGRY_BUILD_SCOPE, "team.enterprise.build.ant.buildChangesOnly", null, false, true, true, true, true), new RequestDialogEntry("impactsInRepo", Messages.EnterpriseRequestDialogOption_IMPACTS_REPOSITORY, Messages.EnterpriseRequestDialogOption_CATEOGRY_BUILD_SCOPE, "team.enterprise.build.impacts.disableInputQueries", ADVANCED_PROPERTY_PERMISSIONS, false, false, false, true, true), new RequestDialogEntry("impactsNotRepo", Messages.EnterpriseRequestDialogOption_IMPACTS_NOT_REPOSITORY, Messages.EnterpriseRequestDialogOption_CATEOGRY_BUILD_SCOPE, "team.enterprise.build.impacts.disableParserOutputQueries", ADVANCED_PROPERTY_PERMISSIONS, false, false, false, true, true), new RequestDialogEntry("impactsAlwaysBuild", Messages.EnterpriseRequestDialogOption_IMPACTS_ALWAYS_BUILD, Messages.EnterpriseRequestDialogOption_CATEOGRY_BUILD_SCOPE, "team.enterprise.build.impacts.disableAlwaysBuildQueries", ADVANCED_PROPERTY_PERMISSIONS, false, false, false, true, true), new RequestDialogEntry("mandatorySubset", Messages.EnterpriseRequestDialogOption_MANDATORY_SUBSET, Messages.EnterpriseRequestDialogOption_CATEOGRY_BUILD_SCOPE, "team.enterprise.build.ant.mandatorySubset", null, false, false, false, true, true), new RequestDialogEntry("deleteDirectory", Messages.EnterpriseRequestDialogOption_DELETE_LOAD_DIRECTORY, Messages.EnterpriseRequestDialogOption_CATEGORY_LOAD_OPTIONS, "team.enterprise.scm.deleteDestinationBeforeFetch", ADVANCED_PROPERTY_PERMISSIONS, false, false, false, true, true), new RequestDialogEntry("fullMinLoad", Messages.EnterpriseRequestDialogOption_MINIMUM_LOAD, Messages.EnterpriseRequestDialogOption_CATEGORY_PERSONAL_BUILD, "team.enterprise.build.ant.fullMinimumLoad", null, false, false, true, false, true), new RequestDialogEntry("appendLibraries", Messages.EnterpriseRequestDialogOption_APPEND_LOAD_OBJECT_LIBRARIES, Messages.EnterpriseRequestDialogOption_CATEGORY_PERSONAL_BUILD, "com.ibm.team.enterprise.ibmi.build.AppendLoadObjLibraries", null, false, false, true, false, true), new RequestDialogEntry("previewBuild", Messages.EnterpriseRequestDialogOption_PREVIEW_BUILD, Messages.EnterpriseRequestDialogOption_CATEGORY_OTHER, "team.enterprise.build.dependency.previewBuild", null, false, true, false, true, false), new RequestDialogEntry("simulationBuild", Messages.EnterpriseRequestDialogOption_SIMULATION_BUILD, Messages.EnterpriseRequestDialogOption_CATEGORY_OTHER, "team.enterprise.build.ant.simulationMode", SIMULATION_PERMISSIONS, false, true, false, true, false)};
    private final RequestDialogEntry entry;
    private boolean teamVisibility;
    private boolean personalVisibility;

    public EnterpriseRequestDialogOption(String id, String label, String category, String buildPropertyName, VisibilityPermissions permissions, boolean isConfigurationProperty, boolean defaultTeamVisibility, boolean defaultPersonalVisibility, boolean teamVisibilityModifiable, boolean personalVisibilityModifiable) {
        this(new RequestDialogEntry(id, label, category, buildPropertyName, permissions, isConfigurationProperty, defaultTeamVisibility, defaultPersonalVisibility, teamVisibilityModifiable, personalVisibilityModifiable));
    }

    private EnterpriseRequestDialogOption(RequestDialogEntry entry) {
        this.entry = entry;
        this.teamVisibility = entry.defaultTeamVisibility;
        this.personalVisibility = entry.defaultPersonalVisibility;
    }

    public String getId() {
        return this.entry.id;
    }

    public String getLabel() {
        return this.entry.label;
    }

    public String getBuildPropertyName() {
        return this.entry.buildPropertyName;
    }

    public String getCategory() {
        return this.entry.category;
    }

    public boolean getTeamVisibility() {
        return this.teamVisibility;
    }

    public boolean getPersonalVisibility() {
        return this.personalVisibility;
    }

    public void setTeamVisibility(boolean visibility) {
        if (this.isTeamVisibilityModifiable()) {
            this.teamVisibility = visibility;
        }
    }

    public void setPersonalVisibility(boolean visibility) {
        if (this.isPersonalVisibilityModifiable()) {
            this.personalVisibility = visibility;
        }
    }

    public boolean isTeamVisibilityModifiable() {
        return this.entry.teamVisibilityModifiable;
    }

    public boolean isPersonalVisibilityModifiable() {
        return this.entry.personalVisibilityModifiable;
    }

    public boolean isConfigurationProperty() {
        return this.entry.isConfigurationProperty;
    }

    public VisibilityPermissions getRequiredPermissions() {
        return this.entry.permissions;
    }

    public String toString() {
        return this.entry.label;
    }

    public static List<EnterpriseRequestDialogOption> parseOptions(String value, boolean isZOS) {
        ArrayList<EnterpriseRequestDialogOption> options = new ArrayList<EnterpriseRequestDialogOption>(REQUEST_OPTIONS.length);
        RequestDialogEntry[] requestDialogEntryArray = REQUEST_OPTIONS;
        int n = REQUEST_OPTIONS.length;
        int n2 = 0;
        while (n2 < n) {
            RequestDialogEntry entry = requestDialogEntryArray[n2];
            if (PLATFORM_INDEPENDENT_OPTION_IDS.contains(entry.id) || (isZOS ? ZOS_OPTION_IDS.contains(entry.id) : IBMI_OPTION_IDS.contains(entry.id))) {
                options.add(new EnterpriseRequestDialogOption(entry));
            }
            ++n2;
        }
        if (value != null && !(value = value.trim()).isEmpty()) {
            String[] pairs;
            String[] stringArray = pairs = value.split(",");
            int n3 = pairs.length;
            n = 0;
            while (n < n3) {
                String pair = stringArray[n];
                int equalsIdx = pair.indexOf(61);
                if (equalsIdx != -1) {
                    String id = pair.substring(0, equalsIdx).trim();
                    String visibilityValue = pair.substring(equalsIdx + 1).trim();
                    for (EnterpriseRequestDialogOption nextOption : options) {
                        if (!nextOption.getId().equals(id)) continue;
                        nextOption.setTeamVisibility(visibilityValue.contains("t"));
                        nextOption.setPersonalVisibility(visibilityValue.contains("p"));
                        break;
                    }
                }
                ++n;
            }
        }
        return options;
    }

    public static List<EnterpriseRequestDialogOption> strictParseOptions(String value, boolean isZOS) {
        ArrayList<EnterpriseRequestDialogOption> options = new ArrayList<EnterpriseRequestDialogOption>(REQUEST_OPTIONS.length);
        ArrayList<EnterpriseRequestDialogOption> candidates = new ArrayList<EnterpriseRequestDialogOption>(REQUEST_OPTIONS.length);
        RequestDialogEntry[] requestDialogEntryArray = REQUEST_OPTIONS;
        int n = REQUEST_OPTIONS.length;
        int n2 = 0;
        while (n2 < n) {
            RequestDialogEntry entry = requestDialogEntryArray[n2];
            if (PLATFORM_INDEPENDENT_OPTION_IDS.contains(entry.id) || (isZOS ? ZOS_OPTION_IDS.contains(entry.id) : IBMI_OPTION_IDS.contains(entry.id))) {
                candidates.add(new EnterpriseRequestDialogOption(entry));
            }
            ++n2;
        }
        if (value != null && !(value = value.trim()).isEmpty()) {
            String[] pairs;
            String[] stringArray = pairs = value.split(",");
            int n3 = pairs.length;
            n = 0;
            while (n < n3) {
                String pair = stringArray[n];
                int equalsIdx = pair.indexOf(61);
                if (equalsIdx != -1) {
                    String id = pair.substring(0, equalsIdx).trim();
                    String visibilityValue = pair.substring(equalsIdx + 1).trim();
                    for (EnterpriseRequestDialogOption nextOption : candidates) {
                        if (!nextOption.getId().equals(id)) continue;
                        nextOption.setTeamVisibility(visibilityValue.contains("t"));
                        nextOption.setPersonalVisibility(visibilityValue.contains("p"));
                        options.add(nextOption);
                        break;
                    }
                }
                ++n;
            }
        }
        return options;
    }

    public static String toPropertyString(List<EnterpriseRequestDialogOption> options, String previousValue) {
        if (options == null || options.isEmpty()) {
            return previousValue;
        }
        StringBuilder buf = new StringBuilder(100);
        HashSet<String> knownIDs = new HashSet<String>();
        for (EnterpriseRequestDialogOption option : options) {
            if (buf.length() != 0) {
                buf.append(',');
            }
            buf.append(option.getId());
            buf.append('=');
            if (option.getTeamVisibility()) {
                buf.append('t');
            }
            if (option.getPersonalVisibility()) {
                buf.append('p');
            }
            knownIDs.add(option.getId());
        }
        if (previousValue != null && !previousValue.isEmpty()) {
            String[] previousPairs;
            String[] stringArray = previousPairs = previousValue.split(",");
            int n = previousPairs.length;
            int n2 = 0;
            while (n2 < n) {
                String id;
                String pair = stringArray[n2];
                int equalsIndex = pair.indexOf(61);
                if (equalsIndex != -1 && !knownIDs.contains(id = pair.substring(0, equalsIndex).trim())) {
                    buf.append(',');
                    buf.append(pair);
                }
                ++n2;
            }
        }
        return buf.toString();
    }

    private static class RequestDialogEntry {
        final String id;
        final String label;
        final String category;
        final String buildPropertyName;
        final VisibilityPermissions permissions;
        final boolean isConfigurationProperty;
        final boolean defaultTeamVisibility;
        final boolean defaultPersonalVisibility;
        final boolean teamVisibilityModifiable;
        final boolean personalVisibilityModifiable;

        public RequestDialogEntry(String id, String label, String category, String buildPropertyName, VisibilityPermissions permissions, boolean isConfigurationProperty, boolean defaultTeamVisibility, boolean defaultPersonalVisibility, boolean teamVisibilityModifiable, boolean personalVisibilityModifiable) {
            this.id = id;
            this.label = label;
            this.category = category;
            this.buildPropertyName = buildPropertyName;
            this.permissions = permissions;
            this.isConfigurationProperty = isConfigurationProperty;
            this.defaultTeamVisibility = defaultTeamVisibility;
            this.defaultPersonalVisibility = defaultPersonalVisibility;
            this.teamVisibilityModifiable = teamVisibilityModifiable;
            this.personalVisibilityModifiable = personalVisibilityModifiable;
        }
    }

    public static class VisibilityPermissions {
        final String operationID;
        final String teamActionID;
        final String personalActionID;

        public VisibilityPermissions(String operationID, String teamActionID, String personalActionID) {
            this.operationID = operationID;
            this.teamActionID = teamActionID;
            this.personalActionID = personalActionID;
        }

        public String getOperation() {
            return this.operationID;
        }

        public String getActionForTeamBuilds() {
            return this.teamActionID;
        }

        public String getActionForPersonalBuilds() {
            return this.personalActionID;
        }
    }
}

