/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.common;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.enterprise.build.common.IBuildUtility;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class DependencyBuildPropertyFactory {
    public static DependencyBuildPropertyFactory instance;
    private Map<String, String> enterpriseConfigurationPropertyMap;

    private DependencyBuildPropertyFactory() {
        this.initEnterpriseConfigurationPropertyMap();
    }

    private void initEnterpriseConfigurationPropertyMap() {
        this.enterpriseConfigurationPropertyMap = new HashMap<String, String>();
        this.enterpriseConfigurationPropertyMap.put("teamz.scm.workspaceUUID", "team.enterprise.scm.workspaceUUID");
        this.enterpriseConfigurationPropertyMap.put("teamz.build.dependency.previewBuild", "team.enterprise.build.dependency.previewBuild");
        this.enterpriseConfigurationPropertyMap.put("teamz.build.dependency.promotionBuild", "team.enterprise.build.dependency.promotionBuild");
    }

    public static DependencyBuildPropertyFactory getInstance() {
        if (instance == null) {
            instance = new DependencyBuildPropertyFactory();
        }
        return instance;
    }

    public String getBuildPropertyValue(String propertyId, IBuildDefinition buildDefinition) {
        String newPropertyId = this.resolvePropertyId(propertyId, buildDefinition);
        IBuildProperty buildProperty = buildDefinition.getProperty(newPropertyId);
        return buildProperty != null ? buildProperty.getValue() : null;
    }

    public String getBuildPropertyValue(String propertyId, Map<String, String> buildProperties) {
        String newPropertyId = this.resolvePropertyId(propertyId, buildProperties);
        return buildProperties.get(newPropertyId);
    }

    public String getBuildPropertyValue(String propertyId, Properties buildProperties) {
        String newPropertyId = this.resolvePropertyId(propertyId, buildProperties);
        return (String)buildProperties.get(newPropertyId);
    }

    public String resolvePropertyId(String propertyId, Map<String, String> buildProperties) {
        if (IBuildUtility.isDependencyBuild(buildProperties)) {
            return this.getPropertyId(propertyId, this.enterpriseConfigurationPropertyMap);
        }
        return propertyId;
    }

    public String resolvePropertyId(String propertyId, Properties buildProperties) {
        if (IBuildUtility.isDependencyBuild(buildProperties)) {
            return this.getPropertyId(propertyId, this.enterpriseConfigurationPropertyMap);
        }
        return propertyId;
    }

    public String resolvePropertyId(String propertyId, IBuildDefinition buildDefinition) {
        if (IBuildUtility.isDependencyBuild(buildDefinition)) {
            return this.getPropertyId(propertyId, this.enterpriseConfigurationPropertyMap);
        }
        return propertyId;
    }

    private String getPropertyId(String propertyId, Map<String, String> propertyMap) {
        String newPropertyId;
        if (propertyMap != null) {
            newPropertyId = propertyMap.get(propertyId);
            if (newPropertyId == null) {
                newPropertyId = propertyId;
            }
        } else {
            newPropertyId = propertyId;
        }
        return newPropertyId;
    }
}

