<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:pp="http://www.ibm.com/enterprise/promotion/preview">

<xsl:template match="/">
  <html>
  <head><meta http-equiv="content-type" content="text/html; charset=UTF-8"/>
  <style type="text/css"> 
.tableWithBorder
{
   border-collapse:collapse;
   border: 1px solid black;
}
.tableWithBorderHeader
{
   border: 1px solid black;
   background-color: #C0C0C0;  
   font-weight: bold;
   text-align: center;
}
.tableWithBorderRow
{
   border: 1px solid black;
}
.tableWithBorderRowCenter
{
   border: 1px solid black;
   text-align: center;
}
.tableNoBorderHeader
{
   background-color: #C0C0C0;  
   font-weight: bold;
   text-align: center;
}
.label
{
   font-weight: bold;
}
.noErrorLabel,
.noMessageLabel
{
   padding-left: 20px;
}
.normalrow {padding:3px;font:13px Arial, Helvetica, sans-serif;margin:0px;}
  </style>
  </head>
  <body>
  <h2>${PreviewReport_TITLE}</h2>
  <table><tbody>
     <tr><td class="label">${PreviewReport_PREVIEW_OPTION_LABEL}</td><td><xsl:value-of select="pp:report/@preflight" /></td></tr>
     <tr><td class="label">${PreviewReport_PROMOTION_BUILD_LABEL}</td><td><xsl:value-of select="pp:report/pp:inputs/pp:buildDefinition/@id" /></td></tr>
     <xsl:for-each select="pp:report/pp:inputs/pp:options/pp:option">
         <tr><td class="label"><xsl:value-of select="@name"/>:</td><td><xsl:value-of select="@value"/></td></tr>
     </xsl:for-each> 
  </tbody></table>   
  <xsl:apply-templates select="pp:report/pp:inputs/pp:workItems"/>
  <hr/>
  <xsl:apply-templates select="pp:report/pp:generalErrors"/>
  <hr/>  
  <xsl:apply-templates select="pp:report/pp:generalMessages"/>
  <hr/>  
  <xsl:apply-templates select="pp:report/pp:preconditions"/>
  <hr/>
  <xsl:apply-templates select="pp:report/pp:validation" />
  <hr/>
  <xsl:apply-templates select="pp:report/pp:promoteOutput" />
  </body>
  </html>
</xsl:template>

<xsl:template match="pp:report/pp:inputs/pp:workItems">
   <h3>${PreviewReport_WORKITEMS_LABEL}</h3>   
   <table>
   <tbody>
   <xsl:for-each select="pp:workItem">
      <xsl:sort select="@id" />     
      <tr>
          <td colspan="3"><xsl:value-of select="@summary"/> (<xsl:value-of select="@id" />)</td>          
      </tr>
      <xsl:if test="pp:changeset"> 
      <tr>
         <td width="20"/>
         <td class="tableNoBorderHeader">${PreviewReport_CHANGESETS_LABEL}</td><td class="tableNoBorderHeader">${PreviewReport_ALREADY_PROMOTED_LABEL}</td>
      </tr>                               
      <xsl:for-each select="pp:changeset">
         <tr>
            <td></td>
            <td><xsl:value-of select="@description" /></td>
            <td align="center"><xsl:value-of select="@alreadyPromoted" /></td>
         </tr>
      </xsl:for-each>
       </xsl:if>       
   </xsl:for-each>
   </tbody>
   </table>
</xsl:template>

<xsl:template match="pp:report/pp:generalErrors">
   <h3>${PreviewReport_GENERAL_ERRORS_LABEL}</h3>
   <xsl:if test="pp:error">
   <table><tbody>
     <xsl:for-each select="pp:error">
        <tr><td width="20"></td><td><xsl:value-of select="@value"/></td></tr>
     </xsl:for-each>  
   </tbody></table>
   </xsl:if>
   <xsl:if test="not(pp:error)">
      <div class="noErrorLabel">${PreviewReport_NO_ERRORS}</div>
   </xsl:if>
</xsl:template>

<xsl:template match="pp:report/pp:generalMessages">
   <h3>${PreviewReport_GENERAL_MESSAGES_LABEL}</h3>
   <xsl:if test="pp:message">
   <table><tbody>
     <xsl:for-each select="pp:message">
        <tr><td width="20"></td><td><xsl:value-of select="@value"/></td></tr>
     </xsl:for-each>  
   </tbody></table>
   </xsl:if>
   <xsl:if test="not(pp:message)">
      <div class="noMessageLabel">${PreviewReport_NO_MESSAGES}</div>
   </xsl:if>
</xsl:template>

<xsl:template match="pp:report/pp:preconditions">
   <h3>${PreviewReport_PRECONDITIONS_LABEL}</h3>
   <xsl:if test="pp:precondition">
   <table><tbody>
     <xsl:for-each select="pp:precondition">
        <tr><td colspan="2"><xsl:value-of select="@error"/></td></tr>
         <xsl:for-each select="pp:param[@type='workitem']">
         	<xsl:choose>
         	 <xsl:when test="@message">
             	<tr><td width="50"></td><td class="td1"><xsl:value-of select="@message"/></td></tr>
             </xsl:when>
             <xsl:otherwise>
                <tr><td width="50"></td><td class="td1"><xsl:value-of select="@summary"/> (<xsl:value-of select="@id"/>)</td></tr>
             </xsl:otherwise>
            </xsl:choose>
         </xsl:for-each>
     </xsl:for-each>  
   </tbody></table>
   </xsl:if>
   <xsl:if test="not(pp:precondition)">
      <div class="noErrorLabel">${PreviewReport_NO_ERRORS}</div>
   </xsl:if>
</xsl:template>

<xsl:template match="pp:report/pp:validation">
   <h3>${PreviewReport_VALIDATION_ERRORS_LABEL}</h3>
   <p class="label">${PreviewReport_CHANGESET_VALIDATION_LABEL}</p>
   <xsl:if test="pp:error[@type='changeset']">
      <table class="tableWithBorder"><tbody>   
        <tr><td class="tableWithBorderHeader">${PreviewReport_WORKITEM_LABEL}</td><td class="tableWithBorderHeader">${PreviewReport_CHANGESET_LABEL}</td><td class="tableWithBorderHeader">${PreviewReport_ERROR_LABEL}</td></tr>
        <xsl:for-each select="pp:error[@type='changeset']">      
           <tr><td class="tableWithBorderRowCenter"><xsl:value-of select="@workItemId"/></td><td class="tableWithBorderRow"><xsl:value-of select="@target"/></td><td class="tableWithBorderRow"><xsl:value-of select="@value"/></td></tr>
        </xsl:for-each>
      </tbody></table>
   </xsl:if>
   <xsl:if test="not(pp:error[@type='changeset'])">
      <div class="noErrorLabel">${PreviewReport_NO_ERRORS}</div>
   </xsl:if>
   <p class="label">${PreviewReport_GAP_VALIDATION_LABEL}</p>
   <xsl:if test="pp:error[@type='gap']">
      <div>${PreviewReport_GAP_DESCRIPTION}</div>
      <table class="tableWithBorder"><tbody>
         <tr><td class="tableWithBorderHeader">${PreviewReport_CHANGESET_LABEL}</td><td class="tableWithBorderHeader">${PreviewReport_GAP_WORK_ITEMS_LABEL}</td></tr>
         <xsl:for-each select="pp:error[@type='gap']">           
             <tr>
            <td class="tableWithBorderRow"><xsl:value-of select="@value"/></td>
            <td class="tableWithBorderRow">
               <xsl:if test="pp:workItem">
                  <xsl:for-each select="pp:workItem">
                     <xsl:value-of select="@id"/> - <xsl:value-of select="@summary"/><br/>
                  </xsl:for-each>
               </xsl:if>
               <xsl:if test="not(pp:workItem)">
                  ${PreviewReport_NO_WORK_ITEMS}
               </xsl:if>
            </td>
         </tr>
         </xsl:for-each>
      </tbody></table>
   </xsl:if>
   <xsl:if test="not(pp:error[@type='gap'])">
      <div class="noErrorLabel">${PreviewReport_NO_GAPS_MESSAGE}</div>
   </xsl:if>
   <p class="label">${PreviewReport_BUILDMAP_VALIDATION_LABEL}</p>
   <xsl:if test="pp:error[@type='buildmap']">
      <table class="tableWithBorder"><tbody>
         <tr><td class="tableWithBorderHeader">${PreviewReport_WORKITEM_LABEL}</td><td class="tableWithBorderHeader">${PreviewReport_BUILDMAP_LABEL}</td><td class="tableWithBorderHeader">${PreviewReport_ERROR_LABEL}</td></tr>
         <xsl:for-each select="pp:error[@type='buildmap']">           
             <tr><td class="tableWithBorderRowCenter"><xsl:value-of select="@workItemId"/></td><td class="tableWithBorderRow"><a><xsl:attribute name="href"><xsl:value-of select="@target"/></xsl:attribute>${PreviewReport_BUILDMAP} (<xsl:value-of select="@buildableFile"/>)</a></td><td class="tableWithBorderRow"><xsl:value-of select="@value"/></td></tr>
         </xsl:for-each>
      </tbody></table>
   </xsl:if>
   <xsl:if test="not(pp:error[@type='buildmap'])">
      <div class="noErrorLabel">${PreviewReport_NO_ERRORS}</div>
   </xsl:if>
</xsl:template>

<xsl:template match="pp:report/pp:promoteOutput">
   <h3>${PreviewReport_OUTPUTS_LABEL}</h3>
   <xsl:if test="pp:datasets/pp:dataset">
   ${PreviewReport_OUTPUTS_DESCRIPTION}
   <p/>
   <table class="tableWithBorder"><tbody>
   <tr><td class="tableWithBorderHeader">${PreviewReport_SOURCE_PDS_LABEL}</td><td class="tableWithBorderHeader">${PreviewReport_TARGET_PDS_LABEL}</td><td class="tableWithBorderHeader">${PreviewReport_MEMBERS_LABEL}</td><td class="tableWithBorderHeader">${PreviewReport_REASON_LABEL}</td><td class="tableWithBorderHeader">${PreviewReport_DEPLOY_TYPE_LABEL}</td></tr>
   <xsl:for-each select="pp:datasets/pp:dataset">
      <tr>
        <td class="tableWithBorderRow"><xsl:value-of select="pp:sourcePDS/@name"/></td>
        <td class="tableWithBorderRow"><xsl:value-of select="pp:targetPDS/@name"/></td>
        <td class="tableWithBorderRow">
        <xsl:for-each select="pp:members/pp:member">
           <xsl:value-of select="@name"/>
           <xsl:if test="@type">.<xsl:value-of select="@type"/></xsl:if>           
           <br/>
        </xsl:for-each>
        </td>
        <td class="tableWithBorderRowCenter">
        	<xsl:for-each select="pp:members/pp:member">
        	    <xsl:choose>
        	       <xsl:when test="@reason = 'LINKED'">1</xsl:when>
        	       <xsl:when test="@reason = 'IMPACTED'">2</xsl:when>
        	       <xsl:otherwise>0</xsl:otherwise>
				</xsl:choose>           
           		<br/>
        	</xsl:for-each>
        </td>
        <td class="tableWithBorderRow"><xsl:value-of select="pp:members/pp:member/@deployType"/></td>
      </tr>
   </xsl:for-each>
   </tbody></table>
   
   <table class="normalrow" border="0" cellpadding="2" cellspacing="2">
     <tbody>
	  <tr><td width="40px" ></td><th align="left">${PreviewReport_REASON_LABEL}</th><th align="left">${PreviewReport_REASON_DESC}</th></tr>
      <tr><td></td><td align="center">0</td><td>${PreviewReport_REASON_DESC_0}</td></tr>
      <tr><td></td><td align="center">1</td><td>${PreviewReport_REASON_DESC_1}</td></tr>
      <tr><td></td><td align="center">2</td><td>${PreviewReport_REASON_DESC_2}</td></tr>
     </tbody>
   </table>
   
   </xsl:if>
   <xsl:if test="not(pp:datasets/pp:dataset)">
       ${PreviewReport_NO_OUTPUTS_MESSAGE}
   </xsl:if>
</xsl:template>


</xsl:stylesheet>

