<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
                              xmlns:package="http://www.ibm.com/team/enterprise/package/"
                              xmlns:manifest="http://www.ibm.com/team/enterprise/package/manifest/">

<xsl:template match="rdf:RDF/rdf:Description">
  <html>
  <head><meta http-equiv="content-type" content="text/html; charset=UTF-8"/>
  <style type="text/css"> 
.tableWithBorder
{
   border-collapse:collapse;
   border: 1px solid black;
}
.tableWithBorderHeader
{
   border: 1px solid black;
   background-color: #C0C0C0;  
   font-weight: bold;
   text-align: center;
}
.tableWithBorderRow
{
   border: 1px solid black;
}
.tableNoBorderHeader
{
   background-color: #C0C0C0;  
   font-weight: bold;
   text-align: center;
}
.label
{
   font-weight: bold;
}
.noErrorLabel
{
   padding-left: 20px;
}
  </style>
  </head>
  <body>
  <h3>${PackageReport_PACKAGE_LABEL} <xsl:value-of select="package:label"/></h3>
  <table><tbody>
     <tr><td class="label">${PackageReport_PACKAGE_DEFINITION_LABEL} </td><td><xsl:value-of select="package:packageDefinitionUUID"/></td></tr>
     <tr><td class="label">${PackageReport_PACKAGE_RESULT_LABEL} </td><td><xsl:value-of select="package:packageResultUUID"/></td></tr>
     <tr><td class="label">${PackageReport_PACKAGE_LOCATION_LABEL} </td><td><xsl:value-of select="package:location"/></td></tr>
     <tr><td class="label">${PackageReport_PACKAGE_TIMESTAMP_LABEL} </td><td><xsl:value-of select="package:timestamp"/></td></tr>
  </tbody></table>
  <xsl:apply-templates select="package:manifest"/>
  </body>
  </html>
</xsl:template>

<xsl:template match="package:manifest">
   <h4>${PackageReport_PACKAGE_CONTENTS_LABEL}</h4>
   <table class="tableWithBorder"><tbody>
   <tr><td class="tableWithBorderHeader">${PackageReport_PACKAGE_LIBRARY_COLUMN_LABEL}</td><td class="tableWithBorderHeader">${PackageReport_PACKAGE_OBJECT_COLUMN_LABEL}</td><td class="tableWithBorderHeader">${PackageReport_PACKAGE_OBJECT_TYPE_COLUMN_LABEL}</td></tr>
   <xsl:for-each select="manifest:container">
      <xsl:variable name="containerName"><xsl:value-of select="@name"/></xsl:variable>
      <xsl:for-each select="manifest:resource">
          <tr><td class="tableWithBorderRow"><xsl:value-of select="$containerName"/></td><td class="tableWithBorderRow"><xsl:value-of select="@name"/></td><td class="tableWithBorderRow"><xsl:value-of select="@subType"/></td></tr>
      </xsl:for-each>
   </xsl:for-each>
   </tbody></table>
</xsl:template>

</xsl:stylesheet>   