/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.build.client.promotion;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.enterprise.build.common.promotion.impl.PromotableFile;
import com.ibm.team.enterprise.build.common.promotion.impl.PromotableResource;
import com.ibm.team.enterprise.build.common.promotion.report.IXmlPreflightReportConstants;
import com.ibm.team.enterprise.build.common.promotion.report.info.BuildDefinitionInfo;
import com.ibm.team.enterprise.build.common.promotion.report.info.BuildMapValidationInfo;
import com.ibm.team.enterprise.build.common.promotion.report.info.ChangeSetInfo;
import com.ibm.team.enterprise.build.common.promotion.report.info.ChangeSetValidationInfo;
import com.ibm.team.enterprise.build.common.promotion.report.info.ErrorInfo;
import com.ibm.team.enterprise.build.common.promotion.report.info.GapChangeSetInfo;
import com.ibm.team.enterprise.build.common.promotion.report.info.IErrorInfo;
import com.ibm.team.enterprise.build.common.promotion.report.info.InputsInfo;
import com.ibm.team.enterprise.build.common.promotion.report.info.PreconditionInfo;
import com.ibm.team.enterprise.build.common.promotion.report.info.ReportInfo;
import com.ibm.team.enterprise.build.common.promotion.report.info.ValidationInfo;
import com.ibm.team.enterprise.build.common.promotion.report.info.WorkItemInfo;
import com.ibm.team.enterprise.build.common.promotion.util.PromotionInfo;
import com.ibm.team.enterprise.build.common.promotion.util.PromotionInfoUtil;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ReportConversion
implements IXmlPreflightReportConstants {
    private final ITeamRepository repository;
    private final Map<UUID, IChangeSet> changeSetMap;
    private final Map<String, IWorkItem> workItemMap;

    public ReportConversion(ITeamRepository repository) {
        this.repository = repository;
        this.changeSetMap = new HashMap<UUID, IChangeSet>();
        this.workItemMap = new HashMap<String, IWorkItem>();
    }

    public ReportInfo toReportInfo(String xmlContent) throws TeamRepositoryException {
        ReportInfo reportInfo = new ReportInfo();
        try {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(xmlContent.getBytes("UTF-8")));
            NodeList nodes = doc.getElementsByTagName("pp:inputs");
            if (nodes.getLength() == 1) {
                this.parseInputsInfo((Element)nodes.item(0), reportInfo.getInputsInfo());
            }
            if ((nodes = doc.getElementsByTagName("pp:generalErrors")).getLength() == 1) {
                this.addGeneralErrors((Element)nodes.item(0), reportInfo);
            }
            nodes = doc.getElementsByTagName("pp:preconditions");
            int i = 0;
            while (i < nodes.getLength()) {
                reportInfo.addPreconditionInfo(this.parsePreconditionsInfo((Element)nodes.item(i)));
                ++i;
            }
            nodes = doc.getElementsByTagName("pp:validation");
            if (nodes.getLength() == 1) {
                this.parseValidationInfo((Element)nodes.item(0), reportInfo.getValidationInfo());
            }
            if ((nodes = doc.getElementsByTagName("pp:promoteOutput")).getLength() == 1) {
                reportInfo.setPromotionInfo(this.parsePromotionInfo((Element)nodes.item(0)));
            }
        }
        catch (TeamRepositoryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TeamRepositoryException((Throwable)e);
        }
        return reportInfo;
    }

    private void parseInputsInfo(Element inputsElement, InputsInfo inputsInfo) throws TeamRepositoryException {
        Element buildDefinitionElement = (Element)inputsElement.getElementsByTagName("pp:buildDefinition").item(0);
        IBuildDefinitionHandle buildDefinitionHandle = (IBuildDefinitionHandle)IBuildDefinition.ITEM_TYPE.createItemHandle(UUID.valueOf((String)buildDefinitionElement.getAttribute("uuid")), null);
        IBuildDefinition buildDefinition = (IBuildDefinition)this.repository.itemManager().fetchCompleteItem((IItemHandle)buildDefinitionHandle, 0, null);
        BuildDefinitionInfo buildDefinitionInfo = new BuildDefinitionInfo(buildDefinition);
        inputsInfo.setBuildDefinitionInfo(buildDefinitionInfo);
        Element workItemsElement = (Element)inputsElement.getElementsByTagName("pp:workItems").item(0);
        NodeList workItemNodes = workItemsElement.getElementsByTagName("pp:workItem");
        int i = 0;
        while (i < workItemNodes.getLength()) {
            Element workItemElement = (Element)workItemNodes.item(i);
            IWorkItemHandle workItemHandle = (IWorkItemHandle)IWorkItem.ITEM_TYPE.createItemHandle(UUID.valueOf((String)workItemElement.getAttribute("uuid")), null);
            IWorkItem workItem = (IWorkItem)this.repository.itemManager().fetchCompleteItem((IItemHandle)workItemHandle, 0, null);
            WorkItemInfo workItemInfo = new WorkItemInfo(workItem);
            this.workItemMap.put(String.valueOf(workItem.getId()), workItem);
            NodeList changeSetNodes = workItemElement.getElementsByTagName("pp:changeset");
            int j = 0;
            while (j < changeSetNodes.getLength()) {
                Element changeSetElement = (Element)changeSetNodes.item(j);
                IChangeSetHandle changeSetHandle = (IChangeSetHandle)IChangeSet.ITEM_TYPE.createItemHandle(UUID.valueOf((String)changeSetElement.getAttribute("uuid")), null);
                IChangeSet changeSet = (IChangeSet)this.repository.itemManager().fetchCompleteItem((IItemHandle)changeSetHandle, 0, null);
                ChangeSetInfo changeSetInfo = new ChangeSetInfo(changeSet);
                changeSetInfo.setAlreadyDelivered(Boolean.valueOf(changeSetElement.getAttribute("alreadyPromoted")).booleanValue());
                workItemInfo.addChangeSetInfo(changeSetInfo);
                this.changeSetMap.put(changeSet.getItemId(), changeSet);
                ++j;
            }
            inputsInfo.addWorkItemInfo(workItemInfo);
            ++i;
        }
        Element optionsElement = (Element)inputsElement.getElementsByTagName("pp:options").item(0);
        NodeList optionNodes = optionsElement.getElementsByTagName("pp:option");
        int i2 = 0;
        while (i2 < optionNodes.getLength()) {
            Element optionElement = (Element)optionNodes.item(i2);
            inputsInfo.setOption(optionElement.getAttribute("name"), optionElement.getAttribute("value"));
            ++i2;
        }
    }

    private void parseValidationInfo(Element validationElement, ValidationInfo validationInfo) throws TeamRepositoryException {
        NodeList errorNodes = validationElement.getElementsByTagName("pp:error");
        int i = 0;
        while (i < errorNodes.getLength()) {
            String uuidValue;
            IChangeSet changeSet;
            Element errorElement = (Element)errorNodes.item(i);
            String type = errorElement.getAttribute("type");
            if (type.equals("changeset")) {
                changeSet = null;
                uuidValue = errorElement.getAttribute("uuid");
                if (uuidValue != null && uuidValue.length() > 0) {
                    changeSet = this.changeSetMap.get(UUID.valueOf((String)uuidValue));
                }
                IWorkItem workItem = null;
                String workItemValue = errorElement.getAttribute("workItemId");
                if (workItemValue != null) {
                    workItem = this.workItemMap.get(workItemValue);
                }
                ChangeSetValidationInfo changeSetValidationInfo = new ChangeSetValidationInfo(changeSet, workItem, (IErrorInfo)new ErrorInfo(errorElement.getAttribute("value")));
                validationInfo.addChangeSetValidationInfo(changeSetValidationInfo);
            } else if (type.equals("buildmap")) {
                IWorkItem workItem = null;
                String workItemValue = errorElement.getAttribute("workItemId");
                if (workItemValue != null) {
                    workItem = this.workItemMap.get(workItemValue);
                }
                BuildMapValidationInfo buildMapValidationInfo = new BuildMapValidationInfo(null, null, (IErrorInfo)new ErrorInfo(errorElement.getAttribute("value")), workItem);
                validationInfo.addBuildMapValidationInfo(buildMapValidationInfo);
            } else if (type.equals("gap")) {
                UUID uuid;
                changeSet = null;
                uuidValue = errorElement.getAttribute("uuid");
                if (uuidValue != null && uuidValue.length() > 0 && (changeSet = this.changeSetMap.get(uuid = UUID.valueOf((String)uuidValue))) == null) {
                    IChangeSetHandle changeSetHandle = (IChangeSetHandle)IChangeSet.ITEM_TYPE.createItemHandle(uuid, null);
                    changeSet = (IChangeSet)this.repository.itemManager().fetchCompleteItem((IItemHandle)changeSetHandle, 0, null);
                    this.changeSetMap.put(uuid, changeSet);
                }
                ArrayList<IWorkItem> workItems = new ArrayList<IWorkItem>();
                NodeList workItemElements = errorElement.getElementsByTagName("pp:workItem");
                int j = 0;
                while (j < workItemElements.getLength()) {
                    Element workItemElement = (Element)workItemElements.item(j);
                    String workItemValue = workItemElement.getAttribute("workItemId");
                    if (workItemValue != null) {
                        String wiUUID;
                        IWorkItem workItem = this.workItemMap.get(workItemValue);
                        if (workItem == null && (wiUUID = workItemElement.getAttribute("uuid")) != null && !wiUUID.isEmpty()) {
                            IWorkItemHandle workItemHandle = (IWorkItemHandle)IWorkItem.ITEM_TYPE.createItemHandle(UUID.valueOf((String)wiUUID), null);
                            workItem = (IWorkItem)this.repository.itemManager().fetchCompleteItem((IItemHandle)workItemHandle, 0, null);
                            this.workItemMap.put(String.valueOf(workItem.getId()), workItem);
                        }
                        if (workItem != null) {
                            workItems.add(workItem);
                        }
                    }
                    ++j;
                }
                validationInfo.addGapChangeSetInfo(new GapChangeSetInfo(changeSet, workItems));
            }
            ++i;
        }
    }

    private PromotionInfo parsePromotionInfo(Element promoteOutputElement) {
        HashMap promotableResources = new HashMap();
        NodeList datasetNodes = promoteOutputElement.getElementsByTagName("pp:dataset");
        int i = 0;
        while (i < datasetNodes.getLength()) {
            ArrayList<PromotableFile> promotableFiles = new ArrayList<PromotableFile>();
            Element datasetElement = (Element)datasetNodes.item(i);
            Element sourcePDSElement = (Element)datasetElement.getElementsByTagName("pp:sourcePDS").item(0);
            String sourcePDS = sourcePDSElement.getAttribute("name");
            Element targetPDSElement = (Element)datasetElement.getElementsByTagName("pp:targetPDS").item(0);
            String targetPDS = targetPDSElement.getAttribute("name");
            NodeList memberNodes = datasetElement.getElementsByTagName("pp:member");
            int k = 0;
            while (k < memberNodes.getLength()) {
                Element memberElement = (Element)memberNodes.item(k);
                PromotableFile promotableFile = new PromotableFile(memberElement.getAttribute("name"), false, Long.parseLong(memberElement.getAttribute("timestamp")), null, "", memberElement.getAttribute("versionId"), PromotionInfoUtil.convertToReason((String)memberElement.getAttribute("reason")));
                String deployType = memberElement.getAttribute("deployType");
                if (deployType != null && !deployType.isEmpty()) {
                    promotableFile.setDeployType(deployType);
                }
                promotableFiles.add(promotableFile);
                ++k;
            }
            PromotableResource promotableResource = new PromotableResource(promotableFiles, sourcePDS, targetPDS);
            ++i;
        }
        return new PromotionInfo(promotableResources, Collections.EMPTY_LIST, PromotionInfo.PromotionBuildType.oldzos, PromotionInfo.PromotionType.workitem);
    }

    private PreconditionInfo parsePreconditionsInfo(Element preconditionsElement) {
        NodeList preconditionNodes = preconditionsElement.getElementsByTagName("pp:precondition");
        if (preconditionNodes.getLength() == 0) {
            return null;
        }
        Element preconditionElement = (Element)preconditionNodes.item(0);
        String error = preconditionElement.getAttribute("error");
        ArrayList<IWorkItem> badWorkItems = new ArrayList<IWorkItem>();
        NodeList paramNodes = preconditionElement.getElementsByTagName("pp:param");
        int i = 0;
        while (i < paramNodes.getLength()) {
            IWorkItem workItem;
            Element paramElement = (Element)paramNodes.item(i);
            if (paramElement.getAttribute("type").equals("workitem") && (workItem = this.workItemMap.get(paramElement.getAttribute("id"))) != null) {
                badWorkItems.add(workItem);
            }
            ++i;
        }
        return new PreconditionInfo(error, badWorkItems, null);
    }

    private void addGeneralErrors(Element generalErrorsElement, ReportInfo reportInfo) {
        NodeList errorNodes = generalErrorsElement.getElementsByTagName("pp:error");
        int i = 0;
        while (i < errorNodes.getLength()) {
            Element errorElement = (Element)errorNodes.item(i);
            reportInfo.addGeneralError(errorElement.getAttribute("value"));
            ++i;
        }
    }
}

