/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.build.client.promotion;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.enterprise.build.client.promotion.IPromotionClient;
import com.ibm.team.enterprise.build.common.promotion.IPromotionService;
import com.ibm.team.enterprise.build.common.promotion.impl.CssNlsHelper;
import com.ibm.team.enterprise.internal.build.client.promotion.ReportConversion;
import com.ibm.team.enterprise.internal.build.client.promotion.nls.Messages;
import com.ibm.team.enterprise.systemdefinition.common.helper.StringHelperUtil;
import com.ibm.team.enterprise.systemdefinition.common.model.IStringHelper;
import com.ibm.team.process.client.IProcessClientService;
import com.ibm.team.process.common.advice.IObjectsResponse;
import com.ibm.team.process.common.advice.IOperationReport;
import com.ibm.team.process.common.advice.ProcessRunnable;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.EventSource;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.common.GapException;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IBaselineSetHandle;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.ResourceBundle;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;

public class PromotionClient
extends EventSource
implements IPromotionClient {
    private final IClientLibraryContext fContext;

    public PromotionClient(IClientLibraryContext context) {
        this.fContext = context;
    }

    protected IClientLibraryContext getContext() {
        return this.fContext;
    }

    protected ITeamRepository getRepository() {
        return this.fContext.teamRepository();
    }

    protected <T> T getService(Class<T> clazz) {
        return (T)this.getContext().getServiceInterface(clazz);
    }

    protected <T> T callCancelableService(IProgressMonitor progressMonitor, IClientLibraryContext.IServiceRunnable<T> serviceRunnable) throws TeamRepositoryException {
        return (T)this.getContext().callCancelableService(serviceRunnable, progressMonitor);
    }

    @Override
    public String processBuildMapsforPromotion(final IBuildResultHandle sourceBuildResult, final IBuildDefinitionHandle targetBuildDefinition, final IBaselineHandle[] baselineHandles, IProgressMonitor monitor) throws TeamRepositoryException {
        return (String)this.callCancelableService(monitor, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                String promotionInfoXML = PromotionClient.this.getService(IPromotionService.class).processBuildMapsforPromotion(sourceBuildResult, targetBuildDefinition, baselineHandles);
                return promotionInfoXML;
            }
        });
    }

    @Override
    public void finalizeTargetBuildMaps(final String promotionInfoXML, IProgressMonitor progressMonitor) throws TeamRepositoryException {
        this.callCancelableService(null, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                PromotionClient.this.getService(IPromotionService.class).finalizeTargetBuildMaps(promotionInfoXML);
                return null;
            }
        });
    }

    @Override
    public String finalizeTargetBuildMaps2(final String promotionInfoXML, IProgressMonitor progressMonitor) throws TeamRepositoryException {
        return (String)this.callCancelableService(null, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                return PromotionClient.this.getService(IPromotionService.class).finalizeTargetBuildMaps2(promotionInfoXML);
            }
        });
    }

    @Override
    public IBaselineSetHandle getBaselineSetForBuildResult(final IBuildResultHandle sourceBuildResult, IProgressMonitor progressMonitor) throws TeamRepositoryException {
        return (IBaselineSetHandle)this.callCancelableService(null, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                return PromotionClient.this.getService(IPromotionService.class).getBaselineSetForBuildResult(sourceBuildResult);
            }
        });
    }

    @Override
    public void updateTargetStream(final IWorkspaceHandle targetStreamHandle, final IBaselineHandle[] baselineHandles, IProgressMonitor progressMonitor) throws TeamRepositoryException {
        this.callCancelableService(null, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                PromotionClient.this.getService(IPromotionService.class).updateTargetStream(targetStreamHandle, baselineHandles);
                return null;
            }
        });
    }

    @Override
    public void updateTargetStream2(final IWorkspaceHandle targetStreamHandle, final IBuildDefinitionHandle promotionBuildDefinitionHandle, final IBuildResultHandle buildResultHandle, final IBaselineHandle[] baselineHandles, IProgressMonitor progressMonitor) throws TeamRepositoryException {
        this.callCancelableService(null, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                PromotionClient.this.getService(IPromotionService.class).updateTargetStream2(targetStreamHandle, promotionBuildDefinitionHandle, buildResultHandle, baselineHandles);
                return null;
            }
        });
    }

    @Override
    public void deleteTemporaryBuildMaps(final String promotionInfoXML, IProgressMonitor progressMonitor) throws TeamRepositoryException {
        this.callCancelableService(null, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                PromotionClient.this.getService(IPromotionService.class).deleteTemporaryBuildMaps(promotionInfoXML);
                return null;
            }
        });
    }

    @Override
    public boolean isTargetStreamUpdated(final IWorkspaceHandle targetStreamHandle, final IBaselineHandle[] baselineHandles, IProgressMonitor monitor) throws TeamRepositoryException {
        return (Boolean)this.callCancelableService(null, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                return PromotionClient.this.getService(IPromotionService.class).isTargetStreamUpdated(targetStreamHandle, baselineHandles);
            }
        });
    }

    @Override
    public Object promoteWorkItems(IWorkItemHandle[] workItemHandles, IBuildDefinitionHandle promotionBuildDefinition, boolean promoteBinary, boolean includeWorkItemChildren, boolean preflight, File htmlReportFile, File xmlReportFile, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.promoteWorkItems2(workItemHandles, promotionBuildDefinition, promoteBinary, includeWorkItemChildren, false, preflight, htmlReportFile, xmlReportFile, monitor);
    }

    @Override
    public Object promoteWorkItems2(final IWorkItemHandle[] workItemHandles, final IBuildDefinitionHandle promotionBuildDefinition, final boolean promoteBinary, final boolean includeWorkItemChildren, final boolean considerIgnoreChanges, final boolean preflight, final File htmlReportFile, final File xmlReportFile, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.callCancelableService(monitor, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                class PromoteWorkItemsRunnable
                extends ProcessRunnable {
                    public Object reportData;
                    private final /* synthetic */ IWorkItemHandle[] val$workItemHandles;
                    private final /* synthetic */ IBuildDefinitionHandle val$promotionBuildDefinition;
                    private final /* synthetic */ boolean val$promoteBinary;
                    private final /* synthetic */ boolean val$includeWorkItemChildren;
                    private final /* synthetic */ boolean val$considerIgnoreChanges;
                    private final /* synthetic */ boolean val$preflight;
                    private final /* synthetic */ File val$htmlReportFile;
                    private final /* synthetic */ File val$xmlReportFile;

                    PromoteWorkItemsRunnable(IWorkItemHandle[] iWorkItemHandleArray, IBuildDefinitionHandle iBuildDefinitionHandle, boolean bl, boolean bl2, boolean bl3, boolean bl4, File file, File file2) {
                        this.val$workItemHandles = iWorkItemHandleArray;
                        this.val$promotionBuildDefinition = iBuildDefinitionHandle;
                        this.val$promoteBinary = bl;
                        this.val$includeWorkItemChildren = bl2;
                        this.val$considerIgnoreChanges = bl3;
                        this.val$preflight = bl4;
                        this.val$htmlReportFile = file;
                        this.val$xmlReportFile = file2;
                    }

                    public IOperationReport run(IProgressMonitor monitor) throws TeamRepositoryException {
                        IObjectsResponse response = PromotionClient.this.getService(IPromotionService.class).promoteWorkItems2(this.val$workItemHandles, this.val$promotionBuildDefinition, this.val$promoteBinary, this.val$includeWorkItemChildren, this.val$considerIgnoreChanges, this.val$preflight);
                        if (this.val$preflight) {
                            String reportXml = StringHelperUtil.toString((IStringHelper)((IStringHelper)response.getClientObjects()[0]));
                            this.reportData = new ReportConversion(PromotionClient.this.getRepository()).toReportInfo(reportXml);
                            if (this.val$htmlReportFile != null || this.val$xmlReportFile != null) {
                                PromotionClient.this.generateReports(reportXml, this.val$htmlReportFile, this.val$xmlReportFile);
                            }
                        } else if (response.getClientObjects().length > 0) {
                            this.reportData = response.getClientObjects()[0];
                        }
                        return response.getOperationReport();
                    }
                }
                PromoteWorkItemsRunnable runnable = new PromoteWorkItemsRunnable(workItemHandles, promotionBuildDefinition, promoteBinary, includeWorkItemChildren, considerIgnoreChanges, preflight, htmlReportFile, xmlReportFile);
                IProcessClientService processService = (IProcessClientService)PromotionClient.this.getRepository().getClientLibrary(IProcessClientService.class);
                processService.execute((ProcessRunnable)runnable, Messages.PromotionClient_PROMOTE_WORK_ITEMS_OPERATION_NAME, monitor);
                return runnable.reportData;
            }
        });
    }

    @Override
    public Object promoteWorkItems4(final IWorkItemHandle[] workItemHandles, final IBuildDefinitionHandle promotionBuildDefinition, final String[] properties, final File htmlReportFile, final File xmlReportFile, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.callCancelableService(monitor, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                class PromoteWorkItemsRunnable
                extends ProcessRunnable {
                    public Object reportData;
                    private final /* synthetic */ String[] val$properties;
                    private final /* synthetic */ IWorkItemHandle[] val$workItemHandles;
                    private final /* synthetic */ IBuildDefinitionHandle val$promotionBuildDefinition;
                    private final /* synthetic */ File val$htmlReportFile;
                    private final /* synthetic */ File val$xmlReportFile;

                    PromoteWorkItemsRunnable(String[] stringArray, IWorkItemHandle[] iWorkItemHandleArray, IBuildDefinitionHandle iBuildDefinitionHandle, File file, File file2) {
                        this.val$properties = stringArray;
                        this.val$workItemHandles = iWorkItemHandleArray;
                        this.val$promotionBuildDefinition = iBuildDefinitionHandle;
                        this.val$htmlReportFile = file;
                        this.val$xmlReportFile = file2;
                    }

                    public IOperationReport run(IProgressMonitor monitor) throws TeamRepositoryException {
                        boolean preflight = this.val$properties.length > 3 && Boolean.parseBoolean(this.val$properties[3]);
                        IObjectsResponse response = PromotionClient.this.getService(IPromotionService.class).promoteWorkItems4(this.val$workItemHandles, this.val$promotionBuildDefinition, this.val$properties);
                        if (preflight) {
                            String reportXml = StringHelperUtil.toString((IStringHelper)((IStringHelper)response.getClientObjects()[0]));
                            this.reportData = new ReportConversion(PromotionClient.this.getRepository()).toReportInfo(reportXml);
                            if (this.val$htmlReportFile != null || this.val$xmlReportFile != null) {
                                PromotionClient.this.generateReports(reportXml, this.val$htmlReportFile, this.val$xmlReportFile);
                            }
                        } else if (response.getClientObjects().length > 0) {
                            this.reportData = response.getClientObjects()[0];
                        }
                        return response.getOperationReport();
                    }
                }
                PromoteWorkItemsRunnable runnable = new PromoteWorkItemsRunnable(properties, workItemHandles, promotionBuildDefinition, htmlReportFile, xmlReportFile);
                IProcessClientService processService = (IProcessClientService)PromotionClient.this.getRepository().getClientLibrary(IProcessClientService.class);
                processService.execute((ProcessRunnable)runnable, Messages.PromotionClient_PROMOTE_WORK_ITEMS_OPERATION_NAME, monitor);
                return runnable.reportData;
            }
        });
    }

    @Override
    public Object promoteWorkItems6(final IWorkItemHandle[] workItemHandles, final IBuildDefinitionHandle promotionBuildDefinition, final String[] properties, final IBuildProperty[] newAndModifiedBuildProperties, final IBuildProperty[] deletedProperties, final File htmlReportFile, final File xmlReportFile, IProgressMonitor monitor) throws TeamRepositoryException {
        final Exception[] caughtException = new Exception[1];
        return this.callCancelableService(monitor, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                class PromoteWorkItemsRunnable
                extends ProcessRunnable {
                    public Object reportData;
                    private final /* synthetic */ String[] val$properties;
                    private final /* synthetic */ IWorkItemHandle[] val$workItemHandles;
                    private final /* synthetic */ IBuildDefinitionHandle val$promotionBuildDefinition;
                    private final /* synthetic */ IBuildProperty[] val$newAndModifiedBuildProperties;
                    private final /* synthetic */ IBuildProperty[] val$deletedProperties;
                    private final /* synthetic */ File val$htmlReportFile;
                    private final /* synthetic */ File val$xmlReportFile;
                    private final /* synthetic */ Exception[] val$caughtException;

                    PromoteWorkItemsRunnable(String[] stringArray, IWorkItemHandle[] iWorkItemHandleArray, IBuildDefinitionHandle iBuildDefinitionHandle, IBuildProperty[] iBuildPropertyArray, IBuildProperty[] iBuildPropertyArray2, File file, File file2, Exception[] exceptionArray) {
                        this.val$properties = stringArray;
                        this.val$workItemHandles = iWorkItemHandleArray;
                        this.val$promotionBuildDefinition = iBuildDefinitionHandle;
                        this.val$newAndModifiedBuildProperties = iBuildPropertyArray;
                        this.val$deletedProperties = iBuildPropertyArray2;
                        this.val$htmlReportFile = file;
                        this.val$xmlReportFile = file2;
                        this.val$caughtException = exceptionArray;
                    }

                    public IOperationReport run(IProgressMonitor monitor) throws TeamRepositoryException {
                        try {
                            boolean preflight = this.val$properties.length > 3 && Boolean.parseBoolean(this.val$properties[3]);
                            IObjectsResponse response = PromotionClient.this.getService(IPromotionService.class).promoteWorkItems6(this.val$workItemHandles, this.val$promotionBuildDefinition, this.val$properties, this.val$newAndModifiedBuildProperties, this.val$deletedProperties);
                            if (preflight) {
                                String reportXml = StringHelperUtil.toString((IStringHelper)((IStringHelper)response.getClientObjects()[0]));
                                this.reportData = new ReportConversion(PromotionClient.this.getRepository()).toReportInfo(reportXml);
                                if (this.val$htmlReportFile != null || this.val$xmlReportFile != null) {
                                    PromotionClient.this.generateReports(reportXml, this.val$htmlReportFile, this.val$xmlReportFile);
                                }
                            } else if (response.getClientObjects().length > 0) {
                                this.reportData = response.getClientObjects()[0];
                            }
                            return response.getOperationReport();
                        }
                        catch (OperationCanceledException e) {
                            this.val$caughtException[0] = e;
                        }
                        catch (TeamRepositoryException e) {
                            if (e.getCause() instanceof GapException) {
                                this.val$caughtException[0] = e;
                            }
                            throw e;
                        }
                        return null;
                    }
                }
                PromoteWorkItemsRunnable runnable = new PromoteWorkItemsRunnable(properties, workItemHandles, promotionBuildDefinition, newAndModifiedBuildProperties, deletedProperties, htmlReportFile, xmlReportFile, caughtException);
                IProcessClientService processService = (IProcessClientService)PromotionClient.this.getRepository().getClientLibrary(IProcessClientService.class);
                processService.execute((ProcessRunnable)runnable, Messages.PromotionClient_PROMOTE_WORK_ITEMS_OPERATION_NAME, monitor);
                if (caughtException[0] instanceof RuntimeException) {
                    throw (RuntimeException)caughtException[0];
                }
                if (caughtException[0] instanceof TeamRepositoryException) {
                    throw (TeamRepositoryException)((Object)caughtException[0]);
                }
                return runnable.reportData;
            }
        });
    }

    private void generateReports(String xmlReportContent, File htmlReportFile, File xmlReportFile) throws TeamRepositoryException {
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            if (xmlReportFile != null) {
                StreamSource xmlSource = new StreamSource(new ByteArrayInputStream(xmlReportContent.getBytes("UTF-8")));
                StreamResult xmlResult = new StreamResult(xmlReportFile);
                Transformer transformer = factory.newTransformer();
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "3");
                transformer.transform(xmlSource, xmlResult);
            }
            if (htmlReportFile != null) {
                FileOutputStream fos = new FileOutputStream(htmlReportFile);
                StreamSource xmlSource = new StreamSource(new ByteArrayInputStream(xmlReportContent.getBytes("UTF-8")));
                InputStream is = new CssNlsHelper(ResourceBundle.getBundle("com.ibm.team.enterprise.internal.build.client.promotion.nls.messages")).getTranslatedContent(this.getClass().getResourceAsStream("report.xsl"));
                StreamSource xslSource = new StreamSource(is);
                Transformer transformer = factory.newTransformer(xslSource);
                transformer.transform(xmlSource, new StreamResult(fos));
                fos.close();
            }
        }
        catch (Exception e) {
            throw new TeamRepositoryException(e.getLocalizedMessage());
        }
    }

    @Override
    public String getWorkItemPromotionSummary(IWorkItemHandle[] workItemHandles, boolean includeWorkItemChildren, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.getService(IPromotionService.class).getWorkItemPromotionSummary(workItemHandles, includeWorkItemChildren);
    }

    @Override
    public String getWorkItemPromotionSummary2(IWorkItemHandle[] workItemHandles, boolean includeWorkItemChildren, boolean includeImpacted, String[] excludedImpactedFiles, IBuildDefinition promotionDefinition, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.getService(IPromotionService.class).getWorkItemPromotionSummary2(workItemHandles, includeWorkItemChildren, includeImpacted, excludedImpactedFiles, promotionDefinition);
    }

    @Override
    public String getImpactedFiles(IWorkItemHandle[] workItemHandles, boolean includeWorkItemChildren, String[] excludedImpactedFiles, IBuildDefinition promotionDefinition, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.getService(IPromotionService.class).getImpactedFiles(workItemHandles, includeWorkItemChildren, excludedImpactedFiles, promotionDefinition);
    }

    @Override
    public String finalizeTargetBuildMaps3(final String promotionInfoXML, IProgressMonitor progressMonitor) throws TeamRepositoryException {
        return (String)this.callCancelableService(null, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                return PromotionClient.this.getService(IPromotionService.class).finalizeTargetBuildMaps3(promotionInfoXML);
            }
        });
    }

    @Override
    public String finalizeTargetBuildMaps4(final String promotionInfoXML, final IBuildResultHandle promotionBuildResult, IProgressMonitor progressMonitor) throws TeamRepositoryException {
        return (String)this.callCancelableService(null, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                return PromotionClient.this.getService(IPromotionService.class).finalizeTargetBuildMaps4(promotionInfoXML, promotionBuildResult);
            }
        });
    }

    @Override
    public String getFinalizeBuildMapStatus(final String requestId, final boolean isSupressBuildMapLinks, IProgressMonitor progressMonitor) throws TeamRepositoryException {
        return (String)this.callCancelableService(null, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                return PromotionClient.this.getService(IPromotionService.class).getFinalizeBuildMapStatus(requestId, isSupressBuildMapLinks);
            }
        });
    }

    @Override
    public String promoteWorkItems3(final IWorkItemHandle[] workItemHandles, final IBuildDefinitionHandle promotionBuildDefinition, final boolean promoteBinary, final boolean includeWorkItemChildren, final boolean considerIgnoreChanges, final boolean preflight, IProgressMonitor monitor) throws TeamRepositoryException {
        return (String)this.callCancelableService(monitor, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                return PromotionClient.this.getService(IPromotionService.class).promoteWorkItems3(workItemHandles, promotionBuildDefinition, promoteBinary, includeWorkItemChildren, considerIgnoreChanges, preflight);
            }
        });
    }

    @Override
    public String promoteWorkItems5(final IWorkItemHandle[] workItemHandles, final IBuildDefinitionHandle promotionBuildDefinition, final String[] properties, IProgressMonitor monitor) throws TeamRepositoryException {
        return (String)this.callCancelableService(monitor, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                return PromotionClient.this.getService(IPromotionService.class).promoteWorkItems5(workItemHandles, promotionBuildDefinition, properties);
            }
        });
    }

    @Override
    public Object getPromoteWorkItemStatus(final String requestId, final File htmlReportFile, final File xmlReportFile, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.callCancelableService(monitor, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                class PromoteWorkItemsRunnable
                extends ProcessRunnable {
                    public Object reportData;
                    private final /* synthetic */ String val$requestId;
                    private final /* synthetic */ File val$htmlReportFile;
                    private final /* synthetic */ File val$xmlReportFile;

                    PromoteWorkItemsRunnable(String string, File file, File file2) {
                        this.val$requestId = string;
                        this.val$htmlReportFile = file;
                        this.val$xmlReportFile = file2;
                    }

                    public IOperationReport run(IProgressMonitor monitor) throws TeamRepositoryException {
                        IObjectsResponse response = PromotionClient.this.getService(IPromotionService.class).getPromoteWorkItemStatus(this.val$requestId);
                        this.reportData = null;
                        if (response != null) {
                            boolean preflight;
                            boolean bl = preflight = this.val$requestId != null && this.val$requestId.endsWith("_preflight");
                            if (preflight) {
                                String reportXml = StringHelperUtil.toString((IStringHelper)((IStringHelper)response.getClientObjects()[0]));
                                this.reportData = new ReportConversion(PromotionClient.this.getRepository()).toReportInfo(reportXml);
                                if (this.val$htmlReportFile != null || this.val$xmlReportFile != null) {
                                    PromotionClient.this.generateReports(reportXml, this.val$htmlReportFile, this.val$xmlReportFile);
                                }
                            } else if (response.getClientObjects().length > 0) {
                                this.reportData = response.getClientObjects()[0];
                            }
                            return response.getOperationReport();
                        }
                        return null;
                    }
                }
                PromoteWorkItemsRunnable runnable = new PromoteWorkItemsRunnable(requestId, htmlReportFile, xmlReportFile);
                IProcessClientService processService = (IProcessClientService)PromotionClient.this.getRepository().getClientLibrary(IProcessClientService.class);
                processService.execute((ProcessRunnable)runnable, Messages.PromotionClient_PROMOTE_WORK_ITEMS_OPERATION_NAME, monitor);
                return runnable.reportData;
            }
        });
    }

    @Override
    public IChangeSetHandle[] checkForGaps(final IWorkItemHandle[] workItemHandles, final boolean includeWorkItemChildren, final IBuildDefinitionHandle promotionDefinitionHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        return (IChangeSetHandle[])this.callCancelableService(monitor, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                return PromotionClient.this.getService(IPromotionService.class).checkForGaps(workItemHandles, includeWorkItemChildren, promotionDefinitionHandle);
            }
        });
    }

    @Override
    public String deleteTemporaryBuildMaps2(final String promotionInfoXML, IProgressMonitor progressMonitor) throws TeamRepositoryException {
        return this.callCancelableService(null, new IClientLibraryContext.IServiceRunnable<String>(){

            public String run(IProgressMonitor monitor) throws TeamRepositoryException {
                return PromotionClient.this.getService(IPromotionService.class).deleteTemporaryBuildMaps2(promotionInfoXML);
            }
        });
    }

    @Override
    public int getDeletingTemporaryBuildMapsStatus(final String processId) throws TeamRepositoryException {
        return this.callCancelableService(null, new IClientLibraryContext.IServiceRunnable<Integer>(){

            public Integer run(IProgressMonitor monitor) throws TeamRepositoryException {
                IStringHelper reportData;
                IObjectsResponse response = PromotionClient.this.getService(IPromotionService.class).getPromoteWorkItemStatus(processId);
                if (response != null && response.getClientObjects().length > 0 && (reportData = (IStringHelper)response.getClientObjects()[0]) != null) {
                    return Integer.parseInt(StringHelperUtil.toString((IStringHelper)reportData));
                }
                return -1;
            }
        });
    }
}

