/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.build.client.packaging;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.enterprise.build.client.packaging.IPackagingClient;
import com.ibm.team.enterprise.build.client.packaging.QueryResultsIterator;
import com.ibm.team.enterprise.internal.build.client.packaging.nls.Messages;
import com.ibm.team.enterprise.packaging.common.IPackagingService;
import com.ibm.team.process.client.IProcessClientService;
import com.ibm.team.process.common.advice.IObjectsResponse;
import com.ibm.team.process.common.advice.IOperationReport;
import com.ibm.team.process.common.advice.ProcessRunnable;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.EventSource;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.service.IQueryService;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import org.eclipse.core.runtime.IProgressMonitor;

public class PackagingClient
extends EventSource
implements IPackagingClient {
    private final IClientLibraryContext fContext;

    public PackagingClient(IClientLibraryContext context) {
        this.fContext = context;
    }

    protected IClientLibraryContext getContext() {
        return this.fContext;
    }

    protected ITeamRepository getRepository() {
        return this.fContext.teamRepository();
    }

    protected <T> T getService(Class<T> clazz) {
        return (T)this.getContext().getServiceInterface(clazz);
    }

    @Override
    public IWorkItemHandle createPackageFromWorkItems(final IWorkItemHandle[] workItemHandles, final IBuildDefinitionHandle packageBuildDefinitionHandle, final boolean includeWorkItemChildren, final String includeShiplist, final String excludeShiplist, final String containerMappings, final boolean workItemPackaging, final String timestamp, IProgressMonitor monitor) throws TeamRepositoryException {
        return (IWorkItemHandle)this.callCancelableService(monitor, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                class PackageWorkItemsRunnable
                extends ProcessRunnable {
                    public Object reportData;
                    private final /* synthetic */ IWorkItemHandle[] val$workItemHandles;
                    private final /* synthetic */ IBuildDefinitionHandle val$packageBuildDefinitionHandle;
                    private final /* synthetic */ boolean val$includeWorkItemChildren;
                    private final /* synthetic */ String val$includeShiplist;
                    private final /* synthetic */ String val$excludeShiplist;
                    private final /* synthetic */ String val$containerMappings;
                    private final /* synthetic */ boolean val$workItemPackaging;
                    private final /* synthetic */ String val$timestamp;

                    PackageWorkItemsRunnable(IWorkItemHandle[] iWorkItemHandleArray, IBuildDefinitionHandle iBuildDefinitionHandle, boolean bl, String string, String string2, String string3, boolean bl2, String string4) {
                        this.val$workItemHandles = iWorkItemHandleArray;
                        this.val$packageBuildDefinitionHandle = iBuildDefinitionHandle;
                        this.val$includeWorkItemChildren = bl;
                        this.val$includeShiplist = string;
                        this.val$excludeShiplist = string2;
                        this.val$containerMappings = string3;
                        this.val$workItemPackaging = bl2;
                        this.val$timestamp = string4;
                    }

                    public IOperationReport run(IProgressMonitor monitor) throws TeamRepositoryException {
                        IObjectsResponse response = PackagingClient.this.getService(IPackagingService.class).createPackageFromWorkItems2(this.val$workItemHandles, this.val$packageBuildDefinitionHandle, this.val$includeWorkItemChildren, this.val$includeShiplist, this.val$excludeShiplist, this.val$containerMappings, this.val$workItemPackaging, this.val$timestamp);
                        if (response.getClientObjects().length > 0) {
                            this.reportData = response.getClientObjects()[0];
                        }
                        return response.getOperationReport();
                    }
                }
                PackageWorkItemsRunnable runnable = new PackageWorkItemsRunnable(workItemHandles, packageBuildDefinitionHandle, includeWorkItemChildren, includeShiplist, excludeShiplist, containerMappings, workItemPackaging, timestamp);
                IProcessClientService processService = (IProcessClientService)PackagingClient.this.getRepository().getClientLibrary(IProcessClientService.class);
                processService.execute((ProcessRunnable)runnable, Messages.PackagingClient_REQUEST_PACKAGE_OPERATION_NAME, monitor);
                return runnable.reportData;
            }
        });
    }

    @Override
    public IWorkItemHandle createPackageFromWorkItems2(final IWorkItemHandle[] workItemHandles, final IBuildDefinitionHandle packageBuildDefinitionHandle, final IBuildProperty[] packagingProperties, final IBuildProperty[] newBuildProperties, final IBuildProperty[] deletedBuildProperties, IProgressMonitor monitor) throws TeamRepositoryException {
        return (IWorkItemHandle)this.callCancelableService(monitor, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                class PackageWorkItemsRunnable
                extends ProcessRunnable {
                    public Object reportData;
                    private final /* synthetic */ IWorkItemHandle[] val$workItemHandles;
                    private final /* synthetic */ IBuildDefinitionHandle val$packageBuildDefinitionHandle;
                    private final /* synthetic */ IBuildProperty[] val$packagingProperties;
                    private final /* synthetic */ IBuildProperty[] val$newBuildProperties;
                    private final /* synthetic */ IBuildProperty[] val$deletedBuildProperties;

                    PackageWorkItemsRunnable(IWorkItemHandle[] iWorkItemHandleArray, IBuildDefinitionHandle iBuildDefinitionHandle, IBuildProperty[] iBuildPropertyArray, IBuildProperty[] iBuildPropertyArray2, IBuildProperty[] iBuildPropertyArray3) {
                        this.val$workItemHandles = iWorkItemHandleArray;
                        this.val$packageBuildDefinitionHandle = iBuildDefinitionHandle;
                        this.val$packagingProperties = iBuildPropertyArray;
                        this.val$newBuildProperties = iBuildPropertyArray2;
                        this.val$deletedBuildProperties = iBuildPropertyArray3;
                    }

                    public IOperationReport run(IProgressMonitor monitor) throws TeamRepositoryException {
                        IObjectsResponse response = PackagingClient.this.getService(IPackagingService.class).createPackageFromWorkItems3(this.val$workItemHandles, this.val$packageBuildDefinitionHandle, this.val$packagingProperties, this.val$newBuildProperties, this.val$deletedBuildProperties);
                        if (response.getClientObjects().length > 0) {
                            this.reportData = response.getClientObjects()[0];
                        }
                        return response.getOperationReport();
                    }
                }
                PackageWorkItemsRunnable runnable = new PackageWorkItemsRunnable(workItemHandles, packageBuildDefinitionHandle, packagingProperties, newBuildProperties, deletedBuildProperties);
                IProcessClientService processService = (IProcessClientService)PackagingClient.this.getRepository().getClientLibrary(IProcessClientService.class);
                processService.execute((ProcessRunnable)runnable, Messages.PackagingClient_REQUEST_PACKAGE_OPERATION_NAME, monitor);
                return runnable.reportData;
            }
        });
    }

    @Override
    public IWorkItemHandle createPackage(final IBuildDefinitionHandle packageBuildDefinitionHandle, final IBuildProperty[] newAndModifiedBuildProperties, IProgressMonitor monitor) throws TeamRepositoryException {
        return (IWorkItemHandle)this.callCancelableService(monitor, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                class CreatePackageRunnable
                extends ProcessRunnable {
                    public Object reportData;
                    private final /* synthetic */ IBuildDefinitionHandle val$packageBuildDefinitionHandle;
                    private final /* synthetic */ IBuildProperty[] val$newAndModifiedBuildProperties;

                    CreatePackageRunnable(IBuildDefinitionHandle iBuildDefinitionHandle, IBuildProperty[] iBuildPropertyArray) {
                        this.val$packageBuildDefinitionHandle = iBuildDefinitionHandle;
                        this.val$newAndModifiedBuildProperties = iBuildPropertyArray;
                    }

                    public IOperationReport run(IProgressMonitor monitor) throws TeamRepositoryException {
                        IObjectsResponse response = PackagingClient.this.getService(IPackagingService.class).createPackage(this.val$packageBuildDefinitionHandle, this.val$newAndModifiedBuildProperties);
                        if (response.getClientObjects().length > 1) {
                            this.reportData = response.getClientObjects()[1];
                        }
                        return response.getOperationReport();
                    }
                }
                CreatePackageRunnable runnable = new CreatePackageRunnable(packageBuildDefinitionHandle, newAndModifiedBuildProperties);
                IProcessClientService processService = (IProcessClientService)PackagingClient.this.getRepository().getClientLibrary(IProcessClientService.class);
                processService.execute((ProcessRunnable)runnable, Messages.PackagingClient_REQUEST_PACKAGE_OPERATION_NAME, monitor);
                return runnable.reportData;
            }
        });
    }

    protected Object callCancelableService(IProgressMonitor progressMonitor, IClientLibraryContext.IServiceRunnable serviceRunnable) throws TeamRepositoryException {
        return this.getContext().callCancelableService(serviceRunnable, progressMonitor);
    }

    @Override
    public String getWorkItemPackagingSummary(IWorkItemHandle[] workItemHandles, boolean includeWorkItemChildren, IBuildDefinition packageDefinition, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.getService(IPackagingService.class).getWorkItemPackagingSummary(workItemHandles, includeWorkItemChildren, packageDefinition);
    }

    @Override
    public String getWorkItemPackagingSummary2(IWorkItemHandle[] workItemHandles, String[] properties, IBuildDefinition packageDefinition, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.getService(IPackagingService.class).getWorkItemPackagingSummary2(workItemHandles, properties, packageDefinition);
    }

    @Override
    public String getChildrenWorkItems(IWorkItemHandle[] workItemHandles) throws TeamRepositoryException {
        return this.getService(IPackagingService.class).getChildrenWorkItems(workItemHandles);
    }

    public IQueryService getQueryService() {
        return this.getService(IQueryService.class);
    }

    public QueryResultsIterator getAllOutputs(UUID buildDefinition) throws TeamRepositoryException {
        return this.getAllOutputs(buildDefinition, false);
    }

    public QueryResultsIterator getAllOutputs(UUID buildDefinition, Boolean hfs) throws TeamRepositoryException {
        return new QueryResultsIterator(this.getQueryService(), this.getService(IPackagingService.class).getAllOutputs(buildDefinition, hfs));
    }
}

