/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.build.client.packaging;

import com.ibm.team.enterprise.packaging.common.jfs.PackageJFSConstants;

public class PackageQueryGenerator
implements PackageJFSConstants {
    public static String getAllPackagesQuery(String buildDefinitionUUID) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(PackageQueryGenerator.getPackageNSPrefix()).append("\n");
        buffer.append("SELECT  ?label ?packageResultUUID ?packageDefinitionUUID \n");
        buffer.append("WHERE\n");
        buffer.append("{\n");
        buffer.append("  ?index   package:label   ?label  .\n");
        buffer.append("  ?index   package:packageResultUUID  ?packageResultUUID   .\n");
        buffer.append("  ?index   package:packageDefinitionUUID   ?packageDefinitionUUID  .\n");
        buffer.append("  ?index   package:packageDefinitionUUID   \"").append(buildDefinitionUUID).append("\"  .\n");
        buffer.append("  ?index   package:markedForDeletion   \"false\"  .\n");
        buffer.append("}\n");
        return buffer.toString();
    }

    public static String getLastFivePackagesQuery(String buildDefinitionUUID) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(PackageQueryGenerator.getPackageNSPrefix()).append("\n");
        buffer.append("SELECT  ?label ?packageResultUUID ?packageDefinitionUUID \n");
        buffer.append("WHERE\n");
        buffer.append("{\n");
        buffer.append("  ?index   package:label   ?label  .\n");
        buffer.append("  ?index   package:packageResultUUID  ?packageResultUUID   .\n");
        buffer.append("  ?index   package:packageDefinitionUUID   ?packageDefinitionUUID  .\n");
        buffer.append("  ?index   package:packageDefinitionUUID   \"").append(buildDefinitionUUID).append("\"  .\n");
        buffer.append("  ?index   package:markedForDeletion   \"false\"  .\n");
        buffer.append("}\n");
        buffer.append("ORDER BY desc(?label)\n");
        buffer.append("LIMIT 5\n");
        return buffer.toString();
    }

    public static String getAllPackagesMarkedForDeletionQuery() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(PackageQueryGenerator.getPackageNSPrefix()).append("\n");
        buffer.append("SELECT  ?label  ?location \n");
        buffer.append("WHERE\n");
        buffer.append("{\n");
        buffer.append("  ?index   package:label    ?label  .\n");
        buffer.append("  ?index   package:location  ?location  .\n");
        buffer.append("  ?index   package:markedForDeletion   \"true\"  .\n");
        buffer.append("}\n");
        return buffer.toString();
    }

    public static String getAllPackagesMarkedForDeletionQuery(String buildDefinitionUUID) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(PackageQueryGenerator.getPackageNSPrefix()).append("\n");
        buffer.append("SELECT  ?location  ?packageResultUUID \n");
        buffer.append("WHERE\n");
        buffer.append("{\n");
        buffer.append("  ?index   package:location  ?location  .\n");
        buffer.append("  ?index   package:packageResultUUID  ?packageResultUUID   .\n");
        buffer.append("  ?index   package:markedForDeletion   \"true\"  .\n");
        buffer.append("  ?index   package:packageDefinitionUUID   \"").append(buildDefinitionUUID).append("\"  .\n");
        buffer.append("}\n");
        return buffer.toString();
    }

    private static String getPackageNSPrefix() {
        return "PREFIX package: <http://www.ibm.com/team/enterprise/package/>";
    }
}

