/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.build.client.packaging;

import com.ibm.team.enterprise.automation.common.jfs.IJFSResource;
import com.ibm.team.enterprise.build.client.packaging.IPackageJFSClient;
import com.ibm.team.enterprise.internal.build.client.packaging.PackageQueryGenerator;
import com.ibm.team.enterprise.packaging.common.jfs.IPackage;
import com.ibm.team.enterprise.packaging.common.jfs.IPackageHandle;
import com.ibm.team.enterprise.packaging.common.jfs.IPackageJFSService;
import com.ibm.team.enterprise.packaging.common.jfs.impl.Package;
import com.ibm.team.enterprise.packaging.common.jfs.impl.PackageJFSParser;
import com.ibm.team.enterprise.rdf.query.common.select.result.Binding;
import com.ibm.team.enterprise.rdf.query.common.select.result.SelectResult;
import com.ibm.team.enterprise.rdf.query.common.select.result.SelectResultFeedParser;
import com.ibm.team.repository.client.util.EventSource;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class PackageJFSClient
extends EventSource
implements IPackageJFSClient {
    private final IClientLibraryContext context;

    public PackageJFSClient(IClientLibraryContext context) {
        this.context = context;
    }

    @Override
    public void deletePackage(final UUID buildResultUUID, final UUID buildDefinitionUUID) throws TeamRepositoryException {
        this.callCancelableService(null, (IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<Object>(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                PackageJFSClient.this.getService(IPackageJFSService.class).deletePackage(buildResultUUID.getUuidValue(), buildDefinitionUUID.getUuidValue());
                return null;
            }
        });
    }

    @Override
    public IPackage getPackage(final UUID buildResultUUID, final UUID buildDefinitionUUID) throws TeamRepositoryException {
        return (IPackage)this.callCancelableService(null, (IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<IPackage>(){

            public IPackage run(IProgressMonitor monitor) throws TeamRepositoryException {
                String rdfXml = PackageJFSClient.this.getService(IPackageJFSService.class).getPackage(buildResultUUID.getUuidValue(), buildDefinitionUUID.getUuidValue());
                return (IPackage)new PackageJFSParser().toJFSResource(rdfXml);
            }
        });
    }

    @Override
    public void saveNewPackage(final IPackage pkg) throws TeamRepositoryException {
        this.callCancelableService(null, (IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<Object>(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                String rdfXml = new PackageJFSParser().toRDFXML((IJFSResource)pkg);
                PackageJFSClient.this.getService(IPackageJFSService.class).saveNewPackage(rdfXml);
                return null;
            }
        });
    }

    @Override
    public void markedForDeletion(final UUID buildResultUUID, final UUID buildDefinitionUUID) throws TeamRepositoryException {
        this.callCancelableService(null, (IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<Object>(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                PackageJFSClient.this.getService(IPackageJFSService.class).markedForDeletion(buildResultUUID.getUuidValue(), buildDefinitionUUID.getUuidValue());
                return null;
            }
        });
    }

    @Override
    public List<SelectResult> getPackagesMarkedForDeletion(String buildDefinitionUUID) throws TeamRepositoryException {
        String result = this.getService(IPackageJFSService.class).runQuery(PackageQueryGenerator.getAllPackagesMarkedForDeletionQuery(buildDefinitionUUID));
        return this.parseResult(result);
    }

    @Override
    public List<SelectResult> queryAllPackages(UUID buildDefinitionUUID) throws TeamRepositoryException {
        String result = this.getService(IPackageJFSService.class).runQuery(PackageQueryGenerator.getAllPackagesQuery(buildDefinitionUUID.getUuidValue()));
        return this.parseResult(result);
    }

    public List<SelectResult> queryLastFivePackages(UUID buildDefinitionUUID) throws TeamRepositoryException {
        String result = this.getService(IPackageJFSService.class).runQuery(PackageQueryGenerator.getLastFivePackagesQuery(buildDefinitionUUID.getUuidValue()));
        return this.parseResult(result);
    }

    @Override
    public List<IPackageHandle> getAllPackageHandles(UUID buildDefinitionUUID) throws TeamRepositoryException {
        List<SelectResult> results = this.queryAllPackages(buildDefinitionUUID);
        ArrayList<IPackageHandle> packageHandles = new ArrayList<IPackageHandle>();
        for (SelectResult result : results) {
            String label = null;
            String packageResultUUID = null;
            String packageDefinitionUUID = null;
            for (Binding binding : result.getBindings()) {
                String bindingName = binding.getName();
                if (bindingName.equals("label")) {
                    label = binding.getValue();
                    continue;
                }
                if (bindingName.equals("packageResultUUID")) {
                    packageResultUUID = binding.getValue();
                    continue;
                }
                if (!bindingName.equals("packageDefinitionUUID")) continue;
                packageDefinitionUUID = binding.getValue();
            }
            if (label == null || packageResultUUID == null || packageDefinitionUUID == null) continue;
            Package pkg = new Package(UUID.valueOf(packageResultUUID), UUID.valueOf(packageDefinitionUUID));
            pkg.setLabel(label);
            packageHandles.add((IPackageHandle)pkg);
        }
        return packageHandles;
    }

    @Override
    public List<IPackageHandle> getLastFivePackageHandles(UUID buildDefinitionUUID) throws TeamRepositoryException {
        List<SelectResult> results = this.queryLastFivePackages(buildDefinitionUUID);
        ArrayList<IPackageHandle> packageHandles = new ArrayList<IPackageHandle>();
        for (SelectResult result : results) {
            String label = null;
            String packageResultUUID = null;
            String packageDefinitionUUID = null;
            for (Binding binding : result.getBindings()) {
                String bindingName = binding.getName();
                if (bindingName.equals("label")) {
                    label = binding.getValue();
                    continue;
                }
                if (bindingName.equals("packageResultUUID")) {
                    packageResultUUID = binding.getValue();
                    continue;
                }
                if (!bindingName.equals("packageDefinitionUUID")) continue;
                packageDefinitionUUID = binding.getValue();
            }
            if (label == null || packageResultUUID == null || packageDefinitionUUID == null) continue;
            Package pkg = new Package(UUID.valueOf(packageResultUUID), UUID.valueOf(packageDefinitionUUID));
            pkg.setLabel(label);
            packageHandles.add((IPackageHandle)pkg);
        }
        return packageHandles;
    }

    public List<SelectResult> getAllPackagesMarkedForDeletion() throws TeamRepositoryException {
        String result = this.getService(IPackageJFSService.class).runQuery(PackageQueryGenerator.getAllPackagesMarkedForDeletionQuery());
        return this.parseResult(result);
    }

    private List<SelectResult> parseResult(String result) throws TeamRepositoryException {
        try {
            SelectResultFeedParser parser = new SelectResultFeedParser();
            return parser.parse((InputStream)new ByteArrayInputStream(result.getBytes("UTF-8")));
        }
        catch (Exception e) {
            throw new TeamRepositoryException((Throwable)e);
        }
    }

    protected <T> T getService(Class<T> clazz) {
        return (T)this.context.getServiceInterface(clazz);
    }

    protected <T> T callCancelableService(IProgressMonitor progressMonitor, IClientLibraryContext.IServiceRunnable serviceRunnable) throws TeamRepositoryException {
        return (T)this.context.callCancelableService(serviceRunnable, progressMonitor);
    }
}

