/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.build.client.deployment;

import com.ibm.team.enterprise.automation.common.jfs.IJFSResource;
import com.ibm.team.enterprise.build.client.deployment.IDeploymentJFSClient;
import com.ibm.team.enterprise.deployment.common.jfs.IDeployment;
import com.ibm.team.enterprise.deployment.common.jfs.IDeploymentJFSService;
import com.ibm.team.enterprise.deployment.common.jfs.impl.Deployment;
import com.ibm.team.enterprise.deployment.common.jfs.impl.DeploymentJFSParser;
import com.ibm.team.enterprise.deployment.common.jfs.impl.DeploymentQueryGenerator;
import com.ibm.team.enterprise.rdf.query.common.select.result.SelectResult;
import com.ibm.team.enterprise.rdf.query.common.select.result.SelectResultFeedParser;
import com.ibm.team.repository.client.util.EventSource;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class DeploymentJFSClient
extends EventSource
implements IDeploymentJFSClient {
    private final IClientLibraryContext context;

    public DeploymentJFSClient(IClientLibraryContext context) {
        this.context = context;
    }

    @Override
    public void deleteDeployment(final UUID packageDefinitionUUID, final UUID deploymentDefinitionUUID, final UUID buildAgentUUID) throws TeamRepositoryException {
        this.callCancelableService(null, (IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<Object>(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                DeploymentJFSClient.this.getService(IDeploymentJFSService.class).deleteDeployment(packageDefinitionUUID.getUuidValue(), deploymentDefinitionUUID.getUuidValue(), buildAgentUUID.getUuidValue());
                return null;
            }
        });
    }

    @Override
    public IDeployment getDeployment(final UUID packageDefinitionUUID, final UUID deploymentDefinitionUUID, final UUID buildAgentUUID) throws TeamRepositoryException {
        return (IDeployment)this.callCancelableService(null, (IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<Object>(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                String rdfXml = DeploymentJFSClient.this.getService(IDeploymentJFSService.class).getDeployment(packageDefinitionUUID.getUuidValue(), deploymentDefinitionUUID.getUuidValue(), buildAgentUUID.getUuidValue());
                if (rdfXml == null || rdfXml.equals("")) {
                    return new Deployment(packageDefinitionUUID, deploymentDefinitionUUID, buildAgentUUID);
                }
                return new DeploymentJFSParser().toJFSResource(rdfXml);
            }
        });
    }

    @Override
    public void saveDeployment(final IDeployment deployment) throws TeamRepositoryException {
        this.callCancelableService(null, (IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<Object>(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                String rdfXml = new DeploymentJFSParser().toRDFXML((IJFSResource)deployment);
                DeploymentJFSClient.this.getService(IDeploymentJFSService.class).saveDeployment(rdfXml, true);
                return null;
            }
        });
    }

    @Override
    public List<SelectResult> queryAllDeployedPackages(UUID packageDefinitionUUID, UUID deploymentDefinitionUUID) throws TeamRepositoryException {
        return this.queryAllDeployedPackages(packageDefinitionUUID, deploymentDefinitionUUID, null);
    }

    @Override
    public List<SelectResult> queryAllDeployedPackages(UUID packageDefinitionUUID, UUID deploymentDefinitionUUID, UUID packageResultUUID) throws TeamRepositoryException {
        return this.queryAllDeployedPackages(packageDefinitionUUID, deploymentDefinitionUUID, packageResultUUID, null);
    }

    @Override
    public List<SelectResult> queryAllDeployedPackages(UUID packageDefinitionUUID, UUID deploymentDefinitionUUID, UUID packageResultUUID, UUID buildAgentUUID) throws TeamRepositoryException {
        String packageDefinitionUUIDValue = null;
        if (packageDefinitionUUID != null) {
            packageDefinitionUUIDValue = packageDefinitionUUID.getUuidValue();
        }
        String deploymentDefinitionUUIDValue = null;
        if (deploymentDefinitionUUID != null) {
            deploymentDefinitionUUIDValue = deploymentDefinitionUUID.getUuidValue();
        }
        String packageResultUUIDValue = null;
        if (packageResultUUID != null) {
            packageResultUUIDValue = packageResultUUID.getUuidValue();
        }
        String buildAgentValue = null;
        if (buildAgentUUID != null) {
            buildAgentValue = buildAgentUUID.getUuidValue();
        }
        String result = this.getService(IDeploymentJFSService.class).runQuery(DeploymentQueryGenerator.getAllDeployedPackagesQuery((String)packageDefinitionUUIDValue, (String)deploymentDefinitionUUIDValue, (String)packageResultUUIDValue, (String)buildAgentValue));
        return this.parseResult(result);
    }

    private List<SelectResult> parseResult(String result) throws TeamRepositoryException {
        try {
            SelectResultFeedParser parser = new SelectResultFeedParser();
            return parser.parse((InputStream)new ByteArrayInputStream(result.getBytes("UTF-8")));
        }
        catch (Exception e) {
            throw new TeamRepositoryException((Throwable)e);
        }
    }

    protected <T> T getService(Class<T> clazz) {
        return (T)this.context.getServiceInterface(clazz);
    }

    protected <T> T callCancelableService(IProgressMonitor progressMonitor, IClientLibraryContext.IServiceRunnable serviceRunnable) throws TeamRepositoryException {
        return (T)this.context.callCancelableService(serviceRunnable, progressMonitor);
    }
}

