/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.build.client.dependencyset;

import com.ibm.team.enterprise.build.client.dependencyset.IDependencySetClient;
import com.ibm.team.enterprise.build.common.dependencyset.IDependencySetService;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.EventSource;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.json.JSONObject;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;

public class DependencySetClient
extends EventSource
implements IDependencySetClient {
    private final IClientLibraryContext fContext;

    public DependencySetClient(IClientLibraryContext context) {
        this.fContext = context;
    }

    protected IClientLibraryContext getContext() {
        return this.fContext;
    }

    protected ITeamRepository getRepository() {
        return this.fContext.teamRepository();
    }

    protected <T> T getService(Class<T> clazz) {
        return (T)this.getContext().getServiceInterface(clazz);
    }

    @Override
    public String buildDependencySet2(final String versionableItemUUID, final String languageDefinitionUUID, final String componentName, final String workspaceUUID, final Map<String, Object> buildProperties, IProgressMonitor progressMonitor) throws IllegalArgumentException, TeamRepositoryException {
        return (String)this.callCancelableService(progressMonitor, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                JSONObject buildPropertiesJSON = new JSONObject();
                for (String key : buildProperties.keySet()) {
                    buildPropertiesJSON.put((Object)key, buildProperties.get(key));
                }
                String dependencySet = DependencySetClient.this.getService(IDependencySetService.class).buildDependencySet2(versionableItemUUID, languageDefinitionUUID, componentName, workspaceUUID, buildPropertiesJSON.toString());
                return dependencySet;
            }
        });
    }

    protected Object callCancelableService(IProgressMonitor progressMonitor, IClientLibraryContext.IServiceRunnable serviceRunnable) throws TeamRepositoryException {
        return this.getContext().callCancelableService(serviceRunnable, progressMonitor);
    }

    @Override
    public Boolean isIgnoreFileTypeForDependencySearch(IProgressMonitor progressMonitor) throws TeamRepositoryException {
        return (Boolean)this.callCancelableService(progressMonitor, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                boolean isIgnoreFileTypeForDependencySearch = DependencySetClient.this.getService(IDependencySetService.class).isIgnoreFileTypeForDependencySearch();
                return new Boolean(isIgnoreFileTypeForDependencySearch);
            }
        });
    }
}

