/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.build.client.buildmap;

import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.enterprise.build.buildmap.common.IBuildMapService;
import com.ibm.team.enterprise.build.buildmap.common.model.IBuildLogHandle;
import com.ibm.team.enterprise.build.buildmap.common.model.IBuildMap;
import com.ibm.team.enterprise.build.buildmap.common.model.IBuildMapHandle;
import com.ibm.team.enterprise.build.client.buildmap.IBuildMapClient;
import com.ibm.team.enterprise.common.client.util.URIUtilities;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.internal.util.ItemUtil;
import com.ibm.team.repository.common.model.ItemHandle;
import java.net.URI;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class BuildMapClient
implements IBuildMapClient {
    private final IClientLibraryContext context;

    public BuildMapClient(IClientLibraryContext context) {
        this.context = context;
    }

    protected IBuildMapService getService() {
        return (IBuildMapService)this.context.getServiceInterface(IBuildMapService.class);
    }

    protected IBuildMap initUnsetCollections(IBuildMap bm) {
        if (bm == null) {
            return null;
        }
        ItemUtil.unprotect((ItemHandle)((ItemHandle)bm));
        EList features = ((EObject)bm).eClass().getEAllStructuralFeatures();
        for (EStructuralFeature feature : features) {
            if (!feature.isMany() || ((EObject)bm).eIsSet(feature) || !ItemUtil.isPersistent((EClass)((EObject)bm).eClass(), (EStructuralFeature)feature)) continue;
            ((EObject)bm).eSet(feature, (Object)Collections.EMPTY_LIST);
        }
        bm.protect();
        return bm;
    }

    @Override
    public void delete(final IBuildMapHandle handle, IProgressMonitor monitor) throws TeamRepositoryException {
        this.context.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<Object>(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                BuildMapClient.this.getService().delete(handle);
                return null;
            }
        }, monitor);
    }

    @Override
    public void deleteHistory(final IBuildMapHandle handle, IProgressMonitor monitor) throws TeamRepositoryException {
        this.context.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<Object>(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                BuildMapClient.this.getService().deleteHistory(handle);
                return null;
            }
        }, monitor);
    }

    @Override
    public void deleteBuildLogs(final Set<IBuildLogHandle> buildLogs, IProgressMonitor monitor) throws TeamRepositoryException {
        this.context.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<Boolean>(){

            public Boolean run(IProgressMonitor monitor) throws TeamRepositoryException {
                if (buildLogs != null && buildLogs.size() > 0) {
                    for (IBuildLogHandle buildLog : buildLogs) {
                        BuildMapClient.this.getService().deleteBuildLog(buildLog);
                    }
                }
                return true;
            }
        }, monitor);
    }

    @Override
    public void deleteBuildMapState(final IBuildMapHandle handle, IProgressMonitor monitor) throws TeamRepositoryException {
        this.context.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<Object>(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                BuildMapClient.this.getService().deleteState(handle);
                return null;
            }
        }, monitor);
    }

    @Override
    public IBuildMap getBuildMap(final IBuildMapHandle handle, IProgressMonitor monitor) throws TeamRepositoryException {
        return (IBuildMap)this.context.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<IBuildMap>(){

            public IBuildMap run(IProgressMonitor monitor) throws TeamRepositoryException {
                IBuildMap bm = BuildMapClient.this.getService().fetchComplete(handle);
                return BuildMapClient.this.initUnsetCollections(bm);
            }
        }, monitor);
    }

    @Override
    public IBuildMap getBuildMap(final UUID buildableFileUUID, final UUID buildDefinitionUUID, IProgressMonitor monitor) throws TeamRepositoryException {
        return (IBuildMap)this.context.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<IBuildMap>(){

            public IBuildMap run(IProgressMonitor monitor) throws TeamRepositoryException {
                IBuildMapHandle handle = BuildMapClient.this.getService().getBuildMapHandle(buildableFileUUID, buildDefinitionUUID);
                if (handle == null) {
                    return null;
                }
                if (monitor != null && monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                IBuildMap bm = BuildMapClient.this.getService().fetchComplete(handle);
                return BuildMapClient.this.initUnsetCollections(bm);
            }
        }, monitor);
    }

    @Override
    public IBuildMap getBuildMap(URI buildMapURI, IProgressMonitor monitor) throws TeamRepositoryException {
        IItemHandle itemHandle = URIUtilities.getItemHandle((URI)buildMapURI);
        IBuildMapHandle buildMapHandle = itemHandle instanceof IBuildMapHandle ? (IBuildMapHandle)itemHandle : null;
        return buildMapHandle != null ? this.getBuildMapState(buildMapHandle, monitor) : null;
    }

    @Override
    public IBuildMap getBuildMapState(final IBuildMapHandle stateHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        return (IBuildMap)this.context.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<IBuildMap>(){

            public IBuildMap run(IProgressMonitor monitor) throws TeamRepositoryException {
                IBuildMap bm = BuildMapClient.this.getService().fetchStateComplete(stateHandle);
                return BuildMapClient.this.initUnsetCollections(bm);
            }
        }, monitor);
    }

    @Override
    public Map<String, IAuditableHandle> getBuildMapStates(final UUID buildableFileUUID, final UUID buildDefinitionUUID, IProgressMonitor monitor) throws TeamRepositoryException {
        return (Map)this.context.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<Map<String, IAuditableHandle>>(){

            public Map<String, IAuditableHandle> run(IProgressMonitor monitor) throws TeamRepositoryException {
                IBuildMapHandle handle = BuildMapClient.this.getService().getBuildMapHandle(buildableFileUUID, buildDefinitionUUID);
                LinkedHashMap<String, IAuditableHandle> bmh = new LinkedHashMap<String, IAuditableHandle>();
                IAuditableHandle[] handles = BuildMapClient.this.getService().fetchStatesArray(handle);
                String[] labels = BuildMapClient.this.getService().fetchBuildNamesArray(handles);
                int i = 0;
                while (i < handles.length) {
                    bmh.put(labels[i], handles[i]);
                    ++i;
                }
                return bmh;
            }
        }, monitor);
    }

    @Override
    public int getBuildMapStatesLimit() {
        return this.getService().getBuildMapStatesLimit();
    }

    @Override
    public IBuildMapHandle[] getBuildMapHandles(final IBuildDefinitionHandle buildDefinition, IProgressMonitor monitor) throws TeamRepositoryException {
        return (IBuildMapHandle[])this.context.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<IBuildMapHandle[]>(){

            public IBuildMapHandle[] run(IProgressMonitor monitor) throws TeamRepositoryException {
                return BuildMapClient.this.getService().getBuildMapHandles(buildDefinition);
            }
        }, monitor);
    }

    @Override
    public IBuildMap[] getBuildMapStates(final IBuildMapHandle buildMapHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        return (IBuildMap[])this.context.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<IBuildMap[]>(){

            public IBuildMap[] run(IProgressMonitor monitor) throws TeamRepositoryException {
                return BuildMapClient.this.getService().getBuildMapStates(buildMapHandle);
            }
        }, monitor);
    }

    @Override
    public Integer getBuildMapStateCount(final IBuildMapHandle buildMapHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        return (Integer)this.context.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<Integer>(){

            public Integer run(IProgressMonitor monitor) throws TeamRepositoryException {
                return BuildMapClient.this.getService().getBuildMapStateCount(buildMapHandle);
            }
        }, monitor);
    }

    @Override
    public IBuildMapHandle saveBuildMap(final IBuildMap buildMap, IProgressMonitor monitor) throws TeamRepositoryException {
        return (IBuildMapHandle)this.context.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<IBuildMapHandle>(){

            public IBuildMapHandle run(IProgressMonitor monitor) throws TeamRepositoryException {
                return BuildMapClient.this.getService().save(buildMap);
            }
        }, monitor);
    }
}

