/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.build.client.buildablesubset;

import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.enterprise.build.client.buildablesubset.IBuildableSubsetClient;
import com.ibm.team.enterprise.buildablesubset.common.BuildSubsetRuleParserFactory;
import com.ibm.team.enterprise.buildablesubset.common.IBuildSubsetRule;
import com.ibm.team.enterprise.buildablesubset.common.ISubsetService;
import com.ibm.team.enterprise.buildablesubset.common.internal.model.Criteria;
import com.ibm.team.enterprise.buildablesubset.common.internal.model.StringHelper;
import com.ibm.team.enterprise.buildablesubset.common.internal.model.Visibility;
import com.ibm.team.enterprise.buildablesubset.common.model.ICriteria;
import com.ibm.team.enterprise.buildablesubset.common.model.ICriteriaSubset;
import com.ibm.team.enterprise.buildablesubset.common.model.ICriteriaWorkItem;
import com.ibm.team.enterprise.buildablesubset.common.model.ISubset;
import com.ibm.team.enterprise.buildablesubset.common.model.ISubsetCriteria;
import com.ibm.team.enterprise.buildablesubset.common.model.ISubsetFileDesc;
import com.ibm.team.enterprise.buildablesubset.common.model.ISubsetHandle;
import com.ibm.team.enterprise.internal.build.client.buildablesubset.nls.Messages;
import com.ibm.team.process.client.IProcessClientService;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.advice.IOperationReport;
import com.ibm.team.process.common.advice.ProcessRunnable;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.EventSource;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;

public class BuildableSubsetClient
extends EventSource
implements IBuildableSubsetClient {
    private static Map<UUID, Integer> workItemNumberCache;
    private final IClientLibraryContext fContext;

    public BuildableSubsetClient(IClientLibraryContext context) {
        this.fContext = context;
    }

    protected IClientLibraryContext getContext() {
        return this.fContext;
    }

    protected ITeamRepository getRepository() {
        return this.fContext.teamRepository();
    }

    protected <T> T getService(Class<T> clazz) {
        return (T)this.getContext().getServiceInterface(clazz);
    }

    protected Object callCancelableService(IProgressMonitor progressMonitor, IClientLibraryContext.IServiceRunnable serviceRunnable) throws TeamRepositoryException {
        return this.getContext().callCancelableService(serviceRunnable, progressMonitor);
    }

    @Override
    public boolean exists(final String buildableSubsetSlug) throws TeamRepositoryException {
        return (Boolean)this.callCancelableService(null, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                return BuildableSubsetClient.this.getService(ISubsetService.class).exists(buildableSubsetSlug);
            }
        });
    }

    @Override
    public ISubset createNewSubset() throws TeamRepositoryException {
        return (ISubset)this.callCancelableService(null, monitor -> this.getService(ISubsetService.class).createSubset());
    }

    @Override
    public ISubset createSubsetFromWorkItems(String name, IContributorHandle owner, Visibility visibility, IBuildDefinitionHandle buildDefinitionHandle, IWorkItemHandle[] workItemHandles, boolean includeWorkItemChildren, boolean includeImpacts, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.createSubsetFromWorkItems(name, owner, visibility, buildDefinitionHandle, workItemHandles, new IWorkItemHandle[0], includeWorkItemChildren, includeImpacts, monitor);
    }

    @Override
    public ISubset createSubsetFromWorkItems(String name, IContributorHandle owner, Visibility visibility, IBuildDefinitionHandle buildDefinitionHandle, IWorkItemHandle[] workItemHandles, IWorkItemHandle[] dynamicWorkItemHandles, boolean includeWorkItemChildren, boolean includeImpacts, IProgressMonitor monitor) throws TeamRepositoryException {
        return (ISubset)this.callCancelableService(monitor, m -> this.getService(ISubsetService.class).createSubsetFromWorkItems(name, owner, visibility, buildDefinitionHandle, workItemHandles, dynamicWorkItemHandles, includeWorkItemChildren, includeImpacts, monitor));
    }

    @Override
    public String deleteBuildableSubset(ISubset subset) throws TeamRepositoryException {
        return this.internalDelete(subset, Messages.BuildableSubsetsClient_DELETE_SUBSET_OPERATION_NAME, null);
    }

    private String internalDelete(final ISubset subset, final String operationId, IProgressMonitor progressMonitor) throws TeamRepositoryException {
        return (String)this.callCancelableService(null, new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                class DeleteSubsetRunnable
                extends ProcessRunnable {
                    public String fDeleteTimestamp;
                    private final /* synthetic */ ISubset val$subset;

                    DeleteSubsetRunnable(ISubset iSubset) {
                        this.val$subset = iSubset;
                    }

                    public IOperationReport run(IProgressMonitor monitor) throws TeamRepositoryException {
                        this.fDeleteTimestamp = BuildableSubsetClient.this.getService(ISubsetService.class).deleteSubset(this.val$subset);
                        return null;
                    }
                }
                DeleteSubsetRunnable runnable = new DeleteSubsetRunnable(subset);
                IProcessClientService processService = (IProcessClientService)BuildableSubsetClient.this.getRepository().getClientLibrary(IProcessClientService.class);
                processService.execute((ProcessRunnable)runnable, operationId, monitor);
                return runnable.fDeleteTimestamp;
            }
        });
    }

    @Override
    public String saveSubset(ISubset subset, ISubset previousSubset) throws TeamRepositoryException {
        return (String)this.callCancelableService(null, monitor -> {
            class UpdateSubsetRunnable
            extends ProcessRunnable {
                String fModifyTimestamp;
                private final /* synthetic */ ISubset val$subset;
                private final /* synthetic */ ISubset val$previousSubset;

                UpdateSubsetRunnable(ISubset iSubset, ISubset iSubset2) {
                    this.val$subset = iSubset;
                    this.val$previousSubset = iSubset2;
                }

                public IOperationReport run(IProgressMonitor monitor) throws TeamRepositoryException {
                    this.fModifyTimestamp = BuildableSubsetClient.this.getService(ISubsetService.class).saveSubset(this.val$subset, this.val$previousSubset);
                    return null;
                }
            }
            UpdateSubsetRunnable runnable = new UpdateSubsetRunnable(subset, previousSubset);
            IProcessClientService processService = (IProcessClientService)this.getRepository().getClientLibrary(IProcessClientService.class);
            processService.execute((ProcessRunnable)runnable, "SAVE SUBSET", monitor);
            return runnable.fModifyTimestamp;
        });
    }

    @Override
    public ISubset evaluateSubset(final ISubset subset) throws TeamRepositoryException {
        return (ISubset)this.callCancelableService(null, new IClientLibraryContext.IServiceRunnable(){

            public ISubset run(IProgressMonitor monitor) throws TeamRepositoryException {
                try {
                    return BuildableSubsetClient.this.getService(ISubsetService.class).evaluateSubset(subset);
                }
                catch (Exception e) {
                    throw new TeamRepositoryException((Throwable)e);
                }
            }
        });
    }

    @Override
    public List<ISubset> getAllBuildableSubsets(IBuildDefinitionHandle buildDefinitionHandle) throws TeamRepositoryException {
        return this.getAllBuildableSubsets(buildDefinitionHandle, null, null);
    }

    @Override
    public List<ISubset> getAllBuildableSubsets(IBuildDefinitionHandle buildDefinitionHandle, String ownerId) throws TeamRepositoryException {
        return this.getAllBuildableSubsets(buildDefinitionHandle, ownerId, null);
    }

    @Override
    public List<ISubset> getAllBuildableSubsets(IBuildDefinitionHandle buildDefinitionHandle, String ownerId, String ifModifiedSince) throws TeamRepositoryException {
        List<ISubset> handles = Arrays.asList(this.getService(ISubsetService.class).getAllSubsets(buildDefinitionHandle.getItemId().getUuidValue(), ownerId));
        return handles;
    }

    @Override
    public List<ISubset> getMyBuildableSubsets(IBuildDefinitionHandle buildDefinitionHandle) throws TeamRepositoryException {
        return this.getMyBuildableSubsets(buildDefinitionHandle, null);
    }

    @Override
    public List<ISubset> getMyBuildableSubsets(IBuildDefinitionHandle buildDefinitionHandle, String ifModifiedSince) throws TeamRepositoryException {
        IContributor contributor = this.getContext().teamRepository().loggedInContributor();
        UUID owner = contributor.getItemId();
        String ownerUUID = owner.getUuidValue();
        List<ISubset> handles = Arrays.asList(this.getService(ISubsetService.class).getSubsetItemByBuildDefAndLabel(buildDefinitionHandle.getItemId().getUuidValue(), ownerUUID));
        return handles;
    }

    @Override
    public List<ISubset> getMySharedBuildableSubsets(IBuildDefinitionHandle buildDefinitionHandle) throws TeamRepositoryException {
        return this.getMySharedBuildableSubsets(buildDefinitionHandle, null);
    }

    @Override
    public List<ISubset> getMySharedBuildableSubsets(IBuildDefinitionHandle buildDefinitionHandle, String ifModifiedSince) throws TeamRepositoryException {
        IContributor contributor = this.getContext().teamRepository().loggedInContributor();
        UUID owner = contributor.getItemId();
        String ownerUUID = owner.getUuidValue();
        List<ISubset> handles = Arrays.asList(this.getService(ISubsetService.class).getSharedSubsetItems(buildDefinitionHandle.getItemId().getUuidValue(), ownerUUID));
        return handles;
    }

    @Override
    public List<ISubset> searchBuildableSubsetsByOwner(final IProjectAreaHandle paHandle, final IContributorHandle[] owners, final String ifModifiedSince) throws TeamRepositoryException {
        return (List)this.callCancelableService(null, new IClientLibraryContext.IServiceRunnable(){

            public List<ISubset> run(IProgressMonitor monitor) throws TeamRepositoryException {
                IContributor contributor = BuildableSubsetClient.this.getContext().teamRepository().loggedInContributor();
                UUID owner = contributor.getItemId();
                return Arrays.stream(BuildableSubsetClient.this.getService(ISubsetService.class).getSubsetItemsByOwner(paHandle, owners, ifModifiedSince)).filter(subset -> subset.getOwner().getItemId().equals((Object)owner) || subset.getVisibility().getValue() == 0).collect(Collectors.toList());
            }
        });
    }

    @Override
    public ISubset getSubsetItem(String buildableSubsetSlug) throws TeamRepositoryException {
        return (ISubset)this.callCancelableService(null, monitor -> {
            try {
                ISubsetService service = this.getService(ISubsetService.class);
                return service.retrieveSubset(buildableSubsetSlug);
            }
            catch (Exception e) {
                return null;
            }
        });
    }

    @Override
    public ISubset getSubsetItem(final ISubsetHandle subsetHandle, ITeamRepository repository) throws TeamRepositoryException {
        return (ISubset)this.callCancelableService(null, (IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<ISubset>(){

            public ISubset run(IProgressMonitor monitor) throws TeamRepositoryException {
                try {
                    ISubsetService service = BuildableSubsetClient.this.getService(ISubsetService.class);
                    return service.getSubsetItem(subsetHandle.getItemId().getUuidValue(), null);
                }
                catch (TeamRepositoryException e) {
                    return null;
                }
            }
        });
    }

    @Override
    public ISubset processRule(IBuildSubsetRule rule, IBuildDefinitionHandle buildDefinitionHandle, ISubset currentSubset) throws TeamRepositoryException {
        return this.processRule(rule, buildDefinitionHandle, currentSubset, false);
    }

    @Override
    public ISubset processRule(final IBuildSubsetRule rule, final IBuildDefinitionHandle buildDefinitionHandle, final ISubset currentSubset, final boolean includeImpacts) throws TeamRepositoryException {
        return (ISubset)this.callCancelableService(null, new IClientLibraryContext.IServiceRunnable(){

            public ISubset run(IProgressMonitor monitor) throws TeamRepositoryException {
                String ruleContent = BuildSubsetRuleParserFactory.getInstance().getParser(rule).toJSON(rule);
                return BuildableSubsetClient.this.getService(ISubsetService.class).processRule(ruleContent, buildDefinitionHandle, currentSubset, includeImpacts);
            }
        });
    }

    @Override
    public List<Object> getReferencedCriterion(ISubsetFileDesc file, List<ISubsetCriteria> criteria, ITeamRepository repository) throws TeamRepositoryException {
        ArrayList<Integer> result = null;
        if (file != null && criteria != null) {
            result = new ArrayList<Integer>();
            ArrayList<String> references = new ArrayList<String>();
            for (Object o : file.getCriteriaRefs()) {
                if (!(o instanceof StringHelper)) continue;
                references.add(((StringHelper)o).getValue());
            }
            for (String reference : references) {
                String uuid = this.getReferencedCriterionUUID(reference);
                for (ISubsetCriteria criterion : criteria) {
                    Integer o;
                    if (!uuid.equals(criterion.getInternalId().getUuidValue()) || (o = this.deref(criterion, reference, repository)) == null) continue;
                    result.add(o);
                }
            }
        }
        return result;
    }

    private String getReferencedCriterionUUID(String reference) {
        int slash = reference.indexOf(47);
        if (slash != -1) {
            return reference.substring(0, slash);
        }
        return reference;
    }

    private Integer deref(ISubsetCriteria criterion, String reference, ITeamRepository repository) throws TeamRepositoryException {
        block5: {
            block6: {
                String subReference;
                String uuidAsString = criterion.getInternalId().getUuidValue();
                if (uuidAsString == null || reference == null || !reference.startsWith(uuidAsString)) break block5;
                int start = uuidAsString.length();
                if (reference.length() > start && reference.charAt(start) == '/') {
                    ++start;
                }
                if ((subReference = reference.substring(start)).isEmpty()) {
                    return null;
                }
                if (!(criterion instanceof ICriteriaSubset)) break block6;
                ICriteriaSubset subsetCriterion = (ICriteriaSubset)criterion;
                for (ISubsetCriteria c : subsetCriterion.getChildCriteria().getReferences()) {
                    Integer o = this.deref(c, reference, repository);
                    if (o == null) continue;
                    return o;
                }
                break block5;
            }
            if (!(criterion instanceof ICriteriaWorkItem)) break block5;
            ICriteriaWorkItem wiCriterion = (ICriteriaWorkItem)criterion;
            List wis = wiCriterion.getWorkItems();
            List additionalWis = wiCriterion.getAdditionalWorkItems();
            Collection<Integer> wiIDs = this.getWorkItemNumbers(wis, repository).values();
            for (Integer wiID : wiIDs) {
                if (!reference.endsWith(Integer.toString(wiID))) continue;
                return wiID;
            }
            Collection<Integer> additionalWiIDs = this.getWorkItemNumbers(additionalWis, repository).values();
            for (Integer wiID : additionalWiIDs) {
                if (!reference.endsWith(Integer.toString(wiID))) continue;
                return wiID;
            }
        }
        return null;
    }

    @Override
    public Map<UUID, Integer> getWorkItemNumbers(List<IWorkItemHandle> wis, ITeamRepository repository) throws TeamRepositoryException {
        if (workItemNumberCache == null) {
            workItemNumberCache = new HashMap<UUID, Integer>();
        }
        Map newWis = wis.stream().filter(wi -> !workItemNumberCache.containsKey(wi.getItemId())).collect(Collectors.toMap(wi -> wi.getItemId(), Function.identity(), (wi1, wi2) -> wi1));
        Map newEntries = (Map)this.callCancelableService(null, monitor -> {
            try {
                List<String> properties = Arrays.asList(IWorkItem.ID_PROPERTY);
                List itemsFetched = repository.itemManager().fetchPartialItems(new ArrayList(newWis.values()), 0, properties, monitor);
                return itemsFetched.stream().filter(IWorkItem.class::isInstance).map(IWorkItem.class::cast).collect(Collectors.toMap(wi -> wi.getItemId(), IWorkItem::getId));
            }
            catch (TeamRepositoryException e) {
                return null;
            }
        });
        workItemNumberCache.putAll(newEntries);
        return wis.stream().collect(Collectors.toMap(wi -> wi.getItemId(), wi -> workItemNumberCache.get(wi.getItemId()), (wi1, wi2) -> wi1));
    }

    @Override
    public Criteria createNewCriteria(List<ISubsetCriteria> criteria) throws TeamRepositoryException {
        return (Criteria)this.callCancelableService(null, monitor -> this.getService(ISubsetService.class).createNewCriteria(criteria.toArray(new ISubsetCriteria[criteria.size()])));
    }

    @Override
    public ICriteria updateCriteria(ICriteria currCriteria, List<ISubsetCriteria> newCriteria) throws TeamRepositoryException {
        return (ICriteria)this.callCancelableService(null, monitor -> this.getService(ISubsetService.class).updateCriteria(currCriteria, newCriteria.toArray(new ISubsetCriteria[newCriteria.size()])));
    }
}

