/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.client.packaging;

import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.query.IDataQueryPage;
import com.ibm.team.repository.common.query.IDataRow;
import com.ibm.team.repository.common.service.IQueryService;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class QueryResultsIterator
implements Iterator<IDataRow> {
    protected IQueryService queryService;
    protected IDataQueryPage currentPage;
    protected int index = 0;

    public QueryResultsIterator(IQueryService queryService, IDataQueryPage page) {
        this.queryService = queryService;
        this.currentPage = page;
    }

    @Override
    public boolean hasNext() {
        return this.index < this.currentPage.getSize() || this.currentPage.hasNext();
    }

    @Override
    public IDataRow next() {
        try {
            return this.nextThrowingException();
        }
        catch (TeamRepositoryException e) {
            throw new RuntimeException(e);
        }
    }

    public IDataRow nextThrowingException() throws TeamRepositoryException {
        if (this.index < this.currentPage.getSize()) {
            return this.currentPage.getRow(this.index++);
        }
        if (this.currentPage.hasNext()) {
            this.currentPage = (IDataQueryPage)this.queryService.fetchPage(this.currentPage.getToken(), this.currentPage.getNextStartPosition(), 512);
            this.index = 0;
            return this.currentPage.getRow(this.index++);
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

