/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.client.artifact.storage;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.ibm.jzos.ZFile;
import com.ibm.team.enterprise.build.client.artifact.IArtifactStorage;
import com.ibm.team.enterprise.build.client.artifact.IStorageHandle;
import com.ibm.team.enterprise.build.client.artifact.util.ChecksumUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.security.NoSuchAlgorithmException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.FileRequestEntity;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.io.FileUtils;

public class ArtifactoryHttp
implements IArtifactStorage {
    public static final String DEFAULT_TARGET_ENCODING = "ISO8859-1";
    private static final String BASE_URL = "https://na.artifactory.swg-devops.com/artifactory";
    private static final String REPO = "sys-dbb-ewm-ee-generic-local";
    private static final String APIKEY = "cmVmdGtuOjAxOjE3MjQ3MDA2MDY6dVJYdkNsd2xla3U2dUV5TXBTTEEzTDhMTVFI";
    private ZipOutputStream zipOutStream;
    private BufferedOutputStream bos;
    private File tempZipFile;
    private ZipFile cache;
    private static final HttpClient client = new HttpClient();

    public ArtifactoryHttp() {
        this.reset();
    }

    private void reset() {
        if (this.tempZipFile != null) {
            this.tempZipFile.delete();
        }
        try {
            this.tempZipFile = File.createTempFile("temp-", "-zip.zip");
            this.tempZipFile.createNewFile();
            FileOutputStream os = new FileOutputStream(this.tempZipFile);
            this.zipOutStream = new ZipOutputStream((OutputStream)os, Charset.forName("UTF-8"));
            this.bos = new BufferedOutputStream(this.zipOutStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean addZFile(String filepath) {
        try {
            int bytesRead;
            ZFile f = new ZFile(filepath, "r");
            ZipEntry e = new ZipEntry(f.getActualFilename());
            this.zipOutStream.putNextEntry(e);
            BufferedInputStream bis = new BufferedInputStream(f.getInputStream());
            byte[] buf = new byte[65536];
            while ((bytesRead = bis.read(buf)) != -1) {
                this.bos.write(buf, 0, bytesRead);
            }
            this.bos.flush();
            this.zipOutStream.closeEntry();
            bis.close();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean addHfsFile(String filepath) {
        try {
            int nRead;
            File f = new File(filepath);
            if (!f.exists()) {
                throw new IllegalArgumentException("File not found: " + filepath);
            }
            FileInputStream fis = new FileInputStream(f);
            ZipEntry e = new ZipEntry(f.getName());
            this.zipOutStream.putNextEntry(e);
            BufferedInputStream bis = new BufferedInputStream(fis);
            byte[] buf = new byte[65536];
            while ((nRead = bis.read(buf)) >= 0) {
                this.bos.write(buf, 0, nRead);
            }
            this.bos.flush();
            this.zipOutStream.closeEntry();
            fis.close();
            bis.close();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public IStorageHandle store() {
        JsonObject json;
        String dateTime;
        block6: {
            PutMethod put;
            block5: {
                dateTime = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMdd-HHmmssSSS"));
                this.zipOutStream.setComment(dateTime);
                this.zipOutStream.finish();
                this.zipOutStream.close();
                json = null;
                put = new PutMethod("https://na.artifactory.swg-devops.com/artifactory/sys-dbb-ewm-ee-generic-local/zOS-testing/" + dateTime + ".zip");
                put.addRequestHeader("X-JFrog-Art-Api", APIKEY);
                put.addRequestHeader("X-Checksum-Sha1", ChecksumUtils.getChecksum(this.tempZipFile));
                put.setRequestEntity((RequestEntity)new FileRequestEntity(this.tempZipFile, "application/zip"));
                int status = client.executeMethod((HttpMethod)put);
                if (status <= 299) break block5;
                System.out.println("upload failed");
                return null;
            }
            json = new JsonParser().parse(put.getResponseBodyAsString()).getAsJsonObject();
            put.releaseConnection();
            if (json != null) break block6;
            return null;
        }
        try {
            ArtifactoryHandle ret = new ArtifactoryHandle(json.get("path").getAsString(), json.get("name").getAsString(), dateTime);
            this.reset();
            return ret;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public ZFile fetchZFile(IStorageHandle m, String filename, String storePath) {
        GetMethod get;
        block3: {
            ArtifactoryHandle artMem = (ArtifactoryHandle)m;
            get = new GetMethod("https://na.artifactory.swg-devops.com/artifactory/sys-dbb-ewm-ee-generic-local" + artMem.path);
            get.addRequestHeader("X-JFrog-Art-Api", APIKEY);
            try {
                int status = client.executeMethod((HttpMethod)get);
                if (status <= 299) break block3;
                return null;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        System.out.println(new String(get.getResponseBody()));
        ZFile f = new ZFile(storePath, "wt");
        f.write(get.getResponseBody());
        f.flush();
        return f;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public File fetchHfsFile(IStorageHandle m, String filename, String location) {
        ArtifactoryHandle artMem = (ArtifactoryHandle)m;
        try {
            if (this.cache == null || !this.cache.getComment().equals(artMem.buildId)) {
                if (this.cache != null) {
                    this.cache.close();
                }
                File cacheFile = new File(artMem.name);
                cacheFile.createNewFile();
                GetMethod get = new GetMethod("https://na.artifactory.swg-devops.com/artifactory/sys-dbb-ewm-ee-generic-local" + artMem.path);
                get.addRequestHeader("X-JFrog-Art-Api", APIKEY);
                int status = client.executeMethod((HttpMethod)get);
                if (status > 299) {
                    return null;
                }
                FileUtils.copyInputStreamToFile((InputStream)get.getResponseBodyAsStream(), (File)cacheFile);
                this.cache = new ZipFile(cacheFile);
                get.releaseConnection();
            }
            File f = new File(location);
            f.createNewFile();
            FileUtils.copyInputStreamToFile((InputStream)this.cache.getInputStream(this.cache.getEntry(filename)), (File)f);
            return f;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean delete(IStorageHandle m) {
        ArtifactoryHandle artMem = (ArtifactoryHandle)m;
        DeleteMethod del = new DeleteMethod("https://na.artifactory.swg-devops.com/artifactory/sys-dbb-ewm-ee-generic-local" + artMem.path);
        del.addRequestHeader("X-JFrog-Art-Api", APIKEY);
        try {
            int status = client.executeMethod((HttpMethod)del);
            del.releaseConnection();
            return status < 299;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public void close() {
        try {
            this.tempZipFile.delete();
            this.zipOutStream.close();
            this.bos.close();
            if (this.cache != null) {
                this.cache.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public String[] query(String query) {
        System.out.println("hello from ArtifactoryHttp");
        return null;
    }

    private class ArtifactoryHandle
    implements IStorageHandle {
        private final String path;
        private final String name;
        private final String buildId;

        private ArtifactoryHandle(String path, String name, String buildId) {
            this.path = path;
            this.name = name;
            this.buildId = buildId;
        }
    }
}

