/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.client.artifact.storage;

import com.ibm.jzos.ZFile;
import com.ibm.team.enterprise.build.client.artifact.IArtifactStorage;
import com.ibm.team.enterprise.build.client.artifact.IStorageHandle;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.jfrog.artifactory.client.Artifactory;
import org.jfrog.artifactory.client.ArtifactoryClientBuilder;

public class ArtifactoryClient
implements IArtifactStorage {
    private static final String BASE_URL = "https://na.artifactory.swg-devops.com/artifactory";
    private static final String REPO = "sys-dbb-ewm-ee-generic-local";
    private static final String APIKEY = "cmVmdGtuOjAxOjE3MjQ3MDA2MDY6dVJYdkNsd2xla3U2dUV5TXBTTEEzTDhMTVFI";
    private final Artifactory art = ArtifactoryClientBuilder.create().setUrl("https://na.artifactory.swg-devops.com/artifactory").setAccessToken("cmVmdGtuOjAxOjE3MjQ3MDA2MDY6dVJYdkNsd2xla3U2dUV5TXBTTEEzTDhMTVFI").build();
    private ZipOutputStream zipOutStream;
    private BufferedOutputStream bufZip;
    private File tempZipFile;
    private ZipFile cache;
    private File cacheFile;

    public ArtifactoryClient() {
        this.reset();
    }

    private void reset() {
        if (this.tempZipFile != null) {
            this.tempZipFile.delete();
        }
        try {
            if (this.bufZip != null) {
                this.bufZip.close();
            }
            this.tempZipFile = File.createTempFile("temp-", ".zip");
            this.tempZipFile.createNewFile();
            FileOutputStream os = new FileOutputStream(this.tempZipFile);
            this.zipOutStream = new ZipOutputStream((OutputStream)os, StandardCharsets.ISO_8859_1);
            this.bufZip = new BufferedOutputStream(this.zipOutStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean addHfsFile(String filepath) {
        block13: {
            File f = new File(filepath);
            if (!f.exists()) {
                throw new IllegalArgumentException("File not found: " + filepath);
            }
            Throwable throwable = null;
            Object var4_6 = null;
            FileInputStream fis = new FileInputStream(f);
            try {
                ZipEntry e = new ZipEntry(f.getName());
                this.zipOutStream.putNextEntry(e);
                IOUtils.copy((InputStream)fis, (OutputStream)this.bufZip);
                this.bufZip.flush();
                this.zipOutStream.closeEntry();
                if (fis == null) break block13;
            }
            catch (Throwable throwable2) {
                try {
                    try {
                        if (fis != null) {
                            fis.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return false;
                }
            }
            fis.close();
        }
        return true;
    }

    @Override
    public boolean addZFile(String filepath) {
        try {
            ZFile f = new ZFile(filepath, "r");
            ZipEntry e = new ZipEntry(f.getActualFilename());
            this.zipOutStream.putNextEntry(e);
            InputStream is = f.getInputStream();
            IOUtils.copy((InputStream)is, (OutputStream)this.bufZip);
            this.bufZip.flush();
            is.close();
            this.zipOutStream.closeEntry();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public IStorageHandle store() {
        org.jfrog.artifactory.client.model.File ret;
        try {
            String dateTime = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMdd-HHmmssSSS"));
            this.zipOutStream.setComment(dateTime);
            this.zipOutStream.finish();
            ret = this.art.repository(REPO).upload(String.valueOf(dateTime) + ".zip", this.tempZipFile).doUpload();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        this.reset();
        return new ArtifactoryHandle(ret.getPath(), ret.getName(), null);
    }

    @Override
    public File fetchHfsFile(IStorageHandle m, String filename, String storePath) {
        ZipEntry ze;
        File outputFile;
        block4: {
            ArtifactoryHandle artMem = (ArtifactoryHandle)m;
            try {
                outputFile = new File(storePath);
                outputFile.createNewFile();
                if (!this.isCacheValid(artMem)) {
                    this.setupCache(artMem);
                }
                if ((ze = this.cache.getEntry(filename)) != null) break block4;
                return null;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        BufferedInputStream bis = new BufferedInputStream(this.cache.getInputStream(ze));
        FileUtils.copyInputStreamToFile((InputStream)bis, (File)outputFile);
        return outputFile;
    }

    @Override
    public ZFile fetchZFile(IStorageHandle m, String filename, String storePath) {
        ZipEntry ze;
        ZFile outputFile;
        block4: {
            ArtifactoryHandle artMem = (ArtifactoryHandle)m;
            try {
                outputFile = new ZFile(storePath, "w");
                if (!this.isCacheValid(artMem)) {
                    this.setupCache(artMem);
                }
                if ((ze = this.cache.getEntry(filename)) != null) break block4;
                return null;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        InputStream is = this.cache.getInputStream(ze);
        BufferedOutputStream bos = new BufferedOutputStream(outputFile.getOutputStream());
        IOUtils.copy((InputStream)is, (OutputStream)bos);
        is.close();
        bos.close();
        return outputFile;
    }

    @Override
    public boolean delete(IStorageHandle m) {
        ArtifactoryHandle artMem = (ArtifactoryHandle)m;
        return this.art.repository(REPO).delete(artMem.path) == null;
    }

    @Override
    public String[] query(String query) {
        return null;
    }

    @Override
    public void close() {
        this.art.close();
        this.tempZipFile.delete();
        try {
            this.bufZip.close();
            if (this.cache != null) {
                this.cacheFile.delete();
                this.cache.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private boolean isCacheValid(ArtifactoryHandle artMem) {
        return this.cache != null && this.cache.getComment().equals(artMem.buildId);
    }

    private void setupCache(ArtifactoryHandle artMem) {
        try {
            if (this.cache != null) {
                this.cache.close();
            }
            this.cacheFile = File.createTempFile(artMem.buildId, ".zip");
            this.cacheFile.createNewFile();
            InputStream is = this.art.repository(REPO).download(artMem.path).doDownload();
            BufferedInputStream bis = new BufferedInputStream(is);
            FileUtils.copyInputStreamToFile((InputStream)bis, (File)this.cacheFile);
            this.cache = new ZipFile(this.cacheFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private class ArtifactoryHandle
    implements IStorageHandle {
        private final String path;
        private final String name;
        private final String buildId;

        private ArtifactoryHandle(String path, String name, String buildId) {
            this.path = path;
            this.name = name;
            this.buildId = buildId;
        }
    }
}

