<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"  xmlns:buildmap="http://www.ibm.com/team/enterprise/build/buildmap/1.0/" xmlns:inputs="http://www.ibm.com/team/enterprise/build/buildmap/inputs/1.0/" xmlns:outputs="http://www.ibm.com/team/enterprise/build/buildmap/outputs/1.0/" xmlns:parserOutputs="http://www.ibm.com/team/enterprise/build/buildmap/parserOutputs/1.0/" version="1.0">	
	<xsl:template match="/">
		<html>
			<head>
				<meta http-equiv="content-type" content="text/html; charset=UTF-8"/>
				<title>${BUILDMAP_XSL_BUILD_MAP}</title>
			</head>
			<body><xsl:apply-templates/></body>
		</html>
	</xsl:template>
	<xsl:template match="rdf:RDF">
		<xsl:apply-templates/>
	</xsl:template>

	<!--  Build definition UUID -->
	<xsl:template match="buildmap:buildDefinitionUUID"/>

	<!-- Build Section -->
	<xsl:template match="rdf:Description[@rdf:about]">
		<h3>${BUILDMAP_XSL_BUILD}</h3>
		<table border="1" cellspacing="0" width="80%">
		<tr><th width="40%">${BUILDMAP_XSL_ATTRIBUTE}</th>
		<th width="60%">${BUILDMAP_XSL_VALUE}</th></tr>
		<tr><td>${BUILDMAP_XSL_BUILD_LABEL}</td><td><xsl:value-of select="buildmap:buildLabel"/></td></tr>
		<tr><td>${BUILDMAP_XSL_SNAPSHOT_NAME}</td><td><xsl:value-of select="buildmap:snapshot "/></td></tr>
		<xsl:if test="buildmap:promotedSourceBuildMapSlug != ''">
			<tr><td>${BUILDMAP_XSL_PROMOTION_SOURCE_BM_SLUG_NAME}</td><td><xsl:value-of select="buildmap:promotedSourceBuildMapSlug"/></td></tr>
		</xsl:if>
		<xsl:if test="buildmap:resourcePrefix != ''">
			<tr><td>${BUILDMAP_XSL_RESOURCE_PREFIX}</td><td><xsl:value-of select="buildmap:resourcePrefix"/></td></tr>
		</xsl:if>
		<xsl:if test="buildmap:datasetPrefix != ''">
			<tr><td>${BUILDMAP_XSL_DATA_SET_PREFIX}</td><td><xsl:value-of select="buildmap:datasetPrefix"/></td></tr>
		</xsl:if>
		<xsl:if test="buildmap:fetchDestination != ''">
			<tr><td>${BUILDMAP_XSL_LOAD_DIRECTORY}</td><td><xsl:value-of select="buildmap:fetchDestination"/></td></tr>
		</xsl:if>
		<xsl:if test="buildmap:workspaceUUID != ''">
			<tr><td>${BUILDMAP_XSL_WORKSPACE_UUID}</td><td><xsl:value-of select="buildmap:workspaceUUID"/></td></tr>
		</xsl:if>
		<xsl:if test="buildmap:buildableFileUUID != ''">
			<tr><td>${BUILDMAP_XSL_BUILDABLEFILE_UUID}</td><td><xsl:value-of select="buildmap:buildableFileUUID"/></td></tr>
		</xsl:if>
		<xsl:if test="buildmap:buildResultUUID != ''">
			<tr><td>${BUILDMAP_XSL_BUILD_RESULT_UUID}</td><td><xsl:value-of select="buildmap:buildResultUUID"/></td></tr>
		</xsl:if>
		<xsl:if test="buildmap:languageDefinitionName != ''">
			<tr><td>${BUILDMAP_XSL_LANGUAGE_DEFINITION}</td><td><xsl:value-of select="buildmap:languageDefinitionName"/></td></tr>
		</xsl:if>						
		</table>
	</xsl:template>

	<!-- Inputs Section -->
	<xsl:template match="rdf:Description[@rdf:nodeID='inputs']">
		<h3>${BUILDMAP_XSL_INPUTS}</h3>
		<xsl:apply-templates/>
	</xsl:template>
	<xsl:template match="inputs:file">
		<table border="1" cellspacing="0" width="80%">
		<tr><th width="40%">${BUILDMAP_XSL_ATTRIBUTE}</th>
		<th width="60%">${BUILDMAP_XSL_VALUE}</th></tr>
		<xsl:if test="inputs:type != ''">
			<tr><td>${BUILDMAP_XSL_FILE_TYPE}</td><td><xsl:value-of select="inputs:type"/></td></tr>
		</xsl:if>
		<xsl:if test="inputs:buildFile  != ''">
			<tr><td>${BUILDMAP_XSL_BUILD_FILE}</td><td><xsl:value-of select="inputs:buildFile"/></td></tr>
		</xsl:if>
		<xsl:if test="inputs:file  != ''">
			<tr><td>${BUILDMAP_XSL_FILE}</td><td><xsl:value-of select="inputs:file"/></td></tr>
		</xsl:if>
		<xsl:if test="inputs:buildPath != ''">
			<tr><td>${BUILDMAP_XSL_BUILD_PATH}</td><td><xsl:value-of select="inputs:buildPath"/></td></tr>
		</xsl:if>
		<xsl:if test="inputs:resourceDefinitionStateId != ''">
			<tr><td>${BUILDMAP_XSL_FILE_TYPE}</td><td><xsl:value-of select="inputs:resourceDefinitionStateId"/></td></tr>
		</xsl:if>
		<xsl:if test="inputs:inputType != ''">
			<tr><td>${BUILDMAP_XSL_INPUT_TYPE}</td><td><xsl:value-of select="inputs:inputType "/></td></tr>
		</xsl:if>	
		<xsl:if test="inputs:scmLocation  != ''">
			<tr><td>${BUILDMAP_XSL_SCM_LOCATION}</td><td><xsl:value-of select="inputs:scmLocation "/></td></tr>
		</xsl:if>			
		<xsl:if test="inputs:dataSetName  != ''">
			<tr><td>${BUILDMAP_XSL_FILE_LOCATION}</td><td><xsl:value-of select="inputs:dataSetName"/>(<xsl:value-of select="inputs:memberName"/>)</td></tr>
		</xsl:if>	
		<xsl:if test="inputs:resourceDefinitionID  != ''">
			<tr><td>${BUILDMAP_XSL_RESOURCE_DEFINITION_ID}</td><td><xsl:value-of select="inputs:resourceDefinitionID "/></td></tr>
		</xsl:if>	
		<xsl:if test="inputs:resourceDefinitionStateId  != ''">
			<tr><td>${BUILDMAP_XSL_RESOURCE_DEFINITION_STATE_ID}</td><td><xsl:value-of select="inputs:resourceDefinitionStateId "/></td></tr>
		</xsl:if>	
		<xsl:if test="inputs:dataSetDefinitionUUID  != ''">
			<tr><td>${BUILDMAP_XSL_DATASET_DEFINITION_UUID}</td><td><xsl:value-of select="inputs:dataSetDefinitionUUID "/></td></tr>
		</xsl:if>	
		<xsl:if test="inputs:module != ''">
			<tr><td>${BUILDMAP_XSL_MODULE_NAMES}</td><td><xsl:value-of select="inputs:module"/></td></tr>
		</xsl:if>
		<xsl:if test="inputs:serviceProgram != ''">
			<tr><td>${BUILDMAP_XSL_SERVICE_PROGRAM_NAMES}</td><td><xsl:value-of select="inputs:serviceProgram"/></td></tr>
		</xsl:if>
		<xsl:if test="inputs:dataSetDefinitionStateUUID != ''">
			<tr><td>${BUILDMAP_XSL_DATASET_DEFINITION_STATE_UUID}</td><td><xsl:value-of select="inputs:dataSetDefinitionStateUUID "/></td></tr>
		</xsl:if>	
		<xsl:if test="inputs:pathName != ''">
			<tr><td>${BUILDMAP_XSL_PATH_NAME}</td><td><xsl:value-of select="inputs:pathName"/></td></tr>
		</xsl:if>
		<xsl:if test="inputs:componentName != ''">
			<tr><td>${BUILDMAP_XSL_COMPONENT_NAME}</td><td><xsl:value-of select="inputs:componentName"/></td></tr>
		</xsl:if>
		<xsl:if test="inputs:projectName != ''">
			<tr><td>${BUILDMAP_XSL_PROJECT_NAME}</td><td><xsl:value-of select="inputs:projectName"/></td></tr>
		</xsl:if>
		<xsl:if test="inputs:uuid  != ''">
			<tr><td>${BUILDMAP_XSL_UUID}</td><td><xsl:value-of select="inputs:uuid"/></td></tr>
		</xsl:if>
		<xsl:if test="inputs:stateUuid != ''">
			<tr><td>${BUILDMAP_XSL_STATE_UUID}</td><td><xsl:value-of select="inputs:stateUuid"/></td></tr>
		</xsl:if>
		<tr><td>${BUILDMAP_XSL_TIME_STAMP}</td><td>
        	<xsl:value-of select="inputs:timestamp"/>
		</td></tr>
		</table>
	</xsl:template>

	<!-- Outputs Section -->
	<xsl:template match="rdf:Description[@rdf:nodeID='outputs']">
		<h3>${BUILDMAP_XSL_OUTPUTS}</h3>
		<xsl:apply-templates/>
	</xsl:template>
	<xsl:template match="outputs:file">
		<table border="1" cellspacing="0" width="80%">
		<tr><th width="40%">${BUILDMAP_XSL_ATTRIBUTE}</th>
		<th width="60%">${BUILDMAP_XSL_VALUE}</th></tr>
		<xsl:if test="outputs:type != ''">
			<tr><td>${BUILDMAP_XSL_FILE_TYPE}</td><td><xsl:value-of select="outputs:type"/></td></tr>
		</xsl:if>
		<xsl:if test="outputs:outputType != ''">
			<tr><td>${BUILDMAP_XSL_FILE_TYPE}</td><td><xsl:value-of select="outputs:outputType"/></td></tr>
		</xsl:if>
		<xsl:if test="outputs:buildPath != ''">
		<xsl:choose>
			<xsl:when test="outputs:sequential = 'true'">
				<tr><td>${BUILDMAP_XSL_FILE_LOCATION}</td><td><xsl:value-of select="outputs:buildPath  "/>
				<xsl:if test="outputs:buildFile != ''">.</xsl:if>
				<xsl:value-of select="outputs:buildFile "/></td></tr>
			</xsl:when>
			<xsl:otherwise>
				<tr><td>${BUILDMAP_XSL_FILE_LOCATION}</td><td><xsl:value-of select="outputs:buildPath  "/>(<xsl:value-of select="outputs:buildFile "/>)</td></tr>
			</xsl:otherwise>
			</xsl:choose>
			
		</xsl:if>	
		<xsl:if test="outputs:dataSetName  != ''">
			<xsl:choose>
			<xsl:when test="outputs:sequential = 'true'">
				<tr><td>${BUILDMAP_XSL_FILE_LOCATION}</td><td><xsl:value-of select="outputs:dataSetName"/>
				<xsl:if test="outputs:buildFile != ''">.</xsl:if>
				<xsl:value-of select="outputs:memberName"/></td></tr>
			</xsl:when>
			<xsl:otherwise>
				<tr><td>${BUILDMAP_XSL_FILE_LOCATION}</td><td><xsl:value-of select="outputs:dataSetName"/>(<xsl:value-of select="outputs:memberName"/>)</td></tr>
			</xsl:otherwise>
			</xsl:choose>
			
		</xsl:if>	
		<xsl:if test="outputs:pathName != ''">
		<tr><td>${BUILDMAP_XSL_FILE_LOCATION}</td><td><xsl:value-of select="outputs:pathName  "/>(<xsl:value-of select="outputs:file "/>)</td></tr>
		</xsl:if>
		<xsl:if test="outputs:componentName != ''">
			<tr><td>${BUILDMAP_XSL_COMPONENT_NAME}</td><td><xsl:value-of select="outputs:componentName"/></td></tr>
		</xsl:if>
		<xsl:if test="outputs:projectName != ''">
			<tr><td>${BUILDMAP_XSL_PROJECT_NAME}</td><td><xsl:value-of select="outputs:projectName"/></td></tr>
		</xsl:if>
		<xsl:if test="outputs:module != ''">
			<tr><td>${BUILDMAP_XSL_MODULE_NAMES}</td><td><xsl:value-of select="outputs:module"/></td></tr>
		</xsl:if>
		<xsl:if test="outputs:serviceProgram != ''">
			<tr><td>${BUILDMAP_XSL_SERVICE_PROGRAM_NAMES}</td><td><xsl:value-of select="outputs:serviceProgram"/></td></tr>
		</xsl:if>
		<xsl:if test="outputs:uuid  != ''">
			<tr><td>${BUILDMAP_XSL_UUID}</td><td><xsl:value-of select="outputs:uuid"/></td></tr>
		</xsl:if>
		<xsl:if test="outputs:stateUuid != ''">
			<tr><td>${BUILDMAP_XSL_STATE_UUID}</td><td><xsl:value-of select="outputs:stateUuid"/></td></tr>
		</xsl:if>
		<xsl:if test="outputs:resourceDefinitionID  != ''">
			<tr><td>${BUILDMAP_XSL_RESOURCE_DEFINITION_ID}</td><td><xsl:value-of select="outputs:resourceDefinitionID "/></td></tr>
		</xsl:if>	
		<xsl:if test="outputs:resourceDefinitionStateId  != ''">
			<tr><td>${BUILDMAP_XSL_RESOURCE_DEFINITION_STATE_ID}</td><td><xsl:value-of select="outputs:resourceDefinitionStateId "/></td></tr>
		</xsl:if>	
		<xsl:if test="outputs:dataSetDefinitionUUID  != ''">
			<tr><td>${BUILDMAP_XSL_DATASET_DEFINITION_UUID}</td><td><xsl:value-of select="outputs:dataSetDefinitionUUID "/></td></tr>
		</xsl:if>	
		<xsl:if test="outputs:dataSetDefinitionStateUUID != ''">
			<tr><td>${BUILDMAP_XSL_DATASET_DEFINITION_STATE_UUID}</td><td><xsl:value-of select="outputs:dataSetDefinitionStateUUID "/></td></tr>
		</xsl:if>	
		<tr><td>${BUILDMAP_XSL_TIME_STAMP}</td><td>
        	<xsl:value-of select="outputs:timestamp"/>
		</td></tr>
		<xsl:if test="outputs:deployType  != ''">
		<tr><td>${BUILDMAP_XSL_DEPLOY_TYPE}</td><td>
        	<xsl:value-of select="outputs:deployType"/>
		</td></tr>
		</xsl:if>	
		</table>
	</xsl:template>

	<!-- ParserOutputs Section -->
	<xsl:template match="rdf:Description[@rdf:nodeID='parserOutputs']">
		<h3>${BUILDMAP_XSL_GENERATED_SOURCES}</h3>
		<xsl:apply-templates/>
	</xsl:template>
	<xsl:template match="parserOutputs:file">
		<table border="1" cellspacing="0" width="80%">
		<tr><th width="40%">${BUILDMAP_XSL_ATTRIBUTE}</th>
		<th width="60%">${BUILDMAP_XSL_VALUE}</th></tr>
		<xsl:if test="parserOutputs:type != ''">
			<tr><td>${BUILDMAP_XSL_FILE_TYPE}</td><td><xsl:value-of select="parserOutputs:type"/></td></tr>
		</xsl:if>
		<xsl:if test="parserOutputs:buildPath != ''">
		<tr><td>${BUILDMAP_XSL_FILE_LOCATION}</td><td><xsl:value-of select="parserOutputs:buildPath"/>(<xsl:value-of select="parserOutputs:buildFile "/>)</td></tr>
		</xsl:if>
		<xsl:if test="parserOutputs:pathName != ''">
		<tr><td>${BUILDMAP_XSL_FILE_LOCATION}</td><td><xsl:value-of select="parserOutputs:pathName"/>(<xsl:value-of select="parserOutputs:file "/>)</td></tr>
		</xsl:if>
		<xsl:if test="parserOutputs:module != ''">
			<tr><td>${BUILDMAP_XSL_MODULE_NAMES}</td><td><xsl:value-of select="parserOutputs:module"/></td></tr>
		</xsl:if>
		<xsl:if test="parserOutputs:serviceProgram != ''">
			<tr><td>${BUILDMAP_XSL_SERVICE_PROGRAM_NAMES}</td><td><xsl:value-of select="parserOutputs:serviceProgram"/></td></tr>
		</xsl:if>
		<xsl:if test="parserOutputs:resourceName != ''">
			<tr><td>${BUILDMAP_XSL_COMPONENT_NAME}</td><td><xsl:value-of select="parserOutputs:resourceName"/></td></tr>
		</xsl:if>
		<xsl:if test="parserOutputs:componentName != ''">
			<tr><td>${BUILDMAP_XSL_COMPONENT_NAME}</td><td><xsl:value-of select="parserOutputs:componentName"/></td></tr>
		</xsl:if>
		<xsl:if test="parserOutputs:projectName != ''">
			<tr><td>${BUILDMAP_XSL_PROJECT_NAME}</td><td><xsl:value-of select="parserOutputs:projectName"/></td></tr>
		</xsl:if>
		<xsl:if test="parserOutputs:dataSetName  != ''">
			<tr><td>${BUILDMAP_XSL_FILE_LOCATION}</td><td><xsl:value-of select="parserOutputs:dataSetName"/>(<xsl:value-of select="parserOutputs:memberName"/>)</td></tr>
		</xsl:if>	
		<xsl:if test="parserOutputs:uuid  != ''">
			<tr><td>${BUILDMAP_XSL_UUID}</td><td><xsl:value-of select="parserOutputs:uuid"/></td></tr>
		</xsl:if>
		<xsl:if test="parserOutputs:stateUuid != ''">
			<tr><td>${BUILDMAP_XSL_STATE_UUID}</td><td><xsl:value-of select="parserOutputs:stateUuid"/></td></tr>
		</xsl:if>
		<xsl:if test="parserOutputs:resourceDefinitionID  != ''">
			<tr><td>${BUILDMAP_XSL_RESOURCE_DEFINITION_ID}</td><td><xsl:value-of select="parserOutputs:resourceDefinitionID "/></td></tr>
		</xsl:if>	
		<xsl:if test="parserOutputs:resourceDefinitionStateId  != ''">
			<tr><td>${BUILDMAP_XSL_RESOURCE_DEFINITION_STATE_ID}</td><td><xsl:value-of select="parserOutputs:resourceDefinitionStateId "/></td></tr>
		</xsl:if>	
		<xsl:if test="parserOutputs:dataSetDefinitionUUID  != ''">
			<tr><td>${BUILDMAP_XSL_DATASET_DEFINITION_UUID}</td><td><xsl:value-of select="parserOutputs:dataSetDefinitionUUID "/></td></tr>
		</xsl:if>	
		<xsl:if test="parserOutputs:dataSetDefinitionStateUUID != ''">
			<tr><td>${BUILDMAP_XSL_DATASET_DEFINITION_STATE_UUID}</td><td><xsl:value-of select="parserOutputs:dataSetDefinitionStateUUID "/></td></tr>
		</xsl:if>	
		<tr><td>${BUILDMAP_XSL_TIME_STAMP}</td><td>
        	<xsl:value-of select="parserOutputs:timestamp"/>
		</td></tr>
		</table>
	</xsl:template>


</xsl:stylesheet>
