<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet 
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
    xmlns:bf="http://www.ibm.com/team/enterprise/build/buildablefiles/1.0/" 
    xmlns:buildmap="http://www.ibm.com/team/enterprise/build/buildmap/1.0/" 
    xmlns:ds="http://www.ibm.com/team/enterprise/build/dependencyset/1.0/" 
    xmlns:inputs="http://www.ibm.com/team/enterprise/build/buildmap/inputs/1.0/" 
    xmlns:outputs="http://www.ibm.com/team/enterprise/build/buildmap/outputs/1.0/" 
    xmlns:parserOutputs="http://www.ibm.com/team/enterprise/build/buildmap/parserOutputs/1.0/"
	version="1.0">

	<xsl:template match="/">
		<html>
			<head>
					<meta http-equiv="content-type" content="text/html; charset=UTF-8" />
					<title>${BUILDABLEFILES_REPORT_TITLE}</title>
					<style type="text/css">
.titlebox {color:#FFFFFF;padding:3px;font:13px Arial,Helvetica,sans-serif; background-color:#888888;margin:0px;}
.normalrow {padding:3px;font:13px Arial, Helvetica, sans-serif;margin:0px;}
.oddrow {padding:3px;font:11px Arial, Helvetica, sans-serif;background-color:#eeeeee;margin:0px;}
.evenrow {padding:3px;font:11px Arial, Helvetica, sans-serif;background-color:#dddddd;margin:0px;}
.linkrow {padding:3px;font:11px Arial, Helvetica, sans-serif;margin:0px;}
.titlebox_blue {color:#FFFFFF;padding:3px;font:13px Arial,Helvetica,sans-serif; background-color:#000088;margin:0px;}
.oddrow_blue {padding:3px;font:11px Arial, Helvetica, sans-serif;background-color:#d5d5e5;margin:0px;}
.evenrow_blue {padding:3px;font:11px Arial, Helvetica, sans-serif;background-color:#b6b6d7;margin:0px;}
.notes {padding:3px;font:13px Arial, Helvetica, sans-serif;margin:0px;}
table { empty-cells: show }
img {border: 0px;}
a {text-decoration: none;}
		    	</style>
		    	<script type="text/javascript"><![CDATA[
		    		hrefs = new Array();
		    		function getHref(id) { return hrefs[id]; }
		    		function getIEVersion() {
		    			var version = 99999;
		    			if (navigator.appVersion.indexOf("MSIE") != -1) {
		    				version = parseFloat(navigator.appVersion.split("MSIE")[1]);
		    			}
		    			return version;
		    		}
		    		function showDependencies(id, up, dn) {
		    			var rowStyle = (getIEVersion() > 7 ? 'table-row' : 'block');
						hidden = document.getElementById(id).style.display == 'none';
						if (hidden) {
							document.getElementById(id).style.display = rowStyle;
							document.getElementById(up).style.display = rowStyle;
							document.getElementById(dn).style.display = 'none';
						} else {
							document.getElementById(id).style.display = 'none';
							document.getElementById(up).style.display = 'none';
							document.getElementById(dn).style.display = rowStyle;
						}
					} 
		    	]]></script>
			</head>
			<body><xsl:apply-templates/></body>
		</html>
	</xsl:template>
	<xsl:template match="bf:buildable">
		<xsl:variable name="reportType"><xsl:value-of select="@bf:report" /></xsl:variable>
		<div class="notes">
	    ${BUILDABLEFILES_REPORT_DESCRIPTION}
	    <xsl:choose>
				<xsl:when test="$reportType = 'buildReport'">
					<p>${BUILDABLEFILES_REPORT_Open_a_build_map}</p>
				</xsl:when>
				<xsl:otherwise>
					<p>${BUILDABLEFILES_REPORT_Click_on_a_member}</p>
				</xsl:otherwise>
		</xsl:choose>
	    </div>
		<table border="1" cellspacing="0" width="100%">
		<xsl:apply-templates/>
		</table>
<br/>		
<table class="normalrow" border="0" cellpadding="2" cellspacing="2"><tbody>
<tr><td width="40px" ></td><th align="left">${BUILDABLEFILES_REPORT_Reason}</th><th align="left">${BUILDABLEFILES_REPORT_Description}</th></tr>
<tr><td></td><td align="center">-1</td><td>${BUILDABLEFILES_REPORT_ReasonMinus1Description}</td></tr>
<tr><td></td><td align="center">0</td><td>${BUILDABLEFILES_REPORT_Reason0Description}</td></tr>
<tr><td></td><td align="center">1</td><td >${BUILDABLEFILES_REPORT_Reason1Description}</td></tr>
<tr><td></td><td align="center">2</td><td >${BUILDABLEFILES_REPORT_Reason2Description}</td></tr>
<tr><td></td><td align="center">3</td><td >${BUILDABLEFILES_REPORT_Reason3Description}</td></tr>
<tr><td></td><td align="center">4</td><td >${BUILDABLEFILES_REPORT_Reason4Description}</td></tr>
<tr><td></td><td align="center">5</td><td >${BUILDABLEFILES_REPORT_Reason5Description}</td></tr>
<tr><td></td><td align="center">6</td><td >${BUILDABLEFILES_REPORT_Reason6Description}</td></tr>
</tbody></table>

	</xsl:template>


	<!-- -->
	<xsl:template name="handleComponent" match="bf:component">
		<xsl:variable name="reportType"><xsl:value-of select="../@bf:report" /></xsl:variable>
		
		<xsl:variable name="componentNameColumnSpan">
			<xsl:choose>
			    <xsl:when test="$reportType = 'buildReport'">7</xsl:when>
			    <xsl:otherwise>8</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<tr class="titlebox">
			<th align="left" colspan="{$componentNameColumnSpan}">${BUILDABLEFILES_REPORT_ComponentName} <xsl:value-of select="@bf:name" /></th>
		</tr>
		<tr class="titlebox">
			<xsl:choose>
				<xsl:when test="$reportType = 'buildReport'">
					<th width="20%">${BUILDABLEFILES_REPORT_Project}</th>
					<th width="20%">${BUILDABLEFILES_REPORT_Source_Member}</th>
					<th width="10%">${BUILDABLEFILES_REPORT_Reason_to_build}</th>
					<th width="5%">${BUILDABLEFILES_REPORT_Code}</th>
					<th width="15%">${BUILDABLEFILES_REPORT_Language_Definition}</th>
					<th width="20%">${BUILDABLEFILES_REPORT_Output_Member}</th>
					<th width="10%">${BUILDABLEFILES_REPORT_Return_Code}</th>					
				</xsl:when>
				<xsl:otherwise>
					<th width="20%">${BUILDABLEFILES_REPORT_Project}</th>
					<th width="20%">${BUILDABLEFILES_REPORT_Source_Member}</th>
					<th width="10%">${BUILDABLEFILES_REPORT_Input_Type}</th>
					<th width="10%">${BUILDABLEFILES_REPORT_Output_Type}</th>
					<th width="5%">${BUILDABLEFILES_REPORT_Reason_to_build}</th>
					<th width="5%">${BUILDABLEFILES_REPORT_Code}</th>
					<th width="20%">${BUILDABLEFILES_REPORT_Language_Definition}</th>
					<th width="10%">${BUILDABLEFILES_REPORT_Output_Member}</th>
				</xsl:otherwise>
			</xsl:choose>
		</tr>
		<xsl:for-each select="bf:project">
			<xsl:variable name="commonProject"><xsl:value-of select="@bf:name" /></xsl:variable>
			<xsl:for-each select="bf:file">
			    <xsl:if test="@bf:reason != '0'">
				<xsl:variable name="sourceMember"><xsl:value-of select="@bf:buildPath" />(<xsl:value-of select="@bf:buildFile" />)

</xsl:variable>
				<xsl:variable name="languageDefinition"><xsl:value-of select="@bf:langDefName" /></xsl:variable>
				<xsl:variable name="languageCode"><xsl:value-of select="@bf:languageCode" /></xsl:variable>
				<xsl:variable name="reason"><xsl:value-of select="@bf:reason" /></xsl:variable>
				<xsl:variable name="prevBuildMap"><xsl:value-of select="@bf:prevBuildMap" /></xsl:variable>
				<xsl:variable name="uuid"><xsl:value-of select="@bf:uuid" /></xsl:variable>
				<xsl:variable name="dependencies_id">dependency_set_table_<xsl:value-of select="$sourceMember" /></xsl:variable>
				<xsl:variable name="up_icon_id">up_icon_<xsl:value-of select="$sourceMember" /></xsl:variable>
				<xsl:variable name="dn_icon_id">dn_icon_<xsl:value-of select="$sourceMember" /></xsl:variable>
				<xsl:variable name="maxRC"><xsl:value-of select="@bf:maxRc" /></xsl:variable>
				<xsl:variable name="buildMap"><xsl:value-of select="@bf:buildMap" /></xsl:variable>
				<xsl:variable name="inputType"><xsl:value-of select="@bf:inputType" /></xsl:variable>
				<xsl:variable name="srcLibrary"><xsl:value-of select="@bf:srcLib" /></xsl:variable>
				
				<xsl:for-each select="bf:prevBuildMap">
				<script type="text/javascript"><![CDATA[
					hrefs["]]><xsl:value-of select="$uuid" /><![CDATA["]="]]><xsl:value-of select="@href" /><![CDATA[";
				]]></script>
				</xsl:for-each>
				
				<xsl:if test="bf:outputs">
				<xsl:for-each select="bf:outputs">
					<xsl:for-each select="outputs:file">
						<tr class="oddrow">
						<td> <xsl:value-of select="$commonProject" /> </td>
						<xsl:choose>
						<xsl:when test="$reason = 6">
							<td ><xsl:value-of select="$sourceMember" /></td>
						</xsl:when>
						<xsl:when test="$reportType = ''">
							<td onmouseout="this.style.cursor='default';" onmouseover="this.style.cursor='pointer';" onclick="showDependencies('{$dependencies_id}', '{$up_icon_id}', '{$dn_icon_id}');"><a href="#">
							<table border="0" cellpadding="0" cellspacing="0" width="95%" >
							<tr class="linkrow">
							<td align="left"><xsl:value-of select="$sourceMember" /></td>
							<td align="right"><img id="{$dn_icon_id}" src="chevron_dn.gif"/><img id="{$up_icon_id}" style="display:none" src="chevron_up.gif"/></td>
							</tr>
							</table>
							</a></td>
						</xsl:when>
						<xsl:otherwise>
							<td ><xsl:value-of select="$sourceMember" /></td>
						</xsl:otherwise>
						</xsl:choose>
 			    		<xsl:if test="not($reportType = 'buildReport')">
							<xsl:choose>
							<xsl:when test="not($srcLibrary = '')">
						   		<td align="center"><xsl:value-of select="$inputType"/></td>
						   		<xsl:variable name="outputType"><xsl:value-of select="outputs:outputType" /></xsl:variable>
						   		<td align="center"><xsl:value-of select="$outputType"/></td>
							</xsl:when>
							<xsl:otherwise>
								<td align="center">-</td>
								<td align="center">-</td>
							</xsl:otherwise>
							</xsl:choose>
						</xsl:if>
						<td align="center"><xsl:value-of select="$reason"/></td>
						<td align="center"><xsl:value-of select="$languageCode" /></td>
						<td><xsl:value-of select="$languageDefinition" /></td>
						<xsl:choose>
						<xsl:when test="$prevBuildMap = 'true'">
							<td onmouseout="this.style.cursor='default';" onmouseover="this.style.cursor='pointer';" ><a href="#">
							<xsl:attribute name="onClick">window.location.href = "open://./enterprise_buildmap/" + getHref('<xsl:value-of select="$uuid" />');</xsl:attribute>
							<table border="0" cellpadding="0" cellspacing="0" width="97%" >
							<tr class="linkrow">
							<xsl:choose>
							<xsl:when test="outputs:sequential = 'true'">
							<td align="left"><xsl:value-of select="outputs:buildPath" />
							<xsl:if test="outputs:buildFile != ''">.</xsl:if>
							<xsl:value-of select="outputs:buildFile" /></td>
							</xsl:when>
							<xsl:otherwise>
							<td align="left"><xsl:value-of select="outputs:buildPath" />(<xsl:value-of select="outputs:buildFile" />)</td>
							</xsl:otherwise>
							</xsl:choose>
							
							
							<td align="right"><img src="externalLink.gif"/></td>
							</tr>
							</table>							
							</a></td>
						</xsl:when>
						<xsl:when test="not($buildMap = '')">
							<td onmouseout="this.style.cursor='default';" onmouseover="this.style.cursor='pointer';" ><a href="#">
							<xsl:attribute name="onClick">window.location.href = "open://./enterprise_buildmap/<xsl:value-of select="$buildMap" />"</xsl:attribute>
							<table border="0" cellpadding="0" cellspacing="0" width="97%" >
							<tr class="linkrow">
							
							<xsl:choose>
							<xsl:when test="outputs:sequential = 'true'">
							<td align="left"><xsl:value-of select="outputs:buildPath" />
							<xsl:if test="outputs:buildFile != ''">.</xsl:if>
							<xsl:value-of select="outputs:buildFile" /></td>
							</xsl:when>
							<xsl:otherwise>
							<td align="left"><xsl:value-of select="outputs:buildPath" />(<xsl:value-of select="outputs:buildFile" />)</td>
							</xsl:otherwise>
							</xsl:choose>
							<td align="right"><img src="externalLink.gif"/></td>
							</tr>
							</table>
							</a></td>
						</xsl:when>
						<xsl:otherwise>
							<xsl:choose>
							<xsl:when test="outputs:sequential = 'true'">
							<td align="left"><xsl:value-of select="outputs:buildPath" />
							<xsl:if test="outputs:buildFile != ''">.</xsl:if>
							<xsl:value-of select="outputs:buildFile" /></td>
							</xsl:when>
							<xsl:otherwise>
							<td ><xsl:value-of select="outputs:buildPath" />(<xsl:value-of select="outputs:buildFile" />)</td>
							</xsl:otherwise>
							</xsl:choose>					
							
						</xsl:otherwise>
						</xsl:choose>
						<xsl:choose>
							<xsl:when test="$reportType = 'buildReport'">
							<xsl:choose>
						         <xsl:when test="$maxRC = ''">
							         <td align="center">N/A</td>
						         </xsl:when>
						         <xsl:otherwise>
							         <td align="center"><xsl:value-of select="$maxRC" /></td>
						         </xsl:otherwise>
						    </xsl:choose>	
							</xsl:when>
						</xsl:choose>
						</tr>
					</xsl:for-each>
				</xsl:for-each>
				</xsl:if>
				<xsl:if test="not(bf:outputs) and not($buildMap = '')">
				   <tr class="oddrow">
						<td> <xsl:value-of select="$commonProject" /> </td>
						<td ><xsl:value-of select="$sourceMember" /></td>
						<td align="center"><xsl:value-of select="$reason"/></td>
						<td align="center"><xsl:value-of select="$languageCode" /></td>
						<td><xsl:value-of select="$languageDefinition" /></td>
						<xsl:choose>
						<xsl:when test="$prevBuildMap = 'true'">
							<td align="center" onmouseout="this.style.cursor='default';" onmouseover="this.style.cursor='pointer';" ><a href="#">
							<xsl:attribute name="onClick">window.location.href = getHref('<xsl:value-of select="$uuid" />');</xsl:attribute>
							<img src="externalLink.gif"/>							
							</a></td>
						</xsl:when>
						<xsl:when test="not($buildMap = '')">
							<td align="center" onmouseout="this.style.cursor='default';" onmouseover="this.style.cursor='pointer';" ><a href="#">
							<xsl:attribute name="onClick">window.location.href = "open://./enterprise_buildmap/<xsl:value-of select="$buildMap" />"</xsl:attribute>
							<img src="externalLink.gif"/>							
							</a></td>
						</xsl:when>
						<xsl:otherwise>
							<td></td>
						</xsl:otherwise>
						</xsl:choose>
						<td></td>
			       </tr>			
				</xsl:if>
				
				<xsl:for-each select="ds:dependency-set">
					<tr id="{$dependencies_id}" colspan="{$componentNameColumnSpan}" style="display:none;"><td colspan="{$componentNameColumnSpan}">
					<table  border="1" cellspacing="0"  width="100%">
					<tr class="titlebox_blue">
						<th width="25%">${BUILDABLEFILES_REPORT_Dependency_Resource}</th>
						<th width="20%">${BUILDABLEFILES_REPORT_Project}</th>
						<th width="30%">${BUILDABLEFILES_REPORT_Path}</th>
						<th width="10%">${BUILDABLEFILES_REPORT_Type}</th>
						<th width="15%">${BUILDABLEFILES_REPORT_Timestamp}</th>
					</tr>
					<xsl:for-each select="inputs:file">
						<xsl:if test="inputs:timestamp != ''">
							<xsl:variable name="projectName"><xsl:value-of select="inputs:projectName" /></xsl:variable>
							<xsl:variable name="pathName"><xsl:value-of select="inputs:scmLocation" /></xsl:variable>
							<tr class="oddrow_blue">
							<td><xsl:value-of select="inputs:buildPath" />(<xsl:value-of select="inputs:buildFile" />) </td>
							<xsl:choose>
							<xsl:when test="$projectName = ''">
								<td>&#160;</td>
							</xsl:when>
							<xsl:otherwise>
								<td><xsl:value-of select="$projectName" /></td>
							</xsl:otherwise>
							</xsl:choose>
							<xsl:choose>
							<xsl:when test="$pathName = ''">
								<td>&#160;</td>
							</xsl:when>
							<xsl:otherwise>
								<td><xsl:value-of select="$pathName" /></td>
							</xsl:otherwise>
							</xsl:choose>
							<td align="center"><xsl:value-of select="inputs:type" /></td>
							<td align="center"><xsl:value-of select="inputs:timestamp"/></td>
							</tr>
						</xsl:if>
					</xsl:for-each>
					</table>
					</td></tr>
				</xsl:for-each>
			    </xsl:if>
			</xsl:for-each>
		</xsl:for-each>
	</xsl:template>  

</xsl:stylesheet>
