<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet 
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
    xmlns:bf="http://www.ibm.com/team/enterprise/build/buildablefiles/1.0/" 
    xmlns:buildmap="http://www.ibm.com/team/enterprise/build/buildmap/1.0/" 
    xmlns:ds="http://www.ibm.com/team/enterprise/build/dependencyset/1.0/" 
    xmlns:inputs="http://www.ibm.com/team/enterprise/build/buildmap/inputs/1.0/" 
    xmlns:outputs="http://www.ibm.com/team/enterprise/build/buildmap/outputs/1.0/" 
    xmlns:parserOutputs="http://www.ibm.com/team/enterprise/build/buildmap/parserOutputs/1.0/"
	xmlns:bc="http://www.ibm.com/team/enterprise/build/buildcomponents/1.0/"
	version="1.0">

	<xsl:template match="/">
		<html>
			<head>
					<meta http-equiv="content-type" content="text/html; charset=UTF-8" />
					<title>${BUILDABLEFILES_COMPONENTS_REPORT_TITLE}</title>
					<style type="text/css">
.titlebox {color:#FFFFFF;padding:3px;font:13px Arial,Helvetica,sans-serif; background-color:#888888;margin:0px;}
.normalrow {padding:3px;font:13px Arial, Helvetica, sans-serif;margin:0px;}
.oddrow {padding:3px;font:11px Arial, Helvetica, sans-serif;background-color:#eeeeee;margin:0px;}
.evenrow {padding:3px;font:11px Arial, Helvetica, sans-serif;background-color:#dddddd;margin:0px;}
.linkrow {padding:3px;font:11px Arial, Helvetica, sans-serif;margin:0px;}
.titlebox_blue {color:#FFFFFF;padding:3px;font:13px Arial,Helvetica,sans-serif; background-color:#000088;margin:0px;}
.oddrow_blue {padding:3px;font:11px Arial, Helvetica, sans-serif;background-color:#d5d5e5;margin:0px;}
.evenrow_blue {padding:3px;font:11px Arial, Helvetica, sans-serif;background-color:#b6b6d7;margin:0px;}
.notes {padding:3px;font:13px Arial, Helvetica, sans-serif;margin:0px;}
table { empty-cells: show }
		    	</style>
		    	<script type="text/javascript"><![CDATA[
		    		hrefs = new Array();
		    		function getHref(id) { return hrefs[id]; }
		    		function getIEVersion() {
		    			var version = 99999;
		    			if (navigator.appVersion.indexOf("MSIE") != -1) {
		    				version = parseFloat(navigator.appVersion.split("MSIE")[1]);
		    			}
		    			return version;
		    		}
		    		function showDependencies(id, up, dn) {
		    			var rowStyle = (getIEVersion() > 7 ? 'table-row' : 'block');
						hidden = document.getElementById(id).style.display == 'none';
						if (hidden) {
							document.getElementById(id).style.display = rowStyle;
							document.getElementById(up).style.display = rowStyle;
							document.getElementById(dn).style.display = 'none';
						} else {
							document.getElementById(id).style.display = 'none';
							document.getElementById(up).style.display = 'none';
							document.getElementById(dn).style.display = rowStyle;
						}
					} 
		    	]]></script>
			</head>
			<body><xsl:apply-templates/></body>
		</html>
	</xsl:template>


	<xsl:template match="bc:languageDefinitions">
		<table  border="1" cellspacing="0"  width="100%">
		<tr class="titlebox_blue">
			<th width="100%">${BUILDCOMPONENTS_Language_Definition}</th>
			<th width="10%"></th>
		</tr>
		<xsl:for-each select="bc:languageDefinition">
			<xsl:sort select="@bc:name"/>
			<tr class="oddrow"> 
			<td onmouseout="this.style.cursor='default';" onmouseover="this.style.cursor='pointer';" >
			<xsl:attribute name="onClick">window.location.href = "open://./systemdefinitions?uuid=<xsl:value-of select="@bc:itemid"/>&amp;stateid=<xsl:value-of select="@bc:stateid"/>&amp;type=languageDefinition"</xsl:attribute>
			<xsl:value-of select="@bc:name"/><img src="externalLink.gif"/>							
			</td>
			</tr>
		</xsl:for-each>
		</table>
	</xsl:template>
	

	<xsl:template match="bc:translators">
		<table  border="1" cellspacing="0"  width="100%">
		<tr class="titlebox_blue">
			<th width="100%">${BUILDCOMPONENTS_Translator}</th>
		</tr>
		<xsl:for-each select="bc:translator">
			<xsl:sort select="@bc:name"/>
			<tr class="oddrow"> 
			<td onmouseout="this.style.cursor='default';" onmouseover="this.style.cursor='pointer';" >
			<xsl:attribute name="onClick">window.location.href = "open://./systemdefinitions?uuid=<xsl:value-of select="@bc:itemid"/>&amp;stateid=<xsl:value-of select="@bc:stateid"/>&amp;type=translator"</xsl:attribute>
			<xsl:value-of select="@bc:name"/><img src="externalLink.gif"/>							
			</td>
			</tr>
		</xsl:for-each>
		</table>
	</xsl:template>
	
	
	<xsl:template match="bc:resourceDefinitions">
		<table  border="1" cellspacing="0"  width="100%">
		<tr class="titlebox_blue">
			<th width="100%">${BUILDCOMPONENTS_Resource_Definition}</th>
		</tr>
		<xsl:for-each select="bc:resourceDefinition">
			<xsl:sort select="@bc:name"/>
			<tr class="oddrow"> 
			<td onmouseout="this.style.cursor='default';" onmouseover="this.style.cursor='pointer';" >
			<xsl:attribute name="onClick">window.location.href = "open://./systemdefinitions?uuid=<xsl:value-of select="@bc:itemid"/>&amp;stateid=<xsl:value-of select="@bc:stateid"/>&amp;type=resourceDefinition"</xsl:attribute>
			<xsl:value-of select="@bc:name"/><img src="externalLink.gif"/>							
			</td>
			</tr>
		</xsl:for-each>
		</table>
	</xsl:template>

	
	<xsl:template match="bc:searchPathDefinitions">
		<table  border="1" cellspacing="0"  width="100%">
		<tr class="titlebox_blue">
			<th width="100%">${BUILDCOMPONENTS_SearchPath_Definition}</th>
		</tr>
		<xsl:for-each select="bc:searchPathDefinition">
			<xsl:sort select="@bc:name"/>
			<tr class="oddrow"> 
			<td onmouseout="this.style.cursor='default';" onmouseover="this.style.cursor='pointer';" >
			<xsl:attribute name="onClick">window.location.href = "open://./systemdefinitions?uuid=<xsl:value-of select="@bc:itemid"/>&amp;stateid=<xsl:value-of select="@bc:stateid"/>&amp;type=searchPathDefinition"</xsl:attribute>
			<xsl:value-of select="@bc:name"/><img src="externalLink.gif"/>							
			</td>
			</tr>
		</xsl:for-each>
		</table>
	</xsl:template>
	
	<xsl:template match="bc:excludedComponents">
		<table  border="1" cellspacing="0"  width="100%">
		<tr class="titlebox_blue">
			<th width="100%">${BUILDCOMPONENTS_ExcludedComponents}</th>
		</tr>
		<xsl:for-each select="bc:excludedComponent">
			<xsl:sort select="@bc:name"/>
			<tr> 
			<td><xsl:value-of select="@bc:name"/></td>
			</tr>
		</xsl:for-each>
		</table>
	</xsl:template>
	
</xsl:stylesheet>

