/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.buildmap.common.util;

import com.ibm.team.enterprise.internal.buildmap.common.IBuild;
import com.ibm.team.enterprise.internal.buildmap.common.IBuildArtifact;
import com.ibm.team.enterprise.internal.buildmap.common.IBuildFile;
import com.ibm.team.enterprise.internal.buildmap.common.IBuildMap;
import com.ibm.team.enterprise.internal.buildmap.common.IInput;
import com.ibm.team.enterprise.internal.buildmap.common.IOutput;
import com.ibm.team.enterprise.internal.buildmap.common.impl.BuildFile;
import com.ibm.team.enterprise.internal.buildmap.common.impl.BuildMap;
import com.ibm.team.enterprise.internal.buildmap.common.impl.Input;
import com.ibm.team.enterprise.internal.buildmap.common.impl.Output;
import com.ibm.team.enterprise.internal.buildmap.common.util.BuildFileComparator;
import com.ibm.team.enterprise.internal.buildmap.common.util.BuildMapConversionUtil;
import com.ibm.team.enterprise.internal.buildmap.common.util.Namespace;
import com.ibm.team.enterprise.internal.buildmap.common.util.TagWithNS;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.xml.sax.SAXException;

public final class BuildMapUtil {
    public static final Namespace BUILDMAP_NAMESPACE = new Namespace("http://www.ibm.com/team/enterprise/build/buildmap/1.0/", "buildmap");
    public static final Namespace INPUTS_NAMESPACE = new Namespace("http://www.ibm.com/team/enterprise/build/buildmap/inputs/1.0/", "inputs");
    public static final Namespace OUTPUTS_NAMESPACE = new Namespace("http://www.ibm.com/team/enterprise/build/buildmap/outputs/1.0/", "outputs");
    public static final Namespace PARSER_OUTPUTS_NAMESPACE = new Namespace("http://www.ibm.com/team/enterprise/build/buildmap/parserOutputs/1.0/", "parserOutputs");
    public static final Namespace BUILD_LOGS_NAMESPACE = new Namespace("http://www.ibm.com/team/enterprise/build/buildmap/buildLogs/1.0/", "buildLogs");
    public static final Namespace RDF_NAMESPACE = new Namespace("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "rdf");
    private static final String ZERO_LENGTH_STRING = "";
    private static final String UUID_PATTERN_STRING = "_[\\w-]{21}[AQgw]";
    private static final String URL_PATTERN_STRING = ".*_buildableFileUUID=(_[\\w-]{21}[AQgw])_buildDefinitionUUID=(_[\\w-]{21}[AQgw]).*";
    private static final Pattern URL_PATTERN = Pattern.compile(".*_buildableFileUUID=(_[\\w-]{21}[AQgw])_buildDefinitionUUID=(_[\\w-]{21}[AQgw]).*");
    private static final String XML_STYLESHEET = "xml-stylesheet";
    private static final String TYPE_TEXT_XSL_HREF_BUILDMAP_XSL = "type=\"text/xsl\" href=\"buildmap2.xsl\"";
    private static final char SLASH_CHAR = '/';
    private static final String COLON = ":";
    private static final String INPUTS_NODE = "inputs";
    private static final String OUTPUTS_NODE = "outputs";
    private static final String PARSER_OUTPUTS_NODE = "parserOutputs";
    private static final String BUILD_LOGS_NODE = "buildLogs";
    private static final Namespace XMLNS_NAMESPACE = new Namespace("http://www.w3.org/2000/xmlns/", "xmlns");
    private static final TagWithNS RDF_RDF_TAG = new TagWithNS(RDF_NAMESPACE, "RDF");
    private static final TagWithNS RDF_DESCRIPTION_TAG = new TagWithNS(RDF_NAMESPACE, "Description");
    private static final TagWithNS RDF_ABOUT_TAG = new TagWithNS(RDF_NAMESPACE, "about");
    private static final TagWithNS RDF_PARSETYPE_TAG = new TagWithNS(RDF_NAMESPACE, "parseType");
    private static final TagWithNS RDF_NODEID_TAG = new TagWithNS(RDF_NAMESPACE, "nodeID");
    private static final TagWithNS RDF_RESOURCE_TAG = new TagWithNS(RDF_NAMESPACE, "resource");
    private static final String XSD_STRING_TYPE = "http://www.w3.org/2001/XMLSchema#string";
    private static final String XSD_LONG_TYPE = "http://www.w3.org/2001/XMLSchema#long";
    private static final String RESOURCE = "Resource";
    private static final TagWithNS BUILDMAP_BUILD_DEFINITION_UUID_TAG = new TagWithNS(BUILDMAP_NAMESPACE, "buildDefinitionUUID");
    private static final TagWithNS BUILDMAP_INPUTS_TAG = new TagWithNS(BUILDMAP_NAMESPACE, "inputs");
    private static final TagWithNS BUILDMAP_INPUTS_REVISION_TAG = new TagWithNS(BUILDMAP_NAMESPACE, "inputsRevision");
    private static final TagWithNS BUILDMAP_OUTPUTS_TAG = new TagWithNS(BUILDMAP_NAMESPACE, "outputs");
    private static final TagWithNS BUILDMAP_OUTPUTS_REVISION_TAG = new TagWithNS(BUILDMAP_NAMESPACE, "outputsRevision");
    private static final TagWithNS BUILDMAP_PARSER_OUTPUTS_TAG = new TagWithNS(BUILDMAP_NAMESPACE, "parserOutputs");
    private static final TagWithNS BUILDMAP_PARSER_OUTPUTS_REVISION_TAG = new TagWithNS(BUILDMAP_NAMESPACE, "parserOutputsRevision");
    private static final TagWithNS BUILDMAP_BUILD_LOGS_TAG = new TagWithNS(BUILDMAP_NAMESPACE, "buildLogs");
    private static final TagWithNS BUILDMAP_BUILD_RESULT_UUID_TAG = new TagWithNS(BUILDMAP_NAMESPACE, "buildResultUUID");
    private static final TagWithNS BUILDMAP_BUILD_LABEL_TAG = new TagWithNS(BUILDMAP_NAMESPACE, "buildLabel");
    private static final TagWithNS BUILDMAP_WORKSPACE_UUID_TAG = new TagWithNS(BUILDMAP_NAMESPACE, "workspaceUUID");
    private static final TagWithNS BUILDMAP_SNAPSHOT_TAG = new TagWithNS(BUILDMAP_NAMESPACE, "snapshot");
    private static final TagWithNS BUILDMAP_RESOURCE_PREFIX_TAG = new TagWithNS(BUILDMAP_NAMESPACE, "resourcePrefix");
    private static final TagWithNS BUILDMAP_DATASET_PREFIX_TAG = new TagWithNS(BUILDMAP_NAMESPACE, "datasetPrefix");
    private static final TagWithNS BUILDMAP_LOAD_DIRECTORY_TAG = new TagWithNS(BUILDMAP_NAMESPACE, "fetchDestination");
    private static final TagWithNS BUILDMAP_SOURCE_BUILD_MAP_SLUG_TAG = new TagWithNS(BUILDMAP_NAMESPACE, "promotedSourceBuildMapSlug");
    private static final TagWithNS BUILDMAP_PROMOTION_RESULT_UUID_TAG = new TagWithNS(BUILDMAP_NAMESPACE, "promotionResultUUID");
    private static final TagWithNS BUILDMAP_BUILDABLEFILE_UUID_TAG = new TagWithNS(BUILDMAP_NAMESPACE, "buildableFileUUID");
    private static final TagWithNS BUILDMAP_WORK_ITEMS_TAG = new TagWithNS(BUILDMAP_NAMESPACE, "workItems");
    private static final TagWithNS BUILDMAP_WORK_ITEM_TAG = new TagWithNS(BUILDMAP_NAMESPACE, "workItem");
    private static final TagWithNS BUILDMAP_LANGUAGE_DEFINITION_UUID_TAG = new TagWithNS(BUILDMAP_NAMESPACE, "languageDefinitionUuid");
    private static final TagWithNS BUILDMAP_LANGUAGE_DEFINITION_STATE_ID_TAG = new TagWithNS(BUILDMAP_NAMESPACE, "languageDefinitionStateId");
    private static final TagWithNS BUILDMAP_LANGUAGE_DEFINITION_NAME_TAG = new TagWithNS(BUILDMAP_NAMESPACE, "languageDefinitionName");
    private static final TagWithNS INPUTS_FILE_TAG = new TagWithNS(INPUTS_NAMESPACE, "file");
    private static final TagWithNS INPUTS_FILE_CHANGED_TAG = new TagWithNS(INPUTS_NAMESPACE, "changed");
    private static final TagWithNS INPUTS_TYPE_TAG = new TagWithNS(INPUTS_NAMESPACE, "type");
    private static final TagWithNS INPUTS_MEMBER_NAME_TAG = new TagWithNS(INPUTS_NAMESPACE, "memberName");
    private static final TagWithNS INPUTS_MODULE_NAME_TAG = new TagWithNS(INPUTS_NAMESPACE, "module");
    private static final TagWithNS INPUTS_SERVICE_PROGRAM_NAME_TAG = new TagWithNS(INPUTS_NAMESPACE, "serviceProgram");
    private static final TagWithNS INPUTS_COMPONENT_NAME_TAG = new TagWithNS(INPUTS_NAMESPACE, "componentName");
    private static final TagWithNS INPUTS_COMPONENT_UUID_TAG = new TagWithNS(INPUTS_NAMESPACE, "componentUUID");
    private static final TagWithNS INPUTS_PROJECT_NAME_TAG = new TagWithNS(INPUTS_NAMESPACE, "projectName");
    private static final TagWithNS INPUTS_PATH_NAME_TAG = new TagWithNS(INPUTS_NAMESPACE, "pathName");
    private static final TagWithNS INPUTS_TIMESTAMP_TAG = new TagWithNS(INPUTS_NAMESPACE, "timestamp");
    private static final TagWithNS INPUTS_UUID_TAG = new TagWithNS(INPUTS_NAMESPACE, "uuid");
    private static final TagWithNS INPUTS_STATE_UUID_TAG = new TagWithNS(INPUTS_NAMESPACE, "stateUuid");
    private static final TagWithNS INPUTS_RESOURCE_DEFINITION_ID_TAG = new TagWithNS(INPUTS_NAMESPACE, "resourceDefinitionID");
    private static final TagWithNS INPUTS_RESOURCE_DEFINITION_STATE_ID_TAG = new TagWithNS(INPUTS_NAMESPACE, "resourceDefinitionStateID");
    private static final TagWithNS INPUTS_BUILD_FILE_TAG = new TagWithNS(INPUTS_NAMESPACE, "buildFile");
    private static final TagWithNS INPUTS_BUILD_PATH_TAG = new TagWithNS(INPUTS_NAMESPACE, "buildPath");
    private static final TagWithNS INPUTS_PROMOTION_BUILD_PATH_TAG = new TagWithNS(INPUTS_NAMESPACE, "promotionBuildPath");
    private static final TagWithNS INPUTS_INPUT_TYPE_TAG = new TagWithNS(INPUTS_NAMESPACE, "inputType");
    private static final TagWithNS INPUTS_SCM_LOCATION_TAG = new TagWithNS(INPUTS_NAMESPACE, "scmLocation");
    private static final TagWithNS INPUTS_OUTPUT_TYPE_TAG = new TagWithNS(INPUTS_NAMESPACE, "outputType");
    private static final TagWithNS INPUTS_SEQUENTIAL_TAG = new TagWithNS(INPUTS_NAMESPACE, "sequential");
    private static final TagWithNS INPUTS_DEPLOYTYPE_TAG = new TagWithNS(INPUTS_NAMESPACE, "deployType");
    private static final TagWithNS INPUTS_HFS_TAG = new TagWithNS(INPUTS_NAMESPACE, "hfs");
    private static final TagWithNS INPUTS_RESOLVED_TO_TAG = new TagWithNS(INPUTS_NAMESPACE, "resolvedTo");
    private static final TagWithNS OUTPUTS_FILE_TAG = new TagWithNS(OUTPUTS_NAMESPACE, "file");
    private static final TagWithNS OUTPUTS_TYPE_TAG = new TagWithNS(OUTPUTS_NAMESPACE, "type");
    private static final TagWithNS OUTPUTS_MEMBER_NAME_TAG = new TagWithNS(OUTPUTS_NAMESPACE, "memberName");
    private static final TagWithNS OUTPUTS_MODULE_NAME_TAG = new TagWithNS(OUTPUTS_NAMESPACE, "module");
    private static final TagWithNS OUTPUTS_SERVICE_PROGRAM_NAME_TAG = new TagWithNS(OUTPUTS_NAMESPACE, "serviceProgram");
    private static final TagWithNS OUTPUTS_COMPONENT_NAME_TAG = new TagWithNS(OUTPUTS_NAMESPACE, "componentName");
    private static final TagWithNS OUTPUTS_COMPONENT_UUID_TAG = new TagWithNS(OUTPUTS_NAMESPACE, "componentUUID");
    private static final TagWithNS OUTPUTS_PROJECT_NAME_TAG = new TagWithNS(OUTPUTS_NAMESPACE, "projectName");
    private static final TagWithNS OUTPUTS_PATH_NAME_TAG = new TagWithNS(OUTPUTS_NAMESPACE, "pathName");
    private static final TagWithNS OUTPUTS_TIMESTAMP_TAG = new TagWithNS(OUTPUTS_NAMESPACE, "timestamp");
    private static final TagWithNS OUTPUTS_UUID_TAG = new TagWithNS(OUTPUTS_NAMESPACE, "uuid");
    private static final TagWithNS OUTPUTS_STATE_UUID_TAG = new TagWithNS(OUTPUTS_NAMESPACE, "stateUuid");
    private static final TagWithNS OUTPUTS_RESOURCE_DEFINITION_ID_TAG = new TagWithNS(OUTPUTS_NAMESPACE, "resourceDefinitionID");
    private static final TagWithNS OUTPUTS_RESOURCE_DEFINITION_STATE_ID_TAG = new TagWithNS(OUTPUTS_NAMESPACE, "resourceDefinitionStateID");
    private static final TagWithNS OUTPUTS_BUILD_FILE_TAG = new TagWithNS(OUTPUTS_NAMESPACE, "buildFile");
    private static final TagWithNS OUTPUTS_BUILD_PATH_TAG = new TagWithNS(OUTPUTS_NAMESPACE, "buildPath");
    private static final TagWithNS OUTPUTS_PROMOTION_BUILD_PATH_TAG = new TagWithNS(OUTPUTS_NAMESPACE, "promotionBuildPath");
    private static final TagWithNS OUTPUTS_OUTPUT_TYPE_TAG = new TagWithNS(OUTPUTS_NAMESPACE, "outputType");
    private static final TagWithNS OUTPUTS_SCM_LOCATION_TAG = new TagWithNS(OUTPUTS_NAMESPACE, "scmLocation");
    private static final TagWithNS OUTPUTS_INPUT_TYPE_TAG = new TagWithNS(OUTPUTS_NAMESPACE, "inputType");
    private static final TagWithNS OUTPUTS_SEQUENTIAL_TAG = new TagWithNS(OUTPUTS_NAMESPACE, "sequential");
    private static final TagWithNS OUTPUTS_DEPLOYTYPE_TAG = new TagWithNS(OUTPUTS_NAMESPACE, "deployType");
    private static final TagWithNS OUTPUTS_USEDASINPUT_TAG = new TagWithNS(OUTPUTS_NAMESPACE, "usedAsInput");
    private static final TagWithNS OUTPUTS_HFS_TAG = new TagWithNS(OUTPUTS_NAMESPACE, "hfs");
    private static final TagWithNS PARSER_OUTPUTS_FILE_TAG = new TagWithNS(PARSER_OUTPUTS_NAMESPACE, "file");
    private static final TagWithNS PARSER_OUTPUTS_TYPE_TAG = new TagWithNS(PARSER_OUTPUTS_NAMESPACE, "type");
    private static final TagWithNS PARSER_OUTPUTS_RESOURCE_NAME_TAG = new TagWithNS(PARSER_OUTPUTS_NAMESPACE, "resourceName");
    private static final TagWithNS PARSER_OUTPUTS_MEMBER_NAME_TAG = new TagWithNS(PARSER_OUTPUTS_NAMESPACE, "memberName");
    private static final TagWithNS PARSER_OUTPUTS_MODULE_NAME_TAG = new TagWithNS(PARSER_OUTPUTS_NAMESPACE, "module");
    private static final TagWithNS PARSER_OUTPUTS_SERVICE_PROGRAM_NAME_TAG = new TagWithNS(PARSER_OUTPUTS_NAMESPACE, "serviceProgram");
    private static final TagWithNS PARSER_OUTPUTS_COMPONENT_NAME_TAG = new TagWithNS(PARSER_OUTPUTS_NAMESPACE, "componentName");
    private static final TagWithNS PARSER_OUTPUTS_COMPONENT_UUID_TAG = new TagWithNS(PARSER_OUTPUTS_NAMESPACE, "componentUUID");
    private static final TagWithNS PARSER_OUTPUTS_PROJECT_NAME_TAG = new TagWithNS(PARSER_OUTPUTS_NAMESPACE, "projectName");
    private static final TagWithNS PARSER_OUTPUTS_PATH_NAME_TAG = new TagWithNS(PARSER_OUTPUTS_NAMESPACE, "pathName");
    private static final TagWithNS PARSER_OUTPUTS_TIMESTAMP_TAG = new TagWithNS(PARSER_OUTPUTS_NAMESPACE, "timestamp");
    private static final TagWithNS PARSER_OUTPUTS_UUID_TAG = new TagWithNS(PARSER_OUTPUTS_NAMESPACE, "uuid");
    private static final TagWithNS PARSER_OUTPUTS_STATE_UUID_TAG = new TagWithNS(PARSER_OUTPUTS_NAMESPACE, "stateUuid");
    private static final TagWithNS PARSER_OUTPUTS_BUILD_FILE_TAG = new TagWithNS(PARSER_OUTPUTS_NAMESPACE, "buildFile");
    private static final TagWithNS PARSER_OUTPUTS_BUILD_PATH_TAG = new TagWithNS(PARSER_OUTPUTS_NAMESPACE, "buildPath");
    private static final TagWithNS PARSER_OUTPUTS_PROMOTION_BUILD_PATH_TAG = new TagWithNS(PARSER_OUTPUTS_NAMESPACE, "promotionBuildPath");
    private static final TagWithNS PARSER_OUTPUTS_RESOURCE_DEFINITION_ID_TAG = new TagWithNS(PARSER_OUTPUTS_NAMESPACE, "resourceDefinitionID");
    private static final TagWithNS PARSER_OUTPUTS_OUTPUT_TYPE_TAG = new TagWithNS(PARSER_OUTPUTS_NAMESPACE, "outputType");
    private static final TagWithNS PARSER_OUTPUTS_SCM_LOCATION_TAG = new TagWithNS(PARSER_OUTPUTS_NAMESPACE, "scmLocation");
    private static final TagWithNS PARSER_OUTPUTS_INPUT_TYPE_TAG = new TagWithNS(PARSER_OUTPUTS_NAMESPACE, "inputType");
    private static final TagWithNS PARSER_OUTPUTS_RESOURCE_DEFINITION_STATE_ID_TAG = new TagWithNS(PARSER_OUTPUTS_NAMESPACE, "resourceDefinitionStateID");
    private static final TagWithNS PARSER_OUTPUTS_SEQUENTIAL_TAG = new TagWithNS(PARSER_OUTPUTS_NAMESPACE, "sequential");
    private static final TagWithNS PARSER_OUTPUTS_DEPLOYTYPE_TAG = new TagWithNS(PARSER_OUTPUTS_NAMESPACE, "deployType");
    private static final TagWithNS BUILD_LOGS_FILE_TAG = new TagWithNS(BUILD_LOGS_NAMESPACE, "file");
    private static final TagWithNS BUILD_LOGS_LOG_FILE_TAG = new TagWithNS(BUILD_LOGS_NAMESPACE, "logFile");
    private static final TagWithNS BUILD_LOGS_LOG_PATH_TAG = new TagWithNS(BUILD_LOGS_NAMESPACE, "logPath");
    private static final TagWithNS BUILD_LOGS_HOST_NAME_TAG = new TagWithNS(BUILD_LOGS_NAMESPACE, "hostName");
    private static final TagWithNS BUILD_LOGS_OUTPUT_TYPE_TAG = new TagWithNS(BUILD_LOGS_NAMESPACE, "outputType");
    private static final TagWithNS BUILD_LOGS_RESOURCE_DEFINITION_ID_TAG = new TagWithNS(BUILD_LOGS_NAMESPACE, "resourceDefinitionID");
    private static final TagWithNS BUILD_LOGS_RESOURCE_DEFINITION_STATE_ID_TAG = new TagWithNS(BUILD_LOGS_NAMESPACE, "resourceDefinitionStateID");
    private static final TagWithNS BUILD_LOGS_TRANSLATOR_ID_TAG = new TagWithNS(BUILD_LOGS_NAMESPACE, "translatorID");
    private static final TagWithNS BUILD_LOGS_TRANSLATOR_STATE_ID_TAG = new TagWithNS(BUILD_LOGS_NAMESPACE, "translatorStateID");
    private static final TagWithNS BUILD_LOGS_DD_INDEX_TAG = new TagWithNS(BUILD_LOGS_NAMESPACE, "ddIndex");
    private static final TagWithNS BUILD_LOGS_TIMESTAMP_TAG = new TagWithNS(BUILD_LOGS_NAMESPACE, "timestamp");
    private static final TagWithNS BUILD_LOGS_COMPACTED_TAG = new TagWithNS(BUILD_LOGS_NAMESPACE, "compacted");
    private static final TagWithNS BUILD_LOGS_SEQUENTIAL_TAG = new TagWithNS(BUILD_LOGS_NAMESPACE, "sequential");
    private static final String _INPUTS = "_inputs";
    private static final String _OUTPUTS = "_outputs";
    private static final String _PARSER_OUTPUTS = "_parserOutputs";
    private static final String _BUILD_LOGS = "_buildLogs";
    private static final String YES = "yes";
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private static final String INDENT_AMOUNT = "{http://xml.apache.org/xalan}indent-amount";
    private static final String THREE = "3";
    private static final String REVISION_ID_PARAMETER = "?revision=";
    private static final String UTF_8 = "UTF-8";
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    public static String generateSlug(String buildableFileUuidValue, String buildDefinitionUuidValue) {
        StringBuffer slugBuffer = new StringBuffer("_buildableFileUUID=");
        slugBuffer.append(buildableFileUuidValue);
        slugBuffer.append("_buildDefinitionUUID=");
        slugBuffer.append(buildDefinitionUuidValue);
        return slugBuffer.toString();
    }

    private BuildMapUtil() {
    }

    public static IBuildMap createBuildMapFromRDFXMLURI(String uri) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        Document document = documentBuilderFactory.newDocumentBuilder().parse(uri);
        BuildMap buildMap = new BuildMap();
        if (buildMap.getBuildResultUUID() == null) {
            return null;
        }
        BuildMapUtil.processDocument(buildMap, document, IBuildMap.XmlType.FULL);
        return buildMap;
    }

    public static IBuildMap createBuildMapFromRDFXML(String xml) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            documentBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        documentBuilderFactory.setNamespaceAware(true);
        Document document = documentBuilderFactory.newDocumentBuilder().parse(new ByteArrayInputStream(xml.getBytes(UTF_8)));
        BuildMap buildMap = new BuildMap();
        BuildMapUtil.processDocument(buildMap, document, IBuildMap.XmlType.FULL);
        if (buildMap.getBuildResultUUID() == null) {
            return null;
        }
        return buildMap;
    }

    public static IBuildMap createBuildMapFromRDFXML(File xml) throws IOException, SAXException, ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        Document document = documentBuilderFactory.newDocumentBuilder().parse(xml);
        BuildMap buildMap = new BuildMap();
        BuildMapUtil.processDocument(buildMap, document, IBuildMap.XmlType.FULL);
        if (buildMap.getBuildResultUUID() == null) {
            return null;
        }
        return buildMap;
    }

    public static IBuildMap createBuildMapBuildFromRDFXML(String xml) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        Document document = documentBuilderFactory.newDocumentBuilder().parse(new ByteArrayInputStream(xml.getBytes(UTF_8)));
        BuildMap buildMap = new BuildMap();
        BuildMapUtil.processDocument(buildMap, document, IBuildMap.XmlType.BUILD);
        return buildMap;
    }

    public static Set<IInput> createBuildMapInputsFromRDFXML(String xml) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        Document document = documentBuilderFactory.newDocumentBuilder().parse(new ByteArrayInputStream(xml.getBytes(UTF_8)));
        BuildMap buildMap = new BuildMap();
        BuildMapUtil.processDocument(buildMap, document, IBuildMap.XmlType.INPUTS);
        return buildMap.getInputs();
    }

    public static Set<IOutput> createBuildMapOutputsFromRDFXML(String xml) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        Document document = documentBuilderFactory.newDocumentBuilder().parse(new ByteArrayInputStream(xml.getBytes(UTF_8)));
        BuildMap buildMap = new BuildMap();
        BuildMapUtil.processDocument(buildMap, document, IBuildMap.XmlType.OUTPUTS);
        return buildMap.getOutputs();
    }

    public static Object createBuildMapParserOutputsFromRDFXML(String xml) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        Document document = documentBuilderFactory.newDocumentBuilder().parse(new ByteArrayInputStream(xml.getBytes(UTF_8)));
        BuildMap buildMap = new BuildMap();
        BuildMapUtil.processDocument(buildMap, document, IBuildMap.XmlType.PARSER_OUTPUTS);
        return buildMap.getParserOutputs();
    }

    public static String createBuildMapURI(String repositoryLocation, String buildableFileUUID, String buildDefinitionUUID, boolean personalBuild, boolean rebuild, boolean temporaryForPromotion) throws Exception {
        return BuildMapUtil.createBuildMapURI(buildableFileUUID, buildDefinitionUUID, personalBuild, rebuild, temporaryForPromotion);
    }

    public static String createBuildMapURI(String buildableFileUUID, String buildDefinitionUUID, boolean personalBuild, boolean rebuild, boolean temporaryForPromotion) throws Exception {
        StringBuffer buildMapURI = new StringBuffer();
        if (buildableFileUUID != null && buildDefinitionUUID != null) {
            buildMapURI.append("_buildableFileUUID=" + buildableFileUUID + "_buildDefinitionUUID=" + buildDefinitionUUID);
            if (personalBuild) {
                buildMapURI.append("_personalBuild=" + personalBuild);
            }
            if (rebuild) {
                buildMapURI.append("_rebuild=" + rebuild);
            }
            if (temporaryForPromotion) {
                buildMapURI.append("_temporaryForPromotion=" + temporaryForPromotion);
            }
        }
        return buildMapURI.toString();
    }

    public static String getBuildMapURIRoot(String repositoryLocation) {
        StringBuffer buildMapURI = new StringBuffer();
        if (repositoryLocation != null) {
            buildMapURI.append(repositoryLocation);
            if (buildMapURI.charAt(buildMapURI.length() - 1) != '/') {
                buildMapURI.append('/');
            }
            buildMapURI.append("enterprise_buildmap");
            buildMapURI.append('/');
        }
        return buildMapURI.toString();
    }

    private static void processDocument(IBuildMap buildMap, Document document, IBuildMap.XmlType xmlType) {
        NodeList rdfElements = document.getElementsByTagNameNS(RDF_RDF_TAG.getNamespace(), RDF_RDF_TAG.getTagName());
        if (rdfElements.getLength() > 0) {
            BuildMapUtil.readRDF(rdfElements.item(0), buildMap, xmlType);
        }
    }

    private static Element getRDFDescription(Element parentElement, String nodeId) {
        NodeList rdfDescriptionElements = parentElement.getElementsByTagNameNS(RDF_DESCRIPTION_TAG.getNamespace(), RDF_DESCRIPTION_TAG.getTagName());
        int length = rdfDescriptionElements.getLength();
        int i = 0;
        while (i < length) {
            Element element;
            String s;
            Node rdfDescription = rdfDescriptionElements.item(i);
            if (rdfDescription instanceof Element && (s = (element = (Element)rdfDescription).getAttributeNS(RDF_NODEID_TAG.getNamespace(), RDF_NODEID_TAG.getTagName())).equals(nodeId)) {
                return element;
            }
            ++i;
        }
        return null;
    }

    private static void readRDF(Node node, IBuildMap buildMap, IBuildMap.XmlType xmlType) {
        Element rdfDescription;
        if (node instanceof Element && (rdfDescription = BuildMapUtil.getRDFDescription((Element)node, ZERO_LENGTH_STRING)) != null) {
            BuildMapUtil.readRDFDescription(rdfDescription, buildMap, (Element)node, xmlType);
        }
    }

    private static void parseUri(String uriString, IBuildMap buildMap) {
        Matcher matcher = URL_PATTERN.matcher(uriString);
        if (matcher.matches()) {
            buildMap.setBuildableFile(matcher.group(1));
            buildMap.setBuildDefinitionUUID(matcher.group(2));
            buildMap.setPersonalBuild(uriString.contains("_personalBuild="));
            buildMap.setRebuild(uriString.contains("_rebuild="));
            buildMap.setTemporaryForPromotion(uriString.contains("_temporaryForPromotion="));
        }
    }

    private static void readRDFDescription(Node node, IBuildMap buildMap, Element rdfRdf, IBuildMap.XmlType xmlType) {
        if (node instanceof Element) {
            Element element = (Element)node;
            switch (xmlType) {
                case FULL: {
                    String uri = element.getAttributeNS(RDF_ABOUT_TAG.getNamespace(), RDF_ABOUT_TAG.getTagName());
                    buildMap.setUri(uri);
                    BuildMapUtil.parseUri(uri, buildMap);
                    BuildMapUtil.readBuild(element, buildMap);
                    BuildMapUtil.readInputs(element, buildMap, rdfRdf);
                    BuildMapUtil.readOutputs(element, buildMap, rdfRdf);
                    BuildMapUtil.readParserOutputs(element, buildMap, rdfRdf);
                    BuildMapUtil.readBuildLogs(element, buildMap, rdfRdf);
                    break;
                }
                case BUILD: {
                    String uri = element.getAttributeNS(RDF_ABOUT_TAG.getNamespace(), RDF_ABOUT_TAG.getTagName());
                    buildMap.setUri(uri);
                    BuildMapUtil.parseUri(uri, buildMap);
                    BuildMapUtil.readBuild(element, buildMap);
                    break;
                }
                case INPUTS: {
                    BuildMapUtil.readInputs(element, buildMap);
                    break;
                }
                case OUTPUTS: {
                    BuildMapUtil.readOutputs(element, buildMap);
                    break;
                }
                case PARSER_OUTPUTS: {
                    BuildMapUtil.readParserOutputs(element, buildMap);
                }
                case BUILD_LOGS: {
                    BuildMapUtil.readParserOutputs(element, buildMap);
                }
            }
        }
    }

    private static void readBuild(Node node, IBuildMap buildMap) {
        IBuild build = null;
        if (node instanceof Element) {
            String[] attrs;
            Element element = (Element)node;
            build = buildMap.getBuild();
            String attr = BuildMapUtil.readAttributeFromChildElement(element, BUILDMAP_BUILDABLEFILE_UUID_TAG);
            if (attr != null) {
                buildMap.setBuildableFile(attr);
            }
            if ((attr = BuildMapUtil.readAttributeFromChildElement(element, BUILDMAP_BUILD_DEFINITION_UUID_TAG)) != null) {
                build.setBuildDefinitionUUID(attr);
            }
            if ((attr = BuildMapUtil.readAttributeFromChildElement(element, BUILDMAP_BUILD_RESULT_UUID_TAG)) != null) {
                build.setBuildResultUUID(attr);
            }
            if ((attr = BuildMapUtil.readAttributeFromChildElement(element, BUILDMAP_BUILD_LABEL_TAG)) != null) {
                build.setBuildLabel(attr);
            }
            if ((attr = BuildMapUtil.readAttributeFromChildElement(element, BUILDMAP_WORKSPACE_UUID_TAG)) != null) {
                build.setWorkspaceUUID(attr);
            }
            if ((attr = BuildMapUtil.readAttributeFromChildElement(element, BUILDMAP_SNAPSHOT_TAG)) != null) {
                build.setSnapshot(attr);
            }
            if ((attr = BuildMapUtil.readAttributeFromChildElement(element, BUILDMAP_DATASET_PREFIX_TAG)) != null) {
                build.setDatasetPrefix(attr);
            }
            if ((attr = BuildMapUtil.readAttributeFromChildElement(element, BUILDMAP_RESOURCE_PREFIX_TAG)) != null) {
                build.setResourcePrefix(attr);
            }
            if ((attr = BuildMapUtil.readAttributeFromChildElement(element, BUILDMAP_LOAD_DIRECTORY_TAG)) != null) {
                build.setLoadDirectory(attr);
            }
            if ((attr = BuildMapUtil.readAttributeFromChildElement(element, BUILDMAP_SOURCE_BUILD_MAP_SLUG_TAG)) != null) {
                build.setSourceBuildMapSlug(attr);
            }
            if ((attr = BuildMapUtil.readAttributeFromChildElement(element, BUILDMAP_PROMOTION_RESULT_UUID_TAG)) != null) {
                build.setPromotionResultUUID(attr);
            }
            if ((attr = BuildMapUtil.readAttributeFromChildElement(element, BUILDMAP_LANGUAGE_DEFINITION_UUID_TAG)) != null) {
                build.setLanguageDefinitionUuid(attr);
            }
            if ((attr = BuildMapUtil.readAttributeFromChildElement(element, BUILDMAP_LANGUAGE_DEFINITION_NAME_TAG)) != null) {
                build.setLanguageDefinitionName(attr);
            }
            if ((attr = BuildMapUtil.readAttributeFromChildElement(element, BUILDMAP_LANGUAGE_DEFINITION_STATE_ID_TAG)) != null) {
                build.setLanguageDefinitionStateId(attr);
            }
            if ((attrs = BuildMapUtil.readAttributesFromChildElement(element, BUILDMAP_WORK_ITEM_TAG)) != null) {
                build.setWorkItems(attrs);
            }
            if ((attr = BuildMapUtil.readAttributeFromChildElement(element, BUILDMAP_INPUTS_TAG)) != null) {
                buildMap.getInputs().add(new Input(null));
            }
            if ((attr = BuildMapUtil.readAttributeFromChildElement(element, BUILDMAP_OUTPUTS_TAG)) != null) {
                buildMap.getOutputs().add(new Output(null));
            }
            if ((attr = BuildMapUtil.readAttributeFromChildElement(element, BUILDMAP_PARSER_OUTPUTS_TAG)) != null) {
                buildMap.setParserOutputs(new Object());
            }
        }
    }

    private static void readInputs(Node node, IBuildMap buildMap, Element rdfRdf) {
        if (node instanceof Element) {
            Element element = (Element)node;
            NodeList buildMapInputNodes = element.getElementsByTagNameNS(BUILDMAP_INPUTS_TAG.getNamespace(), BUILDMAP_INPUTS_TAG.getTagName());
            int n = buildMapInputNodes.getLength();
            int i = 0;
            while (i < n) {
                BuildMapUtil.readBuildMapInput(buildMapInputNodes.item(i), buildMap, rdfRdf);
                ++i;
            }
        }
    }

    private static void readOutputs(Node node, IBuildMap buildMap, Element rdfRdf) {
        if (node instanceof Element) {
            Element element = (Element)node;
            NodeList buildMapOutputNodes = element.getElementsByTagNameNS(BUILDMAP_OUTPUTS_TAG.getNamespace(), BUILDMAP_OUTPUTS_TAG.getTagName());
            int n = buildMapOutputNodes.getLength();
            int i = 0;
            while (i < n) {
                BuildMapUtil.readBuildMapOutput(buildMapOutputNodes.item(i), buildMap, rdfRdf);
                ++i;
            }
        }
    }

    private static void readParserOutputs(Node node, IBuildMap buildMap, Element rdfRdf) {
        if (node instanceof Element) {
            Element element = (Element)node;
            NodeList buildMapParserOutputNodes = element.getElementsByTagNameNS(BUILDMAP_PARSER_OUTPUTS_TAG.getNamespace(), BUILDMAP_PARSER_OUTPUTS_TAG.getTagName());
            int n = buildMapParserOutputNodes.getLength();
            int i = 0;
            while (i < n) {
                BuildMapUtil.readBuildMapParserOutput(buildMapParserOutputNodes.item(i), buildMap, rdfRdf);
                ++i;
            }
        }
    }

    private static void readBuildLogs(Node node, IBuildMap buildMap, Element rdfRdf) {
        if (node instanceof Element) {
            Element element = (Element)node;
            NodeList buildMapBuildLogNodes = element.getElementsByTagNameNS(BUILDMAP_BUILD_LOGS_TAG.getNamespace(), BUILDMAP_BUILD_LOGS_TAG.getTagName());
            int n = buildMapBuildLogNodes.getLength();
            int i = 0;
            while (i < n) {
                BuildMapUtil.readBuildMapBuildLog(buildMapBuildLogNodes.item(i), buildMap, rdfRdf);
                ++i;
            }
        }
    }

    private static void readBuildMapInput(Node inputs, IBuildMap buildMap, Node node) {
        Element element;
        String nodeId;
        if (inputs instanceof Element && (nodeId = ((Element)inputs).getAttributeNS(RDF_NODEID_TAG.getNamespace(), RDF_NODEID_TAG.getTagName())) != null && (element = BuildMapUtil.getRDFDescription((Element)node, nodeId)) != null) {
            BuildMapUtil.readInputs(element, buildMap);
        }
    }

    private static void readInputs(Element element, IBuildMap buildMap) {
        NodeList fileNodes = element.getElementsByTagNameNS(INPUTS_FILE_TAG.getNamespace(), INPUTS_FILE_TAG.getTagName());
        if (fileNodes != null) {
            int length = fileNodes.getLength();
            buildMap.getInputs().clear();
            int i = 0;
            while (i < length) {
                IBuildFile file = BuildMapUtil.readInputsFile(fileNodes.item(i));
                if (file != null) {
                    buildMap.getInputs().add(new Input(file));
                }
                ++i;
            }
        }
    }

    private static void readBuildMapOutput(Node outputs, IBuildMap buildMap, Node node) {
        Element element;
        String nodeId;
        if (outputs instanceof Element && (nodeId = ((Element)outputs).getAttributeNS(RDF_NODEID_TAG.getNamespace(), RDF_NODEID_TAG.getTagName())) != null && (element = BuildMapUtil.getRDFDescription((Element)node, nodeId)) != null) {
            BuildMapUtil.readOutputs(element, buildMap);
        }
    }

    private static void readOutputs(Element element, IBuildMap buildMap) {
        NodeList fileNodes = element.getElementsByTagNameNS(OUTPUTS_FILE_TAG.getNamespace(), OUTPUTS_FILE_TAG.getTagName());
        if (fileNodes != null) {
            int length = fileNodes.getLength();
            buildMap.getOutputs().clear();
            int i = 0;
            while (i < length) {
                IBuildFile file = BuildMapUtil.readOutputsFile(fileNodes.item(i));
                if (file != null) {
                    buildMap.getOutputs().add(new Output(file));
                }
                ++i;
            }
        }
    }

    private static void readBuildMapParserOutput(Node outputs, IBuildMap buildMap, Node node) {
        Element element;
        String nodeId;
        if (outputs instanceof Element && (nodeId = ((Element)outputs).getAttributeNS(RDF_NODEID_TAG.getNamespace(), RDF_NODEID_TAG.getTagName())) != null && (element = BuildMapUtil.getRDFDescription((Element)node, nodeId)) != null) {
            BuildMapUtil.readParserOutputs(element, buildMap);
        }
    }

    private static void readBuildMapBuildLog(Node buildLogs, IBuildMap buildMap, Node node) {
        Element element;
        String nodeId;
        if (buildLogs instanceof Element && (nodeId = ((Element)buildLogs).getAttributeNS(RDF_NODEID_TAG.getNamespace(), RDF_NODEID_TAG.getTagName())) != null && (element = BuildMapUtil.getRDFDescription((Element)node, nodeId)) != null) {
            BuildMapUtil.readBuildLogs(element, buildMap);
        }
    }

    private static void readParserOutputs(Element element, IBuildMap buildMap) {
        int length;
        NodeList fileNodes = element.getElementsByTagNameNS(PARSER_OUTPUTS_FILE_TAG.getNamespace(), PARSER_OUTPUTS_FILE_TAG.getTagName());
        if (fileNodes != null && (length = fileNodes.getLength()) > 0) {
            HashSet<IBuildFile> set = new HashSet<IBuildFile>(length);
            int i = 0;
            while (i < length) {
                IBuildFile file = BuildMapUtil.readParserOutputsFile(fileNodes.item(i));
                if (file != null) {
                    set.add(file);
                }
                ++i;
            }
            buildMap.setParserOutputs(set);
        }
    }

    private static void readBuildLogs(Element element, IBuildMap buildMap) {
        int length;
        NodeList fileNodes = element.getElementsByTagNameNS(BUILD_LOGS_FILE_TAG.getNamespace(), BUILD_LOGS_FILE_TAG.getTagName());
        if (fileNodes != null && (length = fileNodes.getLength()) > 0) {
            int i = 0;
            while (i < length) {
                IBuildFile file = BuildMapUtil.readBuildLogsFile(fileNodes.item(i));
                if (file != null) {
                    buildMap.getLogs().add(new Output(file));
                }
                ++i;
            }
        }
    }

    public static IBuildFile readInputsFile(Node node) {
        BuildFile file = null;
        if (node instanceof Element) {
            Element element = (Element)node;
            file = new BuildFile();
            String attr = BuildMapUtil.readAttributeFromChildElement(element, INPUTS_TYPE_TAG);
            if (attr != null) {
                file.setType(attr);
            }
            if ((attr = BuildMapUtil.readAttributeFromChildElement(element, INPUTS_MEMBER_NAME_TAG)) != null) {
                file.setMemberName(attr);
            }
            if ((attr = BuildMapUtil.readAttributeFromChildElement(element, INPUTS_MODULE_NAME_TAG)) != null) {
                file.setModule(attr);
            }
            if ((attr = BuildMapUtil.readAttributeFromChildElement(element, INPUTS_SERVICE_PROGRAM_NAME_TAG)) != null) {
                file.setServiceProgram(attr);
            }
            if ((attr = BuildMapUtil.readAttributeFromChildElement(element, INPUTS_COMPONENT_NAME_TAG)) != null) {
                file.setComponentName(attr);
            }
            if ((attr = BuildMapUtil.readAttributeFromChildElement(element, INPUTS_COMPONENT_UUID_TAG)) != null) {
                file.setComponentUUID(attr);
            }
            if ((attr = BuildMapUtil.readAttributeFromChildElement(element, INPUTS_PROJECT_NAME_TAG)) != null) {
                file.setProjectName(attr);
            }
            if ((attr = BuildMapUtil.readAttributeFromChildElement(element, INPUTS_PATH_NAME_TAG)) != null) {
                file.setPathName(attr);
            }
            if ((attr = BuildMapUtil.readAttributeFromChildElement(element, INPUTS_TIMESTAMP_TAG)) != null) {
                long timestamp = Long.valueOf(attr);
                file.setTimestamp(timestamp);
            }
            if ((attr = BuildMapUtil.readAttributeFromChildElement(element, INPUTS_UUID_TAG)) != null) {
                file.setFileUUID(attr);
            }
            if ((attr = BuildMapUtil.readAttributeFromChildElement(element, INPUTS_STATE_UUID_TAG)) != null) {
                file.setFileStateUUID(attr);
            }
            if ((attr = BuildMapUtil.readAttributeFromChildElement(element, INPUTS_RESOURCE_DEFINITION_ID_TAG)) != null) {
                file.setResourceDefinitionID(attr);
            }
            if ((attr = BuildMapUtil.readAttributeFromChildElement(element, INPUTS_RESOURCE_DEFINITION_STATE_ID_TAG)) != null) {
                file.setResourceDefinitionStateID(attr);
            }
            if ((attr = BuildMapUtil.readAttributeFromChildElement(element, INPUTS_BUILD_FILE_TAG)) != null) {
                file.setBuildFile(attr);
            }
            if ((attr = BuildMapUtil.readAttributeFromChildElement(element, INPUTS_BUILD_PATH_TAG)) != null) {
                file.setBuildPath(attr);
            }
            if ((attr = BuildMapUtil.readAttributeFromChildElement(element, INPUTS_PROMOTION_BUILD_PATH_TAG)) != null) {
                file.setPromotionBuildPath(attr);
            }
            if ((attr = BuildMapUtil.readAttributeFromChildElement(element, INPUTS_INPUT_TYPE_TAG)) != null) {
                file.setInputType(attr);
            }
            if ((attr = BuildMapUtil.readAttributeFromChildElement(element, INPUTS_SCM_LOCATION_TAG)) != null) {
                file.setSCMLocation(attr);
            }
            if ((attr = BuildMapUtil.readAttributeFromChildElement(element, INPUTS_HFS_TAG)) != null) {
                file.setHFS(Boolean.parseBoolean(attr));
            }
            if ((attr = BuildMapUtil.readAttributeFromChildElement(element, INPUTS_RESOLVED_TO_TAG)) != null) {
                file.setResolvedTo(attr);
            }
        }
        return file;
    }

    public static IBuildFile readOutputsFile(Node node) {
        BuildFile file = null;
        if (node instanceof Element) {
            Element element = (Element)node;
            file = new BuildFile();
            String attr = BuildMapUtil.readAttributeFromChildElement(element, OUTPUTS_TYPE_TAG);
            if (attr != null) {
                file.setType(attr);
            }
            if ((attr = BuildMapUtil.readAttributeFromChildElement(element, OUTPUTS_MEMBER_NAME_TAG)) != null) {
                file.setMemberName(attr);
            }
            if ((attr = BuildMapUtil.readAttributeFromChildElement(element, OUTPUTS_MODULE_NAME_TAG)) != null) {
                file.setModule(attr);
            }
            if ((attr = BuildMapUtil.readAttributeFromChildElement(element, OUTPUTS_SERVICE_PROGRAM_NAME_TAG)) != null) {
                file.setServiceProgram(attr);
            }
            if ((attr = BuildMapUtil.readAttributeFromChildElement(element, OUTPUTS_COMPONENT_NAME_TAG)) != null) {
                file.setComponentName(attr);
            }
            if ((attr = BuildMapUtil.readAttributeFromChildElement(element, OUTPUTS_COMPONENT_UUID_TAG)) != null) {
                file.setComponentUUID(attr);
            }
            if ((attr = BuildMapUtil.readAttributeFromChildElement(element, OUTPUTS_PROJECT_NAME_TAG)) != null) {
                file.setProjectName(attr);
            }
            if ((attr = BuildMapUtil.readAttributeFromChildElement(element, OUTPUTS_PATH_NAME_TAG)) != null) {
                file.setPathName(attr);
            }
            if ((attr = BuildMapUtil.readAttributeFromChildElement(element, OUTPUTS_TIMESTAMP_TAG)) != null) {
                long timestamp = Long.valueOf(attr);
                file.setTimestamp(timestamp);
            }
            if ((attr = BuildMapUtil.readAttributeFromChildElement(element, OUTPUTS_UUID_TAG)) != null) {
                file.setFileUUID(attr);
            }
            if ((attr = BuildMapUtil.readAttributeFromChildElement(element, OUTPUTS_STATE_UUID_TAG)) != null) {
                file.setFileStateUUID(attr);
            }
            if ((attr = BuildMapUtil.readAttributeFromChildElement(element, OUTPUTS_RESOURCE_DEFINITION_ID_TAG)) != null) {
                file.setResourceDefinitionID(attr);
            }
            if ((attr = BuildMapUtil.readAttributeFromChildElement(element, OUTPUTS_RESOURCE_DEFINITION_STATE_ID_TAG)) != null) {
                file.setResourceDefinitionStateID(attr);
            }
            if ((attr = BuildMapUtil.readAttributeFromChildElement(element, OUTPUTS_BUILD_FILE_TAG)) != null) {
                file.setBuildFile(attr);
            }
            if ((attr = BuildMapUtil.readAttributeFromChildElement(element, OUTPUTS_BUILD_PATH_TAG)) != null) {
                file.setBuildPath(attr);
            }
            if ((attr = BuildMapUtil.readAttributeFromChildElement(element, OUTPUTS_PROMOTION_BUILD_PATH_TAG)) != null) {
                file.setPromotionBuildPath(attr);
            }
            if ((attr = BuildMapUtil.readAttributeFromChildElement(element, OUTPUTS_OUTPUT_TYPE_TAG)) != null) {
                file.setOutputType(attr);
            }
            if ((attr = BuildMapUtil.readAttributeFromChildElement(element, OUTPUTS_SEQUENTIAL_TAG)) != null) {
                file.setSequential(attr);
            }
            if ((attr = BuildMapUtil.readAttributeFromChildElement(element, OUTPUTS_HFS_TAG)) != null) {
                file.setHFS(Boolean.parseBoolean(attr));
            }
            if ((attr = BuildMapUtil.readAttributeFromChildElement(element, OUTPUTS_DEPLOYTYPE_TAG)) != null) {
                file.setDeployType(attr);
            }
            if ((attr = BuildMapUtil.readAttributeFromChildElement(element, OUTPUTS_USEDASINPUT_TAG)) != null) {
                file.setUsedAsInput(Boolean.valueOf(attr));
            }
        }
        return file;
    }

    public static IBuildFile readParserOutputsFile(Node node) {
        BuildFile file = null;
        if (node instanceof Element) {
            Element element = (Element)node;
            file = new BuildFile();
            String attr = BuildMapUtil.readAttributeFromChildElement(element, PARSER_OUTPUTS_TYPE_TAG);
            if (attr != null) {
                file.setType(attr);
            }
            if ((attr = BuildMapUtil.readAttributeFromChildElement(element, PARSER_OUTPUTS_RESOURCE_NAME_TAG)) != null) {
                file.setResourceName(attr);
            }
            if ((attr = BuildMapUtil.readAttributeFromChildElement(element, PARSER_OUTPUTS_MEMBER_NAME_TAG)) != null) {
                file.setMemberName(attr);
            }
            if ((attr = BuildMapUtil.readAttributeFromChildElement(element, PARSER_OUTPUTS_SERVICE_PROGRAM_NAME_TAG)) != null) {
                file.setServiceProgram(attr);
            }
            if ((attr = BuildMapUtil.readAttributeFromChildElement(element, PARSER_OUTPUTS_COMPONENT_NAME_TAG)) != null) {
                file.setComponentName(attr);
            }
            if ((attr = BuildMapUtil.readAttributeFromChildElement(element, PARSER_OUTPUTS_COMPONENT_UUID_TAG)) != null) {
                file.setComponentUUID(attr);
            }
            if ((attr = BuildMapUtil.readAttributeFromChildElement(element, PARSER_OUTPUTS_PROJECT_NAME_TAG)) != null) {
                file.setProjectName(attr);
            }
            if ((attr = BuildMapUtil.readAttributeFromChildElement(element, PARSER_OUTPUTS_PATH_NAME_TAG)) != null) {
                file.setPathName(attr);
            }
            if ((attr = BuildMapUtil.readAttributeFromChildElement(element, PARSER_OUTPUTS_TIMESTAMP_TAG)) != null) {
                long timestamp = Long.valueOf(attr);
                file.setTimestamp(timestamp);
            }
            if ((attr = BuildMapUtil.readAttributeFromChildElement(element, PARSER_OUTPUTS_UUID_TAG)) != null) {
                file.setFileUUID(attr);
            }
            if ((attr = BuildMapUtil.readAttributeFromChildElement(element, PARSER_OUTPUTS_STATE_UUID_TAG)) != null) {
                file.setFileStateUUID(attr);
            }
            if ((attr = BuildMapUtil.readAttributeFromChildElement(element, PARSER_OUTPUTS_RESOURCE_DEFINITION_ID_TAG)) != null) {
                file.setResourceDefinitionID(attr);
            }
            if ((attr = BuildMapUtil.readAttributeFromChildElement(element, PARSER_OUTPUTS_BUILD_FILE_TAG)) != null) {
                file.setBuildFile(attr);
            }
            if ((attr = BuildMapUtil.readAttributeFromChildElement(element, PARSER_OUTPUTS_BUILD_PATH_TAG)) != null) {
                file.setBuildPath(attr);
            }
            if ((attr = BuildMapUtil.readAttributeFromChildElement(element, PARSER_OUTPUTS_PROMOTION_BUILD_PATH_TAG)) != null) {
                file.setPromotionBuildPath(attr);
            }
            if ((attr = BuildMapUtil.readAttributeFromChildElement(element, PARSER_OUTPUTS_OUTPUT_TYPE_TAG)) != null) {
                file.setOutputType(attr);
            }
            if ((attr = BuildMapUtil.readAttributeFromChildElement(element, PARSER_OUTPUTS_SEQUENTIAL_TAG)) != null) {
                file.setSequential(attr);
            }
            if ((attr = BuildMapUtil.readAttributeFromChildElement(element, PARSER_OUTPUTS_DEPLOYTYPE_TAG)) != null) {
                file.setDeployType(attr);
            }
        }
        return file;
    }

    public static IBuildFile readBuildLogsFile(Node node) {
        BuildFile file = null;
        if (node instanceof Element) {
            Element element = (Element)node;
            file = new BuildFile();
            String attr = BuildMapUtil.readAttributeFromChildElement(element, BUILD_LOGS_LOG_FILE_TAG);
            if (attr != null) {
                file.setBuildFile(attr);
            }
            if ((attr = BuildMapUtil.readAttributeFromChildElement(element, BUILD_LOGS_LOG_PATH_TAG)) != null) {
                file.setBuildPath(attr);
            }
            if ((attr = BuildMapUtil.readAttributeFromChildElement(element, BUILD_LOGS_HOST_NAME_TAG)) != null) {
                file.setResourceName(attr);
            }
            if ((attr = BuildMapUtil.readAttributeFromChildElement(element, BUILD_LOGS_TIMESTAMP_TAG)) != null) {
                long timestamp = Long.valueOf(attr);
                file.setTimestamp(timestamp);
            }
            if ((attr = BuildMapUtil.readAttributeFromChildElement(element, BUILD_LOGS_RESOURCE_DEFINITION_ID_TAG)) != null) {
                file.setResourceDefinitionID(attr);
            }
            if ((attr = BuildMapUtil.readAttributeFromChildElement(element, BUILD_LOGS_RESOURCE_DEFINITION_STATE_ID_TAG)) != null) {
                file.setResourceDefinitionStateID(attr);
            }
            if ((attr = BuildMapUtil.readAttributeFromChildElement(element, BUILD_LOGS_TRANSLATOR_ID_TAG)) != null) {
                file.setDataSetDefinitionUUID(attr);
            }
            if ((attr = BuildMapUtil.readAttributeFromChildElement(element, BUILD_LOGS_TRANSLATOR_STATE_ID_TAG)) != null) {
                file.setDataSetDefinitionStateUUID(attr);
            }
            if ((attr = BuildMapUtil.readAttributeFromChildElement(element, BUILD_LOGS_DD_INDEX_TAG)) != null) {
                file.setInputType(attr);
            }
            if ((attr = BuildMapUtil.readAttributeFromChildElement(element, BUILD_LOGS_OUTPUT_TYPE_TAG)) != null) {
                file.setOutputType(attr);
            }
            if ((attr = BuildMapUtil.readAttributeFromChildElement(element, BUILD_LOGS_SEQUENTIAL_TAG)) != null) {
                file.setSequential(attr);
            }
            if ((attr = BuildMapUtil.readAttributeFromChildElement(element, BUILD_LOGS_COMPACTED_TAG)) != null) {
                file.setUsedAsInput(Boolean.valueOf(attr));
            }
        }
        return file;
    }

    private static String readAttributeFromChildElement(Element element, TagWithNS tag) {
        String attribute = null;
        NodeList nodeList = element.getElementsByTagNameNS(tag.getNamespace(), tag.getTagName());
        if (nodeList != null && nodeList.getLength() > 0 && (attribute = nodeList.item(0).getTextContent()) != null) {
            attribute = attribute.intern();
        }
        return attribute;
    }

    private static String[] readAttributesFromChildElement(Element element, TagWithNS tag) {
        HashSet<String> attributes = new HashSet<String>();
        NodeList nodeList = element.getElementsByTagNameNS(tag.getNamespace(), tag.getTagName());
        if (nodeList != null && nodeList.getLength() > 0) {
            int i = 0;
            while (i < nodeList.getLength()) {
                String attribute = nodeList.item(i).getTextContent();
                if (attribute != null) {
                    attribute = attribute.intern();
                    attributes.add(attribute);
                }
                ++i;
            }
        }
        return attributes.toArray(new String[attributes.size()]);
    }

    private static Document newDocument() throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        Document document = documentBuilderFactory.newDocumentBuilder().newDocument();
        return document;
    }

    public static String getXmlString(IBuildMap buildMap) throws TransformerConfigurationException, TransformerFactoryConfigurationError, TransformerException, UnsupportedEncodingException, ParserConfigurationException {
        Document document = BuildMapUtil.createBuildMapDoc(buildMap, IBuildMap.XmlType.FULL);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(4096);
        StreamResult result = new StreamResult(outputStream);
        BuildMapUtil.transform(result, document);
        return outputStream.toString(UTF_8);
    }

    public static String getBuildXmlString(IBuildMap buildMap) throws TransformerConfigurationException, TransformerFactoryConfigurationError, TransformerException, UnsupportedEncodingException, ParserConfigurationException {
        return BuildMapUtil.getBuildXmlString(buildMap, null);
    }

    public static String getBuildXmlString(IBuildMap buildMap, Map<String, String> revisionIDs) throws TransformerConfigurationException, TransformerFactoryConfigurationError, TransformerException, UnsupportedEncodingException, ParserConfigurationException {
        Document document = BuildMapUtil.createBuildMapDoc(buildMap, IBuildMap.XmlType.BUILD, revisionIDs);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(4096);
        StreamResult result = new StreamResult(outputStream);
        BuildMapUtil.transform(result, document);
        return outputStream.toString(UTF_8);
    }

    public static String getBuildXmlString(com.ibm.team.enterprise.build.buildmap.common.model.IBuildMap buildmap) throws TransformerConfigurationException, TransformerFactoryConfigurationError, TransformerException, UnsupportedEncodingException, ParserConfigurationException {
        IBuildMap bm = BuildMapConversionUtil.convert(buildmap);
        return BuildMapUtil.getBuildXmlString(bm, null);
    }

    public static String getInputsXmlString(IBuildMap buildMap) throws TransformerConfigurationException, TransformerFactoryConfigurationError, TransformerException, UnsupportedEncodingException, ParserConfigurationException {
        Document document = BuildMapUtil.createBuildMapDoc(buildMap, IBuildMap.XmlType.INPUTS);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(4096);
        StreamResult result = new StreamResult(outputStream);
        BuildMapUtil.transform(result, document);
        return outputStream.toString(UTF_8);
    }

    public static String getOutputsXmlString(IBuildMap buildMap) throws TransformerConfigurationException, TransformerFactoryConfigurationError, TransformerException, UnsupportedEncodingException, ParserConfigurationException {
        Document document = BuildMapUtil.createBuildMapDoc(buildMap, IBuildMap.XmlType.OUTPUTS);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(4096);
        StreamResult result = new StreamResult(outputStream);
        BuildMapUtil.transform(result, document);
        return outputStream.toString(UTF_8);
    }

    public static String getParserOutputsXmlString(IBuildMap buildMap) throws TransformerConfigurationException, TransformerFactoryConfigurationError, TransformerException, UnsupportedEncodingException, ParserConfigurationException {
        Document document = BuildMapUtil.createBuildMapDoc(buildMap, IBuildMap.XmlType.PARSER_OUTPUTS);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(4096);
        StreamResult result = new StreamResult(outputStream);
        BuildMapUtil.transform(result, document);
        return outputStream.toString(UTF_8);
    }

    private static void transform(Result result, Document document) throws TransformerConfigurationException, TransformerFactoryConfigurationError, TransformerException {
        DOMSource source = new DOMSource(document);
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("indent", YES);
        transformer.setOutputProperty(INDENT_AMOUNT, THREE);
        transformer.transform(source, result);
    }

    private static Document createBuildMapDoc(IBuildMap buildMap, IBuildMap.XmlType xmlType) throws ParserConfigurationException {
        return BuildMapUtil.createBuildMapDoc(buildMap, xmlType, null);
    }

    private static Document createBuildMapDoc(IBuildMap buildMap, IBuildMap.XmlType xmlType, Map<String, String> revisionIDs) throws ParserConfigurationException {
        Node node = null;
        Document document = BuildMapUtil.newDocument();
        Element rdfRdf = document.createElementNS(RDF_RDF_TAG.getNamespace(), RDF_RDF_TAG.getTagName());
        rdfRdf.setPrefix(RDF_RDF_TAG.getPrefix());
        node = document.appendChild(rdfRdf);
        switch (xmlType) {
            case FULL: {
                ProcessingInstruction processingInstruction = document.createProcessingInstruction(XML_STYLESHEET, TYPE_TEXT_XSL_HREF_BUILDMAP_XSL);
                document.insertBefore(processingInstruction, node);
                break;
            }
        }
        Attr attr = null;
        String xmlnsNamespace = XMLNS_NAMESPACE.getNamespace();
        String xmlnsPrefix = XMLNS_NAMESPACE.getPrefix();
        Attr attrRdf = document.createAttributeNS(xmlnsNamespace, new StringBuffer(xmlnsPrefix).append(COLON).append(RDF_NAMESPACE.getPrefix()).toString());
        attrRdf.setValue(RDF_NAMESPACE.getNamespace());
        attr = rdfRdf.setAttributeNode(attrRdf);
        switch (xmlType) {
            case FULL: {
                Attr attrBuildMap;
                if (attr == null) {
                    attrBuildMap = document.createAttributeNS(xmlnsNamespace, new StringBuffer(xmlnsPrefix).append(COLON).append(BUILDMAP_NAMESPACE.getPrefix()).toString());
                    attrBuildMap.setValue(BUILDMAP_NAMESPACE.getNamespace());
                    attr = rdfRdf.setAttributeNode(attrBuildMap);
                }
                if (attr == null) {
                    attrBuildMap = document.createAttributeNS(xmlnsNamespace, new StringBuffer(xmlnsPrefix).append(COLON).append(INPUTS_NAMESPACE.getPrefix()).toString());
                    attrBuildMap.setValue(INPUTS_NAMESPACE.getNamespace());
                    attr = rdfRdf.setAttributeNode(attrBuildMap);
                }
                if (attr == null) {
                    attrBuildMap = document.createAttributeNS(xmlnsNamespace, new StringBuffer(xmlnsPrefix).append(COLON).append(OUTPUTS_NAMESPACE.getPrefix()).toString());
                    attrBuildMap.setValue(OUTPUTS_NAMESPACE.getNamespace());
                    attr = rdfRdf.setAttributeNode(attrBuildMap);
                }
                if (attr == null) {
                    attrBuildMap = document.createAttributeNS(xmlnsNamespace, new StringBuffer(xmlnsPrefix).append(COLON).append(PARSER_OUTPUTS_NAMESPACE.getPrefix()).toString());
                    attrBuildMap.setValue(PARSER_OUTPUTS_NAMESPACE.getNamespace());
                    attr = rdfRdf.setAttributeNode(attrBuildMap);
                }
                if (attr != null) break;
                attrBuildMap = document.createAttributeNS(xmlnsNamespace, new StringBuffer(xmlnsPrefix).append(COLON).append(BUILD_LOGS_NAMESPACE.getPrefix()).toString());
                attrBuildMap.setValue(BUILD_LOGS_NAMESPACE.getNamespace());
                attr = rdfRdf.setAttributeNode(attrBuildMap);
                break;
            }
            case BUILD: {
                if (attr != null) break;
                Attr attrBuildMap = document.createAttributeNS(xmlnsNamespace, new StringBuffer(xmlnsPrefix).append(COLON).append(BUILDMAP_NAMESPACE.getPrefix()).toString());
                attrBuildMap.setValue(BUILDMAP_NAMESPACE.getNamespace());
                attr = rdfRdf.setAttributeNode(attrBuildMap);
                break;
            }
            case INPUTS: {
                if (attr != null) break;
                Attr attrBuildMap = document.createAttributeNS(xmlnsNamespace, new StringBuffer(xmlnsPrefix).append(COLON).append(INPUTS_NAMESPACE.getPrefix()).toString());
                attrBuildMap.setValue(INPUTS_NAMESPACE.getNamespace());
                attr = rdfRdf.setAttributeNode(attrBuildMap);
                break;
            }
            case OUTPUTS: {
                if (attr != null) break;
                Attr attrBuildMap = document.createAttributeNS(xmlnsNamespace, new StringBuffer(xmlnsPrefix).append(COLON).append(OUTPUTS_NAMESPACE.getPrefix()).toString());
                attrBuildMap.setValue(OUTPUTS_NAMESPACE.getNamespace());
                attr = rdfRdf.setAttributeNode(attrBuildMap);
                break;
            }
            case PARSER_OUTPUTS: {
                if (attr != null) break;
                Attr attrBuildMap = document.createAttributeNS(xmlnsNamespace, new StringBuffer(xmlnsPrefix).append(COLON).append(PARSER_OUTPUTS_NAMESPACE.getPrefix()).toString());
                attrBuildMap.setValue(PARSER_OUTPUTS_NAMESPACE.getNamespace());
                attr = rdfRdf.setAttributeNode(attrBuildMap);
                break;
            }
            case BUILD_LOGS: {
                if (attr != null) break;
                Attr attrBuildMap = document.createAttributeNS(xmlnsNamespace, new StringBuffer(xmlnsPrefix).append(COLON).append(BUILD_LOGS_NAMESPACE.getPrefix()).toString());
                attrBuildMap.setValue(BUILD_LOGS_NAMESPACE.getNamespace());
                attr = rdfRdf.setAttributeNode(attrBuildMap);
            }
        }
        if (attr == null) {
            Element rdfDescription = document.createElementNS(RDF_DESCRIPTION_TAG.getNamespace(), RDF_DESCRIPTION_TAG.getTagName());
            rdfDescription.setPrefix(RDF_DESCRIPTION_TAG.getPrefix());
            attr = document.createAttributeNS(RDF_ABOUT_TAG.getNamespace(), RDF_ABOUT_TAG.getTagName());
            attr.setPrefix(RDF_ABOUT_TAG.getPrefix());
            String uri = buildMap.getUri();
            switch (xmlType) {
                case FULL: {
                    break;
                }
                case BUILD: {
                    break;
                }
                case INPUTS: {
                    uri = String.valueOf(uri) + _INPUTS;
                    break;
                }
                case OUTPUTS: {
                    uri = String.valueOf(uri) + _OUTPUTS;
                    break;
                }
                case PARSER_OUTPUTS: {
                    uri = String.valueOf(uri) + _PARSER_OUTPUTS;
                    break;
                }
                case BUILD_LOGS: {
                    uri = String.valueOf(uri) + _BUILD_LOGS;
                }
            }
            attr.setValue(uri);
            attr = rdfDescription.setAttributeNodeNS(attr);
            if (attr == null) {
                if (node != null) {
                    node = rdfRdf.appendChild(rdfDescription);
                }
                switch (xmlType) {
                    case FULL: {
                        BuildMapUtil.addBuildAttributes(buildMap, document, rdfDescription, xmlType);
                        BuildMapUtil.addInputsAttributes(buildMap, document, rdfDescription, rdfRdf, xmlType);
                        BuildMapUtil.addOutputsAttributes(buildMap, document, rdfDescription, rdfRdf, xmlType);
                        BuildMapUtil.addParserOutputsAttributes(buildMap, document, rdfDescription, rdfRdf, xmlType);
                        BuildMapUtil.addBuildLogsAttributes(buildMap, document, rdfDescription, rdfRdf, xmlType);
                        break;
                    }
                    case BUILD: {
                        BuildMapUtil.addBuildAttributes(buildMap, document, rdfDescription, xmlType, revisionIDs);
                        break;
                    }
                    case INPUTS: {
                        BuildMapUtil.addInputsAttributes(buildMap, document, rdfDescription, rdfRdf, xmlType);
                        break;
                    }
                    case OUTPUTS: {
                        BuildMapUtil.addOutputsAttributes(buildMap, document, rdfDescription, rdfRdf, xmlType);
                        break;
                    }
                    case PARSER_OUTPUTS: {
                        BuildMapUtil.addParserOutputsAttributes(buildMap, document, rdfDescription, rdfRdf, xmlType);
                        break;
                    }
                    case BUILD_LOGS: {
                        BuildMapUtil.addBuildLogsAttributes(buildMap, document, rdfDescription, rdfRdf, xmlType);
                    }
                }
                if (node == null) {
                    new Throwable().printStackTrace();
                }
            }
        }
        return document;
    }

    private static Element getBuildableFileUUIDElement(IBuildMap buildMap, Document document) {
        Element element = document.createElementNS(BUILDMAP_BUILDABLEFILE_UUID_TAG.getNamespace(), BUILDMAP_BUILDABLEFILE_UUID_TAG.getTagName());
        element.setPrefix(BUILDMAP_BUILDABLEFILE_UUID_TAG.getPrefix());
        element.setTextContent(buildMap.getBuildableFile());
        return element;
    }

    private static void addBuildAttributes(IBuildMap buildMap, Document document, Element element, IBuildMap.XmlType xmlType) {
        BuildMapUtil.addBuildAttributes(buildMap, document, element, xmlType, null);
    }

    private static void addBuildAttributes(IBuildMap buildMap, Document document, Element element, IBuildMap.XmlType xmlType, Map<String, String> revisionIDs) {
        IBuild build = buildMap.getBuild();
        Node node = null;
        node = element.appendChild(BuildMapUtil.getBuildableFileUUIDElement(buildMap, document));
        if (node != null) {
            node = element.appendChild(BuildMapUtil.getBuildDefinitionIdElement(build, document));
        }
        if (node != null) {
            node = element.appendChild(BuildMapUtil.getBuildResultUUIDElement(build, document));
        }
        if (node != null) {
            node = element.appendChild(BuildMapUtil.getBuildLabelElement(build, document));
        }
        if (node != null) {
            node = element.appendChild(BuildMapUtil.getWorkspaceUUIDElement(build, document));
        }
        if (node != null) {
            node = element.appendChild(BuildMapUtil.getSnapshotElement(build, document));
        }
        if (node != null) {
            node = element.appendChild(BuildMapUtil.getDatasetPrefixElement(build, document));
        }
        if (node != null) {
            node = element.appendChild(BuildMapUtil.getResourcePrefixElement(build, document));
        }
        if (node != null) {
            node = element.appendChild(BuildMapUtil.getLoadDirectoryElement(build, document));
        }
        if (node != null) {
            node = element.appendChild(BuildMapUtil.getSourceBuildMapSlugElement(build, document));
        }
        if (node != null) {
            node = element.appendChild(BuildMapUtil.getPromotionResultUUIDElement(build, document));
        }
        if (node != null) {
            node = element.appendChild(BuildMapUtil.getLanguageDefinitionUuid(build, document));
        }
        if (node != null) {
            node = element.appendChild(BuildMapUtil.getLanguageDefinitionName(build, document));
        }
        if (node != null) {
            node = element.appendChild(BuildMapUtil.getLanguageDefinitionStateId(build, document));
        }
        if (node != null) {
            node = element.appendChild(BuildMapUtil.getWorkItemsElement(build, document));
        }
        switch (xmlType) {
            case BUILD: {
                String revision;
                int idx;
                Object parserOutputs;
                Element revisionElement;
                String revision2;
                int idx2;
                Attr attr;
                if (!buildMap.getInputs().isEmpty()) {
                    String inputsUri = String.valueOf(buildMap.getUri()) + _INPUTS;
                    Element inputsElement = document.createElementNS(BUILDMAP_INPUTS_TAG.getNamespace(), BUILDMAP_INPUTS_TAG.getTagName());
                    inputsElement.setPrefix(BUILDMAP_INPUTS_TAG.getPrefix());
                    attr = document.createAttributeNS(RDF_RESOURCE_TAG.getNamespace(), RDF_RESOURCE_TAG.getTagName());
                    attr.setPrefix(RDF_RESOURCE_TAG.getPrefix());
                    attr.setValue(inputsUri);
                    attr = inputsElement.setAttributeNodeNS(attr);
                    element.appendChild(inputsElement);
                    if (revisionIDs != null && revisionIDs.containsKey(inputsUri) && (idx2 = (revision2 = revisionIDs.get(inputsUri)).lastIndexOf(REVISION_ID_PARAMETER)) != -1 && !(revision2 = revision2.substring(idx2 + REVISION_ID_PARAMETER.length()).trim()).isEmpty()) {
                        revisionElement = document.createElementNS(BUILDMAP_INPUTS_REVISION_TAG.getNamespace(), BUILDMAP_INPUTS_REVISION_TAG.getTagName());
                        revisionElement.setPrefix(BUILDMAP_INPUTS_REVISION_TAG.getPrefix());
                        revisionElement.setTextContent(revision2);
                        element.appendChild(revisionElement);
                    }
                }
                if (!buildMap.getOutputs().isEmpty()) {
                    String outputsUri = String.valueOf(buildMap.getUri()) + _OUTPUTS;
                    Element outputsElement = document.createElementNS(BUILDMAP_OUTPUTS_TAG.getNamespace(), BUILDMAP_OUTPUTS_TAG.getTagName());
                    outputsElement.setPrefix(BUILDMAP_OUTPUTS_TAG.getPrefix());
                    attr = document.createAttributeNS(RDF_RESOURCE_TAG.getNamespace(), RDF_RESOURCE_TAG.getTagName());
                    attr.setPrefix(RDF_RESOURCE_TAG.getPrefix());
                    attr.setValue(outputsUri);
                    attr = outputsElement.setAttributeNodeNS(attr);
                    element.appendChild(outputsElement);
                    if (revisionIDs != null && revisionIDs.containsKey(outputsUri) && (idx2 = (revision2 = revisionIDs.get(outputsUri)).lastIndexOf(REVISION_ID_PARAMETER)) != -1 && !(revision2 = revision2.substring(idx2 + REVISION_ID_PARAMETER.length()).trim()).isEmpty()) {
                        revisionElement = document.createElementNS(BUILDMAP_OUTPUTS_REVISION_TAG.getNamespace(), BUILDMAP_OUTPUTS_REVISION_TAG.getTagName());
                        revisionElement.setPrefix(BUILDMAP_OUTPUTS_REVISION_TAG.getPrefix());
                        revisionElement.setTextContent(revision2);
                        element.appendChild(revisionElement);
                    }
                }
                if ((parserOutputs = buildMap.getParserOutputs()) == null || !(parserOutputs instanceof Set) || ((Set)parserOutputs).isEmpty()) break;
                String parserOutputsUri = String.valueOf(buildMap.getUri()) + _PARSER_OUTPUTS;
                Element parserOutputsElement = document.createElementNS(BUILDMAP_PARSER_OUTPUTS_TAG.getNamespace(), BUILDMAP_PARSER_OUTPUTS_TAG.getTagName());
                parserOutputsElement.setPrefix(BUILDMAP_PARSER_OUTPUTS_TAG.getPrefix());
                Attr attr2 = document.createAttributeNS(RDF_RESOURCE_TAG.getNamespace(), RDF_RESOURCE_TAG.getTagName());
                attr2.setPrefix(RDF_RESOURCE_TAG.getPrefix());
                attr2.setValue(parserOutputsUri);
                attr2 = parserOutputsElement.setAttributeNodeNS(attr2);
                element.appendChild(parserOutputsElement);
                if (revisionIDs == null || !revisionIDs.containsKey(parserOutputsUri) || (idx = (revision = revisionIDs.get(parserOutputsUri)).lastIndexOf(REVISION_ID_PARAMETER)) == -1 || (revision = revision.substring(idx + REVISION_ID_PARAMETER.length()).trim()).isEmpty()) break;
                Element revisionElement2 = document.createElementNS(BUILDMAP_PARSER_OUTPUTS_REVISION_TAG.getNamespace(), BUILDMAP_PARSER_OUTPUTS_REVISION_TAG.getTagName());
                revisionElement2.setPrefix(BUILDMAP_PARSER_OUTPUTS_REVISION_TAG.getPrefix());
                revisionElement2.setTextContent(revision);
                element.appendChild(revisionElement2);
                break;
            }
        }
        if (node == null) {
            new Throwable().printStackTrace();
        }
    }

    private static Element getPropertyElementNS(TagWithNS tag, String datatype, Document document) {
        Element element = document.createElementNS(tag.getNamespace(), tag.getTagName());
        element.setPrefix(tag.getPrefix());
        return element;
    }

    private static Element getBuildDefinitionIdElement(IBuild build, Document document) {
        Element element = BuildMapUtil.getPropertyElementNS(BUILDMAP_BUILD_DEFINITION_UUID_TAG, XSD_STRING_TYPE, document);
        element.setTextContent(build.getBuildDefinitionUUID());
        return element;
    }

    private static Element getBuildResultUUIDElement(IBuild build, Document document) {
        Element element = BuildMapUtil.getPropertyElementNS(BUILDMAP_BUILD_RESULT_UUID_TAG, XSD_STRING_TYPE, document);
        element.setTextContent(build.getBuildResultUUID());
        return element;
    }

    private static Element getBuildLabelElement(IBuild build, Document document) {
        Element element = BuildMapUtil.getPropertyElementNS(BUILDMAP_BUILD_LABEL_TAG, XSD_STRING_TYPE, document);
        element.setTextContent(build.getBuildLabel());
        return element;
    }

    private static Element getWorkspaceUUIDElement(IBuild build, Document document) {
        Element element = BuildMapUtil.getPropertyElementNS(BUILDMAP_WORKSPACE_UUID_TAG, XSD_STRING_TYPE, document);
        element.setTextContent(build.getWorkspaceUUID());
        return element;
    }

    private static Element getSnapshotElement(IBuild build, Document document) {
        Element element = BuildMapUtil.getPropertyElementNS(BUILDMAP_SNAPSHOT_TAG, XSD_STRING_TYPE, document);
        element.setTextContent(build.getSnapshot());
        return element;
    }

    private static Element getDatasetPrefixElement(IBuild build, Document document) {
        Element element = BuildMapUtil.getPropertyElementNS(BUILDMAP_DATASET_PREFIX_TAG, XSD_STRING_TYPE, document);
        element.setTextContent(build.getDatasetPrefix());
        return element;
    }

    private static Element getResourcePrefixElement(IBuild build, Document document) {
        Element element = BuildMapUtil.getPropertyElementNS(BUILDMAP_RESOURCE_PREFIX_TAG, XSD_STRING_TYPE, document);
        element.setTextContent(build.getResourcetPrefix());
        return element;
    }

    private static Element getLoadDirectoryElement(IBuild build, Document document) {
        Element element = BuildMapUtil.getPropertyElementNS(BUILDMAP_LOAD_DIRECTORY_TAG, XSD_STRING_TYPE, document);
        element.setTextContent(build.getLoadDirectory());
        return element;
    }

    private static Element getSourceBuildMapSlugElement(IBuild build, Document document) {
        Element element = BuildMapUtil.getPropertyElementNS(BUILDMAP_SOURCE_BUILD_MAP_SLUG_TAG, XSD_STRING_TYPE, document);
        element.setTextContent(build.getSourceBuildMapSlug());
        return element;
    }

    private static Element getPromotionResultUUIDElement(IBuild build, Document document) {
        Element element = BuildMapUtil.getPropertyElementNS(BUILDMAP_PROMOTION_RESULT_UUID_TAG, XSD_STRING_TYPE, document);
        element.setTextContent(build.getPromotionResultUUID());
        return element;
    }

    private static Element getLanguageDefinitionStateId(IBuild build, Document document) {
        Element element = BuildMapUtil.getPropertyElementNS(BUILDMAP_LANGUAGE_DEFINITION_STATE_ID_TAG, XSD_STRING_TYPE, document);
        element.setTextContent(build.getLanguageDefinitionStateId());
        return element;
    }

    private static Element getLanguageDefinitionUuid(IBuild build, Document document) {
        Element element = BuildMapUtil.getPropertyElementNS(BUILDMAP_LANGUAGE_DEFINITION_UUID_TAG, XSD_STRING_TYPE, document);
        element.setTextContent(build.getLanguageDefinitionUuid());
        return element;
    }

    private static Element getLanguageDefinitionName(IBuild build, Document document) {
        Element element = BuildMapUtil.getPropertyElementNS(BUILDMAP_LANGUAGE_DEFINITION_NAME_TAG, XSD_STRING_TYPE, document);
        element.setTextContent(build.getLanguageDefinitionName());
        return element;
    }

    private static Element getWorkItemsElement(IBuild build, Document document) {
        Element element = BuildMapUtil.getPropertyElementNS(BUILDMAP_WORK_ITEMS_TAG, XSD_STRING_TYPE, document);
        Attr attr = document.createAttributeNS(RDF_PARSETYPE_TAG.getNamespace(), RDF_PARSETYPE_TAG.getTagName());
        attr.setPrefix(RDF_PARSETYPE_TAG.getPrefix());
        attr.setValue(RESOURCE);
        element.setAttributeNodeNS(attr);
        String[] wis = build.getWorkItems();
        if (wis != null) {
            String[] stringArray = wis;
            int n = wis.length;
            int n2 = 0;
            while (n2 < n) {
                String wi = stringArray[n2];
                Element wiElement = BuildMapUtil.getPropertyElementNS(BUILDMAP_WORK_ITEM_TAG, XSD_STRING_TYPE, document);
                wiElement.setTextContent(wi);
                element.appendChild(wiElement);
                ++n2;
            }
        }
        return element;
    }

    private static Element addInputsAttributes(IBuildMap buildMap, Document document, Element element, Element rdfRdf, IBuildMap.XmlType xmlType) {
        Element rdfDescription;
        switch (xmlType) {
            case FULL: {
                Element inputsElement = document.createElementNS(BUILDMAP_INPUTS_TAG.getNamespace(), BUILDMAP_INPUTS_TAG.getTagName());
                inputsElement.setPrefix(BUILDMAP_INPUTS_TAG.getPrefix());
                Attr attr = document.createAttributeNS(RDF_NODEID_TAG.getNamespace(), RDF_NODEID_TAG.getTagName());
                attr.setPrefix(RDF_NODEID_TAG.getPrefix());
                attr.setValue(INPUTS_NODE);
                attr = inputsElement.setAttributeNodeNS(attr);
                element.appendChild(inputsElement);
                rdfDescription = document.createElementNS(RDF_DESCRIPTION_TAG.getNamespace(), RDF_DESCRIPTION_TAG.getTagName());
                rdfDescription.setPrefix(RDF_DESCRIPTION_TAG.getPrefix());
                attr = document.createAttributeNS(RDF_NODEID_TAG.getNamespace(), RDF_NODEID_TAG.getTagName());
                attr.setPrefix(RDF_NODEID_TAG.getPrefix());
                attr.setValue(INPUTS_NODE);
                attr = rdfDescription.setAttributeNodeNS(attr);
                rdfRdf.appendChild(rdfDescription);
                break;
            }
            case INPUTS: {
                rdfDescription = element;
                break;
            }
            default: {
                rdfDescription = element;
            }
        }
        Set<IInput> inputSet = buildMap.getInputs();
        ArrayList<IBuildFile> buildFiles = new ArrayList<IBuildFile>();
        for (IInput input : inputSet) {
            IBuildArtifact artifact = input.getArtifact();
            if (artifact == null || !(artifact instanceof IBuildFile)) continue;
            buildFiles.add((IBuildFile)artifact);
        }
        if (!buildFiles.isEmpty()) {
            Collections.sort(buildFiles, new BuildFileComparator());
            for (IBuildFile file : buildFiles) {
                rdfDescription.appendChild(BuildMapUtil.getFileElement(file, document, IBuildMap.FileType.INPUTS));
            }
        }
        return element;
    }

    public static Element addOutputsAttributes(IBuildMap buildMap, Document document, Element element, Element rdfRdf, IBuildMap.XmlType xmlType) {
        Element rdfDescription;
        switch (xmlType) {
            case FULL: {
                Element outputsElement = document.createElementNS(BUILDMAP_OUTPUTS_TAG.getNamespace(), BUILDMAP_OUTPUTS_TAG.getTagName());
                outputsElement.setPrefix(BUILDMAP_OUTPUTS_TAG.getPrefix());
                Attr attr = document.createAttributeNS(RDF_NODEID_TAG.getNamespace(), RDF_NODEID_TAG.getTagName());
                attr.setPrefix(RDF_NODEID_TAG.getPrefix());
                attr.setValue(OUTPUTS_NODE);
                attr = outputsElement.setAttributeNodeNS(attr);
                element.appendChild(outputsElement);
                rdfDescription = document.createElementNS(RDF_DESCRIPTION_TAG.getNamespace(), RDF_DESCRIPTION_TAG.getTagName());
                rdfDescription.setPrefix(RDF_DESCRIPTION_TAG.getPrefix());
                attr = document.createAttributeNS(RDF_NODEID_TAG.getNamespace(), RDF_NODEID_TAG.getTagName());
                attr.setPrefix(RDF_NODEID_TAG.getPrefix());
                attr.setValue(OUTPUTS_NODE);
                attr = rdfDescription.setAttributeNodeNS(attr);
                rdfRdf.appendChild(rdfDescription);
                break;
            }
            case OUTPUTS: {
                rdfDescription = element;
                break;
            }
            default: {
                rdfDescription = element;
            }
        }
        Set<IOutput> outputSet = buildMap.getOutputs();
        ArrayList<IBuildFile> buildFiles = new ArrayList<IBuildFile>();
        for (IOutput output : outputSet) {
            IBuildArtifact artifact = output.getArtifact();
            if (artifact == null || !(artifact instanceof IBuildFile)) continue;
            buildFiles.add((IBuildFile)artifact);
        }
        if (!buildFiles.isEmpty()) {
            Collections.sort(buildFiles, new BuildFileComparator());
            for (IBuildFile file : buildFiles) {
                rdfDescription.appendChild(BuildMapUtil.getFileElement(file, document, IBuildMap.FileType.OUTPUTS));
            }
        }
        return element;
    }

    private static Element addParserOutputsAttributes(IBuildMap buildMap, Document document, Element element, Element rdfRdf, IBuildMap.XmlType xmlType) {
        Element rdfDescription;
        switch (xmlType) {
            case FULL: {
                Element parserOutputsElement = document.createElementNS(BUILDMAP_PARSER_OUTPUTS_TAG.getNamespace(), BUILDMAP_PARSER_OUTPUTS_TAG.getTagName());
                parserOutputsElement.setPrefix(BUILDMAP_PARSER_OUTPUTS_TAG.getPrefix());
                Attr attr = document.createAttributeNS(RDF_NODEID_TAG.getNamespace(), RDF_NODEID_TAG.getTagName());
                attr.setPrefix(RDF_NODEID_TAG.getPrefix());
                attr.setValue(PARSER_OUTPUTS_NODE);
                attr = parserOutputsElement.setAttributeNodeNS(attr);
                element.appendChild(parserOutputsElement);
                rdfDescription = document.createElementNS(RDF_DESCRIPTION_TAG.getNamespace(), RDF_DESCRIPTION_TAG.getTagName());
                rdfDescription.setPrefix(RDF_DESCRIPTION_TAG.getPrefix());
                attr = document.createAttributeNS(RDF_NODEID_TAG.getNamespace(), RDF_NODEID_TAG.getTagName());
                attr.setPrefix(RDF_NODEID_TAG.getPrefix());
                attr.setValue(PARSER_OUTPUTS_NODE);
                attr = rdfDescription.setAttributeNodeNS(attr);
                rdfRdf.appendChild(rdfDescription);
                break;
            }
            case PARSER_OUTPUTS: {
                rdfDescription = element;
                break;
            }
            default: {
                rdfDescription = element;
            }
        }
        Object parserOutputs = buildMap.getParserOutputs();
        ArrayList<IBuildFile> buildFiles = new ArrayList<IBuildFile>();
        if (parserOutputs != null && parserOutputs instanceof Set) {
            for (Object o : (Set)parserOutputs) {
                if (!(o instanceof IBuildFile)) continue;
                buildFiles.add((IBuildFile)o);
            }
        }
        if (!buildFiles.isEmpty()) {
            Collections.sort(buildFiles, new BuildFileComparator());
            for (IBuildFile file : buildFiles) {
                rdfDescription.appendChild(BuildMapUtil.getFileElement(file, document, IBuildMap.FileType.PARSER_OUTPUTS));
            }
        }
        return element;
    }

    private static Element addBuildLogsAttributes(IBuildMap buildMap, Document document, Element element, Element rdfRdf, IBuildMap.XmlType xmlType) {
        Element rdfDescription;
        switch (xmlType) {
            case FULL: {
                Element buildLogsElement = document.createElementNS(BUILDMAP_BUILD_LOGS_TAG.getNamespace(), BUILDMAP_BUILD_LOGS_TAG.getTagName());
                buildLogsElement.setPrefix(BUILDMAP_BUILD_LOGS_TAG.getPrefix());
                Attr attr = document.createAttributeNS(RDF_NODEID_TAG.getNamespace(), RDF_NODEID_TAG.getTagName());
                attr.setPrefix(RDF_NODEID_TAG.getPrefix());
                attr.setValue(BUILD_LOGS_NODE);
                attr = buildLogsElement.setAttributeNodeNS(attr);
                element.appendChild(buildLogsElement);
                rdfDescription = document.createElementNS(RDF_DESCRIPTION_TAG.getNamespace(), RDF_DESCRIPTION_TAG.getTagName());
                rdfDescription.setPrefix(RDF_DESCRIPTION_TAG.getPrefix());
                attr = document.createAttributeNS(RDF_NODEID_TAG.getNamespace(), RDF_NODEID_TAG.getTagName());
                attr.setPrefix(RDF_NODEID_TAG.getPrefix());
                attr.setValue(BUILD_LOGS_NODE);
                attr = rdfDescription.setAttributeNodeNS(attr);
                rdfRdf.appendChild(rdfDescription);
                break;
            }
            case BUILD_LOGS: {
                rdfDescription = element;
                break;
            }
            default: {
                rdfDescription = element;
            }
        }
        Set<IOutput> outputSet = buildMap.getLogs();
        ArrayList<IBuildFile> buildFiles = new ArrayList<IBuildFile>();
        for (IOutput output : outputSet) {
            IBuildArtifact artifact = output.getArtifact();
            if (artifact == null || !(artifact instanceof IBuildFile)) continue;
            buildFiles.add((IBuildFile)artifact);
        }
        if (!buildFiles.isEmpty()) {
            Collections.sort(buildFiles, new BuildFileComparator());
            for (IBuildFile file : buildFiles) {
                rdfDescription.appendChild(BuildMapUtil.getFileElement(file, document, IBuildMap.FileType.BUILD_LOGS));
            }
        }
        return element;
    }

    public static Element getFileElement(IBuildFile file, Document document, IBuildMap.FileType fileType) {
        Element element;
        switch (fileType) {
            case INPUTS: {
                element = document.createElementNS(INPUTS_FILE_TAG.getNamespace(), INPUTS_FILE_TAG.getTagName());
                element.setPrefix(INPUTS_FILE_TAG.getPrefix());
                break;
            }
            case OUTPUTS: {
                element = document.createElementNS(OUTPUTS_FILE_TAG.getNamespace(), OUTPUTS_FILE_TAG.getTagName());
                element.setPrefix(OUTPUTS_FILE_TAG.getPrefix());
                break;
            }
            case BUILD_LOGS: {
                element = document.createElementNS(BUILD_LOGS_FILE_TAG.getNamespace(), BUILD_LOGS_FILE_TAG.getTagName());
                element.setPrefix(BUILD_LOGS_FILE_TAG.getPrefix());
                break;
            }
            default: {
                element = document.createElementNS(PARSER_OUTPUTS_FILE_TAG.getNamespace(), PARSER_OUTPUTS_FILE_TAG.getTagName());
                element.setPrefix(PARSER_OUTPUTS_FILE_TAG.getPrefix());
            }
        }
        Attr attr = document.createAttributeNS(RDF_PARSETYPE_TAG.getNamespace(), RDF_PARSETYPE_TAG.getTagName());
        attr.setPrefix(RDF_PARSETYPE_TAG.getPrefix());
        attr.setValue(RESOURCE);
        attr = element.setAttributeNodeNS(attr);
        Node node = element;
        if (node != null && file.getType() != null && file.getType().length() > 0) {
            node = element.appendChild(BuildMapUtil.getTypeElement(file, document, fileType));
        }
        if (node != null && file.getMemberName() != null && file.getMemberName().length() > 0) {
            node = element.appendChild(BuildMapUtil.getMemberNameElement(file, document, fileType));
        }
        if (node != null && file.getModule() != null && file.getModule().length() > 0) {
            node = element.appendChild(BuildMapUtil.getModuleNameElement(file, document, fileType));
        }
        if (node != null && file.getServiceProgram() != null && file.getServiceProgram().length() > 0) {
            node = element.appendChild(BuildMapUtil.getServiceProgramNameElement(file, document, fileType));
        }
        if (node != null && file.getComponentName() != null && file.getComponentName().length() > 0) {
            node = element.appendChild(BuildMapUtil.getComponentNameElement(file, document, fileType));
        }
        if (node != null && file.getComponentUUID() != null && file.getComponentUUID().length() > 0) {
            node = element.appendChild(BuildMapUtil.getComponentUUIDElement(file, document, fileType));
        }
        if (node != null && file.getProjectName() != null && file.getProjectName().length() > 0) {
            node = element.appendChild(BuildMapUtil.getProjectNameElement(file, document, fileType));
        }
        if (node != null && file.getPathName() != null && file.getPathName().length() > 0) {
            node = element.appendChild(BuildMapUtil.getPathNameElement(file, document, fileType));
        }
        if (node != null && file.getTimestamp() != 0L) {
            node = element.appendChild(BuildMapUtil.getTimestampElement(file, document, fileType));
        }
        if (node != null && file.getFileUUID() != null && file.getFileUUID().length() > 0) {
            node = element.appendChild(BuildMapUtil.getFileUUIDElement(file, document, fileType));
        }
        if (node != null && file.getFileStateUUID() != null && file.getFileStateUUID().length() > 0) {
            node = element.appendChild(BuildMapUtil.getFileStateUUIDElement(file, document, fileType));
        }
        if (node != null && file.getResourceDefinitionID() != null && file.getResourceDefinitionID().length() > 0) {
            node = element.appendChild(BuildMapUtil.getResourceDefinitionIDelement(file, document, fileType));
        }
        if (node != null && file.getResourceDefinitionStateID() != null && file.getResourceDefinitionStateID().length() > 0) {
            node = element.appendChild(BuildMapUtil.getResourceDefinitionStateIDElement(file, document, fileType));
        }
        if (node != null && file.getBuildFile() != null && file.getBuildFile().length() > 0) {
            node = element.appendChild(BuildMapUtil.getBuildFileElement(file, document, fileType));
        }
        if (node != null && file.getBuildPath() != null && file.getBuildPath().length() > 0) {
            node = element.appendChild(BuildMapUtil.getBuildPathElement(file, document, fileType));
        }
        if (node != null && fileType != IBuildMap.FileType.BUILD_LOGS && file.getPromotionBuildPath() != null && file.getPromotionBuildPath().length() > 0) {
            node = element.appendChild(BuildMapUtil.getPromotionBuildPathElement(file, document, fileType));
        }
        if (node != null && file.getInputType() != null && file.getInputType().length() > 0) {
            node = element.appendChild(BuildMapUtil.getInputTypeElement(file, document, fileType));
        }
        if (node != null && file.getOutputType() != null && file.getOutputType().length() > 0) {
            node = element.appendChild(BuildMapUtil.getOutputTypeElement(file, document, fileType));
        }
        if (node != null && file.getSCMLocation() != null && file.getSCMLocation().length() > 0) {
            node = element.appendChild(BuildMapUtil.getSCMLocationElement(file, document, fileType));
        }
        if (node != null && file.getSequential() != null && file.getSequential().length() > 0) {
            node = element.appendChild(BuildMapUtil.getFileSequentialElement(file, document, fileType));
        }
        if (node != null && file.isHFS()) {
            node = element.appendChild(BuildMapUtil.getFileHFSElement(file, document, fileType));
        }
        if (node != null && file.getDeployType() != null && file.getDeployType().length() > 0) {
            node = element.appendChild(BuildMapUtil.getDeployTypeElement(file, document, fileType));
        }
        if (!(node == null || fileType != IBuildMap.FileType.BUILD_LOGS && file.isUsedAsInput())) {
            node = element.appendChild(BuildMapUtil.getUsedAsInputElement(file, document, fileType));
        }
        if (node != null && fileType == IBuildMap.FileType.BUILD_LOGS && file.getResourceName() != null && file.getResourceName().length() > 0) {
            node = element.appendChild(BuildMapUtil.getHOSTElement(file, document));
        }
        if (node != null && fileType == IBuildMap.FileType.BUILD_LOGS && file.getDataSetDefinitionUUID() != null && file.getDataSetDefinitionUUID().length() > 0) {
            node = element.appendChild(BuildMapUtil.getTranslatorUUIDElement(file, document));
        }
        if (node != null && fileType == IBuildMap.FileType.BUILD_LOGS && file.getDataSetDefinitionStateUUID() != null && file.getDataSetDefinitionStateUUID().length() > 0) {
            node = element.appendChild(BuildMapUtil.getTranslatorStateUUIDElement(file, document));
        }
        if (node != null && file.getResolvedTo() != null && file.getResolvedTo().length() > 0) {
            node = element.appendChild(BuildMapUtil.getResolvedToElement(file, document, fileType));
        }
        if (node == null) {
            new Throwable().printStackTrace();
        }
        return element;
    }

    private static Node getTranslatorStateUUIDElement(IBuildFile file, Document document) {
        Element element = BuildMapUtil.getPropertyElementNS(BUILD_LOGS_TRANSLATOR_STATE_ID_TAG, XSD_STRING_TYPE, document);
        element.setTextContent(file.getDataSetDefinitionStateUUID());
        return element;
    }

    private static Node getTranslatorUUIDElement(IBuildFile file, Document document) {
        Element element = BuildMapUtil.getPropertyElementNS(BUILD_LOGS_TRANSLATOR_ID_TAG, XSD_STRING_TYPE, document);
        element.setTextContent(file.getDataSetDefinitionUUID());
        return element;
    }

    private static Element getBuildFileElement(IBuildFile file, Document document, IBuildMap.FileType fileType) {
        Element element;
        switch (fileType) {
            case INPUTS: {
                element = BuildMapUtil.getPropertyElementNS(INPUTS_BUILD_FILE_TAG, XSD_STRING_TYPE, document);
                break;
            }
            case OUTPUTS: {
                element = BuildMapUtil.getPropertyElementNS(OUTPUTS_BUILD_FILE_TAG, XSD_STRING_TYPE, document);
                break;
            }
            case BUILD_LOGS: {
                element = BuildMapUtil.getPropertyElementNS(BUILD_LOGS_LOG_FILE_TAG, XSD_STRING_TYPE, document);
                break;
            }
            default: {
                element = BuildMapUtil.getPropertyElementNS(PARSER_OUTPUTS_BUILD_FILE_TAG, XSD_STRING_TYPE, document);
            }
        }
        element.setTextContent(file.getBuildFile());
        return element;
    }

    private static Element getBuildPathElement(IBuildFile file, Document document, IBuildMap.FileType fileType) {
        Element element;
        switch (fileType) {
            case INPUTS: {
                element = BuildMapUtil.getPropertyElementNS(INPUTS_BUILD_PATH_TAG, XSD_STRING_TYPE, document);
                break;
            }
            case OUTPUTS: {
                element = BuildMapUtil.getPropertyElementNS(OUTPUTS_BUILD_PATH_TAG, XSD_STRING_TYPE, document);
                break;
            }
            case BUILD_LOGS: {
                element = BuildMapUtil.getPropertyElementNS(BUILD_LOGS_LOG_PATH_TAG, XSD_STRING_TYPE, document);
                break;
            }
            default: {
                element = BuildMapUtil.getPropertyElementNS(PARSER_OUTPUTS_BUILD_PATH_TAG, XSD_STRING_TYPE, document);
            }
        }
        element.setTextContent(file.getBuildPath());
        return element;
    }

    private static Element getPromotionBuildPathElement(IBuildFile file, Document document, IBuildMap.FileType fileType) {
        Element element;
        switch (fileType) {
            case INPUTS: {
                element = BuildMapUtil.getPropertyElementNS(INPUTS_PROMOTION_BUILD_PATH_TAG, XSD_STRING_TYPE, document);
                break;
            }
            case OUTPUTS: {
                element = BuildMapUtil.getPropertyElementNS(OUTPUTS_PROMOTION_BUILD_PATH_TAG, XSD_STRING_TYPE, document);
                break;
            }
            default: {
                element = BuildMapUtil.getPropertyElementNS(PARSER_OUTPUTS_PROMOTION_BUILD_PATH_TAG, XSD_STRING_TYPE, document);
            }
        }
        element.setTextContent(file.getPromotionBuildPath());
        return element;
    }

    private static Element getInputTypeElement(IBuildFile file, Document document, IBuildMap.FileType fileType) {
        Element element;
        switch (fileType) {
            case INPUTS: {
                element = BuildMapUtil.getPropertyElementNS(INPUTS_INPUT_TYPE_TAG, XSD_STRING_TYPE, document);
                break;
            }
            case OUTPUTS: {
                element = BuildMapUtil.getPropertyElementNS(OUTPUTS_INPUT_TYPE_TAG, XSD_STRING_TYPE, document);
                break;
            }
            case BUILD_LOGS: {
                element = BuildMapUtil.getPropertyElementNS(BUILD_LOGS_DD_INDEX_TAG, XSD_STRING_TYPE, document);
                break;
            }
            default: {
                element = BuildMapUtil.getPropertyElementNS(PARSER_OUTPUTS_INPUT_TYPE_TAG, XSD_STRING_TYPE, document);
            }
        }
        element.setTextContent(file.getInputType());
        return element;
    }

    private static Element getOutputTypeElement(IBuildFile file, Document document, IBuildMap.FileType fileType) {
        Element element;
        switch (fileType) {
            case OUTPUTS: {
                element = BuildMapUtil.getPropertyElementNS(OUTPUTS_OUTPUT_TYPE_TAG, XSD_STRING_TYPE, document);
                break;
            }
            case INPUTS: {
                element = BuildMapUtil.getPropertyElementNS(INPUTS_OUTPUT_TYPE_TAG, XSD_STRING_TYPE, document);
                break;
            }
            case BUILD_LOGS: {
                element = BuildMapUtil.getPropertyElementNS(BUILD_LOGS_OUTPUT_TYPE_TAG, XSD_STRING_TYPE, document);
                break;
            }
            default: {
                element = BuildMapUtil.getPropertyElementNS(PARSER_OUTPUTS_OUTPUT_TYPE_TAG, XSD_STRING_TYPE, document);
            }
        }
        element.setTextContent(file.getOutputType());
        return element;
    }

    private static Element getSCMLocationElement(IBuildFile file, Document document, IBuildMap.FileType fileType) {
        Element element;
        switch (fileType) {
            case INPUTS: {
                element = BuildMapUtil.getPropertyElementNS(INPUTS_SCM_LOCATION_TAG, XSD_STRING_TYPE, document);
                break;
            }
            case OUTPUTS: {
                element = BuildMapUtil.getPropertyElementNS(OUTPUTS_SCM_LOCATION_TAG, XSD_STRING_TYPE, document);
                break;
            }
            default: {
                element = BuildMapUtil.getPropertyElementNS(PARSER_OUTPUTS_SCM_LOCATION_TAG, XSD_STRING_TYPE, document);
            }
        }
        element.setTextContent(file.getSCMLocation());
        return element;
    }

    private static Element getTypeElement(IBuildFile file, Document document, IBuildMap.FileType fileType) {
        Element element;
        switch (fileType) {
            case INPUTS: {
                element = BuildMapUtil.getPropertyElementNS(INPUTS_TYPE_TAG, XSD_STRING_TYPE, document);
                break;
            }
            case OUTPUTS: {
                element = BuildMapUtil.getPropertyElementNS(OUTPUTS_TYPE_TAG, XSD_STRING_TYPE, document);
                break;
            }
            default: {
                element = BuildMapUtil.getPropertyElementNS(PARSER_OUTPUTS_TYPE_TAG, XSD_STRING_TYPE, document);
            }
        }
        element.setTextContent(file.getType());
        return element;
    }

    private static Element getMemberNameElement(IBuildFile file, Document document, IBuildMap.FileType fileType) {
        Element element;
        switch (fileType) {
            case INPUTS: {
                element = BuildMapUtil.getPropertyElementNS(INPUTS_MEMBER_NAME_TAG, XSD_STRING_TYPE, document);
                break;
            }
            case OUTPUTS: {
                element = BuildMapUtil.getPropertyElementNS(OUTPUTS_MEMBER_NAME_TAG, XSD_STRING_TYPE, document);
                break;
            }
            default: {
                element = BuildMapUtil.getPropertyElementNS(PARSER_OUTPUTS_MEMBER_NAME_TAG, XSD_STRING_TYPE, document);
            }
        }
        element.setTextContent(file.getMemberName());
        return element;
    }

    private static Element getModuleNameElement(IBuildFile file, Document document, IBuildMap.FileType fileType) {
        Element element;
        switch (fileType) {
            case INPUTS: {
                element = BuildMapUtil.getPropertyElementNS(INPUTS_MODULE_NAME_TAG, XSD_STRING_TYPE, document);
                break;
            }
            case OUTPUTS: {
                element = BuildMapUtil.getPropertyElementNS(OUTPUTS_MODULE_NAME_TAG, XSD_STRING_TYPE, document);
                break;
            }
            default: {
                element = BuildMapUtil.getPropertyElementNS(PARSER_OUTPUTS_MODULE_NAME_TAG, XSD_STRING_TYPE, document);
            }
        }
        element.setTextContent(file.getModule());
        return element;
    }

    private static Element getServiceProgramNameElement(IBuildFile file, Document document, IBuildMap.FileType fileType) {
        Element element;
        switch (fileType) {
            case INPUTS: {
                element = BuildMapUtil.getPropertyElementNS(INPUTS_SERVICE_PROGRAM_NAME_TAG, XSD_STRING_TYPE, document);
                break;
            }
            case OUTPUTS: {
                element = BuildMapUtil.getPropertyElementNS(OUTPUTS_SERVICE_PROGRAM_NAME_TAG, XSD_STRING_TYPE, document);
                break;
            }
            default: {
                element = BuildMapUtil.getPropertyElementNS(PARSER_OUTPUTS_SERVICE_PROGRAM_NAME_TAG, XSD_STRING_TYPE, document);
            }
        }
        element.setTextContent(file.getServiceProgram());
        return element;
    }

    private static Element getComponentNameElement(IBuildFile file, Document document, IBuildMap.FileType fileType) {
        Element element;
        switch (fileType) {
            case INPUTS: {
                element = BuildMapUtil.getPropertyElementNS(INPUTS_COMPONENT_NAME_TAG, XSD_STRING_TYPE, document);
                break;
            }
            case OUTPUTS: {
                element = BuildMapUtil.getPropertyElementNS(OUTPUTS_COMPONENT_NAME_TAG, XSD_STRING_TYPE, document);
                break;
            }
            default: {
                element = BuildMapUtil.getPropertyElementNS(PARSER_OUTPUTS_COMPONENT_NAME_TAG, XSD_STRING_TYPE, document);
            }
        }
        element.setTextContent(file.getComponentName());
        return element;
    }

    private static Element getComponentUUIDElement(IBuildFile file, Document document, IBuildMap.FileType fileType) {
        Element element;
        switch (fileType) {
            case INPUTS: {
                element = BuildMapUtil.getPropertyElementNS(INPUTS_COMPONENT_UUID_TAG, XSD_STRING_TYPE, document);
                break;
            }
            case OUTPUTS: {
                element = BuildMapUtil.getPropertyElementNS(OUTPUTS_COMPONENT_UUID_TAG, XSD_STRING_TYPE, document);
                break;
            }
            default: {
                element = BuildMapUtil.getPropertyElementNS(PARSER_OUTPUTS_COMPONENT_UUID_TAG, XSD_STRING_TYPE, document);
            }
        }
        element.setTextContent(file.getComponentUUID());
        return element;
    }

    private static Element getProjectNameElement(IBuildFile file, Document document, IBuildMap.FileType fileType) {
        Element element;
        switch (fileType) {
            case INPUTS: {
                element = BuildMapUtil.getPropertyElementNS(INPUTS_PROJECT_NAME_TAG, XSD_STRING_TYPE, document);
                break;
            }
            case OUTPUTS: {
                element = BuildMapUtil.getPropertyElementNS(OUTPUTS_PROJECT_NAME_TAG, XSD_STRING_TYPE, document);
                break;
            }
            default: {
                element = BuildMapUtil.getPropertyElementNS(PARSER_OUTPUTS_PROJECT_NAME_TAG, XSD_STRING_TYPE, document);
            }
        }
        element.setTextContent(file.getProjectName());
        return element;
    }

    private static Element getPathNameElement(IBuildFile file, Document document, IBuildMap.FileType fileType) {
        Element element;
        switch (fileType) {
            case INPUTS: {
                element = BuildMapUtil.getPropertyElementNS(INPUTS_PATH_NAME_TAG, XSD_STRING_TYPE, document);
                break;
            }
            case OUTPUTS: {
                element = BuildMapUtil.getPropertyElementNS(OUTPUTS_PATH_NAME_TAG, XSD_STRING_TYPE, document);
                break;
            }
            default: {
                element = BuildMapUtil.getPropertyElementNS(PARSER_OUTPUTS_PATH_NAME_TAG, XSD_STRING_TYPE, document);
            }
        }
        element.setTextContent(file.getPathName());
        return element;
    }

    private static Element getFileSequentialElement(IBuildFile file, Document document, IBuildMap.FileType fileType) {
        Element element;
        switch (fileType) {
            case INPUTS: {
                element = BuildMapUtil.getPropertyElementNS(INPUTS_SEQUENTIAL_TAG, XSD_STRING_TYPE, document);
                break;
            }
            case OUTPUTS: {
                element = BuildMapUtil.getPropertyElementNS(OUTPUTS_SEQUENTIAL_TAG, XSD_STRING_TYPE, document);
                break;
            }
            case BUILD_LOGS: {
                element = BuildMapUtil.getPropertyElementNS(BUILD_LOGS_SEQUENTIAL_TAG, XSD_STRING_TYPE, document);
                break;
            }
            default: {
                element = BuildMapUtil.getPropertyElementNS(PARSER_OUTPUTS_SEQUENTIAL_TAG, XSD_STRING_TYPE, document);
            }
        }
        element.setTextContent(file.getSequential());
        return element;
    }

    private static Element getFileHFSElement(IBuildFile file, Document document, IBuildMap.FileType fileType) {
        Element element = BuildMapUtil.getPropertyElementNS(fileType == IBuildMap.FileType.INPUTS ? INPUTS_HFS_TAG : OUTPUTS_HFS_TAG, XSD_STRING_TYPE, document);
        element.setTextContent(Boolean.toString(file.isHFS()));
        return element;
    }

    public static Element getFileChangeElement(Document document, boolean changed) {
        Element element = BuildMapUtil.getPropertyElementNS(INPUTS_FILE_CHANGED_TAG, XSD_STRING_TYPE, document);
        if (changed) {
            element.setTextContent(TRUE);
        } else {
            element.setTextContent(FALSE);
        }
        return element;
    }

    private static Element getDeployTypeElement(IBuildFile file, Document document, IBuildMap.FileType fileType) {
        Element element;
        switch (fileType) {
            case INPUTS: {
                element = BuildMapUtil.getPropertyElementNS(INPUTS_DEPLOYTYPE_TAG, XSD_STRING_TYPE, document);
                break;
            }
            case OUTPUTS: {
                element = BuildMapUtil.getPropertyElementNS(OUTPUTS_DEPLOYTYPE_TAG, XSD_STRING_TYPE, document);
                break;
            }
            default: {
                element = BuildMapUtil.getPropertyElementNS(PARSER_OUTPUTS_DEPLOYTYPE_TAG, XSD_STRING_TYPE, document);
            }
        }
        element.setTextContent(file.getDeployType());
        return element;
    }

    private static Element getUsedAsInputElement(IBuildFile file, Document document, IBuildMap.FileType fileType) {
        Element element;
        switch (fileType) {
            case OUTPUTS: {
                element = BuildMapUtil.getPropertyElementNS(OUTPUTS_USEDASINPUT_TAG, XSD_STRING_TYPE, document);
                break;
            }
            case BUILD_LOGS: {
                element = BuildMapUtil.getPropertyElementNS(BUILD_LOGS_COMPACTED_TAG, XSD_STRING_TYPE, document);
                break;
            }
            default: {
                element = BuildMapUtil.getPropertyElementNS(OUTPUTS_USEDASINPUT_TAG, XSD_STRING_TYPE, document);
            }
        }
        element.setTextContent(Boolean.toString(file.isUsedAsInput()));
        return element;
    }

    private static Element getHOSTElement(IBuildFile file, Document document) {
        Element element = BuildMapUtil.getPropertyElementNS(BUILD_LOGS_HOST_NAME_TAG, XSD_STRING_TYPE, document);
        element.setTextContent(file.getResourceName());
        return element;
    }

    private static Element getTimestampElement(IBuildFile file, Document document, IBuildMap.FileType fileType) {
        Element element;
        switch (fileType) {
            case INPUTS: {
                element = BuildMapUtil.getPropertyElementNS(INPUTS_TIMESTAMP_TAG, XSD_LONG_TYPE, document);
                break;
            }
            case OUTPUTS: {
                element = BuildMapUtil.getPropertyElementNS(OUTPUTS_TIMESTAMP_TAG, XSD_LONG_TYPE, document);
                break;
            }
            case BUILD_LOGS: {
                element = BuildMapUtil.getPropertyElementNS(BUILD_LOGS_TIMESTAMP_TAG, XSD_LONG_TYPE, document);
                break;
            }
            default: {
                element = BuildMapUtil.getPropertyElementNS(PARSER_OUTPUTS_TIMESTAMP_TAG, XSD_LONG_TYPE, document);
            }
        }
        element.setTextContent(Long.toString(file.getTimestamp()));
        return element;
    }

    private static Element getFileUUIDElement(IBuildFile file, Document document, IBuildMap.FileType fileType) {
        Element element;
        switch (fileType) {
            case INPUTS: {
                element = BuildMapUtil.getPropertyElementNS(INPUTS_UUID_TAG, XSD_STRING_TYPE, document);
                break;
            }
            case OUTPUTS: {
                element = BuildMapUtil.getPropertyElementNS(OUTPUTS_UUID_TAG, XSD_STRING_TYPE, document);
                break;
            }
            default: {
                element = BuildMapUtil.getPropertyElementNS(PARSER_OUTPUTS_UUID_TAG, XSD_STRING_TYPE, document);
            }
        }
        element.setTextContent(file.getFileUUID());
        return element;
    }

    private static Element getFileStateUUIDElement(IBuildFile file, Document document, IBuildMap.FileType fileType) {
        Element element;
        switch (fileType) {
            case INPUTS: {
                element = BuildMapUtil.getPropertyElementNS(INPUTS_STATE_UUID_TAG, XSD_STRING_TYPE, document);
                break;
            }
            case OUTPUTS: {
                element = BuildMapUtil.getPropertyElementNS(OUTPUTS_STATE_UUID_TAG, XSD_STRING_TYPE, document);
                break;
            }
            default: {
                element = BuildMapUtil.getPropertyElementNS(PARSER_OUTPUTS_STATE_UUID_TAG, XSD_STRING_TYPE, document);
            }
        }
        element.setTextContent(file.getFileStateUUID());
        return element;
    }

    private static Element getResourceDefinitionIDelement(IBuildFile file, Document document, IBuildMap.FileType fileType) {
        Element element;
        switch (fileType) {
            case INPUTS: {
                element = BuildMapUtil.getPropertyElementNS(INPUTS_RESOURCE_DEFINITION_ID_TAG, XSD_STRING_TYPE, document);
                break;
            }
            case OUTPUTS: {
                element = BuildMapUtil.getPropertyElementNS(OUTPUTS_RESOURCE_DEFINITION_ID_TAG, XSD_STRING_TYPE, document);
                break;
            }
            case BUILD_LOGS: {
                element = BuildMapUtil.getPropertyElementNS(BUILD_LOGS_RESOURCE_DEFINITION_ID_TAG, XSD_STRING_TYPE, document);
                break;
            }
            default: {
                element = BuildMapUtil.getPropertyElementNS(PARSER_OUTPUTS_RESOURCE_DEFINITION_ID_TAG, XSD_STRING_TYPE, document);
            }
        }
        element.setTextContent(file.getResourceDefinitionID());
        return element;
    }

    private static Element getResourceDefinitionStateIDElement(IBuildFile file, Document document, IBuildMap.FileType fileType) {
        Element element;
        switch (fileType) {
            case INPUTS: {
                element = BuildMapUtil.getPropertyElementNS(INPUTS_RESOURCE_DEFINITION_STATE_ID_TAG, XSD_STRING_TYPE, document);
                break;
            }
            case OUTPUTS: {
                element = BuildMapUtil.getPropertyElementNS(OUTPUTS_RESOURCE_DEFINITION_STATE_ID_TAG, XSD_STRING_TYPE, document);
                break;
            }
            case BUILD_LOGS: {
                element = BuildMapUtil.getPropertyElementNS(BUILD_LOGS_RESOURCE_DEFINITION_STATE_ID_TAG, XSD_STRING_TYPE, document);
                break;
            }
            default: {
                element = BuildMapUtil.getPropertyElementNS(PARSER_OUTPUTS_RESOURCE_DEFINITION_STATE_ID_TAG, XSD_STRING_TYPE, document);
            }
        }
        element.setTextContent(file.getResourceDefinitionStateID());
        return element;
    }

    private static Element getResolvedToElement(IBuildFile file, Document document, IBuildMap.FileType fileType) {
        Element element;
        switch (fileType) {
            case INPUTS: {
                element = BuildMapUtil.getPropertyElementNS(INPUTS_RESOLVED_TO_TAG, XSD_STRING_TYPE, document);
                element.setTextContent(file.getResolvedTo());
                break;
            }
            default: {
                element = null;
            }
        }
        return element;
    }

    public static void main(String[] args) throws SAXException, ParserConfigurationException, TransformerConfigurationException, TransformerFactoryConfigurationError, TransformerException, IOException {
        File xml = new File("C:/tmp/buildmap.xml");
        IBuildMap buildMap = BuildMapUtil.createBuildMapFromRDFXML(xml);
        String xmlString = BuildMapUtil.getXmlString(buildMap);
        File outXml = new File("C:/tmp/buildmap_out.xml");
        FileOutputStream fos = new FileOutputStream(outXml);
        fos.write(xmlString.getBytes(UTF_8));
        fos.close();
        String xmlStringBuild = BuildMapUtil.getBuildXmlString(buildMap);
        File buildXml = new File("C:/tmp/buildmap_build.xml");
        fos = new FileOutputStream(buildXml);
        fos.write(xmlStringBuild.getBytes(UTF_8));
        fos.close();
        String xmlStringInputs = BuildMapUtil.getInputsXmlString(buildMap);
        File buildInputsXml = new File("/home/pierre/buildmap/buildmap_inputs.xml");
        fos = new FileOutputStream(buildInputsXml);
        fos.write(xmlStringInputs.getBytes(UTF_8));
        fos.close();
        String xmlStringOutputs = BuildMapUtil.getOutputsXmlString(buildMap);
        File buildOutputsXml = new File("/home/pierre/buildmap/buildmap_outputs.xml");
        fos = new FileOutputStream(buildOutputsXml);
        fos.write(xmlStringOutputs.getBytes(UTF_8));
        fos.close();
        String xmlStringParserOutputs = BuildMapUtil.getParserOutputsXmlString(buildMap);
        File buildParserOutputsXml = new File("/home/pierre/buildmap/buildmap_parserOutputs.xml");
        fos = new FileOutputStream(buildParserOutputsXml);
        fos.write(xmlStringParserOutputs.getBytes(UTF_8));
        fos.close();
        IBuildMap bm = BuildMapUtil.createBuildMapBuildFromRDFXML(xmlStringBuild);
        Set<IInput> inputs = BuildMapUtil.createBuildMapInputsFromRDFXML(xmlStringInputs);
        Set<IOutput> outputs = BuildMapUtil.createBuildMapOutputsFromRDFXML(xmlStringOutputs);
        Object parserOutputs = BuildMapUtil.createBuildMapParserOutputsFromRDFXML(xmlStringParserOutputs);
        if (inputs != null) {
            bm.getInputs().addAll(inputs);
        }
        if (outputs != null) {
            bm.getOutputs().addAll(outputs);
        }
        if (parserOutputs != null) {
            bm.setParserOutputs(parserOutputs);
        }
        xmlString = BuildMapUtil.getXmlString(bm);
        File out2Xml = new File("/home/pierre/buildmap/buildmap_out2.xml");
        fos = new FileOutputStream(out2Xml);
        fos.write(xmlString.getBytes(UTF_8));
        fos.close();
        System.out.println("done");
    }
}

