/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.buildmap.common.util;

import com.ibm.team.enterprise.build.buildmap.common.BuildMapUnsupportedQueryException;
import com.ibm.team.enterprise.build.buildmap.common.model.query.BaseBuildMapQueryModel;
import com.ibm.team.enterprise.build.buildmap.common.nls.Messages;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.query.IDataQuery;
import com.ibm.team.repository.common.query.IDataQueryPage;
import com.ibm.team.repository.common.query.IDataRow;
import com.ibm.team.repository.common.query.ast.IPredicate;
import com.ibm.team.repository.common.query.ast.IQueryModel;
import com.ibm.team.repository.common.query.ast.ISelectionElement;
import com.ibm.team.repository.common.query.ast.IUUID;
import com.ibm.team.repository.common.service.IQueryService;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public class BuildMapSPARQLConversionUtil {
    public static String convertAndRunSPARQLQuery(String sparqlQuery, IQueryService queryService) throws BuildMapUnsupportedQueryException, TeamRepositoryException {
        List<Object> results = new ArrayList();
        if (BuildMapSPARQLConversionUtil.queryIsAddEditShiplistFilterQuery(sparqlQuery)) {
            results = BuildMapSPARQLConversionUtil.runAddEditShiplistFilterQuery(sparqlQuery, queryService);
        } else if (BuildMapSPARQLConversionUtil.queryIsPackagingNonSequentialConfigurationQuery(sparqlQuery)) {
            results = BuildMapSPARQLConversionUtil.runPackagingNonSequentialConfigurationQuery(sparqlQuery, queryService);
        } else {
            throw new BuildMapUnsupportedQueryException(Messages.bind((String)Messages.QueryNotSupported, (Object)sparqlQuery));
        }
        return BuildMapSPARQLConversionUtil.createATOMFeed(results);
    }

    private static boolean queryIsPackagingNonSequentialConfigurationQuery(String query) {
        boolean rc = false;
        if (query.contains("SELECT ?resourcePrefix ?buildPath") && query.contains("?resource buildmap:resourcePrefix ?resourcePrefix") && query.contains("?resource buildmap:buildDefinitionUUID") && query.contains("?resource buildmap:outputs ?outputs") && query.contains("?outputs outputs:file ?file") && query.contains("?file outputs:buildPath ?buildPath")) {
            rc = true;
        } else if (query.contains("SELECT ?datasetPrefix ?dataSetName") && query.contains("?resource buildmap:datasetPrefix ?datasetPrefix") && query.contains("?resource buildmap:buildDefinitionUUID") && query.contains("?resource buildmap:outputs ?outputs") && query.contains("?file outputs:dataSetName ?dataSetName")) {
            rc = true;
        }
        return rc;
    }

    private static boolean queryIsAddEditShiplistFilterQuery(String query) {
        boolean rc = false;
        if (query.contains("SELECT ?resourcePrefix ?buildPath ?buildFile ?timestamp ?outputType") && query.contains("FILTER (fn:matches(?buildFile,") && query.contains("(fn:matches(?buildPath,") && query.contains("(fn:matches(?outputType,")) {
            rc = true;
        } else if (query.contains("SELECT ?resourcePrefix ?buildPath ?buildFile ?timestamp") && query.contains("FILTER ((fn:starts-with(?buildPath, \"${team.enterprise.scm.resourcePrefix}\") && fn:matches(fn:concat(?resourcePrefix, fn:substring(?buildPath")) {
            rc = true;
        }
        return rc;
    }

    private static List<Map<String, Object>> runPackagingNonSequentialConfigurationQuery(String sparqlQuery, IQueryService queryService) throws TeamRepositoryException {
        ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>();
        StringTokenizer tokens = new StringTokenizer(sparqlQuery, " ,\t\n\r\f\"");
        String buildDefinitionUUID = null;
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            if (!token.equals("buildmap:buildDefinitionUUID") || !tokens.hasMoreTokens()) continue;
            buildDefinitionUUID = tokens.nextToken();
            break;
        }
        if (buildDefinitionUUID == null) {
            throw new BuildMapUnsupportedQueryException(Messages.bind((String)Messages.QueryNotSupported, (Object)sparqlQuery));
        }
        IDataQueryPage page = BuildMapSPARQLConversionUtil.runAllOutputsQuery(buildDefinitionUUID, queryService);
        int index = 0;
        IDataRow row = null;
        while (index < page.getSize() || page.hasNext()) {
            if (index < page.getSize()) {
                row = page.getRow(index++);
            } else if (page.hasNext()) {
                page = (IDataQueryPage)queryService.fetchPage(page.getToken(), page.getNextStartPosition(), 512);
                index = 0;
                row = page.getRow(index++);
            }
            String resourcePrefix = row.getString(0);
            String buildPath = row.getString(1);
            HashMap<String, String> result = new HashMap<String, String>();
            if (sparqlQuery.contains("SELECT ?resourcePrefix ?buildPath")) {
                result.put("resourcePrefix", resourcePrefix);
                result.put("buildPath", buildPath);
            } else {
                result.put("datasetPrefix", resourcePrefix);
                result.put("dataSetName", buildPath);
            }
            results.add(result);
        }
        return results;
    }

    private static List<Map<String, Object>> runAddEditShiplistFilterQuery(String sparqlQuery, IQueryService queryService) throws TeamRepositoryException {
        ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>();
        boolean isIBMi = sparqlQuery.contains("?outputType");
        boolean inFilter = false;
        String buildDefinitionUUID = null;
        String buildFileFilter = null;
        String buildPathFilter = null;
        String typeFilter = null;
        StringTokenizer tokens = new StringTokenizer(sparqlQuery, " ,\t\n\r\f\"");
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            if (token.equals("buildmap:buildDefinitionUUID") && tokens.hasMoreTokens()) {
                buildDefinitionUUID = tokens.nextToken();
                continue;
            }
            if (token.equals("FILTER")) {
                inFilter = true;
                continue;
            }
            if (inFilter && (token.equals("(fn:matches(?buildFile") || token.equals("fn:matches(?buildFile")) && tokens.hasMoreTokens()) {
                buildFileFilter = tokens.nextToken();
                continue;
            }
            if (inFilter && (token.equals("(fn:matches(?buildPath") || token.equals("fn:matches(?buildPath")) && tokens.hasMoreTokens()) {
                buildPathFilter = tokens.nextToken();
                buildPathFilter = buildPathFilter.replace("\\\\.", "\\.");
                continue;
            }
            if (!inFilter || !token.equals("(fn:matches(?outputType") || !tokens.hasMoreTokens()) continue;
            typeFilter = tokens.nextToken();
        }
        Pattern correctedBuildPathFilter = null;
        Pattern correctedBuildFileFilter = null;
        Pattern correctedTypeFilter = null;
        if (buildPathFilter != null) {
            correctedBuildPathFilter = Pattern.compile(buildPathFilter);
        }
        if (buildFileFilter != null) {
            correctedBuildFileFilter = Pattern.compile(buildFileFilter);
        }
        if (typeFilter != null) {
            correctedTypeFilter = Pattern.compile(typeFilter);
        }
        if (buildDefinitionUUID == null) {
            throw new BuildMapUnsupportedQueryException(Messages.bind((String)Messages.QueryNotSupported, (Object)sparqlQuery));
        }
        IDataQueryPage page = BuildMapSPARQLConversionUtil.runAllOutputsQuery(buildDefinitionUUID, queryService);
        int index = 0;
        IDataRow row = null;
        while (index < page.getSize() || page.hasNext()) {
            HashMap<String, String> result;
            if (index < page.getSize()) {
                row = page.getRow(index++);
            } else if (page.hasNext()) {
                page = (IDataQueryPage)queryService.fetchPage(page.getToken(), page.getNextStartPosition(), 512);
                index = 0;
                row = page.getRow(index++);
            }
            String resourcePrefix = row.getString(0);
            String buildPath = row.getString(1);
            String buildFile = row.getString(2);
            Timestamp timestamp = row.getTimestamp(3);
            String type = row.getString(4);
            boolean sequential = row.getBoolean(5);
            if (isIBMi && correctedBuildFileFilter != null && correctedBuildFileFilter.matcher(buildFile).matches() && correctedBuildPathFilter != null && correctedBuildPathFilter.matcher(buildPath).matches() && correctedTypeFilter != null && correctedTypeFilter.matcher(type).matches()) {
                result = new HashMap();
                result.put("resourcePrefix", resourcePrefix);
                result.put("buildPath", buildPath);
                result.put("buildFile", buildFile);
                result.put("timestamp", Long.toString(timestamp.getTime()));
                result.put("outputType", type);
                results.add(result);
                continue;
            }
            if (isIBMi || correctedBuildPathFilter == null || !correctedBuildPathFilter.matcher(buildPath).matches()) continue;
            result = new HashMap<String, String>();
            result.put("resourcePrefix", resourcePrefix);
            result.put("buildPath", buildPath);
            result.put("buildFile", buildFile);
            result.put("sequential", Boolean.toString(sequential));
            result.put("timestamp", Long.toString(timestamp.getTime()));
            results.add(result);
        }
        return results;
    }

    private static IDataQueryPage runAllOutputsQuery(String buildDefinitionUUID, IQueryService queryService) throws TeamRepositoryException {
        BaseBuildMapQueryModel.BuildMapQueryModel model = BaseBuildMapQueryModel.BuildMapQueryModel.ROOT;
        IDataQuery dataQuery = (IDataQuery)IDataQuery.FACTORY.newInstance((IQueryModel)model);
        IPredicate filter = model.buildDefinition().itemId()._eq((IUUID)dataQuery.newUUIDArg())._and(model.temporary()._isFalse())._and(model.archived()._isFalse()._and(model.outputs().itemId()._isNull()._not()));
        dataQuery.filter(filter);
        dataQuery.select(new ISelectionElement[]{model.resourcePrefix(), model.outputs().buildPath(), model.outputs().buildFile(), model.outputs().timestamp(), model.outputs().outputType(), model.outputs().sequential()});
        return queryService.queryData(dataQuery, new Object[]{UUID.valueOf((String)buildDefinitionUUID)}, 512);
    }

    private static String createATOMFeed(List<Map<String, Object>> results) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        buffer.append("<feed xmlns=\"http://www.w3.org/2005/Atom\">\n");
        buffer.append("  <title>Converted Query Results</title>\n");
        buffer.append("  <generator>EWM-EE Buildmap Service</generator>\n");
        Iterator<Map<String, Object>> resultIterator = results.iterator();
        int counter = 0;
        while (resultIterator.hasNext()) {
            Map<String, Object> bindings = resultIterator.next();
            buffer.append("  <entry>\n");
            buffer.append("    <title>Result " + counter + "</title>\n");
            buffer.append("    <content type=\"application/sparql-results+xml\">");
            buffer.append("    <result xmlns=\"http://www.w3.org/2005/sparql-results#\">");
            ++counter;
            for (Map.Entry<String, Object> binding : bindings.entrySet()) {
                if (binding.getKey() == null || binding.getKey().length() <= 0 || binding.getValue() == null) continue;
                buffer.append("<binding name=\"" + binding.getKey() + "\">");
                Object value = binding.getValue();
                if (value instanceof String) {
                    buffer.append("<literal>" + (String)value + "</literal>");
                }
                buffer.append("</binding>");
            }
            buffer.append("\n");
            buffer.append("    </result>\n");
            buffer.append("    </content>\n");
            buffer.append("  </entry>\n");
        }
        buffer.append("</feed>");
        return buffer.toString();
    }
}

