/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.buildmap.common.util;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.enterprise.build.buildmap.common.model.BuildLog;
import com.ibm.team.enterprise.build.buildmap.common.model.IBuildFileHandle;
import com.ibm.team.enterprise.build.buildmap.common.model.IBuildLogHandle;
import com.ibm.team.enterprise.build.buildmap.common.model.IInputBuildFile;
import com.ibm.team.enterprise.build.buildmap.common.model.IOutputBuildFile;
import com.ibm.team.enterprise.internal.buildmap.common.IBuildFile;
import com.ibm.team.enterprise.internal.buildmap.common.IBuildMap;
import com.ibm.team.enterprise.internal.buildmap.common.IInput;
import com.ibm.team.enterprise.internal.buildmap.common.IOutput;
import com.ibm.team.enterprise.internal.buildmap.common.impl.BuildFile;
import com.ibm.team.enterprise.internal.buildmap.common.impl.BuildMap;
import com.ibm.team.enterprise.internal.buildmap.common.impl.Input;
import com.ibm.team.enterprise.internal.buildmap.common.impl.Output;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.internal.ComponentHandle;
import com.ibm.team.scm.common.internal.ScmFactory;
import com.ibm.team.scm.common.internal.VersionableHandle;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class BuildMapConversionUtil {
    public static com.ibm.team.enterprise.build.buildmap.common.model.IBuildMap convert(IBuildMap oldBuildMap) {
        com.ibm.team.enterprise.build.buildmap.common.model.IBuildMap bm = (com.ibm.team.enterprise.build.buildmap.common.model.IBuildMap)com.ibm.team.enterprise.build.buildmap.common.model.IBuildMap.ITEM_TYPE.createItem();
        return BuildMapConversionUtil.convert(bm, oldBuildMap);
    }

    public static com.ibm.team.enterprise.build.buildmap.common.model.IBuildMap convert(com.ibm.team.enterprise.build.buildmap.common.model.IBuildMap bm, IBuildMap oldBuildMap) {
        BuildMapConversionUtil.convertBuildMapContents(bm, oldBuildMap);
        BuildMapConversionUtil.convertBuildFiles(bm.getInputs(), oldBuildMap.getInputs(), IInputBuildFile.ITEM_TYPE);
        BuildMapConversionUtil.convertBuildFiles(bm.getOutputs(), oldBuildMap.getOutputs(), IOutputBuildFile.ITEM_TYPE);
        if (oldBuildMap.getParserOutputs() != null && oldBuildMap.getParserOutputs() instanceof Set) {
            BuildMapConversionUtil.convertBuildFiles(bm.getParserOutputs(), (Set)oldBuildMap.getParserOutputs(), IOutputBuildFile.ITEM_TYPE);
        } else {
            BuildMapConversionUtil.convertBuildFiles(bm.getParserOutputs(), new HashSet(), IOutputBuildFile.ITEM_TYPE);
        }
        return bm;
    }

    protected static void convertBuildMapContents(com.ibm.team.enterprise.build.buildmap.common.model.IBuildMap bm, IBuildMap obm) {
        String langDefStateID;
        String langDefUUID;
        if (obm.getBuildableFile() != null && !obm.getBuildableFile().isEmpty()) {
            VersionableHandle vh = ScmFactory.eINSTANCE.createVersionableHandle();
            vh.setItemId(UUID.valueOf((String)obm.getBuildableFile()));
            bm.setBuildableFile((IVersionableHandle)vh);
        }
        if (obm.getBuildDefinitionUUID() != null && !obm.getBuildDefinitionUUID().isEmpty()) {
            IBuildDefinitionHandle bd = (IBuildDefinitionHandle)IBuildDefinition.ITEM_TYPE.createItemHandle(UUID.valueOf((String)obm.getBuildDefinitionUUID()), null);
            bm.setBuildDefinition(bd);
        }
        if (obm.getBuildResultUUID() != null && !obm.getBuildResultUUID().isEmpty()) {
            IBuildResultHandle br = (IBuildResultHandle)IBuildResult.ITEM_TYPE.createItemHandle(UUID.valueOf((String)obm.getBuildResultUUID()), null);
            bm.setBuildResult(br);
        }
        if (obm.getWorkspaceUUID() != null && !obm.getWorkspaceUUID().isEmpty()) {
            IWorkspaceHandle w = (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(UUID.valueOf((String)obm.getWorkspaceUUID()), null);
            bm.setWorkspace(w);
        }
        if ((langDefUUID = obm.getBuild().getLanguageDefinitionUuid()) != null && !langDefUUID.isEmpty()) {
            bm.setLanguageDefinitionUUID(UUID.valueOf((String)langDefUUID));
        }
        if ((langDefStateID = obm.getBuild().getLanguageDefinitionStateId()) != null && !langDefStateID.isEmpty()) {
            bm.setLanguageDefinitionStateUUID(UUID.valueOf((String)langDefStateID));
        }
        bm.setBuildLabel(obm.getBuildLabel());
        bm.setFetchDestination(obm.getBuild().getLoadDirectory());
        bm.setPromotedSourceBuildMapSlug(obm.getBuild().getSourceBuildMapSlug());
        bm.setResourcePrefix(obm.getResourcePrefix());
        bm.setSnapshot(obm.getSnapshot());
    }

    protected static void convertBuildFileContents(com.ibm.team.enterprise.build.buildmap.common.model.IBuildFile bf, IBuildFile obf) {
        bf.setBuildFile(obf.getBuildFile());
        if (bf instanceof IOutputBuildFile) {
            bf.setBuildPath(obf.getBuildPath());
            if (obf.getResourceDefinitionID() != null && !obf.getResourceDefinitionID().isEmpty()) {
                ((IOutputBuildFile)bf).setResourceDefinitionUUID(UUID.valueOf((String)obf.getResourceDefinitionID()));
            }
            if (obf.getResourceDefinitionStateID() != null && !obf.getResourceDefinitionStateID().isEmpty()) {
                ((IOutputBuildFile)bf).setResourceDefinitionStateUUID(UUID.valueOf((String)obf.getResourceDefinitionStateID()));
            }
            ((IOutputBuildFile)bf).setTimestamp(new Timestamp(obf.getTimestamp()));
            String promoBuildPath = obf.getPromotionBuildPath();
            if (promoBuildPath.length() > 1000) {
                promoBuildPath = BuildMapConversionUtil.removeDuplicates(promoBuildPath);
            }
            ((IOutputBuildFile)bf).setPromotionBuildPath(promoBuildPath);
            ((IOutputBuildFile)bf).setType(obf.getType());
            ((IOutputBuildFile)bf).setOutputType(obf.getOutputType());
            ((IOutputBuildFile)bf).setSequential(obf.getSequential() != null && obf.getSequential().trim().equalsIgnoreCase("true"));
            ((IOutputBuildFile)bf).setHFS(obf.isHFS());
            ((IOutputBuildFile)bf).setDeployType(obf.getDeployType());
            ((IOutputBuildFile)bf).setConsumableAsSource(obf.isUsedAsInput());
            ((IOutputBuildFile)bf).setModule(obf.getModule());
            ((IOutputBuildFile)bf).setServiceProgram(obf.getServiceProgram());
        } else if (bf instanceof IInputBuildFile) {
            String buildPath = obf.getBuildPath();
            if (buildPath.length() > 1000) {
                buildPath = BuildMapConversionUtil.removeDuplicates(buildPath);
            }
            bf.setBuildPath(buildPath);
            if (obf.getComponentUUID() != null && !obf.getComponentUUID().isEmpty()) {
                ComponentHandle c = ScmFactory.eINSTANCE.createComponentHandle();
                c.setItemId(UUID.valueOf((String)obf.getComponentUUID()));
                ((IInputBuildFile)bf).setComponent((IComponentHandle)c);
            }
            if (obf.getFileUUID() != null && !obf.getFileUUID().isEmpty()) {
                VersionableHandle vh = ScmFactory.eINSTANCE.createVersionableHandle();
                vh.setItemId(UUID.valueOf((String)obf.getFileUUID()));
                if (obf.getFileStateUUID() != null && !obf.getFileStateUUID().isEmpty()) {
                    vh.setStateId(UUID.valueOf((String)obf.getFileStateUUID()));
                    ((IInputBuildFile)bf).setFileStateUUID(UUID.valueOf((String)obf.getFileStateUUID()));
                }
                ((IInputBuildFile)bf).setFile((IVersionableHandle)vh);
            }
            if (obf.getResourceDefinitionID() != null && !obf.getResourceDefinitionID().isEmpty()) {
                ((IInputBuildFile)bf).setResourceDefinitionUUID(UUID.valueOf((String)obf.getResourceDefinitionID()));
            }
            if (obf.getResourceDefinitionStateID() != null && !obf.getResourceDefinitionStateID().isEmpty()) {
                ((IInputBuildFile)bf).setResourceDefinitionStateUUID(UUID.valueOf((String)obf.getResourceDefinitionStateID()));
            }
            ((IInputBuildFile)bf).setModule(obf.getModule());
            ((IInputBuildFile)bf).setPathName(obf.getPathName());
            ((IInputBuildFile)bf).setSCMLocation(obf.getSCMLocation());
            ((IInputBuildFile)bf).setServiceProgram(obf.getServiceProgram());
            ((IInputBuildFile)bf).setTimestamp(new Timestamp(obf.getTimestamp()));
            String promoBuildPath = obf.getPromotionBuildPath();
            if (promoBuildPath.length() > 1000) {
                promoBuildPath = BuildMapConversionUtil.removeDuplicates(promoBuildPath);
            }
            ((IInputBuildFile)bf).setPromotionBuildPath(promoBuildPath);
            ((IInputBuildFile)bf).setType(obf.getType());
            ((IInputBuildFile)bf).setInputType(obf.getInputType());
            ((IInputBuildFile)bf).setHFS(obf.isHFS());
            ((IInputBuildFile)bf).setResolvedTo(obf.getResolvedTo());
        }
    }

    private static String removeDuplicates(String buildPath) {
        StringBuilder result = new StringBuilder();
        HashSet<String> entries = new HashSet<String>();
        int pos = 0;
        while (true) {
            int end;
            String entry;
            if (!entries.contains(entry = (end = buildPath.indexOf(58, pos)) >= 0 ? buildPath.substring(pos, end) : buildPath.substring(pos))) {
                entries.add(entry);
                if (result.length() > 0) {
                    result.append(":");
                }
                result.append(entry);
            }
            if (end < 0) break;
            pos = end + 1;
        }
        return result.toString();
    }

    public static <T extends IBuildFileHandle> void convertBuildFiles(List<T> target, Collection<?> source, IItemType type) {
        if (target.isEmpty()) {
            for (Object o : source) {
                IBuildFile obf = BuildMapConversionUtil.getOldBuildFile(o);
                if (obf == null) continue;
                com.ibm.team.enterprise.build.buildmap.common.model.IBuildFile bf = (com.ibm.team.enterprise.build.buildmap.common.model.IBuildFile)type.createItem();
                if (type.equals(IInputBuildFile.ITEM_TYPE) && (obf.getFileUUID() == null || obf.getFileUUID().isEmpty()) && (obf.getBuildFile() == null || obf.getBuildFile().isEmpty() || obf.getBuildPath() == null || obf.getBuildPath().isEmpty()) || type.equals(IOutputBuildFile.ITEM_TYPE) && (obf.getBuildFile() == null || obf.getBuildFile().isEmpty())) continue;
                BuildMapConversionUtil.convertBuildFileContents(bf, BuildMapConversionUtil.getOldBuildFile(obf));
                target.add(bf);
            }
        } else {
            com.ibm.team.enterprise.build.buildmap.common.model.IBuildFile bf;
            HashSet<String> keysToRemove = new HashSet<String>();
            HashMap<String, IBuildFile> temp = new HashMap<String, IBuildFile>(source.size());
            for (Object o : source) {
                String key;
                IBuildFile possibleCollision;
                IBuildFile obf = BuildMapConversionUtil.getOldBuildFile(o);
                if (obf == null || (possibleCollision = temp.put(key = BuildMapConversionUtil.getBuildFileKey(obf), obf)) == null) continue;
                keysToRemove.add(key);
                temp.put(BuildMapConversionUtil.getAlternateBuildFileKey(obf), obf);
                temp.put(BuildMapConversionUtil.getAlternateBuildFileKey(possibleCollision), possibleCollision);
            }
            temp.keySet().removeAll(keysToRemove);
            HashSet<IBuildFileHandle> toRemove = new HashSet<IBuildFileHandle>();
            int i = 0;
            while (i < target.size()) {
                IBuildFileHandle bfh = (IBuildFileHandle)target.get(i);
                if (bfh instanceof com.ibm.team.enterprise.build.buildmap.common.model.IBuildFile) {
                    bf = (com.ibm.team.enterprise.build.buildmap.common.model.IBuildFile)((com.ibm.team.enterprise.build.buildmap.common.model.IBuildFile)bfh).getWorkingCopy();
                    target.set(i, bf);
                    String key = BuildMapConversionUtil.getBuildFileKey(bf);
                    String altKey = BuildMapConversionUtil.getAlternateBuildFileKey(bf);
                    if (temp.containsKey(key)) {
                        BuildMapConversionUtil.convertBuildFileContents(bf, (IBuildFile)temp.get(key));
                        temp.remove(key);
                    } else if (temp.containsKey(altKey)) {
                        BuildMapConversionUtil.convertBuildFileContents(bf, (IBuildFile)temp.get(altKey));
                        temp.remove(altKey);
                    } else {
                        toRemove.add(bf);
                    }
                } else {
                    toRemove.add(bfh);
                }
                ++i;
            }
            target.removeAll(toRemove);
            for (IBuildFile obf : temp.values()) {
                bf = (com.ibm.team.enterprise.build.buildmap.common.model.IBuildFile)type.createItem();
                BuildMapConversionUtil.convertBuildFileContents(bf, obf);
                target.add(bf);
            }
        }
    }

    protected static IBuildFile getOldBuildFile(Object o) {
        if (o instanceof IOutput) {
            return (IBuildFile)((IOutput)o).getArtifact();
        }
        if (o instanceof IInput) {
            return (IBuildFile)((IInput)o).getArtifact();
        }
        if (o instanceof IBuildFile) {
            return (IBuildFile)o;
        }
        return null;
    }

    protected static String getBuildFileKey(com.ibm.team.enterprise.build.buildmap.common.model.IBuildFile bf) {
        if (bf instanceof IInputBuildFile && ((IInputBuildFile)bf).getFile() != null) {
            return ((IInputBuildFile)bf).getFile().getItemId().getUuidValue();
        }
        String key = String.valueOf(bf.getBuildPath()) + bf.getBuildFile();
        if (bf instanceof IOutputBuildFile && ((IOutputBuildFile)bf).getOutputType() != null && !((IOutputBuildFile)bf).getOutputType().isEmpty()) {
            key = String.valueOf(key) + ((IOutputBuildFile)bf).getOutputType();
        }
        return key;
    }

    protected static String getBuildFileKey(IBuildFile bf) {
        if (bf.getFileUUID() != null && !bf.getFileUUID().isEmpty()) {
            return bf.getFileUUID();
        }
        String key = String.valueOf(bf.getBuildPath()) + bf.getBuildFile();
        if (bf.getOutputType() != null && !bf.getOutputType().isEmpty()) {
            key = String.valueOf(key) + bf.getOutputType();
        }
        return key;
    }

    protected static String getAlternateBuildFileKey(com.ibm.team.enterprise.build.buildmap.common.model.IBuildFile bf) {
        String postScript = "altKey";
        if (bf instanceof IInputBuildFile && ((IInputBuildFile)bf).getType() != null) {
            IInputBuildFile ibf = (IInputBuildFile)bf;
            postScript = String.valueOf(postScript) + ibf.getType();
            if (ibf.getInputType() != null) {
                postScript = String.valueOf(postScript) + ibf.getInputType();
            }
        } else if (bf instanceof IOutputBuildFile && ((IOutputBuildFile)bf).getType() != null) {
            IOutputBuildFile obf = (IOutputBuildFile)bf;
            postScript = String.valueOf(postScript) + ((IOutputBuildFile)bf).getType();
            if (obf.getOutputType() != null) {
                postScript = String.valueOf(postScript) + obf.getOutputType();
            }
        }
        return String.valueOf(BuildMapConversionUtil.getBuildFileKey(bf)) + postScript;
    }

    protected static String getAlternateBuildFileKey(IBuildFile bf) {
        String postScript = "altKey";
        postScript = String.valueOf(postScript) + bf.getType();
        if (bf.getInputType() != null && !bf.getInputType().isEmpty()) {
            postScript = String.valueOf(postScript) + bf.getInputType();
        } else if (bf.getOutputType() != null && !bf.getOutputType().isEmpty()) {
            postScript = String.valueOf(postScript) + bf.getOutputType();
        }
        return String.valueOf(BuildMapConversionUtil.getBuildFileKey(bf)) + postScript;
    }

    public static IBuildMap convert(com.ibm.team.enterprise.build.buildmap.common.model.IBuildMap buildmap) {
        BuildMap convertedBm = new BuildMap();
        return BuildMapConversionUtil.convert(convertedBm, buildmap);
    }

    public static IBuildMap convert(IBuildMap convertedBuildmap, com.ibm.team.enterprise.build.buildmap.common.model.IBuildMap buildmap) {
        BuildMapConversionUtil.convertBuildMapContents(convertedBuildmap, buildmap);
        BuildMapConversionUtil.convertBuildFiles(convertedBuildmap.getInputs(), buildmap.getInputs());
        BuildMapConversionUtil.convertBuildFiles(convertedBuildmap.getOutputs(), buildmap.getOutputs());
        if (!buildmap.getParserOutputs().isEmpty()) {
            convertedBuildmap.setParserOutputs(new HashSet());
            BuildMapConversionUtil.convertBuildFiles((Set)convertedBuildmap.getParserOutputs(), buildmap.getParserOutputs(), false);
        }
        BuildMapConversionUtil.convertBuildLogs(convertedBuildmap.getLogs(), buildmap);
        return convertedBuildmap;
    }

    public static <T extends IBuildFileHandle, U> void convertBuildLogs(Set<IOutput> targetLogs, com.ibm.team.enterprise.build.buildmap.common.model.IBuildMap buildmap) {
        List<IBuildLogHandle> sourceLogs = buildmap.getLogs();
        for (IBuildLogHandle sourceLog : sourceLogs) {
            UUID translatorStateUUID;
            UUID translatorUUID;
            UUID resDefStateUUID;
            BuildFile obf = new BuildFile();
            if (!(sourceLog instanceof BuildLog)) continue;
            BuildLog sourceBuildLog = (BuildLog)sourceLog;
            obf.setBuildFile(sourceBuildLog.getLogFile());
            obf.setBuildPath(sourceBuildLog.getLogPath());
            obf.setUsedAsInput(sourceBuildLog.isCompacted());
            obf.setResourceName(sourceBuildLog.getHost());
            obf.setTimestamp(sourceBuildLog.getTimestamp().getTime());
            obf.setSequential(Boolean.toString(sourceBuildLog.isSequential()));
            obf.setOutputType(sourceBuildLog.getType());
            UUID resDefUUID = sourceBuildLog.getResourceDefinitionUUID();
            if (resDefUUID != null) {
                obf.setResourceDefinitionID(resDefUUID.getUuidValue());
            }
            if ((resDefStateUUID = sourceBuildLog.getResourceDefinitionStateUUID()) != null) {
                obf.setResourceDefinitionStateID(resDefStateUUID.getUuidValue());
            }
            if ((translatorUUID = sourceBuildLog.getTranslatorUUID()) != null) {
                obf.setDataSetDefinitionUUID(translatorUUID.getUuidValue());
            }
            if ((translatorStateUUID = sourceBuildLog.getTranslatorStateUUID()) != null) {
                obf.setDataSetDefinitionStateUUID(translatorStateUUID.getUuidValue());
            }
            obf.setInputType(String.valueOf(sourceBuildLog.getDdIndex()));
            targetLogs.add(new Output(obf));
        }
    }

    protected static void convertBuildMapContents(IBuildMap obm, com.ibm.team.enterprise.build.buildmap.common.model.IBuildMap bm) {
        UUID promotionResultUUID;
        UUID langDefStateUUID;
        UUID langDefUUID;
        if (bm.getBuildableFile() != null && bm.getBuildableFile().getItemId() != null) {
            obm.setBuildableFile(bm.getBuildableFile().getItemId().getUuidValue());
        }
        if (bm.getBuildDefinition() != null && bm.getBuildDefinition().getItemId() != null) {
            obm.setBuildDefinitionUUID(bm.getBuildDefinition().getItemId().getUuidValue());
        }
        if (bm.getBuildResult() != null && bm.getBuildResult().getItemId() != null) {
            obm.setBuildResultUUID(bm.getBuildResult().getItemId().getUuidValue());
        }
        if (bm.getWorkspace() != null && bm.getWorkspace().getItemId() != null) {
            obm.setWorkspaceUUID(bm.getWorkspace().getItemId().getUuidValue());
        }
        if ((langDefUUID = bm.getLanguageDefinitionUUID()) != null) {
            obm.getBuild().setLanguageDefinitionUuid(langDefUUID.getUuidValue());
        }
        if ((langDefStateUUID = bm.getLanguageDefinitionStateUUID()) != null) {
            obm.getBuild().setLanguageDefinitionStateId(langDefStateUUID.getUuidValue());
        }
        UUID uUID = promotionResultUUID = bm.getPromotionBuildResult() == null ? null : bm.getPromotionBuildResult().getItemId();
        if (promotionResultUUID != null) {
            obm.setPromotionResultUUID(promotionResultUUID.getUuidValue());
        }
        obm.setBuildLabel(bm.getBuildLabel());
        obm.getBuild().setLoadDirectory(bm.getFetchDestination());
        obm.getBuild().setSourceBuildMapSlug(bm.getPromotedSourceBuildMapSlug());
        obm.setResourcePrefix(bm.getResourcePrefix());
        obm.setSnapshot(bm.getSnapshot());
    }

    public static <T extends IBuildFileHandle, U> void convertBuildFiles(Set<U> target, List<T> source) {
        BuildMapConversionUtil.convertBuildFiles(target, source, true);
    }

    public static <T extends IBuildFileHandle, U> void convertBuildFiles(Set<U> target, List<T> source, boolean wrap) {
        for (IBuildFileHandle bf : source) {
            BuildFile obf = new BuildFile();
            BuildMapConversionUtil.convertBuildFileContents(obf, (com.ibm.team.enterprise.build.buildmap.common.model.IBuildFile)bf);
            if (wrap) {
                if (bf instanceof IInputBuildFile) {
                    target.add(new Input(obf));
                    continue;
                }
                if (!(bf instanceof IOutputBuildFile)) continue;
                target.add(new Output(obf));
                continue;
            }
            target.add(obf);
        }
    }

    protected static void convertBuildFileContents(IBuildFile obf, com.ibm.team.enterprise.build.buildmap.common.model.IBuildFile bf) {
        obf.setBuildFile(bf.getBuildFile());
        obf.setBuildPath(bf.getBuildPath());
        if (bf instanceof IOutputBuildFile) {
            if (((IOutputBuildFile)bf).getResourceDefinitionUUID() != null) {
                obf.setResourceDefinitionID(((IOutputBuildFile)bf).getResourceDefinitionUUID().getUuidValue());
            }
            if (((IOutputBuildFile)bf).getResourceDefinitionStateUUID() != null) {
                obf.setResourceDefinitionStateID(((IOutputBuildFile)bf).getResourceDefinitionStateUUID().getUuidValue());
            }
            obf.setTimestamp(((IOutputBuildFile)bf).getTimestamp().getTime());
            obf.setPromotionBuildPath(((IOutputBuildFile)bf).getPromotionBuildPath());
            obf.setType(((IOutputBuildFile)bf).getType());
            obf.setOutputType(((IOutputBuildFile)bf).getOutputType());
            obf.setSequential(Boolean.toString(((IOutputBuildFile)bf).isSequential()));
            obf.setHFS(bf.isHFS());
            obf.setDeployType(((IOutputBuildFile)bf).getDeployType());
            obf.setUsedAsInput(((IOutputBuildFile)bf).isConsumableAsSource());
            obf.setModule(BuildMapConversionUtil.getStringNotNull(((IOutputBuildFile)bf).getModule()));
            obf.setServiceProgram(((IOutputBuildFile)bf).getServiceProgram());
        } else if (bf instanceof IInputBuildFile) {
            if (((IInputBuildFile)bf).getComponent() != null && ((IInputBuildFile)bf).getComponent().getItemId() != null) {
                obf.setComponentUUID(((IInputBuildFile)bf).getComponent().getItemId().getUuidValue());
            }
            if (((IInputBuildFile)bf).getFile() != null && ((IInputBuildFile)bf).getFile().getItemId() != null) {
                obf.setFileUUID(((IInputBuildFile)bf).getFile().getItemId().getUuidValue());
                if (((IInputBuildFile)bf).getFileStateUUID() != null) {
                    obf.setFileStateUUID(((IInputBuildFile)bf).getFileStateUUID().getUuidValue());
                }
            }
            if (((IInputBuildFile)bf).getResourceDefinitionUUID() != null) {
                obf.setResourceDefinitionID(((IInputBuildFile)bf).getResourceDefinitionUUID().getUuidValue());
            }
            if (((IInputBuildFile)bf).getResourceDefinitionStateUUID() != null) {
                obf.setResourceDefinitionStateID(((IInputBuildFile)bf).getResourceDefinitionStateUUID().getUuidValue());
            }
            obf.setModule(BuildMapConversionUtil.getStringNotNull(((IInputBuildFile)bf).getModule()));
            obf.setPathName(BuildMapConversionUtil.getStringNotNull(((IInputBuildFile)bf).getPathName()));
            String scmLocation = ((IInputBuildFile)bf).getSCMLocation();
            if (scmLocation != null) {
                String projectName;
                obf.setSCMLocation(scmLocation);
                int projectInde = scmLocation.indexOf(47);
                if (projectInde > 0 && (projectName = scmLocation.substring(0, projectInde)) != null) {
                    obf.setProjectName(projectName);
                }
            }
            obf.setServiceProgram(((IInputBuildFile)bf).getServiceProgram());
            obf.setTimestamp(((IInputBuildFile)bf).getTimestamp().getTime());
            obf.setPromotionBuildPath(BuildMapConversionUtil.getStringNotNull(((IInputBuildFile)bf).getPromotionBuildPath()));
            obf.setType(((IInputBuildFile)bf).getType());
            obf.setInputType(BuildMapConversionUtil.getStringNotNull(((IInputBuildFile)bf).getInputType()));
            obf.setHFS(bf.isHFS());
            obf.setResolvedTo(((IInputBuildFile)bf).getResolvedTo());
            obf.setBuildPath(((IInputBuildFile)bf).getExpandedBuildPath());
        }
    }

    protected static String getStringNotNull(String string) {
        if (string == null) {
            return "";
        }
        return string;
    }
}

