/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.buildmap.common.impl;

import com.ibm.team.enterprise.internal.buildmap.common.IBuildArtifact;
import com.ibm.team.enterprise.internal.buildmap.common.IBuildFile;
import com.ibm.team.enterprise.internal.buildmap.common.IBuildMap;
import com.ibm.team.enterprise.internal.buildmap.common.IInput;
import com.ibm.team.enterprise.internal.buildmap.common.IOutput;
import com.ibm.team.enterprise.internal.buildmap.common.impl.BuildFile;
import com.ibm.team.enterprise.internal.buildmap.common.impl.BuildMap;
import com.ibm.team.enterprise.internal.buildmap.common.impl.Input;
import com.ibm.team.enterprise.internal.buildmap.common.impl.Output;
import java.util.HashSet;
import java.util.Set;

public class BuildMapConversion {
    public static com.ibm.team.enterprise.internal.teamz.buildmap.common.IBuildMap adapt(IBuildMap enterpriseBuildMap) {
        Set<IOutput> enterpriseOutputs;
        Set<IInput> enterpriseInputs;
        if (enterpriseBuildMap == null) {
            return null;
        }
        com.ibm.team.enterprise.internal.teamz.buildmap.common.impl.BuildMap teamzBuildMap = new com.ibm.team.enterprise.internal.teamz.buildmap.common.impl.BuildMap();
        teamzBuildMap.setBuildableFile(enterpriseBuildMap.getBuildableFile());
        teamzBuildMap.setBuildDefinitionUUID(enterpriseBuildMap.getBuildDefinitionUUID());
        teamzBuildMap.setBuildLabel(enterpriseBuildMap.getBuildLabel());
        teamzBuildMap.setBuildResultUUID(enterpriseBuildMap.getBuildResultUUID());
        teamzBuildMap.setDatasetPrefix(enterpriseBuildMap.getResourcePrefix());
        teamzBuildMap.setLoadDirectory(enterpriseBuildMap.getLoadDirectory());
        Object parserOutputs = enterpriseBuildMap.getParserOutputs();
        if (parserOutputs instanceof Set) {
            Set enterpriseBuildFiles = (Set)parserOutputs;
            HashSet<com.ibm.team.enterprise.internal.teamz.buildmap.common.IBuildFile> teamzBuildFiles = new HashSet<com.ibm.team.enterprise.internal.teamz.buildmap.common.IBuildFile>(enterpriseBuildFiles.size());
            for (Object enterpriseBuildFile : enterpriseBuildFiles) {
                teamzBuildFiles.add(BuildMapConversion.adapt((IBuildFile)enterpriseBuildFile));
            }
            teamzBuildMap.setParserOutputs(teamzBuildFiles);
        }
        if ((enterpriseInputs = enterpriseBuildMap.getInputs()) != null) {
            for (IInput enterpriseInput : enterpriseInputs) {
                teamzBuildMap.getInputs().add(BuildMapConversion.adapt(enterpriseInput));
            }
        }
        if ((enterpriseOutputs = enterpriseBuildMap.getOutputs()) != null) {
            for (IOutput enterpriseOutput : enterpriseOutputs) {
                teamzBuildMap.getOutputs().add(BuildMapConversion.adapt(enterpriseOutput));
            }
        }
        teamzBuildMap.setPersonalBuild(enterpriseBuildMap.isPersonalBuild());
        teamzBuildMap.setRebuild(enterpriseBuildMap.isRebuild());
        teamzBuildMap.setSnapshot(enterpriseBuildMap.getSnapshot());
        teamzBuildMap.setSourceBuildMapSlug(enterpriseBuildMap.getSourceBuildMapSlug());
        teamzBuildMap.setTemporaryForPromotion(enterpriseBuildMap.isTemporaryForPromotion());
        teamzBuildMap.setUri(enterpriseBuildMap.getUri());
        teamzBuildMap.setWorkItems(enterpriseBuildMap.getWorkItems());
        teamzBuildMap.setWorkspaceUUID(enterpriseBuildMap.getWorkspaceUUID());
        return teamzBuildMap;
    }

    public static IBuildMap migrate(com.ibm.team.enterprise.internal.teamz.buildmap.common.IBuildMap teamzBuildMap) {
        Set<com.ibm.team.enterprise.internal.teamz.buildmap.common.IOutput> teamzOutputs;
        Set<com.ibm.team.enterprise.internal.teamz.buildmap.common.IInput> teamzInputs;
        if (teamzBuildMap == null) {
            return null;
        }
        BuildMap enterpriseBuildMap = new BuildMap();
        enterpriseBuildMap.setMigrated(true);
        enterpriseBuildMap.setBuildableFile(teamzBuildMap.getBuildableFile());
        enterpriseBuildMap.setBuildDefinitionUUID(teamzBuildMap.getBuildDefinitionUUID());
        enterpriseBuildMap.setBuildLabel(teamzBuildMap.getBuildLabel());
        enterpriseBuildMap.setBuildResultUUID(teamzBuildMap.getBuildResultUUID());
        enterpriseBuildMap.setDatasetPrefix(teamzBuildMap.getDatasetPrefix());
        if (teamzBuildMap.getBuild() != null) {
            enterpriseBuildMap.setRepositoryAddress(teamzBuildMap.getBuild().getRepositoryAddress());
        }
        enterpriseBuildMap.setResourcePrefix(teamzBuildMap.getDatasetPrefix());
        enterpriseBuildMap.setLoadDirectory(teamzBuildMap.getLoadDirectory());
        Object parserOutputs = teamzBuildMap.getParserOutputs();
        if (parserOutputs instanceof Set) {
            Set teamzBuildFiles = (Set)parserOutputs;
            HashSet<IBuildFile> enterpriseBuildFiles = new HashSet<IBuildFile>(teamzBuildFiles.size());
            for (Object teamzBuildFile : teamzBuildFiles) {
                enterpriseBuildFiles.add(BuildMapConversion.migrate((com.ibm.team.enterprise.internal.teamz.buildmap.common.IBuildFile)teamzBuildFile, teamzBuildMap.getDatasetPrefix()));
            }
            enterpriseBuildMap.setParserOutputs(enterpriseBuildFiles);
        }
        if ((teamzInputs = teamzBuildMap.getInputs()) != null) {
            for (com.ibm.team.enterprise.internal.teamz.buildmap.common.IInput teamzInput : teamzInputs) {
                enterpriseBuildMap.getInputs().add(BuildMapConversion.migrate(teamzInput, teamzBuildMap.getDatasetPrefix()));
            }
        }
        if ((teamzOutputs = teamzBuildMap.getOutputs()) != null) {
            for (com.ibm.team.enterprise.internal.teamz.buildmap.common.IOutput teamzOutput : teamzOutputs) {
                enterpriseBuildMap.getOutputs().add(BuildMapConversion.migrate(teamzOutput, teamzBuildMap.getDatasetPrefix()));
            }
        }
        enterpriseBuildMap.setPersonalBuild(teamzBuildMap.isPersonalBuild());
        enterpriseBuildMap.setRebuild(teamzBuildMap.isRebuild());
        enterpriseBuildMap.setSnapshot(teamzBuildMap.getSnapshot());
        enterpriseBuildMap.setSourceBuildMapSlug(teamzBuildMap.getSourceBuildMapSlug());
        enterpriseBuildMap.setTemporaryForPromotion(teamzBuildMap.isTemporaryForPromotion());
        enterpriseBuildMap.setUri(teamzBuildMap.getUri());
        enterpriseBuildMap.setWorkItems(teamzBuildMap.getWorkItems());
        enterpriseBuildMap.setWorkspaceUUID(teamzBuildMap.getWorkspaceUUID());
        return enterpriseBuildMap;
    }

    private static com.ibm.team.enterprise.internal.teamz.buildmap.common.IBuildFile adapt(IBuildFile enterpriseBuildFile) {
        com.ibm.team.enterprise.internal.teamz.buildmap.common.impl.BuildFile teamzBuildFile = new com.ibm.team.enterprise.internal.teamz.buildmap.common.impl.BuildFile();
        teamzBuildFile.setComponentName(enterpriseBuildFile.getComponentName());
        teamzBuildFile.setDataSetDefinitionStateUUID(enterpriseBuildFile.getDataSetDefinitionStateUUID());
        teamzBuildFile.setDataSetDefinitionUUID(enterpriseBuildFile.getDataSetDefinitionUUID());
        teamzBuildFile.setDataSetName(enterpriseBuildFile.getBuildPath());
        teamzBuildFile.setFileStateUUID(enterpriseBuildFile.getFileStateUUID());
        teamzBuildFile.setFileUUID(enterpriseBuildFile.getFileUUID());
        teamzBuildFile.setMemberName(enterpriseBuildFile.getBuildFile());
        if (enterpriseBuildFile.getPathName() == null || "".equals(enterpriseBuildFile.getPathName())) {
            if (enterpriseBuildFile.getSCMLocation() != null && enterpriseBuildFile.getSCMLocation().indexOf(47) != -1) {
                teamzBuildFile.setPathName(enterpriseBuildFile.getSCMLocation().substring(enterpriseBuildFile.getSCMLocation().indexOf(47) + 1));
            }
        } else {
            teamzBuildFile.setPathName(enterpriseBuildFile.getPathName());
        }
        teamzBuildFile.setProjectName(enterpriseBuildFile.getProjectName());
        teamzBuildFile.setTimestamp(enterpriseBuildFile.getTimestamp());
        teamzBuildFile.setType(enterpriseBuildFile.getType());
        return teamzBuildFile;
    }

    public static IBuildFile migrate(com.ibm.team.enterprise.internal.teamz.buildmap.common.IBuildFile teamzBuildFile, String datasetPrefix) {
        BuildFile enterpriseBuildFile = new BuildFile();
        enterpriseBuildFile.setBuildFile(teamzBuildFile.getMemberName());
        enterpriseBuildFile.setBuildPath(teamzBuildFile.getDataSetName().replace("${teamz.scm.dataset.prefix}", datasetPrefix));
        enterpriseBuildFile.setComponentName(teamzBuildFile.getComponentName());
        enterpriseBuildFile.setFileStateUUID(teamzBuildFile.getFileStateUUID());
        enterpriseBuildFile.setFileUUID(teamzBuildFile.getFileUUID());
        enterpriseBuildFile.setProjectName(teamzBuildFile.getProjectName());
        enterpriseBuildFile.setResourceDefinitionID(teamzBuildFile.getDataSetDefinitionUUID());
        enterpriseBuildFile.setResourceDefinitionStateID(teamzBuildFile.getDataSetDefinitionStateUUID() == null ? "" : teamzBuildFile.getDataSetDefinitionStateUUID());
        enterpriseBuildFile.setTimestamp(teamzBuildFile.getTimestamp());
        enterpriseBuildFile.setType(teamzBuildFile.getType());
        String projectName = "";
        if (teamzBuildFile.getProjectName() != null && teamzBuildFile.getProjectName().length() > 0) {
            projectName = teamzBuildFile.getProjectName();
        }
        String pathName = "";
        if (teamzBuildFile.getPathName() != null && teamzBuildFile.getPathName().length() > 0) {
            pathName = teamzBuildFile.getPathName();
        }
        if (projectName.length() > 0 || pathName.length() > 0) {
            enterpriseBuildFile.setSCMLocation(String.valueOf(projectName) + "/" + pathName);
        }
        enterpriseBuildFile.setPathName(pathName);
        enterpriseBuildFile.setPromotionBuildPath(teamzBuildFile.getDataSetName().replace("${teamz.scm.dataset.prefix}", "${team.enterprise.scm.resourcePrefix}"));
        return enterpriseBuildFile;
    }

    private static com.ibm.team.enterprise.internal.teamz.buildmap.common.IInput adapt(IInput enterpriseInput) {
        com.ibm.team.enterprise.internal.teamz.buildmap.common.impl.Input teamzInput = new com.ibm.team.enterprise.internal.teamz.buildmap.common.impl.Input(BuildMapConversion.adapt(enterpriseInput.getArtifact()));
        return teamzInput;
    }

    public static IInput migrate(com.ibm.team.enterprise.internal.teamz.buildmap.common.IInput teamzInput, String datasetPrefix) {
        Input enterpriseInput = new Input(BuildMapConversion.migrate(teamzInput.getArtifact(), datasetPrefix));
        return enterpriseInput;
    }

    private static com.ibm.team.enterprise.internal.teamz.buildmap.common.IOutput adapt(IOutput enterpriseOutput) {
        com.ibm.team.enterprise.internal.teamz.buildmap.common.impl.Output teamzOutput = new com.ibm.team.enterprise.internal.teamz.buildmap.common.impl.Output(BuildMapConversion.adapt(enterpriseOutput.getArtifact()));
        return teamzOutput;
    }

    public static IOutput migrate(com.ibm.team.enterprise.internal.teamz.buildmap.common.IOutput teamzOutput, String datasetPrefix) {
        Output enterpriseOutput = new Output(BuildMapConversion.migrate(teamzOutput.getArtifact(), datasetPrefix));
        return enterpriseOutput;
    }

    private static com.ibm.team.enterprise.internal.teamz.buildmap.common.IBuildArtifact adapt(IBuildArtifact enterpriseBuildArtifact) {
        if (enterpriseBuildArtifact instanceof IBuildFile) {
            return BuildMapConversion.adapt((IBuildFile)enterpriseBuildArtifact);
        }
        return null;
    }

    private static IBuildArtifact migrate(com.ibm.team.enterprise.internal.teamz.buildmap.common.IBuildArtifact teamzBuildArtifact, String datasetPrefix) {
        if (teamzBuildArtifact instanceof com.ibm.team.enterprise.internal.teamz.buildmap.common.IBuildFile) {
            return BuildMapConversion.migrate((com.ibm.team.enterprise.internal.teamz.buildmap.common.IBuildFile)teamzBuildArtifact, datasetPrefix);
        }
        return null;
    }
}

