/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.internal.buildmap.common.impl;

import com.ibm.team.enterprise.internal.buildmap.common.IBuild;
import com.ibm.team.enterprise.internal.buildmap.common.IBuildMap;
import com.ibm.team.enterprise.internal.buildmap.common.IInput;
import com.ibm.team.enterprise.internal.buildmap.common.IInputs;
import com.ibm.team.enterprise.internal.buildmap.common.IOutput;
import com.ibm.team.enterprise.internal.buildmap.common.IOutputs;
import com.ibm.team.enterprise.internal.buildmap.common.impl.Build;
import com.ibm.team.enterprise.internal.buildmap.common.impl.Inputs;
import com.ibm.team.enterprise.internal.buildmap.common.impl.Outputs;
import com.ibm.team.enterprise.internal.buildmap.common.util.BuildMapUtil;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;

public class BuildMap
implements IBuildMap {
    private String fBuildableFileUUID = null;
    private final IBuild fBuild = new Build();
    private final IInputs fInputs = new Inputs();
    private final IOutputs fOutputs = new Outputs();
    private String fUri = null;
    private Object fParserOutputs;
    private boolean fPersonalBuild;
    private boolean fRebuild;
    private boolean fIsTemporaryPromotionBuildMap;
    private boolean fIsMigrated;
    private final IOutputs fLogs = new Outputs();
    private boolean fHFS;

    @Override
    public String getSlug() {
        StringBuffer slugBuffer = new StringBuffer("_buildableFileUUID=");
        slugBuffer.append(this.fBuildableFileUUID);
        slugBuffer.append("_buildDefinitionUUID=");
        slugBuffer.append(this.getBuildDefinitionUUID());
        if (this.isPersonalBuild()) {
            slugBuffer.append("_personalBuild=");
            slugBuffer.append(this.isPersonalBuild());
        }
        if (this.isRebuild()) {
            slugBuffer.append("_rebuild=");
            slugBuffer.append(this.isRebuild());
        }
        if (this.isTemporaryForPromotion()) {
            slugBuffer.append("_temporaryForPromotion=");
            slugBuffer.append(this.isTemporaryForPromotion());
        }
        return slugBuffer.toString();
    }

    @Override
    public void setRepositoryAddress(String repositoryAddress) {
        this.getBuild().setRepositoryAddress(repositoryAddress);
    }

    @Override
    public String getStorageRepresentation() {
        return this.getStorageRepresentation(IBuildMap.XmlType.FULL);
    }

    @Override
    public String getStorageRepresentation(IBuildMap.XmlType xmlType) {
        return this.getStorageRepresentation(xmlType, null);
    }

    @Override
    public String getStorageRepresentation(IBuildMap.XmlType xmlType, Map<String, String> revisionIDs) {
        String s = null;
        try {
            switch (xmlType) {
                case FULL: {
                    s = BuildMapUtil.getXmlString(this);
                    break;
                }
                case BUILD: {
                    s = BuildMapUtil.getBuildXmlString(this, revisionIDs);
                    break;
                }
                case INPUTS: {
                    s = BuildMapUtil.getInputsXmlString(this);
                    break;
                }
                case OUTPUTS: {
                    s = BuildMapUtil.getOutputsXmlString(this);
                    break;
                }
                case PARSER_OUTPUTS: {
                    s = BuildMapUtil.getParserOutputsXmlString(this);
                    break;
                }
            }
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (TransformerFactoryConfigurationError e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        return s;
    }

    @Override
    public String getRepositoryAddress() {
        return this.getBuild().getRepositoryAddress();
    }

    @Override
    public final void setBuildDefinitionUUID(String buildDefinitionUUID) {
        this.getBuild().setBuildDefinitionUUID(buildDefinitionUUID);
    }

    @Override
    public String getBuildDefinitionUUID() {
        return this.getBuild().getBuildDefinitionUUID();
    }

    @Override
    public void setBuildResultUUID(String buildResultUUID) {
        this.getBuild().setBuildResultUUID(buildResultUUID);
    }

    @Override
    public String getBuildResultUUID() {
        return this.getBuild().getBuildResultUUID();
    }

    @Override
    public void setBuildLabel(String buildLabel) {
        this.getBuild().setBuildLabel(buildLabel);
    }

    @Override
    public String getBuildLabel() {
        return this.getBuild().getBuildLabel();
    }

    @Override
    public void setWorkspaceUUID(String workspaceUUID) {
        this.getBuild().setWorkspaceUUID(workspaceUUID);
    }

    @Override
    public String getWorkspaceUUID() {
        return this.getBuild().getWorkspaceUUID();
    }

    @Override
    public void setSnapshot(String snapshot) {
        this.getBuild().setSnapshot(snapshot);
    }

    @Override
    public String getSnapshot() {
        return this.getBuild().getSnapshot();
    }

    @Override
    public void setDatasetPrefix(String datasetPrefix) {
        this.getBuild().setDatasetPrefix(datasetPrefix);
    }

    @Override
    public String getDatasetPrefix() {
        return this.getBuild().getDatasetPrefix();
    }

    @Override
    public void setResourcePrefix(String resourcePrefix) {
        this.getBuild().setResourcePrefix(resourcePrefix);
    }

    @Override
    public String getResourcePrefix() {
        return this.getBuild().getResourcetPrefix();
    }

    @Override
    public void setFetchDestination(String fetchDestination) {
        this.getBuild().setLoadDirectory(fetchDestination);
    }

    public String getFetchDestination() {
        return this.getBuild().getLoadDirectory();
    }

    @Override
    public void setLoadDirectory(String loadDirectory) {
        this.getBuild().setLoadDirectory(loadDirectory);
    }

    @Override
    public String getLoadDirectory() {
        return this.getBuild().getLoadDirectory();
    }

    @Override
    public IBuild getBuild() {
        return this.fBuild;
    }

    @Override
    public Set<IInput> getInputs() {
        return this.fInputs.getInputs();
    }

    @Override
    public Set<IOutput> getOutputs() {
        return this.fOutputs.getOutputs();
    }

    @Override
    public String getUri() {
        return this.fUri;
    }

    @Override
    public void setUri(String uri) {
        this.fUri = uri;
    }

    @Override
    public String getBuildableFile() {
        return this.fBuildableFileUUID;
    }

    @Override
    public void setBuildableFile(String buildableFile) {
        this.fBuildableFileUUID = buildableFile;
    }

    @Override
    public Object getParserOutputs() {
        return this.fParserOutputs;
    }

    @Override
    public void setParserOutputs(Object parserOutputs) {
        this.fParserOutputs = parserOutputs;
    }

    @Override
    public boolean isPersonalBuild() {
        return this.fPersonalBuild;
    }

    @Override
    public void setPersonalBuild(boolean personalBuild) {
        this.fPersonalBuild = personalBuild;
    }

    @Override
    public boolean isRebuild() {
        return this.fRebuild;
    }

    @Override
    public void setRebuild(boolean rebuild) {
        this.fRebuild = rebuild;
    }

    @Override
    public String getSourceBuildMapSlug() {
        return this.getBuild().getSourceBuildMapSlug();
    }

    @Override
    public void setSourceBuildMapSlug(String buildMapSlug) {
        this.getBuild().setSourceBuildMapSlug(buildMapSlug);
    }

    @Override
    public boolean isTemporaryForPromotion() {
        return this.fIsTemporaryPromotionBuildMap;
    }

    @Override
    public void setTemporaryForPromotion(boolean temporary) {
        this.fIsTemporaryPromotionBuildMap = temporary;
    }

    @Override
    public void setWorkItems(String[] fWorkItems) {
        this.getBuild().setWorkItems(fWorkItems);
    }

    @Override
    public String[] getWorkItems() {
        return this.getBuild().getWorkItems();
    }

    @Override
    public boolean isMigrated() {
        return this.fIsMigrated;
    }

    @Override
    public void setMigrated(boolean value) {
        this.fIsMigrated = value;
    }

    @Override
    public void setPromotionResultUUID(String promotionResultUUID) {
        this.getBuild().setPromotionResultUUID(promotionResultUUID);
    }

    @Override
    public String getPromotionResultUUID() {
        return this.getBuild().getPromotionResultUUID();
    }

    @Override
    public Set<IOutput> getLogs() {
        return this.fLogs.getOutputs();
    }

    @Override
    public boolean isHFS() {
        return this.fHFS;
    }

    @Override
    public void setHFS(boolean value) {
        this.fHFS = value;
    }
}

