/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.buildmap.common.util;

import com.ibm.team.enterprise.build.buildmap.common.model.IOutputBuildFile;
import com.ibm.team.repository.common.UUID;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class OutputXMLUtils {
    private OutputXMLUtils() {
    }

    public static void generateOutputXML(XMLStreamWriter writer, IOutputBuildFile outputFile) throws XMLStreamException {
        String deploytype;
        boolean isHFS;
        boolean isSeq;
        String outtype;
        writer.writeCharacters("\n\t\t");
        writer.writeStartElement("outputs:file");
        OutputXMLUtils.writeBaseElement(writer, 3, "outputs:buildFile", outputFile.getBuildFile());
        OutputXMLUtils.writeBaseElement(writer, 3, "outputs:buildPath", outputFile.getBuildPath());
        String type = outputFile.getType();
        if (type != null && type.length() > 0) {
            OutputXMLUtils.writeBaseElement(writer, 3, "outputs:type", type);
        }
        if ((outtype = outputFile.getOutputType()) != null && outtype.length() > 0) {
            OutputXMLUtils.writeBaseElement(writer, 3, "outputs:outputType", outtype);
        }
        if (isSeq = outputFile.isSequential()) {
            OutputXMLUtils.writeBaseElement(writer, 3, "outputs:sequential", Boolean.toString(isSeq));
        }
        if (isHFS = outputFile.isHFS()) {
            OutputXMLUtils.writeBaseElement(writer, 3, "outputs:hfs", Boolean.toString(isHFS));
        }
        if ((deploytype = outputFile.getDeployType()) != null && deploytype.length() > 0) {
            OutputXMLUtils.writeBaseElement(writer, 3, "outputs:deployType", deploytype);
        }
        OutputXMLUtils.writeBaseElement(writer, 3, "outputs:resourceDefinitionID", outputFile.getResourceDefinitionUUID() == null ? "" : outputFile.getResourceDefinitionUUID().getUuidValue());
        UUID resourceStateID = outputFile.getResourceDefinitionStateUUID();
        if (resourceStateID != null) {
            OutputXMLUtils.writeBaseElement(writer, 3, "outputs:resourceDefinitionStateID", resourceStateID.getUuidValue());
        }
        writer.writeCharacters("\n\t\t");
        writer.writeEndElement();
    }

    private static void writeBaseElement(XMLStreamWriter writer, int indent, String elementName, String value) throws XMLStreamException {
        writer.writeCharacters("\n");
        int i = 0;
        while (i < indent) {
            writer.writeCharacters("\t");
            ++i;
        }
        writer.writeStartElement(elementName);
        writer.writeCharacters(value == null ? "" : value);
        writer.writeEndElement();
    }
}

