/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.buildmap.common.util;

import com.ibm.team.enterprise.build.buildmap.common.model.impl.BuildMapImpl;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.UUID;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.util.EContentAdapter;

public class ListSyncAdapter
extends EContentAdapter {
    public static final ListSyncAdapter INSTANCE = new ListSyncAdapter();

    private ListSyncAdapter() {
    }

    public void notifyChanged(Notification notification) {
        super.notifyChanged(notification);
        if (notification.isTouch()) {
            return;
        }
        int featureId = notification.getFeatureID(BuildMapImpl.class);
        BuildMapImpl buildmap = null;
        if (!(notification.getNotifier() instanceof BuildMapImpl)) {
            return;
        }
        buildmap = (BuildMapImpl)notification.getNotifier();
        List targetList = null;
        if (this.checkOutOfSync(buildmap, featureId)) {
            return;
        }
        if (featureId == 34) {
            targetList = buildmap.getInputStates();
        } else if (featureId == 37) {
            targetList = buildmap.getOutputStates();
        } else if (featureId == 40) {
            targetList = buildmap.getParserOutputStates();
        } else {
            return;
        }
        switch (notification.getEventType()) {
            case 1: {
                targetList.set(notification.getPosition(), this.getState(notification.getNewValue()));
                break;
            }
            case 2: {
                System.err.println("UNSET: " + notification.getNewValue() + " " + notification.getOldValue());
                break;
            }
            case 3: {
                targetList.add(this.getState(notification.getNewValue()));
                break;
            }
            case 4: {
                targetList.remove(notification.getPosition());
                break;
            }
            case 5: {
                for (Object obj : (Collection)notification.getNewValue()) {
                    targetList.add(this.getState(obj));
                }
                break;
            }
            case 6: {
                this.setOutOfSync(buildmap, featureId);
                break;
            }
            case 7: {
                System.err.println("MOVE: " + notification.getNewValue() + " " + notification.getOldValue());
            }
        }
    }

    private void setOutOfSync(BuildMapImpl buildMap, int featureId) {
        switch (featureId) {
            case 34: {
                buildMap.setInputStatesOutOfSync(true);
                return;
            }
            case 37: {
                buildMap.setOutputStatesOutOfSync(true);
                return;
            }
            case 40: {
                buildMap.setParserOutputStatesOutOfSync(true);
                return;
            }
        }
    }

    private boolean checkOutOfSync(BuildMapImpl buildMap, int featureId) {
        switch (featureId) {
            case 34: {
                return buildMap.isInputStatesOutOfSync();
            }
            case 37: {
                return buildMap.isOutputStatesOutOfSync();
            }
            case 40: {
                return buildMap.isParserOutputStatesOutOfSync();
            }
        }
        return true;
    }

    private IItemHandle getHandle(Object obj) {
        if (obj instanceof IItemHandle) {
            return (IItemHandle)obj;
        }
        return null;
    }

    private UUID getState(Object obj) {
        IItemHandle handle = this.getHandle(obj);
        if (handle == null) {
            return null;
        }
        return handle.getStateId();
    }
}

