/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.buildmap.common.util;

import com.ibm.team.enterprise.build.buildmap.common.model.BuildLog;
import com.ibm.team.enterprise.build.buildmap.common.model.BuildMap;
import com.ibm.team.enterprise.build.buildmap.common.model.IBuildFile;
import com.ibm.team.enterprise.build.buildmap.common.model.IBuildFileHandle;
import com.ibm.team.enterprise.build.buildmap.common.model.IBuildLog;
import com.ibm.team.enterprise.build.buildmap.common.model.IBuildLogHandle;
import com.ibm.team.enterprise.build.buildmap.common.model.IBuildMap;
import com.ibm.team.enterprise.build.buildmap.common.model.IInputBuildFile;
import com.ibm.team.enterprise.build.buildmap.common.model.IOutputBuildFile;
import com.ibm.team.enterprise.build.buildmap.common.model.InputBuildFile;
import com.ibm.team.enterprise.build.buildmap.common.model.OutputBuildFile;
import com.ibm.team.repository.common.IItemHandle;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class BuildMapUtil {
    public static IBuildMap mergeIntoComplete(IBuildMap source, IBuildMap target) throws IllegalArgumentException {
        return BuildMapUtil.mergeIntoComplete(source, target, false);
    }

    public static IBuildMap mergeIntoComplete(IBuildMap source, IBuildMap target, boolean skipSanityChecks) throws IllegalArgumentException {
        target = BuildMapUtil.mergeInto(source, target, skipSanityChecks);
        BuildMapUtil.mergeInto(source.getInputs(), target.getInputs(), skipSanityChecks);
        BuildMapUtil.mergeInto(source.getOutputs(), target.getOutputs(), skipSanityChecks);
        BuildMapUtil.mergeInto(source.getParserOutputs(), target.getParserOutputs(), skipSanityChecks);
        return target;
    }

    public static Set<IBuildLogHandle> mergeBuildLogs(List<IBuildLogHandle> sourceLogs, List<IBuildLogHandle> targetLogs, boolean skipSanityChecks) {
        HashSet<IBuildLogHandle> toRemove = new HashSet<IBuildLogHandle>();
        if (targetLogs.isEmpty()) {
            for (IBuildLogHandle bf : sourceLogs) {
                BuildLog newBf = (BuildLog)IBuildLog.ITEM_TYPE.createItem();
                newBf = BuildMapUtil.mergeBuildLog((BuildLog)bf, newBf, skipSanityChecks);
                targetLogs.add(newBf);
            }
        } else {
            String key;
            HashSet<String> keysToRemove = new HashSet<String>();
            HashMap<String, IBuildLogHandle> temp = new HashMap<String, IBuildLogHandle>(sourceLogs.size());
            for (IBuildLogHandle obf : sourceLogs) {
                key = BuildMapUtil.getBuildLogKey(obf);
                IBuildLogHandle possibleCollision = temp.put(key, obf);
                if (possibleCollision == null) continue;
                keysToRemove.add(key);
                temp.put(BuildMapUtil.getAlternateBuildLogKey(possibleCollision), possibleCollision);
                temp.put(BuildMapUtil.getAlternateBuildLogKey(obf), obf);
            }
            for (String key2 : keysToRemove) {
                temp.remove(key2);
            }
            int i = 0;
            while (i < targetLogs.size()) {
                IBuildLogHandle bf = targetLogs.get(i);
                key = BuildMapUtil.getBuildLogKey(bf);
                String altKey = BuildMapUtil.getAlternateBuildLogKey(bf);
                if (temp.containsKey(key)) {
                    bf = BuildMapUtil.mergeBuildLog((BuildLog)temp.get(key), (BuildLog)bf, skipSanityChecks);
                    targetLogs.set(i, bf);
                    temp.remove(key);
                } else if (temp.containsKey(altKey)) {
                    bf = BuildMapUtil.mergeBuildLog((BuildLog)temp.get(altKey), (BuildLog)bf, skipSanityChecks);
                    targetLogs.set(i, bf);
                    temp.remove(altKey);
                } else {
                    toRemove.add(bf);
                }
                ++i;
            }
            targetLogs.removeAll(toRemove);
            for (IBuildLogHandle bf : temp.values()) {
                BuildLog newBf = (BuildLog)IBuildLog.ITEM_TYPE.createItem();
                newBf = BuildMapUtil.mergeBuildLog((BuildLog)bf, newBf, skipSanityChecks);
                targetLogs.add(newBf);
            }
        }
        return toRemove;
    }

    private static BuildLog mergeBuildLog(BuildLog sourceLog, BuildLog targetLog, boolean skipSanityChecks) {
        if (sourceLog != null && targetLog != null) {
            targetLog = (BuildLog)targetLog.getWorkingCopy();
            targetLog.setCompacted(sourceLog.isCompacted());
            targetLog.setLogFile(sourceLog.getLogFile());
            targetLog.setLogPath(sourceLog.getLogPath());
            targetLog.setHost(sourceLog.getHost());
            targetLog.setResourceDefinitionUUID(sourceLog.getResourceDefinitionUUID());
            targetLog.setResourceDefinitionStateUUID(sourceLog.getResourceDefinitionStateUUID());
            targetLog.setTranslatorUUID(sourceLog.getTranslatorUUID());
            targetLog.setTranslatorStateUUID(sourceLog.getTranslatorStateUUID());
            targetLog.setDdIndex(sourceLog.getDdIndex());
            targetLog.setTimestamp(sourceLog.getTimestamp());
            targetLog.setType(sourceLog.getType());
        }
        return targetLog;
    }

    public static IBuildMap mergeInto(IBuildMap source, IBuildMap target) throws IllegalArgumentException {
        return BuildMapUtil.mergeInto(source, target, false);
    }

    public static IBuildMap mergeInto(IBuildMap source, IBuildMap target, boolean skipSanityChecks) throws IllegalArgumentException {
        if (!skipSanityChecks && target.getBuildableFile() != null && !source.getBuildableFile().sameItemId((IItemHandle)target.getBuildableFile())) {
            throw new IllegalArgumentException("Expected buildable File " + target.getBuildableFile() + " instead was " + source.getBuildableFile());
        }
        if (!skipSanityChecks && target.getBuildDefinition() != null && !source.getBuildDefinition().sameItemId((IItemHandle)target.getBuildDefinition())) {
            throw new IllegalArgumentException("Expected build definition " + target.getBuildDefinition() + " instead was " + source.getBuildDefinition());
        }
        target = (IBuildMap)((BuildMap)target).getWorkingCopy();
        target.setBuildableFile(source.getBuildableFile());
        target.setBuildDefinition(source.getBuildDefinition());
        ((BuildMap)target).setBuildLabel(source.getBuildLabel());
        ((BuildMap)target).setBuildResult(source.getBuildResult());
        ((BuildMap)target).setFetchDestination(source.getFetchDestination());
        ((BuildMap)target).setResourcePrefix(source.getResourcePrefix());
        ((BuildMap)target).setWorkspace(source.getWorkspace());
        ((BuildMap)target).setPromotedSourceBuildMapSlug(source.getPromotedSourceBuildMapSlug());
        ((BuildMap)target).setSnapshot(source.getSnapshot());
        ((BuildMap)target).setArchived(source.isArchived());
        ((BuildMap)target).setLanguageDefinitionUUID(source.getLanguageDefinitionUUID());
        ((BuildMap)target).setLanguageDefinitionStateUUID(source.getLanguageDefinitionStateUUID());
        ((BuildMap)target).setV5slug(source.getV5slug());
        ((BuildMap)target).setReserved(((BuildMap)source).getReserved());
        ((BuildMap)target).setPromotionBuildResult(source.getPromotionBuildResult());
        if (!source.getWorkitems().isEmpty()) {
            ((BuildMap)target).getWorkitems().clear();
            ((BuildMap)target).getWorkitems().addAll(source.getWorkitems());
        } else {
            ((BuildMap)target).getWorkitems().clear();
        }
        target.setTemporary(source.isTemporary());
        target.setPromotedSourceBuildMapSlug(source.getPromotedSourceBuildMapSlug());
        return target;
    }

    public static <T extends IBuildFile> T mergeInto(T source, T target) throws IllegalArgumentException {
        return BuildMapUtil.mergeInto(source, target, false);
    }

    protected static <T extends IBuildFile> void sanityCheck(T source, T target) throws IllegalArgumentException {
        if (source instanceof IInputBuildFile && target instanceof IInputBuildFile) {
            IInputBuildFile s = (IInputBuildFile)source;
            IInputBuildFile t = (IInputBuildFile)target;
            if (s.getFile() != null && s.getFile().getItemId() != null && t.getFile() != null && t.getFile().getItemId() != null) {
                if (!t.getFile().sameItemId((IItemHandle)s.getFile())) {
                    throw new IllegalArgumentException("Expected versionable " + t.getFile().getItemId().getUuidValue() + " instead was " + s.getFile().getItemId().getUuidValue());
                }
                return;
            }
        }
        if (target.getBuildFile() != null && !target.getBuildFile().isEmpty() && !source.getBuildFile().equals(target.getBuildFile())) {
            throw new IllegalArgumentException("Expected build File " + target.getBuildFile() + " instead was " + source.getBuildFile());
        }
        if (target.getBuildPath() != null && !target.getBuildPath().isEmpty() && !source.getBuildPath().equals(target.getBuildPath())) {
            throw new IllegalArgumentException("Expected build path " + target.getBuildPath() + " instead was " + source.getBuildPath());
        }
    }

    public static <T extends IBuildFile> T mergeInto(T source, T target, boolean skipSanityChecks) throws IllegalArgumentException {
        if (!skipSanityChecks) {
            BuildMapUtil.sanityCheck(source, target);
        }
        target = (IBuildFile)target.getWorkingCopy();
        target.setBuildFile(source.getBuildFile());
        target.setBuildPath(source.getBuildPath());
        if (target instanceof IInputBuildFile) {
            if (!(source instanceof IInputBuildFile)) {
                throw new IllegalArgumentException("Expected source of type IInputBuildFile and instead was " + source.getClass().getCanonicalName());
            }
            InputBuildFile temp = (InputBuildFile)target;
            temp.setFile(((IInputBuildFile)source).getFile());
            temp.setFileStateUUID(((IInputBuildFile)source).getFileStateUUID());
            temp.setModule(((IInputBuildFile)source).getModule());
            temp.setPathName(((IInputBuildFile)source).getPathName());
            temp.setPromotionBuildPath(((IInputBuildFile)source).getPromotionBuildPath());
            temp.setResourceDefinitionUUID(((IInputBuildFile)source).getResourceDefinitionUUID());
            temp.setResourceDefinitionStateUUID(((IInputBuildFile)source).getResourceDefinitionStateUUID());
            temp.setSCMLocation(((IInputBuildFile)source).getSCMLocation());
            temp.setServiceProgram(((IInputBuildFile)source).getServiceProgram());
            temp.setTimestamp(((IInputBuildFile)source).getTimestamp());
            temp.setType(((IInputBuildFile)source).getType());
            temp.setInputType(((IInputBuildFile)source).getInputType());
            temp.setComponent(((IInputBuildFile)source).getComponent());
            temp.setReserved(((InputBuildFile)source).getReserved());
            temp.setHFS(((IInputBuildFile)source).isHFS());
            temp.setResolvedTo(((IInputBuildFile)source).getResolvedTo());
        } else if (target instanceof IOutputBuildFile) {
            if (!(source instanceof IOutputBuildFile)) {
                throw new IllegalArgumentException("Expected source of type IOutputBuildFile and instead was " + source.getClass().getCanonicalName());
            }
            IOutputBuildFile temp = (IOutputBuildFile)target;
            temp.setPromotionBuildPath(((IOutputBuildFile)source).getPromotionBuildPath());
            temp.setResourceDefinitionUUID(((IOutputBuildFile)source).getResourceDefinitionUUID());
            temp.setResourceDefinitionStateUUID(((IOutputBuildFile)source).getResourceDefinitionStateUUID());
            temp.setTimestamp(((IOutputBuildFile)source).getTimestamp());
            temp.setType(((IOutputBuildFile)source).getType());
            temp.setOutputType(((IOutputBuildFile)source).getOutputType());
            temp.setDeployType(((IOutputBuildFile)source).getDeployType());
            temp.setSequential(((IOutputBuildFile)source).isSequential());
            temp.setConsumableAsSource(((IOutputBuildFile)source).isConsumableAsSource());
            ((OutputBuildFile)temp).setReserved(((OutputBuildFile)source).getReserved());
            temp.setModule(((IOutputBuildFile)source).getModule());
            temp.setServiceProgram(((IOutputBuildFile)source).getServiceProgram());
            temp.setHFS(((IOutputBuildFile)source).isHFS());
        }
        return (T)target;
    }

    public static <T extends IBuildFileHandle> List<T> mergeInto(List<T> source, List<T> target) {
        return BuildMapUtil.mergeInto(source, target, false);
    }

    public static <T extends IBuildFileHandle> List<T> mergeInto(List<T> source, List<T> target, boolean skipSanityChecks) {
        if (target.isEmpty()) {
            for (IBuildFileHandle bf : source) {
                IBuildFile newBf = (IBuildFile)bf.getItemType().createItem();
                newBf = BuildMapUtil.mergeInto((IBuildFile)bf, newBf, skipSanityChecks);
                target.add(newBf);
            }
        } else {
            HashSet<String> keysToRemove = new HashSet<String>();
            HashMap<String, IBuildFileHandle> temp = new HashMap<String, IBuildFileHandle>(source.size());
            for (IBuildFileHandle obf : source) {
                String key = BuildMapUtil.getBuildFileKey(obf);
                IBuildFileHandle possibleCollision = temp.put(key, obf);
                if (possibleCollision == null) continue;
                keysToRemove.add(key);
                temp.put(BuildMapUtil.getAlternateBuildFileKey(possibleCollision), possibleCollision);
                temp.put(BuildMapUtil.getAlternateBuildFileKey(obf), obf);
            }
            for (String key : keysToRemove) {
                temp.remove(key);
            }
            HashSet<IBuildFileHandle> toRemove = new HashSet<IBuildFileHandle>();
            int i = 0;
            while (i < target.size()) {
                IBuildFileHandle bf = (IBuildFileHandle)target.get(i);
                String key = BuildMapUtil.getBuildFileKey(bf);
                String altKey = BuildMapUtil.getAlternateBuildFileKey(bf);
                if (temp.containsKey(key)) {
                    bf = BuildMapUtil.mergeInto((IBuildFile)temp.get(key), (IBuildFile)bf, skipSanityChecks);
                    target.set(i, bf);
                    temp.remove(key);
                } else if (temp.containsKey(altKey)) {
                    bf = BuildMapUtil.mergeInto((IBuildFile)temp.get(altKey), (IBuildFile)bf, skipSanityChecks);
                    target.set(i, bf);
                    temp.remove(altKey);
                } else {
                    toRemove.add(bf);
                }
                ++i;
            }
            target.removeAll(toRemove);
            for (IBuildFileHandle bf : temp.values()) {
                IBuildFile newBf = (IBuildFile)bf.getItemType().createItem();
                newBf = BuildMapUtil.mergeInto((IBuildFile)bf, newBf, skipSanityChecks);
                target.add(newBf);
            }
        }
        return target;
    }

    protected static String getBuildFileKey(IBuildFileHandle bf) {
        if (bf instanceof IInputBuildFile && ((IInputBuildFile)bf).getFile() != null) {
            return ((IInputBuildFile)bf).getFile().getItemId().getUuidValue();
        }
        if (bf instanceof IBuildFile) {
            return String.valueOf(((IBuildFile)bf).getBuildPath()) + ((IBuildFile)bf).getBuildFile();
        }
        return "" + bf.hashCode();
    }

    protected static String getAlternateBuildFileKey(IBuildFileHandle bf) {
        String postScript = "altKey";
        if (bf instanceof IInputBuildFile && ((IInputBuildFile)bf).getType() != null) {
            IInputBuildFile ibf = (IInputBuildFile)bf;
            postScript = String.valueOf(postScript) + ibf.getType();
            if (ibf.getInputType() != null) {
                postScript = String.valueOf(postScript) + ibf.getInputType();
            }
        } else if (bf instanceof IOutputBuildFile && ((IOutputBuildFile)bf).getType() != null) {
            IOutputBuildFile obf = (IOutputBuildFile)bf;
            postScript = String.valueOf(postScript) + ((IOutputBuildFile)bf).getType();
            if (obf.getOutputType() != null) {
                postScript = String.valueOf(postScript) + obf.getOutputType();
            }
        }
        return String.valueOf(BuildMapUtil.getBuildFileKey(bf)) + postScript;
    }

    protected static String getBuildLogKey(IBuildLogHandle bf) {
        if (bf instanceof BuildLog) {
            return String.valueOf(((BuildLog)bf).getLogPath()) + ((BuildLog)bf).getLogFile();
        }
        return "" + bf.hashCode();
    }

    protected static String getAlternateBuildLogKey(IBuildLogHandle log) {
        String postScript = "altKey";
        if (log instanceof BuildLog && ((BuildLog)log).getType() != null) {
            BuildLog obf = (BuildLog)log;
            postScript = String.valueOf(postScript) + obf.getType();
        }
        return String.valueOf(BuildMapUtil.getBuildLogKey(log)) + postScript;
    }

    public static <T extends IBuildFile> T find(String buildFile, String buildPath, List<T> list) throws IllegalArgumentException {
        if (buildFile == null || buildFile.isEmpty()) {
            throw new IllegalArgumentException("BuildFile was invalid: " + buildFile);
        }
        if (buildPath == null || buildPath.isEmpty()) {
            throw new IllegalArgumentException("BuildPath was invalid: " + buildPath);
        }
        for (IBuildFile ibf : list) {
            if (!buildFile.equals(ibf.getBuildFile()) || !buildPath.equals(ibf.getBuildPath())) continue;
            return (T)ibf;
        }
        return null;
    }
}

