/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.buildmap.common.util;

import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.enterprise.build.buildmap.common.model.IOutputBuildFile;
import com.ibm.team.enterprise.build.buildmap.common.model.query.BaseBuildMapQueryModel;
import com.ibm.team.enterprise.build.buildmap.common.util.InListIteratorAdapter;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.query.IDataQuery;
import com.ibm.team.repository.common.query.IDataQueryPage;
import com.ibm.team.repository.common.query.ast.IDateTime;
import com.ibm.team.repository.common.query.ast.IPredicate;
import com.ibm.team.repository.common.query.ast.IQueryModel;
import com.ibm.team.repository.common.query.ast.ISelectionElement;
import com.ibm.team.repository.common.query.ast.IString;
import com.ibm.team.repository.common.query.ast.IUUID;
import com.ibm.team.repository.common.service.IQueryService;
import com.ibm.team.scm.common.IVersionableHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BuildMapQueries {
    public static final int LARGE_LIST_CUTOFF = 100;
    private static IDataQuery parserOutputFilesQuery = null;
    private static IDataQuery parserOutputFilesQueryWithoutOutputType = null;
    private static IDataQuery findBuildableFilesForParserOutputQuery = null;

    public static final IDataQuery getParserOutputFilesQuery() {
        if (parserOutputFilesQuery == null) {
            BaseBuildMapQueryModel.BuildMapQueryModel model = BaseBuildMapQueryModel.BuildMapQueryModel.ROOT;
            IDataQuery query = (IDataQuery)IDataQuery.FACTORY.newInstance((IQueryModel)model);
            IPredicate filter = model.buildDefinition().itemId()._eq((IUUID)query.newUUIDArg())._and(model.temporary()._isFalse())._and(model.archived()._isFalse());
            filter = filter._and(model.parserOutputs().buildFile()._eq((IString)query.newStringArg()));
            filter = filter._and(model.parserOutputs().buildPath()._eq((IString)query.newStringArg()));
            filter = filter._and(model.parserOutputs().timestamp()._ltOrEq((IDateTime)query.newDateTimeArg()));
            filter = filter._and(model.parserOutputs().outputType()._eq((IString)query.newStringArg()));
            query.filter(filter);
            query.select((ISelectionElement)model.buildableFile().itemId());
            query.distinct();
            parserOutputFilesQuery = query;
        }
        return parserOutputFilesQuery;
    }

    public static final IDataQuery getParserOutputFilesQuery(List<UUID> resultScope) {
        BaseBuildMapQueryModel.BuildMapQueryModel model = BaseBuildMapQueryModel.BuildMapQueryModel.ROOT;
        IDataQuery query = (IDataQuery)IDataQuery.FACTORY.newInstance((IQueryModel)model);
        IPredicate filter = model.buildDefinition().itemId()._eq((IUUID)query.newUUIDArg())._and(model.temporary()._isFalse())._and(model.archived()._isFalse());
        filter = filter._and(model.parserOutputs().buildFile()._eq((IString)query.newStringArg()));
        filter = filter._and(model.parserOutputs().buildPath()._eq((IString)query.newStringArg()));
        filter = filter._and(model.parserOutputs().timestamp()._ltOrEq((IDateTime)query.newDateTimeArg()));
        filter = filter._and(model.parserOutputs().outputType()._eq((IString)query.newStringArg()));
        if (resultScope != null) {
            if (resultScope.size() > 100) {
                filter = filter._and(model.buildableFile().itemId()._inLargeList(new InListIteratorAdapter<UUID>(resultScope.iterator())));
            } else if (resultScope.size() > 0) {
                filter = filter._and(model.buildableFile().itemId()._in(resultScope.toArray(new UUID[resultScope.size()])));
            }
        }
        query.filter(filter);
        query.select((ISelectionElement)model.buildableFile().itemId());
        query.distinct();
        return query;
    }

    public static final IDataQuery getParserOutputFilesQueryWithoutOutputType() {
        if (parserOutputFilesQueryWithoutOutputType == null) {
            BaseBuildMapQueryModel.BuildMapQueryModel model = BaseBuildMapQueryModel.BuildMapQueryModel.ROOT;
            IDataQuery query = (IDataQuery)IDataQuery.FACTORY.newInstance((IQueryModel)model);
            IPredicate filter = model.buildDefinition().itemId()._eq((IUUID)query.newUUIDArg())._and(model.temporary()._isFalse())._and(model.archived()._isFalse());
            filter = filter._and(model.parserOutputs().buildFile()._eq((IString)query.newStringArg()));
            filter = filter._and(model.parserOutputs().buildPath()._eq((IString)query.newStringArg()));
            filter = filter._and(model.parserOutputs().timestamp()._ltOrEq((IDateTime)query.newDateTimeArg()));
            query.filter(filter);
            query.select((ISelectionElement)model.buildableFile().itemId());
            query.distinct();
            parserOutputFilesQueryWithoutOutputType = query;
        }
        return parserOutputFilesQueryWithoutOutputType;
    }

    public static final IDataQuery getParserOutputFilesQueryWithoutOutputType(List<UUID> resultScope) {
        BaseBuildMapQueryModel.BuildMapQueryModel model = BaseBuildMapQueryModel.BuildMapQueryModel.ROOT;
        IDataQuery query = (IDataQuery)IDataQuery.FACTORY.newInstance((IQueryModel)model);
        IPredicate filter = model.buildDefinition().itemId()._eq((IUUID)query.newUUIDArg())._and(model.temporary()._isFalse())._and(model.archived()._isFalse());
        filter = filter._and(model.parserOutputs().buildFile()._eq((IString)query.newStringArg()));
        filter = filter._and(model.parserOutputs().buildPath()._eq((IString)query.newStringArg()));
        filter = filter._and(model.parserOutputs().timestamp()._ltOrEq((IDateTime)query.newDateTimeArg()));
        if (resultScope != null) {
            if (resultScope.size() > 100) {
                filter = filter._and(model.buildableFile().itemId()._inLargeList(new InListIteratorAdapter<UUID>(resultScope.iterator())));
            } else if (resultScope.size() > 0) {
                filter = filter._and(model.buildableFile().itemId()._in(resultScope.toArray(new UUID[resultScope.size()])));
            }
        }
        query.filter(filter);
        query.select((ISelectionElement)model.buildableFile().itemId());
        query.distinct();
        return query;
    }

    public static final IDataQueryPage queryParserOutputFiles(IQueryService queryService, UUID buildDefinition, IOutputBuildFile outputBuildFile) throws TeamRepositoryException {
        return BuildMapQueries.queryParserOutputFiles(queryService, buildDefinition, outputBuildFile, null);
    }

    public static final IDataQueryPage queryParserOutputFiles(IQueryService queryService, UUID buildDefinition, IOutputBuildFile outputBuildFile, List<UUID> resultScope) throws TeamRepositoryException {
        if (outputBuildFile.getOutputType() == null || outputBuildFile.getOutputType().isEmpty()) {
            Object[] parameters = new Object[]{buildDefinition, outputBuildFile.getBuildFile(), outputBuildFile.getBuildPath(), outputBuildFile.getTimestamp()};
            if (resultScope == null) {
                return queryService.queryData(BuildMapQueries.getParserOutputFilesQueryWithoutOutputType(), parameters, 512);
            }
            return queryService.queryData(BuildMapQueries.getParserOutputFilesQueryWithoutOutputType(resultScope), parameters, 512);
        }
        Object[] parameters = new Object[]{buildDefinition, outputBuildFile.getBuildFile(), outputBuildFile.getBuildPath(), outputBuildFile.getTimestamp(), outputBuildFile.getOutputType()};
        if (resultScope == null) {
            return queryService.queryData(BuildMapQueries.getParserOutputFilesQuery(), parameters, 512);
        }
        return queryService.queryData(BuildMapQueries.getParserOutputFilesQuery(resultScope), parameters, 512);
    }

    public static final IDataQuery getImpactedFilesQueryMatchingStates(Collection<UUID> fileIds, Collection<UUID> newFileUUIDs, Map<UUID, List<IVersionableHandle>> changedFileStateIdMap) {
        HashSet<UUID> temp = new HashSet<UUID>();
        temp.addAll(fileIds);
        temp.removeAll(newFileUUIDs);
        ArrayList<UUID> states = new ArrayList<UUID>(temp.size());
        for (UUID t : temp) {
            for (IVersionableHandle v : changedFileStateIdMap.get(t)) {
                states.add(v.getStateId());
            }
        }
        return BuildMapQueries.getImpactedFilesQueryMatchingStates(temp, states);
    }

    public static final IDataQuery getImpactedFilesQueryMatchingStates(Collection<UUID> fileIds, Collection<UUID> stateIds) {
        if (fileIds == null || fileIds.isEmpty() || stateIds == null || stateIds.isEmpty()) {
            return null;
        }
        BaseBuildMapQueryModel.BuildMapQueryModel model = BaseBuildMapQueryModel.BuildMapQueryModel.ROOT;
        IDataQuery queryForImpactedFiles = (IDataQuery)IDataQuery.FACTORY.newInstance((IQueryModel)model);
        IPredicate filter = model.temporary()._isFalse()._and(model.archived()._isFalse())._and(model.buildDefinition().itemId()._eq((IUUID)queryForImpactedFiles.newUUIDArg()));
        filter = fileIds.size() > 100 ? filter._and(model.inputs().file().itemId()._inLargeList(new InListIteratorAdapter<UUID>(fileIds.iterator()))) : filter._and(model.inputs().file().itemId()._in(fileIds.toArray(new UUID[0])));
        filter = stateIds.size() > 100 ? filter._and(model.inputs().fileStateUUID()._inLargeList(new InListIteratorAdapter<UUID>(stateIds.iterator()))) : filter._and(model.inputs().fileStateUUID()._in(stateIds.toArray(new UUID[0])));
        queryForImpactedFiles.filter(filter);
        queryForImpactedFiles.select((ISelectionElement)model.buildableFile().itemId());
        queryForImpactedFiles.distinct();
        return queryForImpactedFiles;
    }

    public static final IDataQuery getImpactedFilesQueryWithoutState(Collection<UUID> fileIds, Collection<UUID> newFileUUIDs) {
        HashSet<UUID> temp = new HashSet<UUID>();
        temp.addAll(fileIds);
        temp.removeAll(newFileUUIDs);
        return BuildMapQueries.getImpactedFilesQueryWithoutState(temp);
    }

    public static final IDataQuery getImpactedFilesQueryWithoutState(Collection<UUID> fileIds) {
        if (fileIds == null || fileIds.isEmpty()) {
            return null;
        }
        BaseBuildMapQueryModel.BuildMapQueryModel model = BaseBuildMapQueryModel.BuildMapQueryModel.ROOT;
        IDataQuery queryForImpactedFiles = (IDataQuery)IDataQuery.FACTORY.newInstance((IQueryModel)model);
        IPredicate filter = model.temporary()._isFalse()._and(model.archived()._isFalse())._and(model.buildDefinition().itemId()._eq((IUUID)queryForImpactedFiles.newUUIDArg()));
        filter = fileIds.size() > 100 ? filter._and(model.inputs().file().itemId()._inLargeList(new InListIteratorAdapter<UUID>(fileIds.iterator()))) : filter._and(model.inputs().file().itemId()._in(fileIds.toArray(new UUID[0])));
        queryForImpactedFiles.filter(filter);
        queryForImpactedFiles.select((ISelectionElement)model.buildableFile().itemId());
        queryForImpactedFiles.distinct();
        return queryForImpactedFiles;
    }

    public static final IDataQuery getBuildableFilesForParserOutputQuery() {
        if (findBuildableFilesForParserOutputQuery == null) {
            BaseBuildMapQueryModel.BuildMapQueryModel model = BaseBuildMapQueryModel.BuildMapQueryModel.ROOT;
            IDataQuery query = (IDataQuery)IDataQuery.FACTORY.newInstance((IQueryModel)model);
            IPredicate filter = model.buildDefinition().itemId()._eq((IUUID)query.newUUIDArg())._and(model.temporary()._isFalse())._and(model.archived()._isFalse());
            filter = filter._and(model.outputs().buildFile()._eq((IString)query.newStringArg()));
            filter = filter._and(model.outputs().buildPath()._eq((IString)query.newStringArg()));
            query.filter(filter);
            query.select((ISelectionElement)model.buildableFile().itemId());
            query.distinct();
            findBuildableFilesForParserOutputQuery = query;
        }
        return findBuildableFilesForParserOutputQuery;
    }

    public static Set<UUID> queryBuildableFilesForParserOutput(IBuildDefinitionHandle buildDefinitionHandle, IOutputBuildFile parserOutput, IQueryService queryService) throws TeamRepositoryException {
        Object[] parameters = new Object[]{buildDefinitionHandle.getItemId(), parserOutput.getBuildFile(), parserOutput.getBuildPath()};
        IDataQueryPage results = queryService.queryData(BuildMapQueries.getBuildableFilesForParserOutputQuery(), parameters, 512);
        HashSet<UUID> buildableFileUUIDs = new HashSet<UUID>();
        while (true) {
            int i = 0;
            while (i < results.getSize()) {
                UUID buildableFileUUID = results.getRow(i).getUUID(0);
                if (buildableFileUUID != null) {
                    buildableFileUUIDs.add(buildableFileUUID);
                }
                ++i;
            }
            if (!results.hasNext()) break;
            results = (IDataQueryPage)queryService.fetchPage(results.getToken(), results.getNextStartPosition(), 512);
        }
        return buildableFileUUIDs;
    }
}

