var localPfx;
var localReferences;

setHeadReferences();

function setHeadReferences() {
	var scripts = document.getElementsByTagName('script');
	var local = scripts[0].getAttribute('local');
	var path = window.location.pathname.split('/');
	var doc = false;
	var ext = false;
	var pfx = '';
	
	for (var i = 0; i < path.length-1; i++) {
		if (path[i].startsWith('com.ibm.team.build.extensions.toolkit')) {
			ext = true;
		}
		if (path[i] == 'doc' || path[i] == 'doc_src') {
			doc = true;
			continue;
		}
		if (doc) {
			pfx += '../';
		}
	}
	localPfx = pfx;
	
	if (local == null) {
		var parms = location.search.substring(1).split("&");
		if (parms.length > 0) {
			var parm = parms[0].split("=");
			if (parm[0] == "local") {
				local = unescape(parm[1]).replace(/"/g,"");
			}
		}
	}
	
	if (local == null) {
		if (ext) {
			local = "false";
		} else {
			local = "true";
		}
	}
	
	if (local == "true") {
		localReferences = "true";
	} else {
		localReferences = "false";
	}
	
	if (local == "true") {
		/*
		 * Some documents have id="cssReference" and some don't. Most files in
		 * com.ibm.team.build.extensions.toolkit point directly to the css:
		 *   href="../$css/styles.css"
		 * Most files in other toolkits are referencing via link references:
		 *   href="#" id="cssReference"
		 * So, surround the following getElementById() with try/catch so that
		 * we ignore the hard-coded ones and only update the linked ones>
		 */
		try {
			document.getElementById("cssReference").href = pfx + "../../com.ibm.team.build.extensions.toolkit/doc/$css/styles.css";
		} catch(e) {}
		document.write('<script type="text/javascript" src="' + pfx + '../../com.ibm.team.build.extensions.toolkit/doc/$scr/$Common.js"></script>');
	} else {
		try {
			document.getElementById("cssReference").href = pfx + "$css/styles.css";
		} catch(e) {}
		document.write('<script type="text/javascript" src="' + pfx + '$scr/$Common.js"></script>');
	}
}

function setLinkReferences() {
	var path = '';
	
	if (localReferences == "true") {
		path = '../../com.ibm.team.build.extensions.toolkit/doc/';
	}
	
	try {
		document.getElementById("teamBuildAttributesHref").href = localPfx + path + "$htm/TeamBuildAttributes.htm";
	} catch(e) {}
	
	try {
		document.getElementById("teamBuildAttributesHref2").href = localPfx + path + "$htm/TeamBuildAttributes.htm";
	} catch(e) {}
	
	try {
		document.getElementById("buildExtensionsDebuggingAttributesHref").href = localPfx + path + "$htm/BuildExtensionsDebuggingAttributes.htm";
	} catch(e) {}
	
	try {
		document.getElementById("buildExtensionsGeneralAttributesHref").href = localPfx + path + "$htm/BuildExtensionsGeneralAttributes.htm";
	} catch(e) {}
	
	try {
		document.getElementById("buildDefinitionReferenceHref").href = localPfx + path +  "builddefinition/buildDefinition.htm";
	} catch(e) {}
	
	try {
		document.getElementById("buildDefinitionTasksHref").href = localPfx + path +  "builddefinition/$topic.htm";
	} catch(e) {}
	
	try {
		document.getElementById("buildEngineReferenceHref").href = localPfx + path +  "buildengine/buildEngine.htm";
	} catch(e) {}
	
	try {
		document.getElementById("buildEngineTasksHref").href = localPfx + path +  "buildengine/$topic.htm";
	} catch(e) {}
}

function setLocalLinks() {
	if (localReferences == "true") {
		for (var i = 0; i < document.links.length; i++) {
			document.links[i].href = document.links[i].href + "?local=\"true\"";
		}
	}
}
