/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.logging.toolkit.listener;

import com.ibm.team.build.ant.listener.LiveLogAbstractBuildListener;
import com.ibm.team.build.common.logging.ILiveLogMessage;
import com.ibm.team.enterprise.build.logging.toolkit.listener.Messages;
import com.ibm.team.repository.common.internal.util.StringUtils;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.Target;
import org.eclipse.osgi.util.NLS;

public class LiveLogEnterpriseBuildListener
extends LiveLogAbstractBuildListener {
    private static final String TARGET_START = Messages.LiveLogEnterpriseBuildListener_BUILD_STEP_START;

    public void doBuildStarted(BuildEvent event) {
    }

    public void doSubBuildStarted(BuildEvent event) {
        this.liveLogBuildEvent(event);
    }

    public void doTargetStarted(BuildEvent event) {
        String targetName;
        Target target = event.getTarget();
        if (target != null && (targetName = target.getName()) != null && !targetName.isEmpty()) {
            event.setMessage(NLS.bind((String)TARGET_START, (Object)targetName), 2);
        }
        if (!StringUtils.isEmpty((String)event.getMessage())) {
            this.liveLogBuildEvent(event);
        }
    }

    public void doTaskStarted(BuildEvent event) {
    }

    public void doMessageLogged(BuildEvent event) {
        if (event.getException() != null) {
            this.manageException(event);
        } else {
            String eventMsg = event.getMessage();
            if (!StringUtils.isEmpty((String)eventMsg)) {
                this.liveLogBuildEvent(event);
            }
        }
    }

    public void doTargetFinished(BuildEvent event) {
        if (event.getException() != null) {
            this.manageException(event);
        }
    }

    public void doTaskFinished(BuildEvent event) {
        if (event.getException() != null) {
            this.manageException(event);
        }
    }

    public void doSubBuildFinished(BuildEvent event) {
    }

    public void doBuildFinished(BuildEvent event) {
    }

    private void manageException(BuildEvent event) {
        if (event.getException() != null && !StringUtils.isEmpty((String)event.getException().getMessage())) {
            ILiveLogMessage llmsg = this.createLiveLogMessage();
            llmsg.setLevel(ILiveLogMessage.Level.ERROR);
            llmsg.setMessage(event.getException().getMessage());
            this.liveLogMessage(llmsg);
        }
    }
}

