/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ant.types.resources;

import com.ibm.team.build.common.IStaticReset;
import com.ibm.team.enterprise.build.buildmap.common.model.IOutputBuildFile;
import com.ibm.team.enterprise.build.buildmap.common.util.FailedOutputsContants;
import com.ibm.team.repository.common.UUID;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class LangOutputsCollection
implements IStaticReset {
    public static String LANG_OUT_XML = "langOutputs.xml";
    private static LangOutputsCollection singleton;
    private Map<String, Set<IOutputBuildFile>> collection = new HashMap<String, Set<IOutputBuildFile>>();

    private LangOutputsCollection() {
    }

    public static LangOutputsCollection getInstance(String filePath) throws Exception {
        if (singleton == null) {
            singleton = new LangOutputsCollection();
            LangOutputsCollection.parse(filePath);
        }
        return singleton;
    }

    private static void parse(String filePath) throws FileNotFoundException, XMLStreamException, FactoryConfigurationError {
        LangOutputsCollection.singleton.collection.clear();
        File file = new File(new File(filePath), LANG_OUT_XML);
        if (file.exists()) {
            XMLEventReader reader = XMLInputFactory.newInstance().createXMLEventReader(new FileInputStream(file));
            boolean inLangDef = false;
            boolean inOutputFile = false;
            HashSet<IOutputBuildFile> outputFiles = null;
            IOutputBuildFile outputFile = null;
            String langUUID = null;
            while (reader.hasNext()) {
                String elementName;
                XMLEvent element;
                XMLEvent event = reader.nextEvent();
                if (event.isStartElement()) {
                    String resourceStateIDStr;
                    element = event.asStartElement();
                    if (element == null) continue;
                    elementName = null;
                    if (element != null) {
                        elementName = LangOutputsCollection.getQualifiedName(element.getName());
                    }
                    if (elementName == null || elementName.isEmpty()) continue;
                    if (FailedOutputsContants.LANG_DEF.equals(elementName)) {
                        inLangDef = true;
                        outputFiles = new HashSet<IOutputBuildFile>();
                        langUUID = LangOutputsCollection.getUUIDAttributeFromElement((StartElement)element, reader);
                        continue;
                    }
                    if (inLangDef && "outputs:file".equals(elementName)) {
                        inOutputFile = true;
                        outputFile = (IOutputBuildFile)IOutputBuildFile.ITEM_TYPE.createItem();
                        continue;
                    }
                    if (!inOutputFile || outputFile == null) continue;
                    if ("outputs:buildFile".equals(elementName)) {
                        outputFile.setBuildFile(reader.getElementText().trim());
                        continue;
                    }
                    if ("outputs:buildPath".equals(elementName)) {
                        outputFile.setBuildPath(reader.getElementText().trim());
                        continue;
                    }
                    if ("outputs:sequential".equals(elementName)) {
                        outputFile.setSequential(Boolean.valueOf(reader.getElementText().trim()).booleanValue());
                        continue;
                    }
                    if ("outputs:hfs".equals(elementName)) {
                        outputFile.setHFS(Boolean.valueOf(reader.getElementText().trim()).booleanValue());
                        continue;
                    }
                    if ("outputs:outputType".equals(elementName)) {
                        outputFile.setOutputType(reader.getElementText().trim());
                        continue;
                    }
                    if ("outputs:deployType".equals(elementName)) {
                        outputFile.setDeployType(reader.getElementText().trim());
                        continue;
                    }
                    if ("outputs:resourceDefinitionID".equals(elementName)) {
                        String resourceUUIDStr = reader.getElementText().trim();
                        if (resourceUUIDStr == null || resourceUUIDStr.length() <= 0) continue;
                        outputFile.setResourceDefinitionUUID(UUID.valueOf((String)resourceUUIDStr));
                        continue;
                    }
                    if (!"outputs:resourceDefinitionStateID".equals(elementName) || (resourceStateIDStr = reader.getElementText().trim()) == null || resourceStateIDStr.length() <= 0) continue;
                    outputFile.setResourceDefinitionStateUUID(UUID.valueOf((String)resourceStateIDStr));
                    continue;
                }
                if (!event.isEndElement() || (element = event.asEndElement()) == null) continue;
                elementName = null;
                if (element != null) {
                    elementName = LangOutputsCollection.getQualifiedName(element.getName());
                }
                if (elementName == null || elementName.isEmpty()) continue;
                if (inLangDef && inOutputFile && "outputs:file".equals(elementName) && outputFile != null && outputFiles != null) {
                    inOutputFile = false;
                    outputFiles.add(outputFile);
                    outputFile = null;
                    continue;
                }
                if (!inLangDef || !FailedOutputsContants.LANG_DEF.equals(elementName) || outputFiles == null || langUUID == null) continue;
                LangOutputsCollection.singleton.collection.put(langUUID, outputFiles);
                outputFiles = null;
                langUUID = null;
                inLangDef = false;
            }
        }
    }

    private static String getUUIDAttributeFromElement(StartElement element, XMLEventReader reader) {
        String result = null;
        Iterator<Attribute> it = element.getAttributes();
        while (it.hasNext()) {
            Attribute attr;
            String attrName;
            Attribute temp = it.next();
            if (!(temp instanceof Attribute) || (attrName = LangOutputsCollection.getQualifiedName((attr = temp).getName())) == null || attrName.isEmpty() || !FailedOutputsContants.LANG_UUID.equals(attrName)) continue;
            result = attr.getValue();
            break;
        }
        return result;
    }

    private static String getQualifiedName(QName qName) {
        String result = null;
        if (qName == null) {
            return result;
        }
        StringBuilder builder = new StringBuilder();
        String prefix = qName.getPrefix();
        if (prefix != null && prefix.length() > 0) {
            builder.append(qName.getPrefix()).append(":");
        }
        builder.append(qName.getLocalPart());
        result = builder.toString();
        builder = null;
        return result;
    }

    public Set<IOutputBuildFile> getResource(String langUUID) {
        return this.collection.get(langUUID);
    }

    public static void staticMemoryReset() {
        singleton = null;
        LANG_OUT_XML = "langOUtputs.xml";
    }
}

